/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.license.plugin.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;

public abstract class AbstractLicenseCheckBatchImportPlugin
extends BatchImportPlugin {
    public abstract String getAppId();

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (!StringUtils.isNotBlank((CharSequence)message.toString())) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    public void validBillData(ImportBillData importBillData, StringBuilder message) {
        JSONObject data = importBillData.getData();
        JSONObject orgJsonObject = data.getJSONObject("org");
        if (orgJsonObject == null) {
            return;
        }
        String orgNumber = orgJsonObject.getString("number") != null ? orgJsonObject.getString("number") : "";
        AbstractLicenseCheckBatchImportPlugin.checkOrg(orgNumber, message, this.getAppId());
    }

    public static void checkOrg(String orgNumber, StringBuilder message, String appId) {
        AbstractLicenseCheckBatchImportPlugin.checkOrg(orgNumber, AbstractLicenseCheckBatchImportPlugin.queryOrgId(orgNumber), message, appId);
    }

    public static void checkOrg(String orgNumber, Long orgid, StringBuilder message, String appId) {
        TaxResult result = TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(String.valueOf(orgid)), (String)appId);
        if (result != null && Boolean.TRUE.equals(result.getData())) {
            message.append(result.getMessage());
        }
    }

    private static Long queryOrgId(String orgNumber) {
        return (Long)TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgNum((String)orgNumber).getData();
    }
}

