/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.mq;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.PayRecordTaxtypeEnum;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.mq.MQConstant;
import kd.taxc.bdtaxr.common.mq.MQSender;
import kd.taxc.bdtaxr.common.mq.oversea.TjsjbMetadataidEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class DeclareMQSender
extends MQSender {
    private static final Log logger = LogFactory.getLog(DeclareMQSender.class);

    private static void sendDeclareMQ(DeclareMQMessage message) {
        for (String declareQueue : MQConstant.DECLARE_QUEUES) {
            DeclareMQSender.send(declareQueue, JsonUtil.toJson(message));
        }
    }

    private static void sendTaxableListMQ(DeclareMQMessage message) {
        DeclareMQSender.send("taxc.common.declare.taxableList", JsonUtil.toJson(message));
    }

    private static void sendTaxableListMQByMessage(DynamicObject entity, String topic, String event, DeclareMQMessage message) {
        DeclareMQSender.sendTaxableListMQ(message);
    }

    public static void sendTaxableListMQ(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        try {
            DeclareMQMessage message = DeclareMQSender.transformMessage(entity, startdate, enddate, topic, event);
            DeclareMQSender.sendTaxableListMQByMessage(entity, topic, event, message);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender sendTaxableListMQ error:{}", (Object)e.getMessage());
        }
    }

    public static void sendMQ(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        try {
            DeclareMQMessage message = DeclareMQSender.transformMessage(entity, startdate, enddate, topic, event);
            DeclareMQMessageData data = DeclareMQSender.transformData(entity, startdate, enddate);
            message.setData(DeclareMQSender.doCheckData(data, null));
            DeclareMQSender.sendDeclareMQ(message);
            DeclareMQSender.sendTaxableListMQByMessage(entity, topic, event, message);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
    }

    private static void sendMQ(DynamicObject entity, Date startdate, Date enddate, String topic, String event, String entityName) {
        try {
            DeclareMQMessage message = DeclareMQSender.transformMessage(entity, startdate, enddate, topic, event);
            DeclareMQMessageData data = DeclareMQSender.transformData(entity, startdate, enddate);
            message.setData(DeclareMQSender.doCheckData(data, null));
            DeclareMQSender.sendDeclareMQ(message);
            DeclareMQSender.sendTaxableListMQByMessage(entity, topic, event, message);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
    }

    public static void sendMQ(DynamicObject entity, Date startdate, Date enddate, BigDecimal sjje, Date payDate, String taxtype, String topic, String event) {
        try {
            DeclareMQMessage message = DeclareMQSender.transformMessage(entity, startdate, enddate, topic, event);
            DeclareMQMessageData data = DeclareMQSender.transformData(entity, startdate, enddate);
            message.setData(DeclareMQSender.doCheckData(data, sjje, payDate, taxtype));
            DeclareMQSender.sendDeclareMQ(message);
            DeclareMQSender.sendTaxableListMQByMessage(entity, topic, event, message);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
    }

    public static void sendMQBeforeDelete(DynamicObject entity, Date startdate, Date enddate, String topic, String event, List<DeclareMQMessageData> queryBeforeDeleteData) {
        try {
            DeclareMQMessage message = DeclareMQSender.transformMessage(entity, startdate, enddate, topic, event);
            DeclareMQMessageData data = DeclareMQSender.transformData(entity, startdate, enddate);
            message.setData(DeclareMQSender.doCheckData(data, queryBeforeDeleteData));
            DeclareMQSender.sendDeclareMQ(message);
            DeclareMQSender.sendTaxableListMQByMessage(entity, topic, event, message);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
    }

    public static DeclareMQMessage buildMessage(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        DeclareMQMessage message = DeclareMQSender.transformMessage(entity, startdate, enddate, topic, event);
        DeclareMQMessageData data = DeclareMQSender.transformData(entity, startdate, enddate);
        try {
            message.setData(DeclareMQSender.doCheckData(data, null));
        }
        catch (CloneNotSupportedException e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
        return message;
    }

    public static void sendMQ(DynamicObject entity, Date payDate, String topic, String act, String entityName) {
        try {
            Date skssqz;
            Date skssqq;
            if (null != payDate) {
                skssqq = DateUtils.getFirstDateOfMonth(payDate);
                skssqz = DateUtils.getLastDateOfMonth(payDate);
            } else {
                skssqq = DateUtils.getFirstDateOfMonth(entity.getDate("skssqq"));
                skssqz = DateUtils.getLastDateOfMonth(entity.getDate("skssqz"));
            }
            DeclareMQSender.sendMQ(entity, skssqq, skssqz, topic, act, entityName);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
    }

    public static void sendMQ(DynamicObject entity, Date payDate, String topic, String act) {
        try {
            Date skssqz;
            Date skssqq;
            if (null != payDate) {
                skssqq = DateUtils.getFirstDateOfMonth(payDate);
                skssqz = DateUtils.getLastDateOfMonth(payDate);
            } else {
                skssqq = DateUtils.getFirstDateOfMonth(entity.getDate("skssqq"));
                skssqz = DateUtils.getLastDateOfMonth(entity.getDate("skssqz"));
            }
            DeclareMQSender.sendMQ(entity, skssqq, skssqz, topic, act);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
    }

    public static void sendMQ(DynamicObjectCollection list, String tableType, String topic, String event) {
        for (DynamicObject entity : list) {
            try {
                Date skssqq = entity.getDate("skssqq");
                Date skssqz = entity.getDate("skssqz");
                DeclareMQMessage message = DeclareMQSender.transformMessage(entity, skssqq, skssqz, topic, event);
                DeclareMQMessageData data = DeclareMQSender.transformData(entity, skssqq, skssqz, tableType);
                message.setData(DeclareMQSender.doCheckData(data, null));
                DeclareMQSender.sendDeclareMQ(message);
                DeclareMQSender.sendTaxableListMQByMessage(entity, topic, event, message);
            }
            catch (Exception e) {
                logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
            }
        }
    }

    public static void sendMQ(DynamicObjectCollection list, String tableType, String topic, String event, String entityName) {
        for (DynamicObject entity : list) {
            try {
                Date skssqq = entity.getDate("skssqq");
                Date skssqz = entity.getDate("skssqz");
                DeclareMQMessage message = DeclareMQSender.transformMessage(entity, skssqq, skssqz, topic, event);
                DeclareMQMessageData data = DeclareMQSender.transformData(entity, skssqq, skssqz, tableType);
                message.setData(DeclareMQSender.doCheckData(data, null));
                DeclareMQSender.sendDeclareMQ(message);
                DeclareMQSender.sendTaxableListMQByMessage(entity, topic, event, message);
            }
            catch (Exception e) {
                logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
            }
        }
    }

    private static List<DeclareMQMessageData> doCheckData(DeclareMQMessageData data, List<DeclareMQMessageData> queryBeforeDeleteData) throws CloneNotSupportedException {
        String templatetype = data.getDeclareType();
        DynamicObjectCollection payrecord = DeclareMQSender.getSjjeAndPayDate(data.getSbbid());
        if (payrecord.size() > 0) {
            data.setSjje(((DynamicObject)payrecord.get(0)).getBigDecimal("sjje"));
            data.setPaydate(DateUtils.format(((DynamicObject)payrecord.get(0)).getDate("paydate"), "yyyy-MM-dd HH:mm:ss"));
        }
        Map<String, List<DynamicObject>> map = payrecord.stream().collect(Collectors.groupingBy(o -> o.getString("taxtype")));
        if ("zzs".equals(TemplateTypeConstant.getTypeByValue(templatetype))) {
            QFilter taxTypeFilter;
            QFilter idFilter = new QFilter("sbbid", "=", (Object)Long.valueOf(data.getSbbid()));
            if (QueryServiceHelper.exists((String)"tctb_declare_entry", (QFilter[])new QFilter[]{idFilter, taxTypeFilter = new QFilter("ewblxh", "in", Arrays.asList("3", "4", "5"))})) {
                DeclareMQMessageData csjsData = data.clone();
                csjsData.setTaxType("6");
                DeclareMQMessageData jyfjData = data.clone();
                jyfjData.setTaxType("19");
                DeclareMQMessageData dfjyfjData = data.clone();
                dfjyfjData.setTaxType("20");
                List<DeclareMQMessageData> list = Arrays.asList(data, csjsData, jyfjData, dfjyfjData);
                DeclareMQSender.updateData(list, map);
                return list;
            }
        } else {
            if ("fjsf".equals(TemplateTypeConstant.getTypeByValue(templatetype))) {
                DeclareMQMessageData csjsData = data.clone();
                csjsData.setTaxType("6");
                DeclareMQMessageData jyfjData = data.clone();
                jyfjData.setTaxType("19");
                DeclareMQMessageData dfjyfjData = data.clone();
                dfjyfjData.setTaxType("20");
                List<DeclareMQMessageData> list = Arrays.asList(csjsData, jyfjData, dfjyfjData);
                DeclareMQSender.updateData(list, map);
                return list;
            }
            if ("fcs".equals(TemplateTypeConstant.getTypeByValue(templatetype))) {
                DeclareMQMessageData cztdsData = data.clone();
                cztdsData.setTaxType("9");
                List<DeclareMQMessageData> list = Arrays.asList(data, cztdsData);
                DeclareMQSender.updateData(list, map);
                return list;
            }
        }
        if (EmptyCheckUtils.isNotEmpty(queryBeforeDeleteData) && ("ccxws".equals(templatetype) || "qtsf_tysbb".equals(templatetype) || "qtsf_fsstysbb".equals(templatetype))) {
            ArrayList<DeclareMQMessageData> arrayList = new ArrayList<DeclareMQMessageData>();
            for (DeclareMQMessageData a : queryBeforeDeleteData) {
                DeclareMQMessageData entryData = data.clone();
                entryData.setTaxType(a.getTaxType());
                entryData.setSkssqq(a.getSkssqq());
                entryData.setSkssqz(a.getSkssqz());
                arrayList.add(entryData);
            }
            return arrayList;
        }
        return Collections.singletonList(data);
    }

    private static List<DeclareMQMessageData> doCheckData(DeclareMQMessageData data, BigDecimal sjje, Date payDate, String taxtype) throws CloneNotSupportedException {
        if (data != null) {
            data.setSjje(sjje);
            data.setPaydate(DateUtils.format(payDate));
            data.setTaxType(DeclareMQSender.getBaseTaxTypeIdByTaxtype(taxtype));
        }
        return Collections.singletonList(data);
    }

    public static void sendTcretMQ(DynamicObject nsrxxObj, DynamicObject[] zbList, String topic, String event, String entityName) {
        try {
            Date skssqq = DateUtils.getFirstDateOfMonth(nsrxxObj.getDate("skssqq"));
            Date skssqz = DateUtils.getLastDateOfMonth(nsrxxObj.getDate("skssqz"));
            DeclareMQMessage message = DeclareMQSender.transformMessage(nsrxxObj, skssqq, skssqz, topic, event);
            DeclareMQMessageData data = DeclareMQSender.transformData(nsrxxObj, skssqq, skssqz);
            message.setData(DeclareMQSender.doCheckData(data, null));
            DeclareMQSender.sendDeclareMQ(message);
            DeclareMQSender.sendTaxableListMQByMessage(nsrxxObj, topic, event, message);
        }
        catch (Exception e) {
            logger.error("DeclareMQSender send error:{}", (Object)e.getMessage());
        }
    }

    private static String doGetBaseTaxTypeId(String taxTypeNumber) {
        if (DeclareTaxType.FJSF.getBaseTaxCode().equals(taxTypeNumber)) {
            return "2";
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxTypeNumber)});
        return obj == null ? null : obj.getString("id");
    }

    private static String getBaseTaxTypeIdByTaxtype(String taxtype) {
        if (DeclareTaxType.FJSF.getBaseTaxCode().equals(taxtype)) {
            return "2";
        }
        return PayRecordTaxtypeEnum.getBaseTaxIdByTaxtype(taxtype);
    }

    private static DeclareMQMessage transformMessage(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        String entityType;
        DeclareMQMessage message = new DeclareMQMessage();
        if (entity.getDataEntityType().getName().equals("tpo_declare_main_tsc")) {
            DynamicObject templatetype = (DynamicObject)entity.get("templatetype");
            entityType = templatetype.getString("number");
        } else {
            entityType = entity.getString("type");
        }
        message.setTax(TemplateTypeConstant.getTypeByValue(entityType));
        message.setTopic(topic);
        message.setEvent(DeclareMQEvent.match(event));
        message.setSbbid(entity.getString("id"));
        message.setOrg(DeclareMQSender.doAdaptDynamic(entity, "org"));
        message.setSkssqq(DateUtils.format(startdate));
        message.setSkssqz(DateUtils.format(enddate));
        message.setDeclareType(entityType);
        message.setBillno(entity.getString("billno"));
        message.setDeclarestatus(entity.getString("declarestatus"));
        message.setPaystatus(entity.getString("paystatus"));
        message.setTaxauthority(DeclareMQSender.doAdaptDynamic(entity, "taxauthority"));
        return message;
    }

    private static DeclareMQMessageData transformData(DynamicObject entity, Date skssqq, Date skssqz, String tableType) {
        DeclareMQMessageData data = DeclareMQSender.transformData(entity, skssqq, skssqz);
        data.setTableType(tableType);
        return data;
    }

    private static DeclareMQMessageData transformData(DynamicObject entity, Date startdate, Date enddate) {
        String entityType;
        DeclareMQMessageData data = new DeclareMQMessageData();
        if (entity.getDataEntityType().getName().equals("tpo_declare_main_tsc")) {
            DynamicObject templatetype = (DynamicObject)entity.get("templatetype");
            entityType = templatetype.getString("number");
        } else {
            entityType = entity.getString("type");
        }
        data.setBusinessSource("0");
        data.setDeclareType(entityType);
        if (TableTypeMapTemplateTypeEnum.getEnumByTemplateType(entityType) != null) {
            data.setTableType(TableTypeMapTemplateTypeEnum.getEnumByTemplateType(entityType).getTableType());
        }
        data.setTaxType(DeclareMQSender.doGetBaseTaxTypeId(DeclareTaxType.nssbMatchBase(TemplateTypeConstant.getTypeByValue(entityType))));
        data.setDataType(entity.getString("datatype"));
        data.setSbbid(entity.getString("id"));
        data.setBillNo(entity.getString("billno"));
        data.setBillStatus(entity.getString("billstatus"));
        data.setOrg(DeclareMQSender.doAdaptDynamic(entity, "org"));
        data.setSkssqq(DateUtils.format(startdate));
        data.setSkssqz(DateUtils.format(enddate));
        data.setStartDate(DateUtils.format(entity.getDate("skssqq")));
        data.setEndDate(DateUtils.format(entity.getDate("skssqz")));
        data.setSerialno(entity.getDynamicObjectType().getProperty("serialno") == null ? "" : entity.getString("serialno"));
        data.setSjje(entity.getDynamicObjectType().getProperty("sjje") == null ? BigDecimal.ZERO : entity.getBigDecimal("sjje"));
        data.setPaydate(entity.getDynamicObjectType().getProperty("paydate") == null ? "" : DateUtils.format(entity.getDate("paydate"), "yyyy-MM-dd HH:mm:ss"));
        data.setEntityName(DeclareMQSender.transformEntityName(data.getTaxType(), data.getDeclareType()));
        return data;
    }

    private static String transformEntityName(String taxType, String type) {
        if ("ccxws".equals(type)) {
            return TjsjbMetadataidEnum.getMetaDataidByType(taxType, type);
        }
        return TjsjbMetadataidEnum.getMetaDataidByType(taxType, "");
    }

    private static Long doAdaptDynamic(DynamicObject entity, String key) {
        Object value = entity.get(key);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    private static DynamicObjectCollection queryDeclareData(DeclareMQMessageData data, String templatetype) {
        if ("ccxws".equals(templatetype)) {
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)data.getSbbid());
            DynamicObjectCollection tcretCcxwsZbTds = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"taxtype,sm,startdate as skssqq,enddate as skssqz", (QFilter[])new QFilter[]{sbbidFilter});
            Map<String, Long> taxtypeMap = Arrays.stream(DeclareTaxType.values()).filter(a -> a.getLocalTaxName() != null && a.getBaseTaxId() != null).collect(Collectors.toMap(k -> k.getLocalTaxName(), v -> v.getBaseTaxId(), (m, n) -> m));
            for (DynamicObject tcvatNsrxx : tcretCcxwsZbTds) {
                Long taxcatetory;
                if (tcvatNsrxx.getString("taxtype") == null || (taxcatetory = taxtypeMap.get(tcvatNsrxx.getString("taxtype"))) == null) continue;
                tcvatNsrxx.set("taxtype", (Object)((Object)taxcatetory).toString());
            }
            return tcretCcxwsZbTds;
        }
        if ("qtsf_tysbb".equals(templatetype) || "qtsf_fsstysbb".equals(templatetype)) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(data.getSbbid()));
            DynamicObjectCollection tcvat_nsrxx = QueryServiceHelper.query((String)"totf_sjfzsf_dtb", (String)"startdate as skssqq,enddate as skssqz,zspm as taxtype", (QFilter[])new QFilter[]{qFilter});
            Map<String, Long> taxtypeMap = Arrays.stream(DeclareTaxType.values()).filter(a -> a.getLocalTaxName() != null && a.getBaseTaxId() != null).collect(Collectors.toMap(k -> k.getLocalTaxName(), v -> v.getBaseTaxId(), (m, n) -> m));
            for (DynamicObject tcvatNsrxx : tcvat_nsrxx) {
                Long taxcatetory = taxtypeMap.get(tcvatNsrxx.getString("taxtype"));
                if (taxcatetory == null) continue;
                tcvatNsrxx.set("taxtype", (Object)((Object)taxcatetory).toString());
            }
            return tcvat_nsrxx;
        }
        return new DynamicObjectCollection();
    }

    private static DynamicObjectCollection getSjjeAndPayDate(String sbbid) {
        DynamicObjectCollection obj = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"id,skssqq,skssqz,paydate,sjje,taxtype,entryentity.taxitem,entryentity.yjjemx,entryentity.sjjemx", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        return obj;
    }

    private static void updateData(List<DeclareMQMessageData> list, Map<String, List<DynamicObject>> map) {
        for (DeclareMQMessageData data : list) {
            if (DeclareTaxType.nssbMatchCode(data.getTaxType()) != null && map.get(DeclareTaxType.nssbMatchCode(data.getTaxType())) != null) {
                data.setSjje(map.get(DeclareTaxType.nssbMatchCode(data.getTaxType())).get(0).getBigDecimal("sjje"));
                data.setPaydate(DateUtils.format(map.get(DeclareTaxType.nssbMatchCode(data.getTaxType())).get(0).getDate("paydate"), "yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            data.setSjje(BigDecimal.ZERO);
            data.setPaydate("");
        }
    }
}

