/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.mq;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.taxc.bdtaxr.common.mq.messagebuilder.ExtendedMQMessage;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class MQSender {
    private static final Log logger = LogFactory.getLog(MQSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String queue, String message) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("taxc", queue);){
            logger.info("enter MQSender send to:{}", (Object)queue);
            logger.info(message);
            pub.publish(message);
        }
    }

    public static void send(List<ExtendedMQMessage> extendedMQMessages) {
        MQSender.insertLocalMessage(extendedMQMessages);
        for (ExtendedMQMessage extendedMQMessage : extendedMQMessages) {
            MQSender.send(extendedMQMessage);
        }
    }

    private static void send(ExtendedMQMessage extendedMQMessage) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("taxc", extendedMQMessage.getQueue());){
            String messageJSON = JsonUtil.toJson(extendedMQMessage.getMessage());
            logger.info("enter MQSender send to:{}", (Object)extendedMQMessage.getQueue());
            logger.info(messageJSON);
            pub.publish(messageJSON);
        }
    }

    private static void insertLocalMessage(List<ExtendedMQMessage> extendedMQMessages) {
        try {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            long[] ids = DB.genLongIds((String)"t_bdtaxr_localmessage", (int)extendedMQMessages.size());
            int size = extendedMQMessages.size();
            for (int i = 0; i < size; ++i) {
                Long messageId = ids[i];
                extendedMQMessages.get(i).getMessage().setMessageId(messageId);
                Date createTime = new Date();
                Date expireTime = DateUtils.addDay(createTime, 1);
                Object[] params = new Object[]{messageId, "MQMessage", createTime, expireTime};
                paramsList.add(params);
            }
            if (paramsList.size() > 0) {
                String insertSql = "INSERT INTO T_BDTAXR_LOCALMESSAGE (FID,FTYPE,FCREATETIME,FEXPIRETIME) values (?,?,?,?) ";
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)insertSql, paramsList);
            }
        }
        catch (Exception e) {
            logger.error("insertLocalMessage error:" + e.getMessage(), (Throwable)e);
        }
    }
}

