/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.mq;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.MQSender;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQMessage;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQMessage;
import kd.taxc.bdtaxr.common.mq.messagebuilder.DeclareMQMessageBuilder;
import kd.taxc.bdtaxr.common.mq.messagebuilder.DeclareMQMessageBuilderFactory;
import kd.taxc.bdtaxr.common.mq.messagebuilder.ExtendedMQMessage;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class MultiDeclareMQSender
extends MQSender {
    private static final Log logger = LogFactory.getLog(MultiDeclareMQSender.class);
    private static final Map<String, String> operateEvent = new HashMap<String, String>(10);

    public static void sendMQ(DynamicObject[] declares, String operateKey) {
        MultiDeclareMQSender.sendMQ(declares, operateKey, null);
    }

    public static void sendMQ(DynamicObject[] declares, String operateKey, Map<Long, Map<String, Object>> params) {
        try {
            if (EmptyCheckUtils.isEmpty(declares)) {
                return;
            }
            String event = operateEvent.get(operateKey);
            ArrayList<ExtendedMQMessage> extendedMQMessages = new ArrayList<ExtendedMQMessage>(10);
            for (DynamicObject declare : declares) {
                Map<String, Object> declareParams = null;
                if (EmptyCheckUtils.isNotEmpty(params)) {
                    declareParams = params.get(declare.getLong("id"));
                }
                String templateType = declare.getString("templatetype.number");
                if (MultiTableEnum.TSD001.getDeclareMainTable().equals(declare.getDynamicObjectType().getName())) {
                    String draftpurpose = declare.getString("draftpurpose");
                    if ("sjjt".equals(draftpurpose)) {
                        MultiDeclareMQSender.addTamAccrualMQMessage(extendedMQMessages, declare, DeclareMQType.DRAFT.name(), event, declareParams);
                        continue;
                    }
                    String taxType = TemplateTypeConstant.getTypeByValue(templateType);
                    if ("Overseas".equals(taxType)) {
                        MultiDeclareMQSender.addTamDeclareMQMessage(extendedMQMessages, declare, DeclareMQType.DECLARE.name(), event, declareParams);
                        continue;
                    }
                    MultiDeclareMQSender.addTamDraftMQMessage(extendedMQMessages, declare, DeclareMQType.DRAFT.name(), event, declareParams);
                    continue;
                }
                MultiDeclareMQSender.addTamDeclareMQMessage(extendedMQMessages, declare, DeclareMQType.DECLARE.name(), event, declareParams);
                MultiDeclareMQSender.addTcretDeclareMQMessage(extendedMQMessages, declare, DeclareMQType.DECLARE.name(), event, declareParams);
            }
            if (EmptyCheckUtils.isNotEmpty(extendedMQMessages)) {
                MQSender.send(extendedMQMessages);
            }
        }
        catch (Exception e) {
            logger.error("MultiDeclareMQSender sendMQ error:" + e.getMessage(), (Throwable)e);
        }
    }

    private static void addTamDeclareMQMessage(List<ExtendedMQMessage> extendedMQMessages, DynamicObject entity, String topic, String event, Map<String, Object> params) {
        try {
            String type = entity.getString("templatetype.number");
            DeclareMQMessageBuilder messageBuilder = DeclareMQMessageBuilderFactory.getInstance(type);
            DeclareMQMessage message = messageBuilder.buildDeclareMQMessage(entity, topic, event, params);
            ExtendedMQMessage extendedMQMessage = new ExtendedMQMessage();
            extendedMQMessage.setMessage(message);
            extendedMQMessage.setQueue("taxc.common.declare.taxableList");
            extendedMQMessages.add(extendedMQMessage);
        }
        catch (Exception e) {
            logger.error("MultiDeclareMQSender addTamDeclareMQMessage error:" + e.getMessage(), (Throwable)e);
        }
    }

    private static void addTcretDeclareMQMessage(List<ExtendedMQMessage> extendedMQMessages, DynamicObject entity, String topic, String event, Map<String, Object> params) {
        try {
            String type = entity.getString("templatetype.number");
            ArrayList supportTemplateTypes = Lists.newArrayList((Object[])new String[]{"dkdj", "kjqysds"});
            if (!supportTemplateTypes.contains(type)) {
                return;
            }
            DeclareMQMessageBuilder messageBuilder = DeclareMQMessageBuilderFactory.getInstance(type);
            DeclareMQMessage message = messageBuilder.buildDeclareMQMessage(entity, topic, event, params);
            message.setData(messageBuilder.buildDeclareMQMessageData(entity, params));
            ExtendedMQMessage extendedMQMessage = new ExtendedMQMessage();
            extendedMQMessage.setMessage(message);
            extendedMQMessage.setQueue("taxc.common.declare.statistics");
            extendedMQMessages.add(extendedMQMessage);
        }
        catch (Exception e) {
            logger.error("MultiDeclareMQSender addTcretDeclareMQMessage error:" + e.getMessage(), (Throwable)e);
        }
    }

    private static void addTamDraftMQMessage(List<ExtendedMQMessage> extendedMQMessages, DynamicObject entity, String topic, String event, Map<String, Object> params) {
        try {
            String type = entity.getString("templatetype.number");
            DeclareMQMessageBuilder messageBuilder = DeclareMQMessageBuilderFactory.getInstance(type);
            DraftMQMessage message = messageBuilder.buildDraftMQMessage(entity, topic, event, params);
            ExtendedMQMessage extendedMQMessage = new ExtendedMQMessage();
            extendedMQMessage.setMessage(message);
            extendedMQMessage.setQueue("taxc.common.draft.taxableList");
            extendedMQMessages.add(extendedMQMessage);
        }
        catch (Exception e) {
            logger.error("MultiDeclareMQSender addTamDraftMQMessage error:" + e.getMessage(), (Throwable)e);
        }
    }

    private static void addTamAccrualMQMessage(List<ExtendedMQMessage> extendedMQMessages, DynamicObject entity, String topic, String event, Map<String, Object> params) {
        try {
            String type = entity.getString("templatetype.number");
            DeclareMQMessageBuilder messageBuilder = DeclareMQMessageBuilderFactory.getInstance(type);
            AccrualMQMessage message = messageBuilder.buildAccrualMQMessage(entity, topic, event, params);
            ExtendedMQMessage extendedMQMessage = new ExtendedMQMessage();
            extendedMQMessage.setMessage(message);
            extendedMQMessage.setQueue("taxc.common.accrual.accrualList");
            extendedMQMessages.add(extendedMQMessage);
        }
        catch (Exception e) {
            logger.error("MultiDeclareMQSender addTamAccrualMQMessage error:" + e.getMessage(), (Throwable)e);
        }
    }

    static {
        operateEvent.put("delete", DeclareMQEvent.DELETE.name());
        operateEvent.put("save", DeclareMQEvent.SAVE.name());
        operateEvent.put("submit", DeclareMQEvent.SUBMIT.name());
        operateEvent.put("unsubmit", DeclareMQEvent.UNSUBMIT.name());
        operateEvent.put("audit", DeclareMQEvent.AUDIT.name());
        operateEvent.put("unaudit", DeclareMQEvent.UNAUDIT.name());
        operateEvent.put("pay", DeclareMQEvent.PAY.name());
        operateEvent.put("cancelpay", DeclareMQEvent.CANCELPAY.name());
        operateEvent.put("apply", DeclareMQEvent.APPLY.name());
        operateEvent.put("cancelapply", DeclareMQEvent.CANCELAPPLY.name());
    }
}

