/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.mq.messagebuilder.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQMessage;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQMessage;
import kd.taxc.bdtaxr.common.mq.messagebuilder.DeclareMQMessageBuilder;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftConstant;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DefaultDeclareMQMessageBuilder
implements DeclareMQMessageBuilder {
    @Override
    public DeclareMQMessage buildDeclareMQMessage(DynamicObject declare, String topic, String event, Map<String, Object> params) {
        DeclareMQMessage message = new DeclareMQMessage();
        String templateType = declare.getString("templatetype.number");
        message.setTax(TemplateTypeConstant.getTypeByValue(templateType));
        message.setTopic(topic);
        message.setEvent(DeclareMQEvent.match(event));
        message.setSbbid(DefaultDeclareMQMessageBuilder.getStringValue(declare, "id"));
        message.setOrg(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "org"));
        message.setSkssqq(DefaultDeclareMQMessageBuilder.getDateStringValue(declare, "skssqq"));
        message.setSkssqz(DefaultDeclareMQMessageBuilder.getDateStringValue(declare, "skssqz"));
        message.setDeclareType(templateType);
        message.setBillno(DefaultDeclareMQMessageBuilder.getStringValue(declare, "billno"));
        message.setDeclarestatus(DefaultDeclareMQMessageBuilder.getStringValue(declare, "declarestatus"));
        message.setPaystatus(DefaultDeclareMQMessageBuilder.getStringValue(declare, "paystatus"));
        message.setTaxauthority(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxauthority"));
        message.setTaxationsys(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxsystem"));
        message.setTaxareagroup(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxareagroup"));
        if (EmptyCheckUtils.isNotEmpty(params)) {
            if (EmptyCheckUtils.isNotEmpty(params.get("declarestatus"))) {
                message.setDeclarestatus((String)params.get("declarestatus"));
            }
            if (EmptyCheckUtils.isNotEmpty(params.get("paystatus"))) {
                message.setDeclarestatus((String)params.get("paystatus"));
            }
        }
        return message;
    }

    @Override
    public List<DeclareMQMessageData> buildDeclareMQMessageData(DynamicObject entity, Map<String, Object> params) {
        String templateType = entity.getString("templatetype.number");
        DeclareMQMessageData data = new DeclareMQMessageData();
        data.setBusinessSource("0");
        data.setDeclareType(templateType);
        if (TableTypeMapTemplateTypeEnum.getEnumByTemplateType(templateType) != null) {
            data.setTableType(TableTypeMapTemplateTypeEnum.getEnumByTemplateType(templateType).getTableType());
        }
        data.setTaxType(DefaultDeclareMQMessageBuilder.doGetBaseTaxTypeId(DeclareTaxType.nssbMatchBase(TemplateTypeConstant.getTypeByValue(templateType))));
        data.setDataType(DefaultDeclareMQMessageBuilder.getStringValue(entity, "datatype"));
        data.setSbbid(DefaultDeclareMQMessageBuilder.getStringValue(entity, "id"));
        data.setBillNo(DefaultDeclareMQMessageBuilder.getStringValue(entity, "billno"));
        data.setBillStatus(DefaultDeclareMQMessageBuilder.getStringValue(entity, "billstatus"));
        data.setOrg(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(entity, "org"));
        data.setSkssqq(DefaultDeclareMQMessageBuilder.getDateStringValue(entity, "skssqq"));
        data.setSkssqz(DefaultDeclareMQMessageBuilder.getDateStringValue(entity, "skssqz"));
        data.setStartDate(DefaultDeclareMQMessageBuilder.getDateStringValue(entity, "skssqq"));
        data.setEndDate(DefaultDeclareMQMessageBuilder.getDateStringValue(entity, "skssqz"));
        data.setSerialno(DefaultDeclareMQMessageBuilder.getStringValue(entity, "serialno"));
        data.setSjje(DefaultDeclareMQMessageBuilder.getBigDecimalValue(entity, "sjje"));
        data.setPaydate(DefaultDeclareMQMessageBuilder.getDateTimeStringValue(entity, "paydate"));
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(templateType);
        if (templateEnum != null) {
            data.setEntityName(templateEnum.getDraftQueryPage());
        }
        return Collections.singletonList(data);
    }

    @Override
    public DraftMQMessage buildDraftMQMessage(DynamicObject declare, String topic, String event, Map<String, Object> params) {
        DraftMQMessage message = new DraftMQMessage();
        String templatetype = declare.getString("templatetype.number");
        message.setTemplatetype(templatetype);
        String drafttype = TemplateTypeConstant.getDraftTypeByDraftTemplateType(templatetype);
        message.setTax(DraftConstant.getTaxByDraftType(drafttype));
        message.setDrafttype(drafttype);
        message.setTopic(topic);
        message.setEvent(DeclareMQEvent.match(event));
        message.setOrg(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "org"));
        message.setSkssqq(DefaultDeclareMQMessageBuilder.getDateStringValue(declare, "skssqq"));
        message.setSkssqz(DefaultDeclareMQMessageBuilder.getDateStringValue(declare, "skssqz"));
        message.setType(DefaultDeclareMQMessageBuilder.getStringValue(declare, "type"));
        message.setDraftPurpose(DefaultDeclareMQMessageBuilder.getStringValue(declare, "draftpurpose"));
        message.setBillno(DefaultDeclareMQMessageBuilder.getStringValue(declare, "billno"));
        message.setBillstatus(DefaultDeclareMQMessageBuilder.getStringValue(declare, "billstatus"));
        message.setTaxationsys(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxsystem"));
        message.setTaxareagroup(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxareagroup"));
        return message;
    }

    @Override
    public AccrualMQMessage buildAccrualMQMessage(DynamicObject declare, String topic, String event, Map<String, Object> params) {
        AccrualMQMessage message = new AccrualMQMessage();
        message.setOrgid(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "org"));
        message.setTaxsystem(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxsystem"));
        message.setTaxareagroup(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxareagroup"));
        message.setTaxtype(DefaultDeclareMQMessageBuilder.getDynamicObjectValue(declare, "taxtype"));
        message.setAccountsettype(DefaultDeclareMQMessageBuilder.getStringValue(declare, "accountsettype"));
        message.setTemplatetype(DefaultDeclareMQMessageBuilder.getStringValue(declare, "templatetype.number"));
        message.setSkssqq(DefaultDeclareMQMessageBuilder.getDateValue(declare, "skssqq"));
        message.setSkssqz(DefaultDeclareMQMessageBuilder.getDateValue(declare, "skssqz"));
        return message;
    }

    private static String doGetBaseTaxTypeId(String taxTypeNumber) {
        if (DeclareTaxType.FJSF.getBaseTaxCode().equals(taxTypeNumber)) {
            return "2";
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxTypeNumber)});
        return obj == null ? null : obj.getString("id");
    }

    private static BigDecimal getBigDecimalValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key) || entity.getBigDecimal(key) == null) {
            return BigDecimal.ZERO;
        }
        return entity.getBigDecimal(key);
    }

    private static Date getDateValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return null;
        }
        return entity.getDate(key);
    }

    private static String getDateStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key) || entity.getDate(key) == null) {
            return "";
        }
        return DateUtils.format(entity.getDate(key));
    }

    private static String getDateTimeStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key) || entity.getDate(key) == null) {
            return "";
        }
        return DateUtils.format(entity.getDate(key), "yyyy-MM-dd HH:mm:ss");
    }

    private static String getStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return "";
        }
        return entity.getString(key);
    }

    private static Long getDynamicObjectValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return null;
        }
        Object value = entity.get(key);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }
}

