/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.onekeygenerate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQSender;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;

public abstract class AbstractEngineHandler
implements EngineHandler {
    @Override
    public void execute(EngineModel engineModel) {
        try {
            this.getEngineList().forEach(e -> e.deleteData(engineModel));
            String draftpurpose = (String)engineModel.getCustom().getOrDefault("draftpurpose", "nssb");
            String declareType = engineModel.getDeclareType();
            String draftType = TemplateEnum.getEnumByDeclareType(declareType, draftpurpose).getDraftType();
            StatusUtils.delete(draftType, engineModel.getOrgId(), engineModel.getStartDate(), engineModel.getEndDate(), draftpurpose);
            DynamicObject statusBill = StatusUtils.createStatus(draftType, engineModel.getOrgId(), engineModel.getStartDate(), engineModel.getEndDate(), this.getStatus(), draftpurpose, engineModel.getOrgId());
            if (engineModel.getPageCache() != null) {
                engineModel.getPageCache().put("draftId", statusBill.getString("id"));
            }
            this.updateDraftCodeNumber(engineModel, draftType);
            this.getEngineList().forEach(e -> e.runEngine(engineModel));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected void updateDraftCodeNumber(EngineModel model, String draftType) {
        String draftpurpose = (String)model.getCustom().getOrDefault("draftpurpose", "nssb");
        DynamicObject statusBill = StatusUtils.queryOne(draftType, model.getOrgId(), model.getStartDate(), model.getEndDate(), draftpurpose);
        if (statusBill != null) {
            if ("sjjt".equals(draftpurpose)) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)statusBill.get("id"), (String)"tpo_declare_main_tsd");
                DynamicObject numberObject = BusinessDataServiceHelper.newDynamicObject((String)"tctb_draft_main");
                String number = DeclareServiceHelper.generateSBBNo("tctb_draft_main", numberObject, model.getOrgId());
                String draftNumberPrefix = this.getDraftNumberPrefix(model, draftType);
                number = StatusUtils.getDraftNumber(draftpurpose, number, draftNumberPrefix, draftType);
                String dgType = draftNumberPrefix.split("-")[1];
                object.set("type", (Object)dgType);
                object.set("billno", (Object)number);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                AccrualMQSender.sendMQ(BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"tpo_declare_main_tsd"));
            } else {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)statusBill.get("id"), (String)"tctb_draft_main");
                String number = DeclareServiceHelper.generateSBBNo("tctb_draft_main", object, model.getOrgId());
                String draftNumberPrefix = this.getDraftNumberPrefix(model, draftType);
                number = number.replaceAll("X", draftNumberPrefix);
                String dgType = draftNumberPrefix.split("-")[1];
                object.set("type", (Object)dgType);
                object.set("billno", (Object)number);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                DraftMQSender.sendMQ(object, object.getDate("startdate"), object.getDate("enddate"), DeclareMQType.DRAFT.name(), DeclareMQEvent.SAVE.name());
            }
        }
    }

    @Override
    public void validate(EngineModel engineModel) throws KDBizException {
    }

    @Override
    public void handleException(KDBizException exception, IFormView view, IFormPlugin plugin) {
    }

    public String getDraftNumberPrefix(EngineModel model, String draftType) {
        return DraftConstant.getDraftNumberPrefix(draftType);
    }

    protected abstract String getStatus();
}

