/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DraftQueryListOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DraftQueryListOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if (DeclareMQEvent.DELETE.name().equalsIgnoreCase(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            for (DynamicObject entity : dataEntities) {
                DynamicObject draft = null;
                try {
                    Object pkValue = entity.getPkValue();
                    draft = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tpo_declare_main_tsd");
                    String templatetype = draft.get("templatetype") instanceof DynamicObject ? draft.getString("templatetype.number") : draft.getString("templatetype");
                    String declareType = TemplateEnum.getEnumByDraftType(templatetype).getDeclareType();
                    EngineHandler handler = EngineHandlerFactory.createHandler(declareType);
                    List<IEngine> engineList = handler.getEngineList();
                    String orgId = draft.getDynamicObject("org").getString("id");
                    Date startdate = draft.getDate("skssqq");
                    Date enddate = draft.getDate("skssqz");
                    String draftpurpose = draft.getString("draftpurpose");
                    String skssqq = startdate != null ? DateUtils.format(draft.getDate("skssqq")) : "1900-01-01";
                    String skssqz = enddate != null ? DateUtils.format(draft.getDate("skssqz")) : "1900-01-31";
                    EngineModel engineModel = handler.getEngineModel(templatetype, declareType, orgId, startdate, enddate, skssqq, skssqz);
                    engineModel.addCustom("draftpurpose", draftpurpose);
                    engineList.forEach(e -> e.deleteData(engineModel));
                    successObjs.add(entity);
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u5e95\u7a3f\u6570\u636e\u5931\u8d25\uff01", (String)"DraftQueryListOp_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entity.getString("billno"));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_draft_error", "", msg, ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                }
            }
            Set<Object> idSet = successObjs.stream().map(a -> a.get("id")).collect(Collectors.toSet());
            new DraftService().deleteRiskItem("tpo_declare_main_tsd", idSet);
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        }
    }
}

