/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.entity.property.BasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import org.apache.commons.lang.StringUtils;

public class BaseDataListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String[] EXCLUDE_FORMS = new String[]{"tcvat_rollout_register", "tcvat_initialization", "tcvat_tax_refund_account", "tcvat_prepay_project_info", "tcvat_output_sign", "tctrc_risk_run_list"};
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private List<Map<String, List<Object>>> customfilter = null;
    private FilterColumn filterColumn;
    private String orgField = null;

    public void beforeF7Select(BeforeFilterF7SelectEvent paramBeforeFilterF7SelectEvent) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.getOrgField();
        if (this.orgField == null) {
            return;
        }
        CommonFilterColumn orgColumn = this.getOrgFilterColumn(filterColumnList);
        if (orgColumn == null) {
            return;
        }
        List<ComboItem> combos = this.getOrgComboItem();
        String defaultOrg = this.getPageCache().get("CACHE_DEFAULT_ORG");
        if (defaultOrg == null && !combos.isEmpty()) {
            defaultOrg = combos.get(0).getValue();
        }
        if ("tcret_query_report".equals(listShowParameter.getBillFormId())) {
            orgColumn.setDefaultValue(null);
        } else {
            orgColumn.setDefaultValue(defaultOrg);
        }
        orgColumn.setType("enum");
        orgColumn.setComboItems(combos);
        if (this.filterValues == null) {
            this.filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
            this.filterValues.put("fastfilter", new ArrayList());
            this.filterValues.put("customfilter", new ArrayList());
            for (FilterColumn filterColumn : filterColumnList) {
                HashMap<String, List> customFiter = new HashMap<String, List>();
                ArrayList<String> fieldName = new ArrayList<String>();
                fieldName.add(filterColumn.getFieldName());
                customFiter.put("FieldName", fieldName);
                if (filterColumn.getFieldName().startsWith(this.orgField + ".")) {
                    ArrayList<String> value = new ArrayList<String>();
                    value.add(defaultOrg);
                    customFiter.put("Value", value);
                } else if (filterColumn.getDefaultValues() != null && filterColumn.getDefaultValues().size() > 0) {
                    customFiter.put("Value", filterColumn.getDefaultValues());
                }
                if (customFiter.get("Value") == null) continue;
                this.filterValues.get("customfilter").add(customFiter);
            }
            this.customfilter = this.filterValues.get("customfilter");
            this.filterColumn = orgColumn;
            String customfilterSer = SerializationUtils.toJsonString(this.customfilter);
            this.getPageCache().put("customfilter", customfilterSer);
            this.getPageCache().put("CACHE_DEFAULT_ORG", defaultOrg);
            this.getPageCache().put("verifyOrg", defaultOrg);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String entityId;
        FormOperate operate = (FormOperate)args.getSource();
        if (operate instanceof Refresh) {
            this.getOrgField();
        } else if (operate instanceof StatusConvert && (entityId = operate.getEntityId()).equals("tctb_invoice_setting")) {
            this.invoiceSettingOperate(args, operate, entityId);
        }
    }

    private void invoiceSettingOperate(BeforeDoOperationEventArgs args, FormOperate operate, String entityId) {
        String enable = "B";
        String disable = "C";
        ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
        List pks = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        QFilter pkFilter = new QFilter("id", "in", pks);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityId, (String)"id,billstatus", (QFilter[])new QFilter[]{pkFilter});
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            args.setCancel(true);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if ("enable".equals(operate.getType()) && enable.equals(dynamicObject.getString("billstatus"))) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u6570\u636e\u4e0d\u9700\u8981\u518d\u6b21\u542f\u7528", (String)"BaseDataListPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            if (!"disable".equals(operate.getType()) || !disable.equals(dynamicObject.getString("billstatus"))) continue;
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u6570\u636e\u4e0d\u9700\u8981\u518d\u6b21\u7981\u7528", (String)"BaseDataListPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.filterValues = args.getSearchClickEvent().getFilterValues();
        List<Map<String, List<Object>>> customFiterList = this.filterValues.get("customfilter");
        if (customFiterList == null) {
            this.getPageCache().remove("customfilter");
            return;
        }
        String customfilterSer = SerializationUtils.toJsonString(customFiterList);
        this.getPageCache().remove("customfilter");
        this.getPageCache().put("customfilter", customfilterSer);
        String orgId = null;
        this.getPageCache().remove("CACHE_DEFAULT_ORG");
        for (Map<String, List<Object>> customFiter : customFiterList) {
            List<Object> orgIds;
            List<Object> fieldNames = customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !fieldNames.get(0).toString().startsWith(this.orgField + ".") || (orgIds = customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            this.getPageCache().put("CACHE_DEFAULT_ORG", String.valueOf(orgId));
            this.getPageCache().put("verifyOrg", String.valueOf(orgId));
            break;
        }
        super.filterContainerSearchClick(args);
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        String useOrg = this.getPageCache().get("CACHE_DEFAULT_ORG");
        if (this.filterColumn == null) {
            return;
        }
        CommonFilterColumn ff = (CommonFilterColumn)this.filterColumn;
        if (!ff.isMulti()) {
            this.filterColumn.setDefaultValue(useOrg);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs(this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            OrgUtils.addFilterByConditionBeforeF7Select(args, this.getView(), EXCLUDE_FORMS, null, null);
        }
    }

    public String getEntityNumber() {
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String entity = listShowParameter.getBillFormId();
            return entity;
        }
        return this.getView().getEntityId();
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        ArrayList<Map<String, String>> orgList = new ArrayList();
        if (orgListCacheString == null || StringUtils.equals((String)orgListCacheString, (String)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems(this.getView(), EXCLUDE_FORMS, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }

    private CommonFilterColumn getOrgFilterColumn(List<FilterColumn> filterColumnList) {
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith(this.orgField + ".") || !(filterColumn instanceof CommonFilterColumn)) continue;
            return (CommonFilterColumn)filterColumn;
        }
        return null;
    }

    public String getOrgField() {
        if (this.orgField == null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                IDataEntityType parent;
                String extendName;
                BasedataProp decProp;
                if (!(property instanceof BasedataProp) || !"bos_org".equals((decProp = (BasedataProp)property).getBaseEntityId()) || "til_invoice_list".equals(extendName = (parent = decProp.getParent()).getExtendName()) && "org".equals(decProp.getName())) continue;
                this.orgField = decProp.getName();
                break;
            }
        }
        return this.orgField;
    }
}

