/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.plugin;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.dto.ExrateConvertDto;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.enums.RuleConfigEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TctbAdvanceConfForm
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    public static final String ADVANCED_CONF = "advancedconf";
    public static final String ADVANCED_CONF_JSON = "advancedconfjson";
    public static final String ADVANCED_CONF_DATA = "advancedConfData";
    public static final String ADVANCED_CONF_VALUE = "advancedConfValue";
    public static final String ADVANCED_ONLY_READ = "onlyRead";
    public static final String DATA_TYPE = "datatype";
    public static final String VATRATE = "vatrate";
    public static final String YZ_VATRATE = "yzvatrate";
    public static final String JSBL = "jsbl";
    public static final String ADVANCECONFKEY = "advanceconfKey";
    private static final String RATEFLEXPANELAP = "rateflexpanelap";
    private static final String MUST_CONVERT_RATE = "mustConvertRate";
    private static final String START = "start";
    private static final String END = "end";
    private static final String ENDAVG = "endavg";
    public static final String EXRATEJSON = "exratejson";
    private static final String EXRATELOGIC = "exratelogic";
    public static final String DIFFERENCE_INVOICE = "differenceinvoice";
    private static final String EXRATETABLE = "exratetable";
    private static final String ORIGINALCOIN = "originalcoin";
    private static final String TARGETCOIN = "targetcoin";
    private static final String EXRATETYPE = "exratetype";
    private static final String CONVERTRATE = "convertrate";
    private static final Set<String> MUSTIN_FIELDS = Sets.newHashSet((Object[])new String[]{"convertrate", "exratetable", "originalcoin", "targetcoin", "exratetype", "exratelogic"});
    public static final String CONVERT_RATE_JSON = "convert_rate_json";
    private static final String ADVANCECONF_KEY = "advanceconfKey";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
        BasedataEdit originalcoin = (BasedataEdit)this.getControl(ORIGINALCOIN);
        originalcoin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetcoin = (BasedataEdit)this.getControl(TARGETCOIN);
        targetcoin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4", "flexpanelap5", "flexpanelap6", "flexpanelap9"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String data = (String)customParams.get(ADVANCED_CONF_DATA);
        Boolean onlyRead = (Boolean)customParams.get(ADVANCED_ONLY_READ);
        if (Boolean.TRUE.equals(onlyRead)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap3"});
        }
        String[] itemStr = data.split(",");
        ArrayList<ComboItem> selctItem = new ArrayList<ComboItem>();
        for (int i = 0; i < itemStr.length; ++i) {
            if (!StringUtils.isNotEmpty((String)itemStr[i])) continue;
            selctItem.add(new ComboItem(new LocaleString(RuleConfigEnum.getRuleConfigName(itemStr[i])), itemStr[i]));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        comboEdit.setComboItems(selctItem);
        String value = (String)customParams.get(ADVANCED_CONF_VALUE);
        String dataType = (String)customParams.get(DATA_TYPE);
        String advanceconfKey = (String)customParams.get("advanceconfKey");
        BigDecimal vatrateValue = BigDecimal.ZERO;
        boolean vatrateVisible = false;
        boolean qsljVisible = true;
        String parentFormId = this.getParentFormId();
        String serviceAppId = this.getParentFormServiceAppId();
        String defaultValue = new ComboItem(new LocaleString(RuleConfigEnum.getRuleConfigName(value)), value).getValue();
        boolean existsDefault = selctItem.stream().anyMatch(s -> s.getValue().equals(defaultValue));
        this.getModel().setValue("combofield", (Object)(existsDefault ? defaultValue : (selctItem.size() > 0 ? ((ComboItem)selctItem.get(0)).getValue() : "")));
        if (null != dataType) {
            if ("tcvat".equals(serviceAppId)) {
                if ("tcvat_rule_income".equals(parentFormId) || "tcvat_n_rule_query".equals(parentFormId)) {
                    qsljVisible = false;
                    if (dataType.equals(DataType.ZJQS.getCode()) || "invoiceentryentity".equals(advanceconfKey) || "setadvancedconf1".equals(advanceconfKey) || "qtfpbhssrentryentity".equals(advanceconfKey)) {
                        vatrateVisible = false;
                    } else {
                        vatrateVisible = true;
                        vatrateValue = new BigDecimal(customParams.get(VATRATE).toString());
                    }
                    this.getView().setVisible(Boolean.valueOf("sim_vatinvoice".equals(customParams.get("entityNumber"))), new String[]{"flexpanelap9"});
                    Boolean differenceInvoice = (Boolean)customParams.get(DIFFERENCE_INVOICE);
                    this.getModel().setValue(DIFFERENCE_INVOICE, (Object)differenceInvoice);
                    if ("acctentryentity".equals(advanceconfKey) || "wkpseentryentity".equals(advanceconfKey) || "setadvancedconf".equals(advanceconfKey) || "setadvancedconf3".equals(advanceconfKey)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
                    }
                } else if ("tcvat_rule_refund".equals(parentFormId)) {
                    qsljVisible = "setadvancedconf".equals(advanceconfKey);
                    vatrateVisible = !dataType.equals(DataType.ZJQS.getCode());
                    vatrateValue = vatrateVisible ? new BigDecimal(customParams.get(VATRATE).toString()) : BigDecimal.ZERO;
                }
            } else {
                if (dataType.equals(DataType.JSFLQS.getCode()) || dataType.equals(DataType.CYSLDSQS.getCode()) || dataType.equals(DataType.SEHSHSJ.getCode()) || dataType.equals("yjjsflqs")) {
                    vatrateVisible = true;
                    vatrateValue = new BigDecimal(customParams.get(VATRATE).toString());
                }
                if (dataType.equals(DataType.HSJHSSE.getCode()) || dataType.equals(DataType.BHSJHSSE.getCode())) {
                    qsljVisible = false;
                    vatrateVisible = true;
                    vatrateValue = new BigDecimal(customParams.get(VATRATE).toString());
                }
                if ("rdesd_accessconfig".equals(parentFormId)) {
                    vatrateVisible = true;
                    BigDecimal bigDecimal = vatrateValue = vatrateVisible ? new BigDecimal(customParams.get(VATRATE).toString()) : BigDecimal.ZERO;
                }
                if (dataType.equals(DataType.ZJQS.getCode())) {
                    vatrateVisible = false;
                }
                if ("tcvvt".equals(serviceAppId) && ("tcvvt_tax_accessconfig".equals(parentFormId) || "tcvvt_qh_accessconfig".equals(parentFormId))) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
                    ((DecimalEdit)this.getControl(JSBL)).setMustInput(true);
                    this.getModel().setValue(JSBL, (Object)new BigDecimal(customParams.get(JSBL).toString()));
                }
            }
            if (dataType.equals("gjqs")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
                this.getModel().setValue(JSBL, (Object)new BigDecimal(customParams.get(JSBL).toString()));
            }
            if (dataType.equals("yjjsflqs")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap5", "flexpanelap6"});
                this.getModel().setValue(YZ_VATRATE, (Object)new BigDecimal(customParams.get(YZ_VATRATE).toString()));
            }
        }
        this.getModel().setValue(VATRATE, (Object)vatrateValue);
        this.getView().setVisible(Boolean.valueOf(vatrateVisible), new String[]{VATRATE});
        this.getView().setVisible(Boolean.valueOf(vatrateVisible), new String[]{"flexpanelap2"});
        this.getView().setVisible(Boolean.valueOf(qsljVisible), new String[]{"flexpanelap1"});
        this.getPageCache().put(MUST_CONVERT_RATE, "0");
        if (this.showConvertRate()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{RATEFLEXPANELAP});
            String convertRateJson = (String)customParams.get(CONVERT_RATE_JSON);
            if (!StringUtil.isBlank((CharSequence)convertRateJson) && !StringUtil.eqNull(convertRateJson)) {
                ExrateConvertDto convertRateMap = (ExrateConvertDto)SerializationUtils.fromJsonString((String)convertRateJson, ExrateConvertDto.class);
                Boolean convertrate = convertRateMap.getConvertrate();
                if (Boolean.TRUE.equals(convertrate)) {
                    this.getPageCache().put(MUST_CONVERT_RATE, "1");
                    this.setMustIn(Boolean.TRUE);
                    this.getModel().setValue(CONVERTRATE, (Object)Boolean.TRUE);
                }
                String exratetable = convertRateMap.getExratetable();
                String originalcoin = convertRateMap.getOriginalcoin();
                String targetcoin = convertRateMap.getTargetcoin();
                String exratetype = convertRateMap.getExratetype();
                String exratelogic = convertRateMap.getExratelogic();
                if (StringUtils.isNotEmpty((String)exratetable)) {
                    this.getModel().setValue(EXRATETABLE, (Object)Long.parseLong(exratetable));
                }
                if (StringUtils.isNotEmpty((String)originalcoin)) {
                    this.getModel().setValue(ORIGINALCOIN, (Object)Long.parseLong(originalcoin));
                }
                if (StringUtils.isNotEmpty((String)targetcoin)) {
                    this.getModel().setValue(TARGETCOIN, (Object)Long.parseLong(targetcoin));
                }
                if (StringUtils.isNotEmpty((String)exratetype)) {
                    this.getModel().setValue(EXRATETYPE, (Object)exratetype);
                }
                if (StringUtils.isNotEmpty((String)exratelogic)) {
                    this.getModel().setValue(EXRATELOGIC, (Object)exratelogic);
                }
            } else {
                String exratelogicDefault = START;
                if (this.getView().getParentView() != null && "tccit".equals(serviceAppId)) {
                    exratelogicDefault = "tccit_year_rule".equals(parentFormId) ? ENDAVG : END;
                }
                this.getModel().setValue(EXRATELOGIC, (Object)exratelogicDefault);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{RATEFLEXPANELAP});
        }
    }

    private boolean showConvertRate() {
        boolean showConvertRate = Boolean.FALSE;
        if (this.getView().getParentView() != null) {
            FormShowParameter formShowParameter = this.getView().getParentView().getFormShowParameter();
            String formId = formShowParameter.getFormId();
            String serviceAppId = formShowParameter.getServiceAppId();
            String advanceconfKey = (String)this.getView().getFormShowParameter().getCustomParams().get("advanceconfKey");
            if ("tccit".equals(serviceAppId) && !"tccit_standbook_rule_item".equals(formId)) {
                showConvertRate = Boolean.TRUE;
            }
            if ("tcvat".equals(serviceAppId) && ("tcvat_rule_income".equals(formId) && !"setadvancedconf2".equals(advanceconfKey) || "tcvat_n_rule_query".equals(formId) || "tcvat_rule_refund".equals(formId)) && !"invoicesetadvancedconf".equals(advanceconfKey) && !"invoiceentryentity".equals(advanceconfKey) && !"zyfpseentryentity".equals(advanceconfKey)) {
                showConvertRate = Boolean.TRUE;
            }
            if ("tcvvt".equals(serviceAppId) && ("tcvvt_tax_accessconfig".equals(formId) || "tcvvt_qh_accessconfig".equals(formId))) {
                showConvertRate = Boolean.TRUE;
            }
        }
        return showConvertRate;
    }

    private String getParentFormId() {
        if (this.getView().getParentView() != null) {
            return this.getView().getParentView().getFormShowParameter().getFormId();
        }
        return null;
    }

    private String getParentFormServiceAppId() {
        if (this.getView().getParentView() != null) {
            return this.getView().getParentView().getFormShowParameter().getServiceAppId();
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (CONVERTRATE.equals(name)) {
            this.setMustIn((Boolean)newValue);
        } else if (EXRATETABLE.equals(name)) {
            this.getModel().setValue(ORIGINALCOIN, null);
            this.getModel().setValue(TARGETCOIN, null);
        } else if (ORIGINALCOIN.equals(name)) {
            this.getModel().setValue(TARGETCOIN, null);
        }
    }

    private void setMustIn(Boolean must) {
        this.getPageCache().put(MUST_CONVERT_RATE, must != false ? "1" : "0");
        List<String> fields = Arrays.asList(EXRATETABLE, ORIGINALCOIN, TARGETCOIN, EXRATELOGIC, EXRATETYPE);
        HashMap map = new HashMap(2);
        HashMap<String, Boolean> itemsMap = new HashMap<String, Boolean>(2);
        itemsMap.put("mi", must);
        map.put("item", itemsMap);
        for (String field : fields) {
            this.getView().updateControlMetadata(field, map);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        Boolean onlyRead = (Boolean)this.getView().getFormShowParameter().getCustomParams().get(ADVANCED_ONLY_READ);
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            if (Boolean.TRUE.equals(onlyRead)) {
                this.getView().close();
                return;
            }
            if (this.valid()) {
                this.returnDataToParent();
            }
        }
        if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private boolean valid() {
        String combofield = (String)this.getModel().getValue("combofield");
        if (StringUtils.isBlank((String)combofield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u6570\u903b\u8f91\u3002", (String)"TctbAdvanceConfForm_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return false;
        }
        if ("1".equals(this.getPageCache().get(MUST_CONVERT_RATE))) {
            for (String mustinField : MUSTIN_FIELDS) {
                if (this.getModel().getValue(mustinField) != null && (!(this.getModel().getValue(mustinField) instanceof String) || !StringUtil.isEmpty((CharSequence)((CharSequence)this.getModel().getValue(mustinField))))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u5f55\u5b57\u6bb5\u4e0d\u5f97\u4e3a\u7a7a\u3002", (String)"TctbAdvanceConfForm_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        this.getView().returnDataToParent(ret);
        this.getView().close();
    }

    private Map<String, Object> getConfig() {
        String combofield = (String)this.getModel().getValue("combofield");
        BigDecimal vatrate = (BigDecimal)this.getModel().getValue(VATRATE);
        BigDecimal yzvatrate = (BigDecimal)this.getModel().getValue(YZ_VATRATE);
        Boolean differenceInvoice = (Boolean)this.getModel().getValue(DIFFERENCE_INVOICE);
        BigDecimal jsbl = (BigDecimal)this.getModel().getValue(JSBL);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(ADVANCED_CONF, RuleConfigEnum.getRuleConfigName(combofield));
        data.put(ADVANCED_CONF_JSON, combofield);
        data.put(VATRATE, vatrate);
        data.put(YZ_VATRATE, yzvatrate);
        data.put(JSBL, jsbl);
        data.put(DIFFERENCE_INVOICE, differenceInvoice);
        if ("1".equals(this.getPageCache().get(MUST_CONVERT_RATE))) {
            ExrateConvertDto exrateConvertDto = new ExrateConvertDto();
            DynamicObject dyobject = (DynamicObject)this.getModel().getValue(EXRATETABLE);
            String exrateTableStr = dyobject != null ? dyobject.getString("id") : "0";
            DynamicObject originalcoin = (DynamicObject)this.getModel().getValue(ORIGINALCOIN);
            String originalcoinStr = originalcoin != null ? originalcoin.getString("id") : "0";
            DynamicObject targetcoin = (DynamicObject)this.getModel().getValue(TARGETCOIN);
            String targetcoinStr = targetcoin != null ? targetcoin.getString("id") : "0";
            Boolean convertrate = (Boolean)this.getModel().getValue(CONVERTRATE);
            String exrateType = (String)this.getModel().getValue(EXRATETYPE);
            String exrateLogic = (String)this.getModel().getValue(EXRATELOGIC);
            exrateConvertDto.setConvertrate(convertrate);
            exrateConvertDto.setExratetable(exrateTableStr);
            exrateConvertDto.setOriginalcoin(originalcoinStr);
            exrateConvertDto.setTargetcoin(targetcoinStr);
            exrateConvertDto.setExratetype(exrateType);
            exrateConvertDto.setExratelogic(exrateLogic);
            data.put(CONVERT_RATE_JSON, SerializationUtils.toJsonString((Object)exrateConvertDto));
        }
        return data;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        DynamicObject value = (DynamicObject)this.getModel().getValue(EXRATETABLE);
        if (value != null) {
            if (ORIGINALCOIN.equals(name)) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_exrate_tree", (String)"orgcur.id,cur.id", (QFilter[])new QFilter("exctable", "=", value.get("id")).toArray());
                Set collect = query.stream().map(a -> a.get("orgcur.id")).collect(Collectors.toSet());
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", collect));
            } else if (TARGETCOIN.equals(name)) {
                DynamicObject orinal = (DynamicObject)this.getModel().getValue(ORIGINALCOIN);
                if (orinal != null) {
                    QFilter qFilter = new QFilter("exctable", "=", value.get("id")).and("orgcur", "=", orinal.get("id"));
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_exrate_tree", (String)"orgcur.id,cur.id", (QFilter[])qFilter.toArray());
                    Set collect = query.stream().map(a -> a.get("cur.id")).collect(Collectors.toSet());
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", collect));
                } else {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "=", (Object)0L));
                }
            }
        } else {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c47\u7387\u8868", (String)"TctbAdvanceConfForm_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }
}

