/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareShowPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String ORG = "org";
    private static final String PARA_ORG = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String TABPAGEAP2 = "tabpageap2";
    private static final String TABPAGEAP3 = "tabpageap3";
    private static final String TABPAGEAP4 = "tabpageap4";
    private static final String TABPAGEAP5 = "tabpageap5";
    protected static final String DRAFTTEMPLATE = "draft_qysdsnb";
    protected static final String TEMPLATE = "qysdsnb";
    private static final String[] tab_keys = new String[]{"tabpageap1", "tabpageap2", "tabpageap3", "tabpageap4", "tabpageap5"};

    public void registerListener(EventObject e) {
        this.addClickListeners(tab_keys);
    }

    private void setActiveTab(String tabKey) {
        HashMap<String, Object> stylemap = new HashMap<String, Object>(2);
        stylemap.put("bc", "#F3F6FF");
        String linestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", linestyle);
        style.put("b", border);
        stylemap.put("s", style);
        this.getView().updateControlMetadata(tabKey, stylemap);
        HashMap<String, Object> stylemap1 = new HashMap<String, Object>(2);
        stylemap1.put("bc", "#ffffff");
        String linestyle1 = "0px_solid_#ffffff";
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("b", linestyle1);
        style1.put("b", border1);
        stylemap1.put("s", style1);
        Arrays.asList(tab_keys).forEach(key -> {
            if (!key.equals(tabKey)) {
                this.getView().updateControlMetadata(key, stylemap1);
            }
        });
        this.showTab(tabKey);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String type = (String)this.getView().getFormShowParameter().getCustomParams().get("type");
        if (TEMPLATE.equals(type) && TABPAGEAP5.equals(key)) {
            String startDate = this.getParam(SKSSQQ);
            String endDate = this.getParam(SKSSQZ);
            String orgId = this.getParam(PARA_ORG);
            DynamicObject draftDyo = this.queryDraftBillObject(orgId, startDate, endDate);
            DynamicObject dyo = YbnsrService.queryYbnsr(orgId, TEMPLATE, startDate, endDate, null);
            if (draftDyo == null || "2".equals(dyo.getString("datatype"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u68c0\u6d4b\u5230\u6709\u5b58\u50a8\u7684\u5e95\u7a3f\u6570\u636e\u3002", (String)"DeclareShowPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
        }
        if (Arrays.asList(tab_keys).contains(key)) {
            this.setActiveTab(key);
        }
    }

    protected DynamicObject queryDraftBillObject(String orgId, String startdate, String enddate) {
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startdate)).and(new QFilter("enddate", "=", (Object)DateUtils.stringToDate(enddate)));
        QFilter templatetype = new QFilter("templatetype", "=", (Object)DRAFTTEMPLATE);
        return QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, templatetype});
    }

    public void afterCreateNewData(EventObject e) {
        String orgId = this.getParam(PARA_ORG);
        String startDate = this.getParam(SKSSQQ);
        String endDate = this.getParam(SKSSQZ);
        this.getModel().setValue(ORG, (Object)orgId);
        this.getModel().setValue("startdate", (Object)DateUtils.stringToDate(startDate));
        this.getModel().setValue("enddate", (Object)DateUtils.stringToDate(endDate));
        String type = (String)this.getView().getFormShowParameter().getCustomParams().get("type");
        this.getView().setVisible(Boolean.valueOf(TEMPLATE.equals(type)), new String[]{TABPAGEAP5});
        this.setActiveTab(TABPAGEAP1);
    }

    public void tabSelected(TabSelectEvent event) {
        this.showTab(event.getTabKey());
    }

    private void showTab(String tableKey) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (TABPAGEAP1.equals(tableKey)) {
            FormShowParameter parameter = new FormShowParameter();
            String templatetype = (String)customParams.get("templatetype");
            if (Arrays.asList(TEMPLATE, "qysdsnb_fzjg", "qysds_hdzs_nb", "qtsf_tysbb", "qtsf_fsstysbb", "whsyjsf").contains(templatetype) && "bdtaxr_history_sbb".equals(customParams.get("entityid"))) {
                this.createRequest(customParams, templatetype);
            }
            QFilter qFilter = new QFilter("type", "=", (Object)templatetype);
            boolean isNewTemplate = QueryServiceHelper.exists((String)"bdtaxr_template_main", (QFilter[])new QFilter[]{qFilter});
            if ("totf_cjrjybzj".equals(templatetype)) {
                parameter.setFormId("bdtaxr_declare_multi");
            } else if (isNewTemplate) {
                parameter.setFormId("bdtaxr_declare");
            } else {
                parameter.setFormId("bdtaxr_declare_old");
            }
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexcontent");
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        } else if (TABPAGEAP5.equals(tableKey)) {
            String startDate = this.getParam(SKSSQQ);
            String endDate = this.getParam(SKSSQZ);
            String orgId = this.getParam(PARA_ORG);
            FormShowParameter parameter = new FormShowParameter();
            customParams.put(PARA_ORG, orgId);
            customParams.put(SKSSQQ, startDate);
            customParams.put(SKSSQZ, endDate);
            customParams.put("declarefinish", true);
            parameter.setFormId("tccit_mainpage");
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexcontent");
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        }
    }

    private void createRequest(Map<String, Object> customParams, String templatetype) {
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(Long.parseLong((String)customParams.getOrDefault("sbbid", "0")));
        requestModel.setOrgId(Long.parseLong((String)customParams.getOrDefault(PARA_ORG, "0")));
        requestModel.setTemplateType(templatetype);
        requestModel.setOperation("read");
        requestModel.setSkssqq((String)customParams.get(SKSSQQ));
        requestModel.setSkssqz((String)customParams.get(SKSSQZ));
        DynamicObject object = DeclareShowPlugin.queryHistoryNsrxx(templatetype, this.getParam(PARA_ORG), this.getParam(SKSSQQ), this.getParam(SKSSQZ));
        if (object != null && StringUtils.isNotEmpty((CharSequence)object.getString("templateid"))) {
            customParams.put("templateid", object.getString("templateid"));
        }
        if ("bdtaxr_history_sbb".equals(customParams.get("entityid"))) {
            requestModel.setDataSource("history");
        }
        requestModel.setRefresh(false);
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }

    public static DynamicObject queryHistoryNsrxx(String templateType, String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        QFilter qFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId)).and(SKSSQQ, "=", (Object)DateUtils.stringToDate(startdate)).and(SKSSQZ, "=", (Object)DateUtils.stringToDate(enddate)).and("type", "=", (Object)templateType);
        return QueryServiceHelper.queryOne((String)"bdtaxr_history_sbb", (String)"templateid, id,modifytime, creator, datatype", (QFilter[])qFilter.toArray());
    }
}

