/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class HistorySbbViewFormPlugin
extends AbstractFormPlugin {
    public void initialize() {
        Object sbbid = this.getView().getFormShowParameter().getCustomParam("sbbid");
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.setFilter(new QFilter("sbbid", "=", sbbid));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("view".equals(operateKey)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRow listSelectedRow = billlist.getSelectedRows().get(0);
            this.openHistorySbb(listSelectedRow.getPrimaryKeyValue());
        }
    }

    private void openHistorySbb(Object sbbid) {
        DynamicObject object2;
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"bdtaxr_history_sbb");
        String type = object.getString("type");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("sbbid", object.getString("id"));
        customParams.put("billno", object.getString("billno"));
        customParams.put("orgid", object.getDynamicObject("org").getString("id"));
        customParams.put("orgname", object.getDynamicObject("org").getString("name"));
        customParams.put("draftpurpose", "nssb");
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        customParams.put("type", type);
        customParams.put("templatetype", type);
        customParams.put("taxPayerType", type);
        customParams.put("deadLine", "month".equals(object.getString("taxlimit")) ? "aysb" : "ajsb");
        customParams.put("tcrettype", object.getString("tcrettype"));
        customParams.put("apanage", object.getString("apanage"));
        String startDate = DateUtils.format(skssqq, "yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format(skssqz, "yyyy-MM-dd"));
        customParams.put("taxlimit", DateUtils.getTaxLimit(skssqq, skssqz));
        customParams.put("taxperiod", startDate.substring(0, 7));
        customParams.put("readonly", Boolean.TRUE);
        customParams.put("from", "history");
        customParams.put("entityid", "bdtaxr_history_sbb");
        customParams.put("modifytime", object.getDate("modifytime"));
        DataEntityPropertyCollection properties = object.getDataEntityType().getProperties();
        if (properties.get((Object)"declaredate") != null) {
            customParams.put("declaredate", object.getDate("declaredate"));
        }
        if (properties.get((Object)"taxauthority") != null) {
            customParams.put("taxauthority", object.getLong("taxauthority.id"));
        }
        if ("ccxws".equals(type) && (object2 = QueryServiceHelper.queryOne((String)"tcret_query_report", (String)"id,declaredate,billno,taxauthority", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)object.getLong("sbbid"))})) != null) {
            String billno = (String)customParams.get("billno");
            if (StringUtils.isBlank((CharSequence)billno)) {
                customParams.put("billno", object2.getString("billno"));
            }
            customParams.put("maindataid", object.getLong("sbbid"));
            customParams.put("declaredate", object2.getString("declaredate"));
        }
        String dataType = object.getString("datatype");
        customParams.put("datatype", dataType);
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(StringUtils.trimToEmpty((String)type));
        param.setFormId(templateEnum.getDeclareShowPage());
        param.setCaption(TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(param);
    }
}

