/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public interface ImportExcelHandler {
    public static final String TEMPLATE_ID_KEY = "TEMPLATE_ID#0#0";

    default public Map<String, String> getDynMapper(String sheetName, List<Map.Entry<String, EntityField>> datas, List<String> dynRowNoList) {
        return new HashMap<String, String>(16);
    }

    default public Map<String, String> getDynMapper(String sheetName, List<Map.Entry<String, EntityField>> datas, List<String> dynRowNoList, String templateNumber) {
        return new HashMap<String, String>(16);
    }

    default public List<String> getDynRows(Map<String, String> mapper) {
        return new ArrayList<String>();
    }

    default public List<Map.Entry<String, String>> getDynStartRows(String sheetName, Map<String, String> excelDataMap, List<String> dynRows) {
        return new ArrayList<Map.Entry<String, String>>();
    }

    default public List<Map.Entry<String, String>> getDynStartRows(String sheetName, Map<String, String> excelDataMap, List<String> dynRows, String templateNumber) {
        return new ArrayList<Map.Entry<String, String>>();
    }

    default public ValidDataResultVo checkDynData(Map<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>> dynRowDatas, String sheetName) {
        return ValidDataResultVo.success();
    }

    default public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        return ValidDataResultVo.success();
    }

    default public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        return ValidDataResultVo.success();
    }

    default public Map<String, Integer> getOffsetsWithTemplate(Long templateId, Map<String, List<Map.Entry<String, EntityField>>> sheetsMaps, Map<String, String> excelDataMap, DynamicObject templateContent) {
        HashMap<String, Integer> offsets = new HashMap<String, Integer>(32);
        sheetsMaps.entrySet().stream().forEach(s -> ((List)s.getValue()).forEach(ss -> offsets.put((String)ss.getKey(), 0)));
        return offsets;
    }

    default public ValidDataResultVo validExcelType(Map<String, String> excelDataMap, DynamicObject templateContent) {
        if (templateContent.getString("id").equals(excelDataMap.get(TEMPLATE_ID_KEY))) {
            return ValidDataResultVo.success();
        }
        return ValidDataResultVo.fail(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u5f15\u5165\u7684\u7533\u62a5\u8868\u548c\u9009\u62e9\u7684\u6a21\u7248\u7c7b\u578b\u4e00\u81f4\u3002", (String)"ImportExcelHandler_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    default public String getBillNo(String id, String skssqz) {
        return id;
    }

    default public DynamicObject queryReportExistsId(ImportDataVo vo) {
        return TemplateUtils.queryReportExistsId(vo.getOrgId(), vo.getTemplateTypeId(), vo.getStartDate(), vo.getEndDate(), vo.getTaxLimit());
    }

    default public Supplier<Function<Map.Entry<String, String>, String>> getSupplier(String sheetName) {
        return () -> s -> (String)s.getValue();
    }

    default public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
    }

    default public boolean isHandleGetDynData() {
        return false;
    }

    default public Map<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>> getDynDatas(Map<String, String> excelDataMap, String sheetName) {
        return new HashMap<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>>(4);
    }

    default public Map<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>> getDynDatas(Map<String, String> excelDataMap, String sheetName, String templateNumber) {
        return new HashMap<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>>(4);
    }

    default public Map<String, Object> parseDeclareMainInfos(Map<String, String> importExcelDataMap, Map<String, List<Map.Entry<String, EntityField>>> sheetsMaps) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"skssqq", "skssqz"});
        for (Map.Entry<String, List<Map.Entry<String, EntityField>>> entry : sheetsMaps.entrySet()) {
            String sheet = entry.getKey();
            List<Map.Entry<String, EntityField>> cells = entry.getValue();
            cells.stream().filter(cell -> columns.contains(((EntityField)cell.getValue()).getFieldId())).forEach(cell -> resultMap.put(((EntityField)cell.getValue()).getFieldId(), importExcelDataMap.get(cell.getKey())));
        }
        return resultMap;
    }

    default public void checkPayRecord(String orgid, Date startDate, Date endDate, String nsrtype) {
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter nsrtypeFilter = new QFilter("nsrtype", "=", (Object)nsrtype);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
        QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)"1");
        boolean isVoucher = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{orgFilter, dateFilter, nsrtypeFilter, voucherFilter});
        if (isVoucher) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5728\u76f8\u540c\u7684\u7a0e\u671f\u4e0b\u5df2\u5b58\u5728\u7f34\u6b3e\u5355\u751f\u6210\u51ed\u8bc1\u7684\u7533\u62a5\u8868\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u6216\u901a\u8fc7\u66f4\u6b63\u7533\u62a5\u4fee\u6b63\u6570\u636e\u3002", (String)"ImportExcelHandler_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        QFilter paystatusFilter = new QFilter("paystatus", "=", (Object)"1");
        boolean payed = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{orgFilter, dateFilter, nsrtypeFilter, paystatusFilter});
        if (payed) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u5f53\u524d\u7533\u62a5\u8868\u5df2\u7f34\u6b3e\uff0c\u8bf7\u5148\u53d6\u6d88\u7f34\u6b3e\u6216\u901a\u8fc7\u66f4\u6b63\u7533\u62a5\u4fee\u6b63\u6570\u636e\u3002", (String)"ImportExcelHandler_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }
}

