/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.helper.TaxcPrivacyHelper;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxDeclareDetailPlugin
extends AbstractFormPlugin {
    public static final String ORIGINAL_VALUE = "originalvalue";
    public static final String TARGET_VALUE = "targetvalue";

    public void initialize() {
        boolean privacyProp;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Map formulaVo = (Map)params.get("formulaVo");
        Map businessMap = (Map)params.get("businessMap");
        String sbbid = (String)this.getView().getFormShowParameter().getCustomParam("sbbid");
        String cellid = (String)this.getView().getFormShowParameter().getCustomParam("cellid");
        String[] ary = cellid.split("#");
        boolean bl = privacyProp = ary.length == 3 && TaxcPrivacyHelper.isPrivacyProp(ary[0], ary[2]);
        if (formulaVo != null) {
            billList.addPackageDataListener(evt -> {
                DynamicObject data = evt.getRowData();
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
                String cellType = (String)formulaVo.get("cellType");
                if (ORIGINAL_VALUE.equals(columnDesc.getKey()) || TARGET_VALUE.equals(columnDesc.getKey())) {
                    switch (cellType) {
                        case "5": {
                            evt.setFormatValue(this.setBaseDataFormatValue(columnDesc.getKey(), formulaVo, data, businessMap));
                            break;
                        }
                        case "7": {
                            evt.setFormatValue((Object)StringUtil.dealWithSensitive(data.getString(columnDesc.getKey())));
                            break;
                        }
                        case "4": {
                            evt.setFormatValue(this.setTextTypeFormatValue(data.getString(columnDesc.getKey()), formulaVo));
                            break;
                        }
                        default: {
                            evt.setFormatValue(data.get(columnDesc.getKey()));
                        }
                    }
                    if (privacyProp) {
                        String dataTxt = data.getString(columnDesc.getKey());
                        String desensitize = TaxcPrivacyHelper.desensitizeByMeta(ary[0], ary[2], dataTxt);
                        evt.setFormatValue((Object)desensitize);
                    }
                }
            });
        } else if ("tcvat_ybnsr_zb_5_jbrysfzjhm".equals(cellid) || "tcvat_xgm_zb_7_jbrysfzjhm".equals(cellid)) {
            billList.addPackageDataListener(evt -> {
                DynamicObject data = evt.getRowData();
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
                if (ORIGINAL_VALUE.equals(columnDesc.getKey())) {
                    evt.setFormatValue((Object)StringUtil.dealWithSensitive(data.getString(ORIGINAL_VALUE)));
                } else if (TARGET_VALUE.equals(columnDesc.getKey())) {
                    evt.setFormatValue((Object)StringUtil.dealWithSensitive(data.getString(TARGET_VALUE)));
                }
            });
        } else if (privacyProp) {
            billList.addPackageDataListener(evt -> {
                DynamicObject data = evt.getRowData();
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
                if (ORIGINAL_VALUE.equals(columnDesc.getKey()) || TARGET_VALUE.equals(columnDesc.getKey())) {
                    String dataTxt = data.getString(columnDesc.getKey());
                    String desensitize = TaxcPrivacyHelper.desensitizeByMeta(ary[0], ary[2], dataTxt);
                    evt.setFormatValue((Object)desensitize);
                }
            });
        }
        QFilter q = new QFilter("sbbid", "=", (Object)sbbid);
        q.and(new QFilter("cellid", "=", (Object)cellid));
        billList.setFilter(q);
    }

    private Object setBaseDataFormatValue(String key, Map<String, String> formulaVo, DynamicObject data, Map<String, String> businessMap) {
        return TemplateShowUtils.getBaseDataDisplayText(data.getString(key), formulaVo.get("formulaName"), businessMap);
    }

    private Object setTextTypeFormatValue(String value, Map<String, String> formulaVo) {
        Map<String, String> itemMap = TemplateShowUtils.parseCellType(formulaVo.get("formulaName"));
        if (!itemMap.isEmpty()) {
            return itemMap.get(value);
        }
        return null;
    }
}

