/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractDeclarePlugin;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxDeclareEditPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractDeclarePlugin.class);
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_SBBID = "sbbid";
    private static final String PARAM_TCRET_TYPE = "tcrettype";
    private static final String PARAM_APANAGE = "apanage";
    private static final String PARAM_TAXLIMIT = "taxlimit";
    private static final String EDIT_KEY = "edit";
    private static final String SAVE_KEY = "save";
    private static final String CANCEL_KEY = "cancel";
    private static final String RECALC_KEY = "recalc";
    private static final String CHILD_PAGE_ID = "CHILD_PAGE_ID";
    private static final String FCS_CZTDSYS = "fcscztdsys";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String YEAR = "year";
    private static final String JIDU = "jidu";
    private static final String ORG = "org";
    private static final String SPLITFLEX = "splitflex";
    private static final String ZDSY = "zdsybsqyxxb";
    private static final String CALLBACKID_MODIFY = "callback_modify";
    private static final String CALLBACKID_MOD = "modifyOrDelete";

    public void afterCreateNewData(EventObject e) {
        QFilter qFilter;
        DynamicObject templateType;
        this.getView().setVisible(Boolean.FALSE, new String[]{SKSSQZ, SPLITFLEX, CANCEL_KEY, SAVE_KEY});
        String type = this.getParam(PARAM_TYPE);
        Boolean refreshFrom = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("refresh");
        if (StringUtils.isEmpty((CharSequence)type)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u5b9a\u7533\u62a5\u8868\u7c7b\u578b", (String)"TaxDeclareEditPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (type.equals(FCS_CZTDSYS)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SKSSQQ});
        }
        if (StringUtils.isNotBlank((Object)refreshFrom) && !refreshFrom.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SKSSQQ});
            this.getView().setEnable(Boolean.FALSE, new String[]{SKSSQZ});
            this.getView().setEnable(Boolean.FALSE, new String[]{ORG});
            this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY});
            this.getPageCache().put(type + "refresh", refreshFrom.toString());
        }
        if ((templateType = QueryServiceHelper.queryOne((String)"tpo_template_type", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)type)})) == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7533\u62a5\u8868\u7c7b\u578b%s", (String)"TaxDeclareEditPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), type));
            return;
        }
        Date startDate = null;
        Date endDate = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(SKSSQQ) != null) {
            String startdate = (String)customParams.get(SKSSQQ);
            this.getPageCache().put(SKSSQQ, startdate);
            startDate = DateUtils.stringToDate(startdate);
            this.getModel().setValue(SKSSQQ, (Object)startDate);
            String enddate = (String)customParams.get(SKSSQZ);
            this.getPageCache().put(SKSSQZ, enddate);
            endDate = DateUtils.stringToDate(enddate);
            this.getModel().setValue(SKSSQZ, (Object)endDate);
            if ("tcept".equals(type)) {
                String[] split = startdate.split("-");
                this.getModel().setValue(YEAR, (Object)split[0]);
                this.getModel().setValue(JIDU, (Object)((Integer.parseInt(split[1]) + 2) / 3));
            }
        } else {
            Date now = new Date();
            String taxlimit = this.getParam(PARAM_TAXLIMIT);
            if (YEAR.equals(taxlimit)) {
                startDate = DateUtils.getFirstDateOfYear(now);
                endDate = DateUtils.getLastDateOfYear(now);
            } else if ("halfyear".equals(taxlimit)) {
                Date date = DateUtils.addMonth(now, -6);
                startDate = DateUtils.getFirstDateOfHalfYear(date);
                endDate = DateUtils.getLastDateOfHalfYear(date);
            } else if ("season".equals(taxlimit)) {
                Date date = DateUtils.addMonth(now, -3);
                startDate = DateUtils.getFirstDateOfSeason(date);
                endDate = DateUtils.getLastDateOfSeason(date);
                this.getModel().setValue(YEAR, (Object)DateUtils.getYearOfDate(startDate));
                this.getModel().setValue(JIDU, (Object)((DateUtils.getMonthOfDate(startDate) + 2) / 3));
            } else {
                Date date = DateUtils.addMonth(now, -1);
                startDate = DateUtils.getFirstDateOfMonth(date);
                endDate = DateUtils.getLastDateOfMonth(date);
            }
            this.getPageCache().put(SKSSQQ, DateUtils.format(startDate));
            this.getPageCache().put(SKSSQZ, DateUtils.format(endDate));
            this.getModel().setValue(SKSSQQ, (Object)startDate);
            this.getModel().setValue(SKSSQZ, (Object)endDate);
        }
        this.getPageCache().put(PARAM_TYPE, type);
        this.getPageCache().put(PARAM_TCRET_TYPE, this.getParam(PARAM_TCRET_TYPE));
        this.getPageCache().put(PARAM_APANAGE, this.getParam(PARAM_APANAGE));
        if (this.existTemplate(startDate, endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7f3a\u5c11\u7533\u62a5\u8868\u6a21\u677f", (String)"TaxDeclareEditPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (null != customParams.get("orgid")) {
            this.getModel().setValue(ORG, customParams.get("orgid"));
            this.getPageCache().put("orgid", (String)customParams.get("orgid"));
        } else {
            this.getModel().setValue(ORG, (Object)PermissionUtils.getDefaultOrgId());
            this.getPageCache().put("orgid", String.valueOf(PermissionUtils.getDefaultOrgId()));
        }
        this.openDeclarePage("read", false);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        String type = this.getParam(PARAM_TYPE);
        String taxlimit = this.getParam(PARAM_TAXLIMIT);
        if (ORG.equals(name) || SKSSQQ.equals(name) || YEAR.equals(name) || JIDU.equals(name)) {
            switch (name) {
                case "org": {
                    ChangeData[] changeData = e.getChangeSet();
                    if (changeData == null || changeData.length <= 0) break;
                    DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                    if (null == newOrg) {
                        this.getView().getModel().setValue(ORG, (Object)this.getPageCache().get("orgid"));
                        return;
                    }
                    String neworgid = newOrg.getString("id");
                    String appid = this.getView().getFormShowParameter().getAppId();
                    if ("fjsf".equals(type) || "tcept".equals(type) || "tcvvt".equals(type) || "yys".equals(type) || "tcrt".equals(type)) {
                        appid = "fjsf";
                    }
                    if (OrgCheckUtil.check(this.getView(), neworgid, appid, TaxAppEnum.getEnumInstanceByAppid(appid).getCategoryCode())) {
                        this.getModel().setValue(ORG, (Object)this.getPageCache().get("orgid"));
                        break;
                    }
                    this.getPageCache().put("orgid", neworgid);
                    break;
                }
                case "skssqq": {
                    Date startDate = DateUtils.getFirstDateOfMonth((Date)this.getModel().getValue(SKSSQQ));
                    if (startDate == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65f6\u95f4\uff01", (String)"TaxDeclareEditPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    Date endDate = YEAR.equals(taxlimit) ? DateUtils.getLastDateOfYear(startDate) : DateUtils.getLastDateOfMonth(startDate);
                    if (this.existTemplate(startDate, endDate)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7f3a\u5c11\u7533\u62a5\u8868\u6a21\u677f", (String)"TaxDeclareEditPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    this.getModel().setValue(SKSSQZ, (Object)endDate);
                    this.getPageCache().put(SKSSQQ, DateUtils.format(startDate));
                    this.getPageCache().put(SKSSQZ, DateUtils.format(endDate));
                    break;
                }
                case "year": {
                    String year = (String)e.getChangeSet()[0].getNewValue();
                    String jidu = (String)this.getModel().getValue(JIDU);
                    if (!this.switchDate(year, jidu)) break;
                    return;
                }
                case "jidu": {
                    String year1 = (String)this.getModel().getValue(YEAR);
                    String jidu1 = (String)e.getChangeSet()[0].getNewValue();
                    if (!this.switchDate(year1, jidu1)) break;
                    return;
                }
            }
            this.openDeclarePage("read", false);
        }
    }

    private boolean switchDate(String year, String jidu) {
        if (StringUtil.isBlank((CharSequence)year) || StringUtil.isBlank((CharSequence)jidu)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65f6\u95f4\uff01", (String)"TaxDeclareEditPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        String date = DateUtils.getLastDayOfMonth(Integer.parseInt(year), Integer.parseInt(jidu) * 3);
        Date endDate = DateUtils.stringToDate(date);
        Date startDate = DateUtils.getFirstDateOfSeason(endDate);
        if (this.existTemplate(startDate, endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7f3a\u5c11\u7533\u62a5\u8868\u6a21\u677f", (String)"TaxDeclareEditPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        this.getModel().setValue(SKSSQQ, (Object)startDate);
        this.getPageCache().put(SKSSQQ, DateUtils.format(startDate));
        this.getModel().setValue(SKSSQZ, (Object)endDate);
        this.getPageCache().put(SKSSQZ, date);
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (EDIT_KEY.equals(evt.getItemKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Object licenseCheck = customParams.get("license");
            if (null != org && null == licenseCheck && ("fjsf".equals(this.getParam(PARAM_TYPE)) ? LicenseCheckServiceHelper.check(org.getString("id"), this.getView(), "fjsf") : LicenseCheckServiceHelper.check(org.getString("id"), this.getView(), this.getView().getFormShowParameter().getAppId()))) {
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{CANCEL_KEY, SAVE_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, RECALC_KEY});
            this.showDeclare(EDIT_KEY, false);
        }
        if (CANCEL_KEY.equals(evt.getItemKey())) {
            LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"TaxDeclareEditPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.getView().showLoading(cancelMsg, 3000);
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_KEY, SAVE_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY});
            if (StringUtils.equals((CharSequence)String.valueOf(Boolean.FALSE), (CharSequence)this.getPageCache().get(this.getParam(PARAM_TYPE) + "refresh")) || StringUtils.equals((CharSequence)"2", (CharSequence)((String)customParams.get("datatype")))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{RECALC_KEY});
            }
            this.showDeclare("read", false);
        }
        if (SAVE_KEY.equals(evt.getItemKey())) {
            LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"TaxDeclareEditPlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.getView().showLoading(saveMsg, 3000);
            if (this.saveClick()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_KEY, SAVE_KEY});
                this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY});
                if (StringUtils.equals((CharSequence)String.valueOf(Boolean.FALSE), (CharSequence)this.getPageCache().get(this.getParam(PARAM_TYPE) + "refresh")) || StringUtils.equals((CharSequence)"2", (CharSequence)((String)customParams.get("datatype")))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{RECALC_KEY});
                }
                this.showDeclare("read", false);
            } else {
                this.getView().hideLoading();
            }
        }
        if (RECALC_KEY.equals(evt.getItemKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_KEY, SAVE_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY});
            this.recale();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (RECALC_KEY.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.showDeclare("read", true);
            }
        } else if (CALLBACKID_MODIFY.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.showDeclare("read", false);
            } else {
                this.getView().close();
            }
        } else if (CALLBACKID_MOD.equals(event.getCallBackId())) {
            String orgId = this.getPageCache().get("orgid");
            if (event.getResult() == MessageBoxResult.Yes) {
                String skssqq = this.getPageCache().get(SKSSQQ);
                String skssqz = this.getPageCache().get(SKSSQZ);
                TemplateUtilsOld.deleteReport(Long.parseLong(orgId), this.getParam(PARAM_TYPE), DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz), null);
                this.showDeclare("read", true);
            } else if (event.getResult() == MessageBoxResult.No) {
                this.showDeclare("read", false);
                this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY});
            } else {
                this.getView().close();
            }
        }
    }

    protected void openDeclarePage(String operation, boolean refresh) {
        String skssqq = this.getPageCache().get(SKSSQQ);
        String skssqz = this.getPageCache().get(SKSSQZ);
        String orgid = this.getPageCache().get("orgid");
        String templateType = this.getParam(PARAM_TYPE);
        Map<String, Object> map = this.chooseDeclareFormByDataType(orgid, templateType, skssqq, skssqz, this.getParam(PARAM_SBBID));
        String billstatus = (String)map.get("billstatus");
        String declarestatus = (String)map.get("declarestatus");
        if (((Boolean)map.get("flag")).booleanValue()) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)billstatus)) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                String taxLimitTips = DateUtils.getTaxLimitTips(DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz));
                String orgname = this.getModel().getValue(ORG) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG)).getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"TaxDeclareEditPlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                if (FCS_CZTDSYS.equals(templateType) || "tvpt".equals(templateType)) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"TaxDeclareEditPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"TaxDeclareEditPlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e", (String)"TaxDeclareEditPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACKID_MODIFY, (IFormPlugin)this), btnNameMaps);
                } else {
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"TaxDeclareEditPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"TaxDeclareEditPlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"TaxDeclareEditPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e", (String)"TaxDeclareEditPlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
                }
            } else {
                this.checkBillStatus(billstatus, declarestatus, operation);
                this.showDeclare(operation, refresh);
            }
        } else {
            this.checkBillStatus(billstatus, declarestatus, operation);
            this.showDeclare(operation, refresh);
        }
    }

    private void checkBillStatus(String billstatus, Object declarestatus, String operation) {
        if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            String orgName = null != org ? org.getString("name") : "";
            String statusName = this.getStatusLocaleName(billstatus, declarestatus);
            String taxlimitStr = DateUtils.getTaxLimitTips(DateUtils.stringToDate(this.getPageCache().get(SKSSQQ)), DateUtils.stringToDate(this.getPageCache().get(SKSSQZ)));
            if (!taxlimitStr.equals("")) {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2%3$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"TaxDeclareEditPlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, taxlimitStr, statusName);
                this.getView().showTipNotification(msg, Integer.valueOf(5000));
            }
        }
        this.setBtnStatus(billstatus, operation);
    }

    private void setBtnStatus(String billstatus, String operationStatus) {
        if (EmptyCheckUtils.isNotEmpty(billstatus) && "read".equals(operationStatus)) {
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{EDIT_KEY, RECALC_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE_KEY, CANCEL_KEY});
            } else if ("B".equals(billstatus) || "C".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{EDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{EDIT_KEY, RECALC_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE_KEY, CANCEL_KEY});
        }
    }

    private String getStatusLocaleName(Object billstatus, Object declarestatus) {
        String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"TaxDeclareEditPlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        if ("C".equals(billstatus)) {
            statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"TaxDeclareEditPlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        if ("declared".equals(declarestatus)) {
            statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"TaxDeclareEditPlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        return statusName;
    }

    protected Map<String, Object> chooseDeclareFormByDataType(String orgid, String type, String startDate, String endDate, String sbbid) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject dyo = "tvpt".equals(type) ? YbnsrService.queryYbnsr(sbbid) : YbnsrService.queryYbnsr(orgid, type, startDate, endDate, null);
        Boolean flag = Boolean.FALSE;
        String billstatus = "";
        String declareStatus = "";
        if (null != dyo) {
            billstatus = dyo.getString("billstatus");
            declareStatus = dyo.getString("declarestatus");
            if (StringUtils.equals((CharSequence)"2", (CharSequence)dyo.getString("datatype"))) {
                flag = Boolean.TRUE;
            }
        }
        map.put("billstatus", billstatus);
        map.put("declarestatus", declareStatus);
        map.put("flag", flag);
        return map;
    }

    private void showDeclare(String operation, boolean refresh) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(10);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            String orgId = org.getString("id");
            String type = this.getPageCache().get(PARAM_TYPE);
            String skssqq = this.getPageCache().get(SKSSQQ);
            String skssqz = this.getPageCache().get(SKSSQZ);
            customParams.put("orgid", orgId);
            customParams.put(SKSSQQ, skssqq);
            customParams.put(SKSSQZ, skssqz);
            customParams.put("templatetype", type);
            customParams.put(PARAM_TCRET_TYPE, this.getPageCache().get(PARAM_TCRET_TYPE));
            customParams.put(PARAM_APANAGE, this.getPageCache().get(PARAM_APANAGE));
            customParams.put("operation", operation);
            customParams.put("ParentCache", "false");
            customParams.put(PARAM_SBBID, this.getParam(PARAM_SBBID));
            customParams.put("billno", this.getBillNo(orgId, type, DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz)));
            if (refresh) {
                customParams.put("refresh", "true");
            }
            if (!StringUtils.isEmpty((CharSequence)type) && ZDSY.equals(type)) {
                int month = DateUtils.getMonthOfDate(DateUtils.stringToDate(skssqq));
                if (month % 3 == 0) {
                    customParams.put("sheetname", ResManager.loadKDString((String)"\u4fe1\u606f\u8868,\u7a0e\u6536\u8868,\u4ea7\u54c1\u8868,\u8d22\u52a1\u8868", (String)"TaxDeclareEditPlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                } else {
                    customParams.put("sheetname", ResManager.loadKDString((String)"\u4fe1\u606f\u8868,\u7a0e\u6536\u8868,\u4ea7\u54c1\u8868", (String)"TaxDeclareEditPlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
            }
            param.setFormId("bdtaxr_declare_old");
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.InContainer);
            param.getOpenStyle().setTargetKey("flexpanelap");
            String pageid = param.getPageId();
            this.getPageCache().put(CHILD_PAGE_ID, pageid);
            this.getView().showForm(param);
        }
    }

    private String getBillNo(String orgid, String type, Date skssqq, Date skssqz) {
        String billno;
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.valueOf(orgid));
        QFilter typeFilter = new QFilter(PARAM_TYPE, "=", (Object)type);
        QFilter skssqqFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billno", (QFilter[])new QFilter[]{orgFilter, typeFilter, skssqqFilter, skssqzFilter});
        if (null != dynamicObject) {
            return dynamicObject.getString("billno");
        }
        String key = orgid + type + skssqq + skssqz;
        String billnoStr = this.getPageCache().get(key);
        if (StringUtil.isNotEmpty((CharSequence)billnoStr)) {
            return billnoStr;
        }
        if (FCS_CZTDSYS.equals(type)) {
            billno = TaxDeclareEditPlugin.generateDraftNo("tcret_declare_query", orgid);
        } else if ("yhs".equals(type)) {
            billno = TaxDeclareEditPlugin.generateDraftNo("tcsd_yhs_declare_list", orgid);
        } else if ("tcept".equals(type)) {
            billno = TaxDeclareEditPlugin.generateDraftNo("totf_nssb_query", orgid);
        } else if ("tcrt".equals(type)) {
            billno = TaxDeclareEditPlugin.generateDraftNo("totf_nssb_query", orgid);
            billno = billno.replace("ENP", "RES");
        } else if ("yys".equals(type)) {
            billno = TaxDeclareEditPlugin.generateDraftNo("totf_nssb_query", orgid);
            billno = billno.replace("ENP", "TBL");
        } else if ("tcvvt".equals(type)) {
            billno = TaxDeclareEditPlugin.generateDraftNo("totf_nssb_query", orgid);
            billno = billno.replace("ENP", "VAV");
        } else if ("tvpt".equals(type)) {
            billno = TaxDeclareEditPlugin.generateDraftNo("totf_nssb_query", orgid);
            billno = billno.replace("ENP", "VPC");
        } else {
            return null;
        }
        this.getPageCache().put(key, billno);
        return billno;
    }

    protected static String generateDraftNo(String entityName, String orgid) {
        return DeclareServiceHelper.generateSBBNo(entityName, null, orgid);
    }

    private boolean saveClick() {
        String pageid = this.getPageCache().get(CHILD_PAGE_ID);
        IFormView childView = this.getView().getView(pageid);
        if (childView != null) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
            IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
            List pluginList = pluginProxy.getPlugIns();
            Object taxDeclarePlugin = null;
            for (IFormPlugin plugin : pluginList) {
                if (!plugin.getPluginName().endsWith("TaxDeclarePlugin")) continue;
                taxDeclarePlugin = plugin;
            }
            if (taxDeclarePlugin != null) {
                boolean result;
                Class<?> pluginClass = taxDeclarePlugin.getClass();
                try {
                    Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class);
                    result = (Boolean)saveClick.invoke(taxDeclarePlugin, childPageCache);
                }
                catch (InvocationTargetException e) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"TaxDeclareEditPlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    LOGGER.error("\u6570\u636e\u683c\u5f0f\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                    return false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return result;
            }
        }
        return true;
    }

    private boolean existTemplate(Date startDate, Date endDate) {
        String type = this.getPageCache().get(PARAM_TYPE);
        DynamicObject template = TemplateUtilsOld.getTemplateObject(type, startDate, endDate);
        return Objects.isNull(template);
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String o = customParams.getOrDefault(param, "");
        return o instanceof String ? o : o.toString();
    }

    private void recale() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxDeclareEditPlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxDeclareEditPlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5237\u65b0\u5c06\u5bfc\u81f4\u539f\u6709\u7eb3\u7a0e\u7533\u62a5\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"TaxDeclareEditPlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }
}

