/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.BooleanEnum;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TaxDeductionConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.formula.db.formula.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.declare.TaxDeclareDataHandlerFactory;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.CellType;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.BasePointInfo;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractTaxDeclarePluginNew;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class TaxDeclarePlugin
extends AbstractTaxDeclarePluginNew {
    private static Log LOGGER = LogFactory.getLog(TaxDeclarePlugin.class);
    private static String CUSTOM_CONTROL = "customcontrolap";
    private static final String CACHE_CURRENT_DATA = "current_data";
    private static final String CACHE_UPDATA_CELLID = "updata_cellid";
    private static final String CACHE_UPDATA_FOCUS = "focus";
    private static final String CACHE_UPDATA_REMARK = "remark_data";
    private static final String CACHE_TEMPLATE_TABLE_LIST = "CACHE_TEMPLATE_TABLE_LIST";
    private static final String EVENT_SHOW_BASE_DATA = "showBaseData";
    private static final String EVENT_SELECT_SHEET = "selectSheet";
    private static final String EVENT_DETAIL = "detail";
    private static final String EVENT_SHOW_ADD_REMARK = "showAddRemark";
    private static final String EVENT_CHANGE_DATA = "changeData";
    private static final String EVENT_HREF = "datahref";
    private static final String EVENT_UPDATE_ROW = "updateRow";
    private static final String BASEDATA_ENTITY_ID = "baseEntityId";
    private static final char SPLIT_STRING_SAVE = '#';
    private static final char SPLIT_STRING_SHOW = '_';
    private static final String IS_SHOW_FCS_PRICE = "isShowFcsByPrice";
    private static final String IS_SHOW_FCS_HIRE = "isShowFcsByHire";
    private static final String IS_SHOW_TDS = "isShowTds";
    private static final String TAXLIMIT = "taxlimit";
    private static final String APANAGE = "apanage";
    private static final String DECLARE_MONTH = "declaremonth";
    private static final String TCRETTYPE = "tcrettype";
    private static final String FCS_CZTDSYS = "fcscztdsys";
    private static final String SBBID = "sbbid";
    private static final List<String> COMBO_CELLID = Lists.newArrayList((Object[])new String[]{"tcvat_sb_fjsf_jz_2_bqsfsyjzzc", "tcvat_sb_fjsf_jz_1_sfyssdjsqydmzc", "tcvat_prepay_flzl_5_bqsfsyjzzc"});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public String getAttachmentFieldName() {
        return "attachmentpanelap";
    }

    @Override
    public String getAttachmentPanelName() {
        return "attachmentflex";
    }

    public void afterCreateNewData(EventObject e) {
        boolean success;
        String assignplan;
        String sblx;
        String taxorg;
        String declareserialno;
        String projectid;
        String deadLine;
        String taxPayerType;
        String skssqq;
        QFilter qFilter;
        DynamicObjectCollection collection;
        Object submittedType;
        String templatetype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("rootPageId", (String)customParams.get("rootPageId"));
        String orgid = (String)customParams.get("orgid");
        if (StringUtils.isEmpty((CharSequence)orgid)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        this.getPageCache().put("orgid", orgid);
        String sheetid = (String)customParams.get("sheetid");
        if (!StringUtils.isEmpty((CharSequence)sheetid)) {
            this.getPageCache().put("sheetid", sheetid);
        }
        if (StringUtils.isEmpty((CharSequence)(templatetype = (String)customParams.get("templatetype")))) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6a21\u677f\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (templatetype.equals(FCS_CZTDSYS)) {
            this.saveExtendParams(customParams, this.getPageCache());
        }
        this.getPageCache().put("templatetype", templatetype);
        Object object = submittedType = StringUtils.isBlank(customParams.get("submittedType")) ? this.getPageCache().get("submittedType") : customParams.get("submittedType");
        if (StringUtils.equals((CharSequence)"qhjtbs", (CharSequence)templatetype) && StringUtils.isBlank(submittedType) && EmptyCheckUtils.isNotEmpty(collection = QueryServiceHelper.query((String)"tcvvt_group_book", (String)"id,orgrow.id as rowid,orgrow.orgid as orgid", (QFilter[])new QFilter[]{qFilter = new QFilter("orgrow.orgid", "=", (Object)orgid).or("orgrow.parentid", "=", (Object)orgid)})) && collection.size() >= 1) {
            this.getPageCache().put("submittedType", "3");
            this.getPageCache().put("groupid", ((DynamicObject)collection.get(0)).getString("id"));
        }
        if (StringUtils.equals((CharSequence)"qhjtbs", (CharSequence)templatetype) && !ObjectUtils.notEqual((Object)"3", submittedType)) {
            Object groupId = customParams.get("groupid");
            if (StringUtils.isBlank(groupId)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u96c6\u56e2\u62a5\u9001\u96c6\u56e2\u540d\u518c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            this.getPageCache().put("groupid", groupId.toString());
            this.getPageCache().put("submittedType", "3");
            orgid = customParams.get("grouporgid").toString();
            this.getPageCache().put("orgid", orgid);
        }
        if (StringUtils.isEmpty((CharSequence)(skssqq = (String)customParams.get("skssqq")))) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sdf.parse(skssqq);
        }
        catch (ParseException e1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a[yyyy-MM-dd]", (String)"TaxDeclarePlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), e1);
        }
        this.getPageCache().put("skssqq", skssqq);
        String skssqz = (String)customParams.get("skssqz");
        if (StringUtils.isEmpty((CharSequence)skssqz)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        try {
            sdf.parse(skssqz);
        }
        catch (ParseException e1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a[yyyy-MM-dd]", (String)"TaxDeclarePlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), e1);
        }
        this.getPageCache().put("skssqz", skssqz);
        String operation = (String)customParams.get("operation");
        if (StringUtils.isEmpty((CharSequence)operation)) {
            operation = "read";
        }
        this.getPageCache().put("operation", operation);
        String sheetName = (String)customParams.get("sheetname");
        this.getPageCache().put("sheetname", sheetName);
        String changedsave = (String)customParams.get("changedsave");
        this.getPageCache().put("changedsave", changedsave);
        String sbbid = (String)customParams.get(SBBID);
        String billno = (String)customParams.get("billno");
        this.getPageCache().put(SBBID, sbbid);
        this.getPageCache().put("billno", billno);
        boolean refresh = false;
        Object refreshParam = customParams.get("refresh");
        if (refreshParam != null) {
            refresh = refreshParam instanceof Boolean ? Boolean.TRUE.equals(refreshParam) : "true".equals(String.valueOf(refreshParam));
        }
        if (!StringUtils.isEmpty((CharSequence)(taxPayerType = (String)customParams.get("taxPayerType")))) {
            this.getPageCache().put("taxPayerType", taxPayerType);
        }
        if (!StringUtils.isEmpty((CharSequence)(deadLine = (String)customParams.get("deadLine")))) {
            this.getPageCache().put("deadline", deadLine);
        }
        if (!StringUtils.isEmpty((CharSequence)(projectid = (String)customParams.get("projectid")))) {
            this.getPageCache().put("projectid", projectid);
            this.getPageCache().put(APANAGE, projectid);
        }
        if (!StringUtils.isEmpty((CharSequence)(declareserialno = (String)customParams.get("declareserialno")))) {
            this.getPageCache().put("declareserialno", declareserialno);
        }
        if (!StringUtils.isEmpty((CharSequence)(taxorg = (String)customParams.get("taxorg")))) {
            this.getPageCache().put("taxorg", taxorg);
        }
        if (!StringUtils.isEmpty((CharSequence)(sblx = (String)customParams.get("sblx")))) {
            this.getPageCache().put("sblx", sblx);
        }
        if (!StringUtils.isEmpty((CharSequence)(assignplan = (String)customParams.get("assignplan")))) {
            this.getPageCache().put("assignplan", assignplan);
        }
        if (customParams.get("templateid") != null) {
            this.getPageCache().put("templateid", (String)customParams.get("templateid"));
        } else {
            String templateId = this.getTemplateId();
            if (StringUtil.isEmpty((CharSequence)templateId)) {
                return;
            }
            this.getPageCache().put("templateid", templateId);
        }
        LOGGER.info("\u5237\u65b0\u7533\u62a5\u8868\uff1a" + refresh);
        this.loadDeclare(orgid, templatetype, sheetName, operation, skssqq, skssqz, refresh);
        if (refresh && (success = ((Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeclareStepsStatusService", (String)"updateStatus", (Object[])new Object[]{customParams, orgid, skssqq, skssqz})).booleanValue())) {
            Integer totalSteps = (Integer)customParams.get("totalsteps");
            String focuspage = (String)customParams.get("focuspage");
            if (customParams.get("rootPageId") != null) {
                IFormView rootView = this.getView().getView((String)customParams.get("rootPageId"));
                DeclareStepsUtils.resetSteps(totalSteps, focuspage, focuspage, rootView);
                this.getView().sendFormAction(rootView);
            } else {
                DeclareStepsUtils.resetSteps(totalSteps, focuspage, focuspage, this.getView());
            }
        }
        if (null != this.getView().getParentView()) {
            this.getView().getParentView().addClientCallBack(null == this.getPageCache().get("sheetid") ? "0" : this.getPageCache().get("sheetid"), Integer.valueOf(0));
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void saveExtendParams(Map<String, Object> customParams, IPageCache pageCache) {
        pageCache.put(IS_SHOW_TDS, String.valueOf(customParams.get(IS_SHOW_TDS)));
        pageCache.put(IS_SHOW_FCS_PRICE, String.valueOf(customParams.get(IS_SHOW_FCS_PRICE)));
        pageCache.put(IS_SHOW_FCS_HIRE, String.valueOf(customParams.get(IS_SHOW_FCS_HIRE)));
        pageCache.put(TAXLIMIT, (String)customParams.get(TAXLIMIT));
        pageCache.put(APANAGE, (String)customParams.get(APANAGE));
        pageCache.put(DECLARE_MONTH, (String)customParams.get(DECLARE_MONTH));
        pageCache.put(TCRETTYPE, (String)customParams.get(TCRETTYPE));
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        String eventName = e.getEventName();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (EVENT_CHANGE_DATA.equals(eventName)) {
            this.checkData(argsMap);
            this.changeData((String)argsMap.get("cellid"), (String)argsMap.get("value"), (String)argsMap.get("sheetid"));
            if (String.valueOf(Boolean.TRUE).equals(this.getPageCache().get("changedsave"))) {
                String riskstatus;
                String curruntStatus;
                List<Map<String, String>> errMaps = FormulaService.checkFormula(this.getCache());
                String id = this.getCache().get("cache_sbbid");
                QFilter qfilter = new QFilter("id", "=", (Object)Long.valueOf(id));
                DynamicObject[] nsrxx = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{qfilter});
                if (null != nsrxx && nsrxx.length > 0 && !(curruntStatus = errMaps.size() > 0 ? "1" : "0").equals(riskstatus = nsrxx[0].getString("riskstatus"))) {
                    nsrxx[0].set("riskstatus", (Object)curruntStatus);
                    SaveServiceHelper.update((DynamicObject)nsrxx[0]);
                }
                String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("rootPageId");
                IFormView parentView = this.getView().getView(parentPageId);
                if (errMaps.size() > 0) {
                    if (null != parentView) {
                        parentView.showErrorNotification(errMaps.get(0).get("content"));
                        this.getView().sendFormAction(parentView);
                    } else {
                        this.getView().showErrorNotification(errMaps.get(0).get("content"));
                    }
                } else {
                    FormulaService.save(this.getCache());
                    if (null != parentView) {
                        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"TaxDeclarePlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        this.getView().sendFormAction(parentView);
                    } else {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"TaxDeclarePlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                }
            }
        } else if (EVENT_SHOW_ADD_REMARK.equals(eventName)) {
            this.showAddRemark((String)argsMap.get("cellid"));
        } else if (EVENT_DETAIL.equals(eventName)) {
            this.showDetail((String)argsMap.get("cellid"));
        } else if (EVENT_SELECT_SHEET.equals(eventName)) {
            this.getPageCache().put("sheetid", (String)argsMap.get("sheetid"));
            if (null != this.getView().getParentView()) {
                this.getView().getParentView().addClientCallBack((String)argsMap.get("sheetid"));
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else if (EVENT_SHOW_BASE_DATA.equals(eventName)) {
            this.getPageCache().put(BASEDATA_ENTITY_ID, (String)argsMap.get(BASEDATA_ENTITY_ID));
            this.getPageCache().put("cellid", (String)argsMap.get("cellid"));
            this.showBaseData(argsMap);
        } else if ("jumptotctrcrisk".equals(eventName)) {
            this.jumpToTctrcRisk(argsMap);
        } else if ("recaltctrcrisk".equals(eventName)) {
            this.reCalTctrcRisk(argsMap);
        } else if (EVENT_HREF.equals(eventName)) {
            this.hyperLinkClick(argsMap);
        } else if (EVENT_UPDATE_ROW.equals(eventName)) {
            // empty if block
        }
    }

    private void hyperLinkClick(Map<String, String> argsMap) {
        String hreftype = argsMap.get("hreftype");
        String hrefpara = argsMap.get("hrefpara");
        if ("hyperLinkClick".equals(hreftype)) {
            IFormView parentView = this.getView().getParentView();
            JSONObject jsonObject = JSONObject.parseObject((String)hrefpara);
            String pluginName = jsonObject.getString("plugin");
            String method = jsonObject.getString("method");
            JSONObject param = this.replaceCellValue(jsonObject);
            try {
                FormViewPluginProxy pluginProxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
                IFormPlugin plugin = pluginProxy.getPlugin(pluginName);
                if (plugin == null) {
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u63d2\u4ef6%s", (String)"TaxDeclarePlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), pluginName));
                }
                Class<?> pluginClass = plugin.getClass();
                Method hyperLinkClick = pluginClass.getMethod(method, String.class, JSONObject.class);
                Map<String, String> allFieldToSave = this.getAllFieldToSave();
                hyperLinkClick.invoke((Object)plugin, allFieldToSave.get(argsMap.get("cellid")), param);
                this.getView().sendFormAction(parentView);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public JSONObject replaceCellValue(JSONObject jsonObject) {
        JSONObject param = jsonObject.getJSONObject("param");
        Map resultCache = TreeUtils.getCache(this.getCache(), "cacheResult", Map.class);
        for (Map.Entry entry : param.entrySet()) {
            if (resultCache.get(entry.getValue()) == null) continue;
            entry.setValue(resultCache.get(entry.getValue()));
        }
        return param;
    }

    private void reCalTctrcRisk(Map<String, String> argsMap) {
        String resultidstr = argsMap.get("tctrcresultids");
        if (EmptyCheckUtils.isEmpty(resultidstr)) {
            return;
        }
        List<Long> resultids = Arrays.stream(resultidstr.trim().split(",")).filter(v -> EmptyCheckUtils.isNotEmpty(v)).map(v -> Long.parseLong(v)).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(resultids)) {
            return;
        }
        this.doReCalTctrcRisk(resultids);
        List<Map<String, String>> tctrcResultMapList = this.queryTctrcResultMapList(this.getPageCache().get("orgid"), this.getPageCache().get("templatetype"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(16);
        showDataMap.put("haslicense", "1");
        showDataMap.put("tctrcwarning", tctrcResultMapList);
        showDataMap.put("tctrcwarningsize", tctrcResultMapList.size());
        showDataMap.put("pageid", this.getView().getPageId());
        CustomControl control = (CustomControl)this.getControl(CUSTOM_CONTROL);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", showDataMap);
        StringBuilder sb = new StringBuilder();
        String pageId = this.getView().getPageId();
        sb.append("<ul id=\"tctrcriskul_").append(pageId);
        if (tctrcResultMapList.size() == 0) {
            sb.append("\" class=\"riskContent contentno\"  >").append("<div class=\"contentimg\"></div>").append(ResManager.loadKDString((String)"<div class=\"contentnotext\">\u4f18\u79c0\uff01\u6682\u65e0\u98ce\u9669\u7ba1\u63a7\u9884\u8b66\uff5e</div>", (String)"TaxDeclarePlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        } else {
            sb.append("\" class=\"riskContent\"  >");
            for (int i = 0; i < tctrcResultMapList.size(); ++i) {
                Map<String, String> riskMap = tctrcResultMapList.get(i);
                sb.append("<li id=\"tctrcriskItem").append(pageId).append(i).append("\">").append("<div class=\"contentTitle\" >").append(riskMap.get("tctrcriskname")).append(" <a tctrcresultid=\"").append(riskMap.get("id")).append(ResManager.loadKDString((String)"\" style=\" text-decoration: underline;color:#0E5FD8;margin-left: 8px;cursor: pointer; \" >\u67e5\u770b\u8be6\u60c5</a> ", (String)"TaxDeclarePlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append("</div>").append("<div class=\"content\">").append(riskMap.get("tctrcriskdesc")).append("</div>").append("</li>");
            }
        }
        sb.append("</ul>");
        map.put("tctrcriskinfohtml", sb.toString());
        map.put("tctrcriskinfos", 1);
        control.setData(map);
    }

    private void doReCalTctrcRisk(List<Long> resultids) {
        LocaleString relCalMsg = new LocaleString(ResManager.loadKDString((String)"\u98ce\u9669\u91cd\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff085S\uff09", (String)"TaxDeclarePlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        this.getView().getParentView().showLoading(relCalMsg, 5000);
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctrc", (String)"TctrcRiskReCal", (String)"riskReCal", (Object[])new Object[]{resultids, this.getView()});
    }

    private void jumpToTctrcRisk(Map<String, String> argsMap) {
        String resultid = argsMap.get("tctrcresultid");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(resultid));
        DynamicObject result = QueryServiceHelper.queryOne((String)"tctrc_risk_run_result", (String)"risk.risktype", (QFilter[])new QFilter[]{qFilter});
        if (result == null) {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Long> customParams = new HashMap<String, Long>(4);
        String risktype = result.getString("risk.risktype");
        if ("1".equals(risktype)) {
            param.setFormId("tctrc_resultview_number");
        } else if ("2".equals(risktype)) {
            param.setFormId("tctrc_resultview_sampling");
        } else {
            param.setFormId("tctrc_resultview_verify");
        }
        customParams.put("resultid", Long.parseLong(resultid));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void showAddRemark(String cellId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_remark");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)cellId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_remark");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showDetail(String cellId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_detail");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)cellId);
        showParameter.setCustomParam(SBBID, (Object)this.getPageCache().get(SBBID));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_detail");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showBaseData(Map<String, String> argsMap) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EVENT_SHOW_BASE_DATA);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)argsMap.get(BASEDATA_ENTITY_ID), (boolean)false, (int)2);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        this.setFilter(argsMap, listFilterParameter);
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setFilter(Map<String, String> argsMap, ListFilterParameter listFilterParameter) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String templatetype = customParams.get("templatetype").toString();
        String startDate = customParams.get("skssqq").toString();
        String endDate = customParams.get("skssqz").toString();
        if ("fjsf".equals(templatetype) || StringUtils.isNotEmpty((CharSequence)templatetype) && templatetype.contains("zzs")) {
            String cellid = argsMap.get("cellid");
            if ("tcvat_sb_fjsf_1_jmxzdm".equals(cellid) || "tcvat_prepay_flzl_1_jmxzdm".equals(cellid)) {
                templatetype = "cswhjss";
            }
            if ("tcvat_sb_fjsf_2_jmxzdm".equals(cellid) || "tcvat_prepay_flzl_2_jmxzdm".equals(cellid)) {
                templatetype = "jyffj";
            }
            if ("tcvat_sb_fjsf_3_jmxzdm".equals(cellid) || "tcvat_prepay_flzl_3_jmxzdm".equals(cellid)) {
                templatetype = "dfjyffj";
            }
        }
        if (null != TaxDeductionConstant.getMap().get(templatetype)) {
            QFilter cateGoryFilter = new QFilter("taxcategory", "=", (Object)TaxDeductionConstant.getMap().get(templatetype));
            listFilterParameter.getQFilters().add(cateGoryFilter);
        }
        if (argsMap.get(BASEDATA_ENTITY_ID).equals("tpo_taxdeduction")) {
            listFilterParameter.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        }
        QFilter periodFilter = new QFilter("startDate", "<=", (Object)DateUtils.stringToDate(startDate)).and(new QFilter("endDate", ">=", (Object)DateUtils.stringToDate(endDate)).or("endDate", "is null", null));
        if (!"bd_country".equals(argsMap.get(BASEDATA_ENTITY_ID))) {
            listFilterParameter.getQFilters().add(periodFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnObj = event.getReturnData();
        if (returnObj != null && "bdtaxr_declare_remark".equals(event.getActionId())) {
            Map returnData = (Map)returnObj;
            HashMap<String, String> remarkMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_REMARK, Map.class);
            if (remarkMap == null) {
                remarkMap = new HashMap<String, String>(16);
            }
            String cellId = (String)returnData.get("cellid");
            String remark = (String)returnData.get("remark");
            if (StringUtils.isNotEmpty((CharSequence)cellId) && StringUtils.isNotEmpty((CharSequence)remark)) {
                remarkMap.put(cellId, remark);
                TreeUtils.putCache(this.getPageCache(), CACHE_UPDATA_REMARK, remarkMap);
            }
        } else if (event.getActionId().startsWith(EVENT_SHOW_BASE_DATA) && returnObj != null) {
            String cellId = this.getPageCache().get("cellid");
            ListSelectedRowCollection returnList = (ListSelectedRowCollection)returnObj;
            if (returnList != null && !returnList.isEmpty()) {
                ListSelectedRow row = returnList.get(0);
                Map<String, String> dataMap = CacheUtils.getInstance().getDataResult(this.getCache());
                Map<String, String> saveFieldMap = this.getAllFieldToSave();
                String saveCellId = saveFieldMap.get(cellId);
                String beforeValue = dataMap.get(saveCellId);
                if (!row.getPrimaryKeyValue().toString().equals(beforeValue)) {
                    String sheetId = this.getPageCache().get("sheetid");
                    this.changeData(cellId, row.getPrimaryKeyValue().toString(), sheetId);
                }
            }
        }
    }

    private void changeData(String cellId, String value, String sheetId) {
        HashMap<String, String> dataMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID, Map.class);
        if (dataMap == null) {
            dataMap = new HashMap<String, String>(16);
        }
        if (StringUtils.isNotEmpty((CharSequence)cellId)) {
            Map<String, EntityField> typeMap = TemplateUtilsOld.getAllFieldTypeToShow(this.getTemplateTables());
            if (null != typeMap.get(cellId)) {
                if ("Decimal".equals(typeMap.get(cellId).getFieldType()) || "Integer".equals(typeMap.get(cellId).getFieldType())) {
                    value = StringUtils.isNotBlank((CharSequence)value) ? value.replaceAll(",", "") : "0";
                    value = TemplateUtilsOld.dataFormatPreSave(value, typeMap.get(cellId));
                }
                if (COMBO_CELLID.contains(cellId)) {
                    if (StringUtils.isNotBlank((CharSequence)value) && value.contains(",")) {
                        String[] split = value.split(",");
                        value = split[0];
                    }
                    if (StringUtil.isEmpty((CharSequence)value.trim())) {
                        value = "0";
                    }
                }
            }
            dataMap.put(cellId, value);
            TaxDeclareDataHandlerFactory.createHandler(this.getPageCache().get("templatetype")).handleUpdateData(dataMap);
            TreeUtils.putCache(this.getPageCache(), CACHE_UPDATA_CELLID, dataMap);
            Map<String, String> showAllMap = this.getAllFieldToSave();
            Map<String, String> newData = FormulaService.cal(this.getCache(), showAllMap.get(cellId), value);
            Map<String, String> showData = this.changeToShow(newData);
            this.addVelocityTemplateDataToFormulaContent(showData, this.getPageCache().get("templatetype"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
            if (sheetId != null) {
                this.getPageCache().put("sheetid", sheetId);
            }
            this.getPageCache().put(CACHE_UPDATA_FOCUS, cellId);
            String sheetName = this.getPageCache().get("sheetname");
            this.refreshAll(this.getPageCache().get("orgid"), this.getPageCache().get("templatetype"), showData, sheetName, "edit", this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        }
    }

    private void checkData(Map<String, String> argsMap) {
        String cell = argsMap.get("cellid");
        Map<String, String> formulaKey = this.getAllFieldToSave();
        String[] array = null;
        if (null != formulaKey.get(cell)) {
            array = formulaKey.get(cell).split("#");
        }
        if (null != array && array.length == 3) {
            String matedata = array[0];
            String key = array[2];
            EntityInfo entity = MetadataUtil.getEntityById(matedata);
            Optional<EntityField> object = entity.getFieldList().stream().filter(e -> key.equals(e.getFieldId())).findFirst();
            if (object.isPresent()) {
                EntityField entityField = object.get();
                String fieldType = entityField.getFieldType();
                if ("Text".equals(fieldType)) {
                    if (entityField.getMaxLength() > 0) {
                        this.checkLength(argsMap, entityField);
                    }
                } else if ("Date".equals(fieldType)) {
                    this.checkDateFormat(argsMap);
                }
            }
        }
    }

    private void checkLength(Map<String, String> argsMap, EntityField entityField) {
        String value = argsMap.get("value");
        int maxLength = entityField.getMaxLength();
        int currentLength = value.length();
        if (currentLength > maxLength) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5f97\u8d85\u8fc7%2$s\u5b57\u7b26", (String)"TaxDeclarePlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entityField.getFieldName(), maxLength);
            this.getView().showErrorNotification(msg);
            argsMap.put("value", "");
            return;
        }
    }

    private void checkDateFormat(Map<String, String> argsMap) {
        String value = argsMap.get("value");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            df.parse(value);
        }
        catch (ParseException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM-dd", (String)"TaxDeclarePlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), value);
            this.getView().showErrorNotification(msg);
        }
    }

    private String getCacheKey(String name, String orgId, String type, String startData, String endData) {
        return String.format("tax%s_%s_%s_%s_%s", name, orgId, type, startData, endData);
    }

    public boolean saveClick(IPageCache pageCache) {
        boolean exists;
        Map updateMap = TreeUtils.getCache(pageCache, CACHE_UPDATA_CELLID, Map.class);
        String templatetype = pageCache.get("templatetype");
        if ("zzsyjskb".equals(templatetype) && !(exists = QueryServiceHelper.exists((String)"tcvat_prepay_declare_bill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(pageCache.get(SBBID))), new QFilter("billstatus", "=", (Object)"A")}))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"TaxDeclarePlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> hisList = new ArrayList<DynamicObject>();
        if (updateMap != null && !updateMap.isEmpty()) {
            Object[] checkData = this.checkBizData(updateMap);
            if (!((Boolean)checkData[0]).booleanValue()) {
                this.getView().getParentView().showErrorNotification((String)checkData[1]);
                return false;
            }
            Map currMap = TreeUtils.getCache(pageCache, CACHE_CURRENT_DATA, Map.class);
            Map remarkMap = TreeUtils.getCache(pageCache, CACHE_UPDATA_REMARK, Map.class);
            String templateType = this.getPageCache().get("templatetype");
            List<FormulaVo> formulas = QueryFormulaService.queryDBCellConfig(templateType, this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getPageCache().get("templateid"));
            HashMap<String, List> basePkListMap = new HashMap<String, List>();
            HashMap<String, List> baseFieldListMap = new HashMap<String, List>();
            HashMap<String, Object> cellTypeMap = new HashMap<String, Object>();
            for (FormulaVo formulaVo : formulas) {
                String key;
                String string = formulaVo.getCellType();
                if (!"5".equals(string) && !"3".equals(string) && !"4".equals(string) && !"2".equals(string) || !updateMap.containsKey(key = formulaVo.getFormulaKey().replace('#', '_'))) continue;
                CellType cellType = new CellType();
                cellType.setCellId(key);
                cellType.setCellType(string);
                Map<String, String> itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                if ("5".equals(string)) {
                    String newValue;
                    Map.Entry<String, String> cellTypeEntry = itemMap.entrySet().iterator().next();
                    cellType.setBaseEntityId(cellTypeEntry.getKey());
                    cellType.setDisplayConfig(cellTypeEntry.getValue());
                    List<String> fieldList = TemplateShowUtils.parseBaseDataFieldList(formulaVo.getFormulaName());
                    List selectFieldList = baseFieldListMap.getOrDefault(cellType.getBaseEntityId(), new ArrayList());
                    fieldList.add("id");
                    for (String field : fieldList) {
                        if (selectFieldList.contains(field)) continue;
                        selectFieldList.add(field);
                    }
                    baseFieldListMap.put(cellType.getBaseEntityId(), selectFieldList);
                    String oldValue = null;
                    if (null != currMap) {
                        oldValue = (String)currMap.get(key);
                    }
                    List pkList = basePkListMap.getOrDefault(cellType.getBaseEntityId(), new ArrayList());
                    if (!StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)oldValue))) {
                        pkList.add(oldValue);
                    }
                    if (!StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)(newValue = (String)updateMap.get(key))))) {
                        pkList.add(newValue);
                    }
                    basePkListMap.put(cellType.getBaseEntityId(), pkList);
                } else {
                    cellType.setItemMap(itemMap);
                }
                cellTypeMap.put(key, cellType);
            }
            HashMap<String, DynamicObject> baseValueMap = new HashMap<String, DynamicObject>();
            for (Map.Entry entry : basePkListMap.entrySet()) {
                ArrayList<Long> ids = new ArrayList<Long>(32);
                for (String str : (List)entry.getValue()) {
                    ids.add(Long.valueOf(str));
                }
                QFilter qFilter = new QFilter("id", "in", ids);
                DynamicObjectCollection resultCollection = QueryServiceHelper.query((String)((String)entry.getKey()), (String)String.join((CharSequence)",", (Iterable)baseFieldListMap.get(entry.getKey())), (QFilter[])new QFilter[]{qFilter});
                if (resultCollection == null) continue;
                for (DynamicObject result : resultCollection) {
                    String valIndex = (String)entry.getKey() + result.getString("id");
                    baseValueMap.put(valIndex, result);
                }
            }
            Map<String, String> map = this.getTemplateTables();
            Map<String, EntityField> map2 = TemplateUtilsOld.getAllFieldTypeToShow(map);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_declare_his");
            RequestContext context = RequestContext.get();
            for (Map.Entry entry : updateMap.entrySet()) {
                DynamicObject dObj = new DynamicObject((DynamicObjectType)mainEntityType);
                dObj.set(SBBID, (Object)this.getPageCache().get(SBBID));
                dObj.set("cellid", entry.getKey());
                dObj.set("modifytype", (Object)"2");
                String formatValue = TemplateUtilsOld.dataFormatPreSave(entry.getValue(), map2.get(entry.getKey()));
                if (null != map2.get(entry.getKey()) && "Decimal".equals(map2.get(entry.getKey()).getFieldType()) && StringUtils.isNotBlank((CharSequence)formatValue)) {
                    formatValue = formatValue.replaceAll(",", "");
                }
                CellType cellType = (CellType)cellTypeMap.get(entry.getKey());
                String originalvalue = null;
                if (null != currMap) {
                    originalvalue = (String)currMap.get(entry.getKey());
                    if (null != map2.get(entry.getKey()) && "Decimal".equals(map2.get(entry.getKey()).getFieldType()) && StringUtils.isNotBlank((CharSequence)originalvalue)) {
                        originalvalue = originalvalue.replaceAll(",", "");
                    }
                }
                if (cellType != null && "5".equals(cellType.getCellType())) {
                    DynamicObject baseObj;
                    BigDecimal origDec = BigDecimalUtil.toBigDecimal(originalvalue);
                    if (BigDecimal.ZERO.compareTo(origDec) != 0) {
                        DynamicObject baseObj2 = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + origDec.longValue());
                        dObj.set("originalvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj2));
                    } else {
                        DynamicObject baseObj2 = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + originalvalue);
                        dObj.set("originalvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj2));
                    }
                    BigDecimal tarDec = BigDecimalUtil.toBigDecimal(formatValue);
                    if (BigDecimal.ZERO.compareTo(origDec) != 0) {
                        baseObj = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + tarDec.longValue());
                        dObj.set("targetvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj));
                    } else {
                        baseObj = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + formatValue);
                        dObj.set("targetvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj));
                    }
                } else if (cellType != null && cellType.getItemMap() != null) {
                    dObj.set("originalvalue", (Object)this.getItemName(originalvalue, cellType.getItemMap()));
                    dObj.set("targetvalue", (Object)this.getItemName(formatValue, cellType.getItemMap()));
                } else {
                    dObj.set("originalvalue", (Object)originalvalue);
                    dObj.set("targetvalue", (Object)formatValue);
                }
                if (remarkMap != null) {
                    dObj.set("remark", remarkMap.get(entry.getKey()));
                }
                dObj.set("modifierfield", (Object)context.getUserId());
                dObj.set("modifydatefield", (Object)new Date());
                hisList.add(dObj);
                if (null == currMap) continue;
                currMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (!CollectionUtils.isEmpty(hisList)) {
            DynamicObject prePayBill;
            FormulaService.save(this.getCache());
            DynamicObject[] arrInsertDobj = new DynamicObject[hisList.size()];
            arrInsertDobj = hisList.toArray(arrInsertDobj);
            SaveServiceHelper.save((DynamicObject[])arrInsertDobj);
            DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pageCache.get(SBBID)), (String)"tcvat_nsrxx");
            if (declareMain != null) {
                declareMain.set("ismodified", (Object)1);
                SaveServiceHelper.update((DynamicObject)declareMain);
            }
            if ("zzsyjskb".equals(templatetype) && (prePayBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pageCache.get(SBBID)), (String)"tcvat_prepay_declare_bill")) != null) {
                prePayBill.set("ismodified", (Object)1);
                SaveServiceHelper.update((DynamicObject)prePayBill);
            }
        }
        try {
            String ssbId = this.getPageCache().get(SBBID);
            this.saveAttachment(ssbId, templatetype);
        }
        catch (Exception e) {
            LOGGER.error("save attachments error", (Throwable)e);
        }
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.parseLong(pageCache.get("orgid")));
        requestModel.setTemplateType(pageCache.get("templatetype"));
        requestModel.setSkssqq(pageCache.get("skssqq"));
        requestModel.setSkssqz(pageCache.get("skssqz"));
        this.sendRiskCalRealTimeTask(requestModel, updateMap, new HashMap<String, String>());
        return true;
    }

    private Object[] checkBizData(Map<String, String> updateMap) {
        String type = this.getPageCache().get("templatetype");
        Object[] result = new Object[]{Boolean.TRUE, ""};
        if ("tvpt".equals(type)) {
            String carserialno = updateMap.get("tcret_clgzs_zb_1_carserialno");
            if (StringUtil.isNotEmpty((CharSequence)carserialno)) {
                QFilter[] qFilters;
                String mainTable;
                DynamicObjectCollection sbbs;
                String org = this.getPageCache().get("orgid");
                String id = this.getPageCache().get(SBBID);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcret_clgzs_zb", (String)SBBID, (QFilter[])new QFilter("carserialno", "=", (Object)carserialno).and(SBBID, "!=", (Object)id).toArray());
                List sbbid = dynamicObjects.stream().map(a -> a.getString(SBBID)).filter(b -> StringUtil.isNotEmpty((CharSequence)b)).map(Long::valueOf).collect(Collectors.toList());
                if (sbbid.size() > 0 && EmptyCheckUtils.isNotEmpty(sbbs = QueryServiceHelper.query((String)(mainTable = TemplateUtilsOld.getMainTable(type)), (String)"id", (QFilter[])(qFilters = new QFilter("org", "=", (Object)Long.valueOf(org)).and("id", "in", sbbid).toArray())))) {
                    result[0] = Boolean.FALSE;
                    result[1] = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\u4e0e\u8f66\u67b6\u53f7\u7684\u7533\u62a5\u8868\uff01", (String)"TaxDeclarePlugin_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                }
            }
        } else if (updateMap != null) {
            String ybnsrJbrsfz = updateMap.get("tcvat_ybnsr_zb_5_jbrysfzjhm");
            String xgmJbrsfz = updateMap.get("tcvat_xgm_zb_7_jbrysfzjhm");
            String jbrsfzjhm = ybnsrJbrsfz;
            if (StringUtils.isBlank((CharSequence)jbrsfzjhm)) {
                jbrsfzjhm = xgmJbrsfz;
            }
            if (StringUtils.isNotBlank((CharSequence)jbrsfzjhm)) {
                if (jbrsfzjhm.length() <= 6) {
                    result[0] = Boolean.FALSE;
                    result[1] = ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u5458\u8eab\u4efd\u8bc1\u4ef6\u53f7\u7801\u5c0f\u4e8e6\u4f4d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TaxDeclarePlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                } else if (jbrsfzjhm.length() > 50) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u5458\u8eab\u4efd\u8bc1\u4ef6\u53f7\u7801\u957f\u5ea6\u5927\u4e8e50\u4f4d", (String)"TaxDeclarePlugin_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    private void loadDeclare(String org, String templateType, String sheetName, String operation, String skssqq, String skssqz, boolean refresh) {
        Map<String, String> dataMap = this.queryData(org, templateType, skssqq, skssqz, refresh);
        this.refreshAll(org, templateType, dataMap, sheetName, operation, skssqq, skssqz);
        String sbbid = dataMap.getOrDefault("tcvat_nsrxx#1#id", "-1");
        this.showAttachment(sbbid, operation, templateType);
    }

    private void refreshAll(String org, String templateType, Map<String, String> dataMap, String sheetName, String operation, String skssqq, String skssqz) {
        long start = System.currentTimeMillis();
        Map<String, Object> map = this.createCustomDataMap(dataMap, sheetName, operation);
        Map showDataMap = (Map)map.get("data");
        String id = dataMap.getOrDefault("tcvat_nsrxx#1#id", "-1");
        this.getCache().put("orgid", org);
        this.getCache().put("startDate", skssqq);
        this.getCache().put("endDate", skssqz);
        this.getCache().put("formulaType", templateType);
        List<Map<String, String>> checkFormulaList = FormulaService.checkFormula(this.getCache());
        showDataMap.put("riskwarning", checkFormulaList);
        showDataMap.put("riskwarningSize", checkFormulaList.size());
        boolean isnothaslicense = LicenseCheckServiceHelper.check(org, null, "tctrc");
        List<Object> tctrcResultMapList = new ArrayList();
        if (!isnothaslicense) {
            tctrcResultMapList = this.queryTctrcResultMapList(org, templateType, skssqq, skssqz);
            showDataMap.put("haslicense", "1");
            showDataMap.put("tctrcwarning", tctrcResultMapList);
            showDataMap.put("tctrcwarningsize", tctrcResultMapList.size());
        } else {
            showDataMap.put("haslicense", "0");
            showDataMap.put("tctrcwarning", tctrcResultMapList);
            showDataMap.put("tctrcwarningsize", 0);
        }
        new DeclareService().saveRiskItem(id, checkFormulaList, tctrcResultMapList, 2);
        this.saveDraftRiskItem(id, checkFormulaList, tctrcResultMapList);
        CustomControl control = (CustomControl)this.getControl(CUSTOM_CONTROL);
        control.setData(map);
        LOGGER.info("TaxDeclarePlugin.refresh:" + (System.currentTimeMillis() - start));
    }

    private void saveDraftRiskItem(String id, List<Map<String, String>> checkFormulaList, List<Map<String, String>> tctrcResultMapList) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftTable = (String)customParams.get("draftTable");
        String templatetype = (String)customParams.get("templatetype");
        if (DraftService.DRAFT_RISK_TYPES.contains(templatetype) && draftTable != null) {
            String draftId = (String)customParams.get("draftId");
            new DraftService().saveRiskItem(draftTable, draftId, id, checkFormulaList, tctrcResultMapList, 2);
        }
    }

    private List<Map<String, String>> queryTctrcResultMapList(String org, String templateType, String skssqq, String skssqz) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(10);
        String templateTypeId = this.queryTemplateTypeIdByNumber(templateType);
        QFilter qFilter = new QFilter("risk.sbbtype.fbasedataid", "=", (Object)templateTypeId);
        QFilter qFilter6 = new QFilter("risk.issbshow", "=", (Object)BooleanEnum.YES.getCode());
        QFilter qFilter1 = new QFilter("startdate", ">=", (Object)DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(skssqq)));
        QFilter qFilter2 = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(skssqz)));
        QFilter qFilter3 = new QFilter("rlevel.id", "in", Arrays.asList(1, 2, 3));
        QFilter qFilter4 = new QFilter("status", "in", Arrays.asList("0", "2"));
        qFilter4.or(new QFilter("status", "=", (Object)"1").and(new QFilter("dealresult", "=", (Object)"3")));
        QFilter qFilter5 = new QFilter("runorg.id", "=", (Object)Long.parseLong(org));
        LOGGER.info("params org:+" + org + "+templateTypeId:" + templateTypeId + "skssqq:" + skssqq + "skssqz:" + skssqz);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_handle_list", (String)"id,risk.name,risk.number,riskdesc", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4, qFilter5, qFilter6});
        if (EmptyCheckUtils.isEmpty(dynamicObjects)) {
            LOGGER.info("size:0");
            return resultList;
        }
        LOGGER.info("size:" + dynamicObjects.length);
        return Arrays.stream(dynamicObjects).map(TaxDeclarePlugin::createTctrcMap).collect(Collectors.toList());
    }

    private String queryTemplateTypeIdByNumber(String templateType) {
        QFilter qFilter = new QFilter("number", "=", (Object)templateType);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tpo_template_type", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isEmpty(dynamicObjects)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801%s\u67e5\u8be2tctb_template_type\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (String)"TaxDeclarePlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), templateType));
        }
        if (dynamicObjects.length != 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801%s\u67e5\u8be2tctb_template_type\u67e5\u8be2\u5230\u591a\u6761\u8bb0\u5f55", (String)"TaxDeclarePlugin_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), templateType));
        }
        return dynamicObjects[0].getString("id");
    }

    private static Map<String, String> createTctrcMap(DynamicObject dynamicObject) {
        HashMap<String, String> tctrcMap = new HashMap<String, String>(16);
        tctrcMap.put("id", dynamicObject.getString("id"));
        tctrcMap.put("tctrcriskname", String.format(ResManager.loadKDString((String)"%s\u5f02\u5e38", (String)"TaxDeclarePlugin_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dynamicObject.getString("risk.name")));
        tctrcMap.put("tctrcriskdesc", dynamicObject.getString("riskdesc"));
        return tctrcMap;
    }

    private String getTemplateId() {
        String templateType = this.getPageCache().get("templatetype");
        String skssqq = this.getPageCache().get("skssqq");
        Date startDate = DateUtils.stringToDate(skssqq, "yyyy-MM-dd");
        String orgid = this.getPageCache().get("orgid");
        DynamicObject template = TemplateUtilsOld.getTemplateObjectByConfig(templateType, orgid, startDate, startDate);
        if (template != null && StringUtils.isNotEmpty((CharSequence)template.getString("content_tag"))) {
            return template.getString("id");
        }
        LOGGER.info("TaxDeclarePlugin.getTemplate:\u7533\u62a5\u8868\u6a21\u677f\u4e3a\u7a7a\uff0c\u6a21\u677f\u7c7b\u578b:" + templateType);
        this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"TaxDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        this.getView().sendFormAction(this.getView().getParentView());
        return null;
    }

    private String getTemplate(String sheetName, String editFlag) {
        String templateType = this.getPageCache().get("templatetype");
        String cacheKey = "TEMPLATE_" + editFlag + templateType + sheetName;
        String templateHtml = "";
        String skssqq = this.getPageCache().get("skssqq");
        Date startDate = DateUtils.stringToDate(skssqq, "yyyy-MM-dd");
        DynamicObject template = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("templateid"))) {
            template = TemplateUtilsOld.getTemplateObjectById(templateType, this.getPageCache().get("templateid"));
        }
        if (template != null && StringUtils.isNotEmpty((CharSequence)template.getString("content_tag"))) {
            ArrayList<BasePointInfo> floatBasePointList = new ArrayList<BasePointInfo>();
            String json = template.getString("content_tag");
            Map<String, EntityField> fieldMap = TemplateUtilsOld.getAllEntityShow(this.getTemplateTables());
            ArrayList<Sheet> sheets = new ArrayList<Sheet>();
            if (StringUtils.isNotBlank((CharSequence)sheetName)) {
                String[] sheetNames;
                for (String itemSheet : sheetNames = sheetName.split(",")) {
                    sheets.addAll(SpreadUtils.getSheets(json, itemSheet));
                }
            } else {
                sheets.addAll(SpreadUtils.getSheets(json, sheetName));
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            boolean needWarn = Boolean.FALSE.toString().equals((String)customParams.get("needwarn"));
            boolean needRemark = Boolean.FALSE.toString().equals((String)customParams.get("needremark"));
            Map<String, FormulaVo> cellTypeMap = FormulaService.queryCellConfig(templateType, DateUtils.format(startDate), DateUtils.format(startDate), this.getPageCache().get("templateid"));
            templateHtml = TemplateShowUtils.buildSbbHtml(sheets, fieldMap, cellTypeMap, editFlag, "{PAGE_ID}", !needWarn, !needRemark, floatBasePointList);
            TreeUtils.putCache(this.getCache(), cacheKey, templateHtml);
        } else {
            LOGGER.info("TaxDeclarePlugin.getTemplate:\u7533\u62a5\u8868\u6a21\u677f\u4e3a\u7a7a\uff0c\u6a21\u677f\u7c7b\u578b:" + templateType);
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"TaxDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        }
        return templateHtml.replace("{PAGE_ID}", this.getView().getPageId());
    }

    private List<String> queryHasHisCell() {
        String sbbid = this.getPageCache().get(SBBID);
        ArrayList<String> cellIdList = new ArrayList<String>();
        if (sbbid != null) {
            QFilter qFilter = new QFilter(SBBID, "=", (Object)sbbid);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_declare_his", (String)"cellid", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject obj : collection) {
                String cellid = obj.getString("cellid");
                if (cellIdList.contains(cellid)) continue;
                cellIdList.add(cellid);
            }
        }
        return cellIdList;
    }

    private Map<String, String> queryData(String org, String templateType, String skssqq, String skssqz, boolean refresh) {
        IPageCache cache = this.getCache();
        Map<String, String> valueMap = FormulaService.query(cache, templateType, org, skssqq, skssqz, refresh);
        this.getPageCache().put("refresh", String.valueOf(Boolean.FALSE));
        this.getPageCache().put(SBBID, valueMap.get("tcvat_nsrxx#1#id"));
        Map<String, String> data = this.changeToShow(valueMap);
        this.addVelocityTemplateDataToFormulaContent(data, templateType, skssqq, skssqz);
        TreeUtils.putCache(this.getPageCache(), CACHE_CURRENT_DATA, data);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.parseLong(cache.get("orgid")));
        requestModel.setTemplateType(cache.get("templatetype"));
        requestModel.setSkssqq(cache.get("skssqq"));
        requestModel.setSkssqz(cache.get("skssqz"));
        this.sendRiskCalRealTimeTask(requestModel, new HashMap<String, String>(), new HashMap<String, String>());
        return data;
    }

    private Map<String, String> changeToShow(Map<String, String> srcMap) {
        Map<String, String> listTab = this.getTemplateTables();
        Map<String, String> showAllMap = TemplateUtilsOld.getAllFieldToShow(listTab);
        Map<String, EntityField> typeMap = TemplateUtilsOld.getAllFieldTypeToShow(listTab);
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        Set<Map.Entry<String, String>> entrySet = srcMap.entrySet();
        Iterator<Map.Entry<String, String>> it = entrySet.iterator();
        Set<String> excludeFields = this.excludeField();
        Set<String> excludeFields2 = this.excludeField2();
        Set<String> excludeField3 = this.excludeField3();
        while (it.hasNext()) {
            Object value;
            Map.Entry<String, String> ent = it.next();
            String newkey = showAllMap.getOrDefault(ent.getKey(), ent.getKey());
            if (excludeFields.contains(ent.getKey())) {
                value = new BigDecimal(ent.getValue()).toBigInteger().toString();
                dataMap.put(newkey, (String)value);
                continue;
            }
            if (excludeFields2.contains(ent.getKey())) {
                value = new BigDecimal(ent.getValue());
                String text = String.format("%s%%", ((BigDecimal)value).multiply(new BigDecimal("100")).setScale(2, 4));
                dataMap.put(newkey, text);
                continue;
            }
            if (this.zeroNoDisplay().contains(ent.getKey())) {
                if (null == ent.getValue() || StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)ent.getValue())) {
                    dataMap.put(newkey, "");
                    continue;
                }
                dataMap.put(newkey, TemplateUtilsOld.dataFormat(ent.getValue(), typeMap.get(newkey)));
                continue;
            }
            if (excludeField3.contains(ent.getKey())) {
                dataMap.put(newkey, TemplateUtilsOld.defaultDataFormat(ent.getValue(), typeMap.get(newkey)));
                continue;
            }
            dataMap.put(newkey, TemplateUtilsOld.dataFormat(ent.getValue(), typeMap.get(newkey)));
        }
        return dataMap;
    }

    private Set<String> excludeField3() {
        String table = "tccit_qysds_a107041";
        String column = "hj";
        List rows = IntStream.range(4, 33).boxed().filter(s -> !Lists.newArrayList((Object[])new Integer[]{10, 13, 30}).contains(s)).map(s -> s.toString()).collect(Collectors.toList());
        Set<String> excludeFields = Lists.newArrayList((Object[])new String[]{"#", "_"}).stream().flatMap(flag -> rows.stream().map(row -> table + flag + row + flag + column)).collect(Collectors.toSet());
        String table2 = "tccit_qysds_a107042";
        String column2 = "je";
        ArrayList rows2 = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "6", "7", "10", "11", "22"});
        Set excludeFields2 = Lists.newArrayList((Object[])new String[]{"#", "_"}).stream().flatMap(flag -> rows2.stream().map(row -> table2 + flag + row + flag + column2)).collect(Collectors.toSet());
        excludeFields.addAll(excludeFields2);
        return excludeFields;
    }

    private Set<String> zeroNoDisplay() {
        HashSet result = Sets.newHashSet((Object[])new String[]{"tccit_qysds_a000000#1#sbssqnd", "tccit_qysds_a000000#1#ssqxynd", "tccit_qysds_a000000#1#zsbh1", "tccit_qysds_a000000#1#zsbh2"});
        return result;
    }

    private Set<String> excludeField2() {
        HashSet result = Sets.newHashSet((Object[])new String[]{"tccit_qysds_a107041#10#hj", "tccit_qysds_a107041#13#hj", "tccit_qysds_a107041#30#hj"});
        return result;
    }

    private Set<String> excludeField() {
        String table = "tccit_qysds_a105040";
        String column = "1";
        ArrayList rows = Lists.newArrayList((Object[])new String[]{"qwnd", "qsind", "qsand", "qend", "qynd", "bn"});
        Set<String> excludeFields = Lists.newArrayList((Object[])new String[]{"#", "_"}).stream().flatMap(flag -> rows.stream().map(row -> table + flag + column + flag + row)).collect(Collectors.toSet());
        return excludeFields;
    }

    private Map<String, String> getAllFieldToSave() {
        String templateType = this.getPageCache().get("templatetype");
        Map<String, String> saveFieldMap = TreeUtils.getCache(this.getCache(), "AllFieldToSave" + templateType, Map.class);
        if (saveFieldMap == null) {
            saveFieldMap = TemplateUtilsOld.getAllFieldToSave(this.getTemplateTables());
            TreeUtils.putCache(this.getCache(), "AllFieldToSave" + templateType, saveFieldMap);
        }
        return saveFieldMap;
    }

    private Map<String, Object> createCustomDataMap(Map<String, String> dataMap, String sheetName, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String sheetId = this.getPageCache().get("sheetid");
        String templateType = this.getPageCache().get("templatetype");
        TemplateUtilsOld.handleTaxRateOnFormShowByTypeAndField(templateType, dataMap);
        Map<String, String> showData = this.changeToShow(dataMap);
        this.queryBaseData(showData);
        TaxDeclareDataHandlerFactory.createHandler(templateType).handleShowData(showData, operation);
        String template = this.getTemplate(sheetName, operation);
        map.put("template", template);
        map.put("operation", operation);
        map.put("sheetid", "tab-item-content" + this.getView().getPageId() + sheetId);
        map.put(CACHE_UPDATA_FOCUS, this.getPageCache().get(CACHE_UPDATA_FOCUS));
        map.put("pageid", this.getView().getPageId());
        HashMap<String, String> showDataMap = new HashMap<String, String>(4);
        showDataMap.putAll(showData);
        map.put("data", showDataMap);
        if ("read".equals(operation)) {
            List<String> hisCellList = this.queryHasHisCell();
            ArrayList list = new ArrayList(hisCellList.size());
            for (String str : hisCellList) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("id", str);
                list.add(m);
            }
            map.put("hisCells", list);
        }
        return map;
    }

    private void queryBaseData(Map<String, String> showData) {
        long start = System.currentTimeMillis();
        HashMap<String, List> pkListMap = new HashMap<String, List>();
        HashMap<String, List> basePkCellListMap = new HashMap<String, List>();
        HashMap<String, List<String>> baseSelectFieldMap = new HashMap<String, List<String>>();
        HashMap<String, String> displayPopMap = new HashMap<String, String>();
        String templateType = this.getPageCache().get("templatetype");
        HashMap<String, FormulaVo> cellTypeMap = new HashMap<String, FormulaVo>();
        List<FormulaVo> formulas = QueryFormulaService.queryDBCellConfig(templateType, this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getPageCache().get("templateid"));
        for (FormulaVo formulaVo : formulas) {
            String celltype = formulaVo.getCellType();
            if (!"3".equals(celltype) && !"4".equals(celltype) && !"5".equals(celltype)) continue;
            cellTypeMap.put(formulaVo.getFormulaKey().replace('#', '_'), formulaVo);
        }
        for (Map.Entry entry : cellTypeMap.entrySet()) {
            Map<String, String> itemMap;
            String[] strs;
            FormulaVo formulaVo;
            String celltype;
            String key = (String)entry.getKey();
            String text = showData.get(key);
            if (StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)text)) || !"3".equals(celltype = (formulaVo = (FormulaVo)cellTypeMap.get(key)).getCellType()) && !"4".equals(celltype) && !"5".equals(celltype)) continue;
            if ("3".equals(celltype)) {
                for (String s2 : strs = text.split(",")) {
                    showData.put(key + s2, s2);
                }
            }
            if ("4".equals(celltype)) {
                for (String s2 : strs = text.split(",")) {
                    showData.put(key + s2, s2 + UUID.randomUUID());
                }
                continue;
            }
            if (!"5".equals(celltype) || (itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName())).isEmpty()) continue;
            Map.Entry<String, String> cellTypeEntry = itemMap.entrySet().iterator().next();
            String baseId = cellTypeEntry.getKey() + "&" + key;
            String basetext = cellTypeEntry.getValue();
            String valIndex = baseId + text;
            List cellList = basePkCellListMap.getOrDefault(baseId, new ArrayList());
            showData.put(key + "_text", showData.get(key + "jsmsextval"));
            cellList.add(key);
            basePkCellListMap.put(valIndex, cellList);
            List pkList = pkListMap.getOrDefault(baseId, new ArrayList());
            if (!pkList.contains(text)) {
                pkList.add(text);
            }
            List<String> selectFieldList = TemplateShowUtils.parseBaseDataFieldList(basetext);
            baseSelectFieldMap.put(baseId, selectFieldList);
            pkListMap.put(baseId, pkList);
            displayPopMap.put(key, basetext);
        }
        HashMap<String, DynamicObjectCollection> mapResult = new HashMap<String, DynamicObjectCollection>();
        for (Map.Entry entry : pkListMap.entrySet()) {
            List list = ((List)entry.getValue()).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", list);
            List fieldList = (List)baseSelectFieldMap.get(entry.getKey());
            String table = ((String)entry.getKey()).split("&")[0];
            String mapKey = table + String.valueOf(list);
            DynamicObjectCollection resultCollection = (DynamicObjectCollection)mapResult.get(mapKey);
            if (null == resultCollection) {
                resultCollection = QueryServiceHelper.query((String)table, (String)String.join((CharSequence)",", fieldList), (QFilter[])new QFilter[]{qFilter});
                mapResult.put(mapKey, resultCollection);
            }
            if (resultCollection == null) continue;
            for (DynamicObject result : resultCollection) {
                String valIndex = (String)entry.getKey() + result.getString("id");
                List cellList = (List)basePkCellListMap.get(valIndex);
                if (cellList == null) {
                    cellList = (List)basePkCellListMap.get(valIndex + ".00");
                }
                for (String key : cellList) {
                    String display = (String)displayPopMap.get(key);
                    if (null == display) continue;
                    showData.put(key + "_text", TemplateShowUtils.getDisplayText(display, result));
                }
            }
        }
        LOGGER.info("TaxDeclarePlugin.queryBaseData:" + (System.currentTimeMillis() - start));
    }

    private String getItemName(String value, Map<String, String> itemMap) {
        if (value == null || itemMap == null) {
            return null;
        }
        String[] strs = value.split(",");
        StringBuilder sb = new StringBuilder();
        int size = itemMap.size();
        for (String str : strs) {
            String text = itemMap.get(str);
            if (size == 1 && itemMap.containsKey(str) && StringUtils.isEmpty((CharSequence)text)) {
                sb.append(ResManager.loadKDString((String)"\u9009\u62e9", (String)"TaxDeclarePlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)text)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(text);
        }
        return sb.toString();
    }

    private IPageCache getCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ParentCache = (String)customParams.get("ParentCache");
        if (Boolean.TRUE.toString().equals(ParentCache)) {
            String parentpageId = (String)customParams.get("rootPageId");
            IFormView parentView = this.getView().getParentView();
            if (StringUtils.isNotEmpty((CharSequence)parentpageId)) {
                parentView = this.getView().getView(parentpageId);
            }
            IPageCache f = (IPageCache)parentView.getService(IPageCache.class);
            return f;
        }
        return this.getPageCache();
    }

    private Map<String, String> getTemplateTables() {
        Map<String, String> map = TreeUtils.getCache(this.getPageCache(), CACHE_TEMPLATE_TABLE_LIST, Map.class);
        if (map == null) {
            String templateType = this.getPageCache().get("templatetype");
            map = TemplateUtilsOld.queryEntityByTypeId(templateType);
            TreeUtils.putCache(this.getPageCache(), CACHE_TEMPLATE_TABLE_LIST, map);
        }
        return map;
    }

    private void addVelocityTemplateDataToFormulaContent(Map<String, String> data, String templateType, String skssqq, String skssqz) {
        Map<String, FormulaVo> cellTypeMap = FormulaService.queryCellConfig(templateType, skssqq, skssqz, this.getPageCache().get("templateid"));
        Map<String, Object> convertMap = TemplateShowUtils.convertMap(data);
        Map<String, String> listTab = this.getTemplateTables();
        Map<String, EntityField> typeMap = TemplateUtilsOld.getAllFieldTypeToShow(listTab);
        for (Map.Entry<String, Object> entry : convertMap.entrySet()) {
            Object value;
            if (null == typeMap.get(entry.getKey()) || !"Decimal".equals(typeMap.get(entry.getKey()).getFieldType()) || !StringUtils.isNotBlank((Object)(value = entry.getValue()))) continue;
            value = value.toString().replaceAll(",", "");
            convertMap.put(entry.getKey(), value);
        }
        VelocityContext context = new VelocityContext(convertMap);
        StringWriter stringWriter = new StringWriter();
        try (Reader reader = this.getReader(cellTypeMap, data);){
            Velocity v = new Velocity();
            Method evaluate = v.getClass().getDeclaredMethod("evaluate", Context.class, Writer.class, String.class, Reader.class);
            evaluate.invoke((Object)v, context, stringWriter, "mystring", reader);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        try {
            LOGGER.info("mystring:" + stringWriter);
            Map velocityMap = (Map)JSONObject.parse((String)stringWriter.toString());
            data.putAll(velocityMap);
        }
        catch (Exception e) {
            LOGGER.error("json parse error:" + e.getMessage());
        }
    }

    public Reader getReader(Map<String, FormulaVo> cellTypeMap, Map<String, String> data) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<String, FormulaVo> entry : cellTypeMap.entrySet()) {
            String showFormulaKey;
            FormulaVo formulaVo = entry.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)formulaVo.getContent()) || !StringUtils.isNotEmpty((CharSequence)formulaVo.getFormulaKey()) || null == data.get(showFormulaKey = formulaVo.getFormulaKey().replace('#', '_'))) continue;
            sb.append('\"').append(showFormulaKey).append("_title\":\"").append(formulaVo.getContent()).append("\",");
        }
        sb.append('}');
        return new StringReader(sb.toString());
    }
}

