/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.BizEnumToMapUtils;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTrasStaffImportHandlerImpl
implements ImportExcelHandler {
    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        Long orgId;
        QFilter orgQFilter;
        DynamicObject object;
        String nsrsbh = resultMap.get("tcvat_nsrxx#1#nsrsbh");
        String sshymc = resultMap.get("tcvat_nsrxx#1#sshymc");
        String registertype = resultMap.get("tcvat_nsrxx#1#registertype");
        String registertime = resultMap.get("tcvvt_tras_attached#1#registertime");
        String zjgorg = resultMap.get("tcvvt_tras_attached#1#zjgorg");
        String zjgnsrmc = resultMap.get("tcvvt_tras_attached#1#zjgnsrmc");
        String qysdsdeadline = resultMap.get("tcvvt_tras_attached#1#qysdsdeadline");
        String fddbrxm = resultMap.get("tcvat_nsrxx#1#fddbrxm");
        String zcdz = resultMap.get("tcvat_nsrxx#1#zcdz");
        String taxauthority = resultMap.get("tcvat_nsrxx#1#taxauthority");
        QFilter orgQ = new QFilter("taxorg.unifiedsocialcode", "=", (Object)nsrsbh);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id", (QFilter[])new QFilter[]{orgQ});
        DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((Object)(ObjectUtils.isNotEmpty((Object)results) ? ((DynamicObject)results.get(0)).getLong("id") : 0L), (String)"tctb_tax_main");
        if (ObjectUtils.isNotEmpty((Object)taxMain)) {
            if (StringUtils.isBlank((CharSequence)sshymc)) {
                resultMap.put("tcvat_nsrxx#1#sshymc", taxMain.getString("codeandname.name"));
            }
            if (StringUtils.isBlank((CharSequence)registertype)) {
                resultMap.put("tcvat_nsrxx#1#registertype", taxMain.getString("registertype.name"));
            }
            if (StringUtils.isBlank((CharSequence)registertime)) {
                resultMap.put("tcvvt_tras_attached#1#registertime", DateUtils.format(taxMain.getDate("registertime")));
            }
            if (StringUtils.isBlank((CharSequence)fddbrxm)) {
                resultMap.put("tcvat_nsrxx#1#fddbrxm", taxMain.getString("legalpeople"));
            }
            if (StringUtils.isBlank((CharSequence)zcdz)) {
                resultMap.put("tcvat_nsrxx#1#zcdz", taxMain.getString("registeraddrdetail"));
            }
            if (StringUtils.isBlank((CharSequence)taxauthority)) {
                resultMap.put("tcvat_nsrxx#1#taxauthority", taxMain.getString("taxoffice.id"));
            }
            if (StringUtils.isBlank((CharSequence)qysdsdeadline)) {
                DynamicObjectCollection collection = taxMain.getDynamicObjectCollection("categoryentryentity");
                for (DynamicObject row : collection) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)row.getString("taxtype"), (CharSequence)"qysds")) continue;
                    if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)row.getString("enable"))) {
                        qysdsdeadline = "0";
                        break;
                    }
                    switch (row.getString("deadline")) {
                        case "aysb": {
                            qysdsdeadline = "1";
                            break;
                        }
                        case "ajsb": {
                            qysdsdeadline = "2";
                            break;
                        }
                        default: {
                            qysdsdeadline = "0";
                            break;
                        }
                    }
                    break;
                }
                resultMap.put("tcvvt_tras_attached#1#qysdsdeadline", qysdsdeadline);
            }
        }
        if (StringUtils.isBlank((CharSequence)zjgnsrmc) && StringUtils.isNotBlank((CharSequence)zjgorg) && ObjectUtils.isNotEmpty((Object)(object = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{orgQFilter = new QFilter("org", "=", (Object)(orgId = Long.valueOf(Long.parseLong(zjgorg))))})))) {
            resultMap.put("tcvvt_tras_attached#1#zjgnsrmc", object.getString("unifiedsocialcode"));
        }
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        String orgName = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName1());
        String orgNumber = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName2());
        String s8 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName8());
        String s9 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName9());
        String s10 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName10());
        String s11 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName11());
        String s12 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName12());
        String s13 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName13());
        String s14 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName14());
        String s15 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName15());
        String s16 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName16());
        String s17 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName17());
        String s18 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName18());
        String s19 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName19());
        String s20 = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName20());
        String s21 = excelDataMap.get("originOrgName");
        if (StringUtils.isBlank((CharSequence)orgNumber) || "0".equals(orgNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25,\u4f01\u4e1a\u4e3b\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4f01\u4e1a\u4e3b\u4ee3\u7801\u3002", (String)"AbstractTrasStaffImportHandlerImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"id,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)orgNumber)});
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25,\u4f01\u4e1a\u4e3b\u4ee3\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4f01\u4e1a\u4e3b\u4ee3\u7801\u3002", (String)"AbstractTrasStaffImportHandlerImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        List<Long> isTaxpayerOrg = this.getIsTaxpayerOrg();
        if (!isTaxpayerOrg.contains(dynamicObject.getLong("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25,\u4f01\u4e1a\u4e3b\u4ee3\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4f01\u4e1a\u4e3b\u4ee3\u7801\u3002", (String)"AbstractTrasStaffImportHandlerImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        QFilter orgQ = new QFilter("taxorg.unifiedsocialcode", "=", (Object)orgNumber);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id,taxorg.id", (QFilter[])new QFilter[]{orgQ});
        if (ObjectUtils.isNotEmpty((Object)(results = TcvvtCategoryInfoBusinessImpl.queryzdsyCategoryInfoByUnifiedsocialCode(results)))) {
            Long id = ((DynamicObject)results.get(0)).getLong("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctb_tax_main");
            String codeandname = object.getString("codeandname.name");
            String registertype = object.getString("registertype.name");
            String registertime = DateUtils.format(object.getDate("registertime"));
            String legalpeople = object.getString("legalpeople");
            String registeraddrdetail = object.getString("registeraddrdetail");
            String taxoffice = object.getString("taxoffice.name");
            String taxpayer = object.getString("taxorg.taxpayer");
            String qysdsdeadline = "";
            DynamicObjectCollection collection = object.getDynamicObjectCollection("categoryentryentity");
            for (DynamicObject row : collection) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)row.getString("taxtype"), (CharSequence)"qysds")) continue;
                if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)row.getString("enable"))) {
                    qysdsdeadline = ResManager.loadKDString((String)"\u4e0d\u7533\u62a5", (String)"AbstractTrasStaffImportHandlerImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    continue;
                }
                qysdsdeadline = BizEnumToMapUtils.createDeadlineMap().get(row.getString("deadline"));
            }
            ArrayList<String> messageList = new ArrayList<String>(16);
            if (!StringUtils.equalsIgnoreCase((CharSequence)s8, (CharSequence)orgNumber)) {
                messageList.add(ResManager.loadKDString((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (String)"AbstractTrasStaffImportHandlerImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)s9, (CharSequence)orgNumber)) {
                messageList.add(ResManager.loadKDString((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801(\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7)", (String)"AbstractTrasStaffImportHandlerImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)s10, (CharSequence)taxpayer)) {
                messageList.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0", (String)"AbstractTrasStaffImportHandlerImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s11) && !StringUtils.equalsIgnoreCase((CharSequence)s11, (CharSequence)codeandname)) {
                messageList.add(ResManager.loadKDString((String)"\u56fd\u6c11\u7ecf\u6d4e\u884c\u4e1a\u7c7b\u522b", (String)"AbstractTrasStaffImportHandlerImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s12) && !StringUtils.equalsIgnoreCase((CharSequence)s12, (CharSequence)registertype)) {
                messageList.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b", (String)"AbstractTrasStaffImportHandlerImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s13) && !StringUtils.equalsIgnoreCase((CharSequence)s13, (CharSequence)registertime)) {
                messageList.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u8425\u4e1a\u6267\u7167\u7684\u767b\u8bb0\u65f6\u95f4", (String)"AbstractTrasStaffImportHandlerImpl_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s17) && !StringUtils.equalsIgnoreCase((CharSequence)s17, (CharSequence)qysdsdeadline)) {
                messageList.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u7533\u62a5\u5468\u671f", (String)"AbstractTrasStaffImportHandlerImpl_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s18) && !StringUtils.equalsIgnoreCase((CharSequence)s18, (CharSequence)legalpeople)) {
                messageList.add(ResManager.loadKDString((String)"\u6cd5\u5b9a\u4ee3\u8868\u4eba", (String)"AbstractTrasStaffImportHandlerImpl_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s19) && !StringUtils.equalsIgnoreCase((CharSequence)s19, (CharSequence)registeraddrdetail)) {
                messageList.add(ResManager.loadKDString((String)"\u6ce8\u518c\u5730\u5740", (String)"AbstractTrasStaffImportHandlerImpl_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s20) && !StringUtils.equalsIgnoreCase((CharSequence)s20, (CharSequence)taxoffice)) {
                messageList.add(ResManager.loadKDString((String)"\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173", (String)"AbstractTrasStaffImportHandlerImpl_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (ObjectUtils.isNotEmpty(messageList)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165%s\u4e0e\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractTrasStaffImportHandlerImpl_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), StringUtils.join(messageList, (String)",")));
            }
            QFilter nameQ = new QFilter("name", "=", (Object)s14);
            DynamicObjectCollection country = QueryServiceHelper.query((String)"bd_country", (String)"enable", (QFilter[])new QFilter[]{nameQ});
            if (ObjectUtils.isNotEmpty((Object)country) && !((DynamicObject)country.get(0)).getBoolean("enable")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e3b\u8981\u6295\u8d44\u65b9\u6240\u5c5e\u56fd\u5bb6\u6216\u5730\u533a\uff1a%s\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractTrasStaffImportHandlerImpl_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), s14));
            }
            if (StringUtils.isNotBlank((CharSequence)s16) && StringUtils.isBlank((CharSequence)s15)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u603b\u673a\u6784\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u6709\u503c\uff0c\u603b\u673a\u6784\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AbstractTrasStaffImportHandlerImpl_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)s16) && StringUtils.isNotBlank((CharSequence)s15)) {
                QFilter orgNameQ = new QFilter("org.name", "=", (Object)s15);
                DynamicObjectCollection zjgOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"status,unifiedsocialcode", (QFilter[])new QFilter[]{orgNameQ});
                if (ObjectUtils.isEmpty((Object)zjgOrgs)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25,\u603b\u673a\u6784\u540d\u79f0%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractTrasStaffImportHandlerImpl_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), s21));
                }
                if (!((DynamicObject)zjgOrgs.get(0)).getBoolean("status")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25,\u603b\u673a\u6784\u540d\u79f0%s\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractTrasStaffImportHandlerImpl_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), s21));
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)s16, (CharSequence)((DynamicObject)zjgOrgs.get(0)).getString("unifiedsocialcode"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25,\u603b\u673a\u6784\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801%1$s\u4e0e\u603b\u673a\u6784%2$s\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"AbstractTrasStaffImportHandlerImpl_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), s16, s21));
                }
            }
        }
        String type = templateContent.getString("type.number");
        String startDate = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName3());
        String endDate = excelDataMap.get(AbstractTrasStaffImportHandlerImpl.getSheetName4());
        Date sssqq = this.formatDateStr(startDate);
        Date sssqz = this.formatDateStr(endDate);
        ArrayList<Integer> jdList = new ArrayList<Integer>(4);
        jdList.add(3);
        jdList.add(6);
        jdList.add(9);
        jdList.add(12);
        int monthOfDateStart = DateUtils.getMonthOfDate(sssqq);
        int monthOfDateEnd = DateUtils.getMonthOfDate(sssqz);
        if ("zdsybs_yd".equalsIgnoreCase(type) ? jdList.contains(monthOfDateStart) || monthOfDateStart != monthOfDateEnd : "zdsybs_jd".equalsIgnoreCase(type) && (!jdList.contains(monthOfDateStart) || monthOfDateStart != monthOfDateEnd)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u671f\u5f15\u5165\u4e0d\u6b63\u786e\u3002", (String)"AbstractTrasStaffImportHandlerImpl_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        return ValidDataResultVo.success();
    }

    protected Date formatDateStr(String dateStr) {
        Date date;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"AbstractTrasStaffImportHandlerImpl_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        String format = "yyyy-MM-dd";
        if (dateStr.contains(ResManager.loadKDString((String)"\u65e5", (String)"AbstractTrasStaffImportHandlerImpl_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]))) {
            format = DateUtils.YYYYMMDD_CHINESE;
        }
        this.checkLeapYear(dateStr, format);
        try {
            date = DateUtils.stringToDate(dateStr);
        }
        catch (Exception e) {
            try {
                date = DateUtils.stringToDate(dateStr, DateUtils.YYYYMMDD_CHINESE);
            }
            catch (Exception e1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"AbstractTrasStaffImportHandlerImpl_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
        return date;
    }

    private void checkLeapYear(String dateStr, String format) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            LocalDate localDate = LocalDate.parse(dateStr, dateTimeFormatter);
            if (!localDate.isLeapYear() && (dateStr.endsWith("-02-29") || dateStr.endsWith(ResManager.loadKDString((String)"\u5e7402\u670829\u65e5", (String)"AbstractTrasStaffImportHandlerImpl_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0])))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"AbstractTrasStaffImportHandlerImpl_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"AbstractTrasStaffImportHandlerImpl_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    protected List<Long> getIsTaxpayerOrg() {
        DynamicObjectCollection taxOrgs;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_tras_declare_list", "4730fc9f000003ae", RequestContext.get().getCurrUserId());
        QFilter istaxpayerQuery = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
        QFilter status = new QFilter("status", "=", (Object)"1");
        if (EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty(hasPermOrgResult.getHasPermOrgs())) {
            QFilter authFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{istaxpayerQuery, status, authFilter});
        } else {
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{istaxpayerQuery, status});
        }
        if (CollectionUtils.isEmpty((Collection)taxOrgs)) {
            return new ArrayList<Long>();
        }
        List<Long> ids = taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
        QFilter orgFilters = this.getOrgFilters(ids);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid as id", (QFilter[])new QFilter[]{orgFilters});
        return CollectionUtils.isEmpty((Collection)results) ? new ArrayList<Long>() : results.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    protected QFilter getOrgFilters(List<Long> orgIds) {
        List<Long> ids = TcvvtCategoryInfoBusinessImpl.queryzdsyCategoryInfoByOrgIds(orgIds);
        return new QFilter("orgid", "in", ids);
    }

    private static String getSheetName1() {
        return String.format(ResManager.loadKDString((String)"B1\u7a0e\u6536\u8868#4#1", (String)"AbstractTrasStaffImportHandlerImpl_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName2() {
        return String.format(ResManager.loadKDString((String)"B1\u7a0e\u6536\u8868#4#3", (String)"AbstractTrasStaffImportHandlerImpl_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName3() {
        return String.format(ResManager.loadKDString((String)"B1\u7a0e\u6536\u8868#3#1", (String)"AbstractTrasStaffImportHandlerImpl_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName4() {
        return String.format(ResManager.loadKDString((String)"B1\u7a0e\u6536\u8868#3#3", (String)"AbstractTrasStaffImportHandlerImpl_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName5() {
        return String.format(ResManager.loadKDString((String)"B3\u8d22\u52a1\u8868#3#2", (String)"AbstractTrasStaffImportHandlerImpl_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName6() {
        return String.format(ResManager.loadKDString((String)"B3\u8d22\u52a1\u8868#3#3", (String)"AbstractTrasStaffImportHandlerImpl_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName7() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#13#4", (String)"AbstractTrasStaffImportHandlerImpl_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName8() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#2#1", (String)"AbstractTrasStaffImportHandlerImpl_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName9() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#3#4", (String)"AbstractTrasStaffImportHandlerImpl_32", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName10() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#4#4", (String)"AbstractTrasStaffImportHandlerImpl_33", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName11() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#5#4", (String)"AbstractTrasStaffImportHandlerImpl_34", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName12() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#6#4", (String)"AbstractTrasStaffImportHandlerImpl_35", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName13() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#7#4", (String)"AbstractTrasStaffImportHandlerImpl_36", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName14() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#8#4", (String)"AbstractTrasStaffImportHandlerImpl_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName15() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#13#4", (String)"AbstractTrasStaffImportHandlerImpl_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName16() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#14#4", (String)"AbstractTrasStaffImportHandlerImpl_38", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName17() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#25#4", (String)"AbstractTrasStaffImportHandlerImpl_39", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName18() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#33#4", (String)"AbstractTrasStaffImportHandlerImpl_40", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName19() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#37#4", (String)"AbstractTrasStaffImportHandlerImpl_41", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName20() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#40#4", (String)"AbstractTrasStaffImportHandlerImpl_42", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }
}

