/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class CcxwsImportServiceImpl
implements ImportExcelHandler {
    public static final Map<MultiLangEnumBridge, Long> dimensionTaxTypes = new HashMap<MultiLangEnumBridge, Long>();

    @Override
    public String getBillNo(String id, String skssqz) {
        return DeclareServiceHelper.generateSBBNo("tcret_declare_main_tp");
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        String declaredate = resultMap.get("tcret_ccxws_info#1#declaredate");
        if (EmptyCheckUtils.isNotEmpty(declaredate)) {
            resultMap.put("tcvat_nsrxx#1#declaredate", declaredate);
        }
        Map<String, DynamicObjectCollection> collectionMap = MapToTableUtils.mapToTable("tcvat_nsrxx", resultMap.get("tcvat_nsrxx#1#id"), resultMap);
        DynamicObjectCollection collection = collectionMap.get("tcret_ccxws_zb_hb");
        Map<String, String> skssqzMap = this.getSkssqzMap((List<DynamicObject>)collection);
        String skssqq = skssqzMap.get("skssqq");
        String skssqz = skssqzMap.get("skssqz");
        if (EmptyCheckUtils.isNotEmpty(skssqq)) {
            importDataVo.setStartDate(DateUtils.stringToDate(skssqq));
            resultMap.put("tcvat_nsrxx#1#skssqq", skssqq);
        }
        if (EmptyCheckUtils.isNotEmpty(skssqz)) {
            importDataVo.setEndDate(DateUtils.stringToDate(skssqz));
            resultMap.put("tcvat_nsrxx#1#skssqz", skssqz);
        }
    }

    private Map<String, String> getSkssqzMap(List<DynamicObject> collection) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (EmptyCheckUtils.isNotEmpty(collection)) {
            Date skssqq = null;
            Date skssqz = null;
            for (DynamicObject object : collection) {
                if (null == skssqq || null == skssqz) {
                    skssqq = object.getDate("startdate");
                    skssqz = object.getDate("enddate");
                }
                if (skssqq != null && object.getDate("startdate") != null && skssqq.compareTo(object.getDate("startdate")) > 0) {
                    skssqq = object.getDate("startdate");
                }
                if (skssqz == null || object.getDate("enddate") == null || skssqz.compareTo(object.getDate("enddate")) >= 0) continue;
                skssqz = object.getDate("enddate");
            }
            map.put("skssqq", DateUtils.format(skssqq));
            map.put("skssqz", DateUtils.format(skssqz));
        }
        return map;
    }

    @Override
    public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        String declaredate = resultMap.get("tcret_ccxws_info#1#declaredate");
        if (EmptyCheckUtils.isEmpty(declaredate)) {
            return ValidDataResultVo.fail(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7533\u62a5\u65e5\u671f\u3002", (String)"CcxwsImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        Map<String, DynamicObjectCollection> collectionMap = MapToTableUtils.mapToTable("tcvat_nsrxx", resultMap.get("tcvat_nsrxx#1#id"), resultMap);
        DynamicObjectCollection collection = collectionMap.get("tcret_ccxws_zb_hb");
        if (EmptyCheckUtils.isEmpty(collection)) {
            return ValidDataResultVo.fail(ResManager.loadKDString((String)"\u3010\u8d22\u4ea7\u548c\u884c\u4e3a\u7a0e\u7eb3\u7a0e\u7533\u62a5\u8868\u3011\u9875\u7b7e\u7684\u7a0e\u79cd\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"CcxwsImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (EmptyCheckUtils.isNotEmpty(collection)) {
            long orgId = Long.parseLong(importDataVo.getOrgId());
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            String taxauthority = resultMap.get("tcvat_nsrxx#1#taxauthority");
            QFilter taxauthorityFilter = new QFilter("taxauthority", "=", (Object)Long.parseLong(taxauthority));
            QFilter typeFilter = new QFilter("type", "=", (Object)"ccxws");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,billno,datatype", (QFilter[])new QFilter[]{orgFilter, taxauthorityFilter, typeFilter});
            List sbbid = dynamicObjects.stream().map(s -> s.getLong("id") + "").distinct().collect(Collectors.toList());
            QFilter sbbidFilter = new QFilter("sbbid", "in", sbbid);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(taxauthority))});
            String organname = importDataVo.getOrgName();
            String taxauthorityName = "";
            if (load != null && load.length > 0) {
                taxauthorityName = load[0].getString("name");
            }
            for (DynamicObject entity : collection) {
                QFilter sksssqFilter;
                String chineseTaxtype = entity.getString("taxtype");
                boolean isDimprovision = this.isDimprovision(orgId, chineseTaxtype, entity.getDate("startdate"), entity.getDate("enddate"));
                if (isDimprovision) {
                    return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"%s\u5df2\u542f\u7528\u5206\u7ef4\u5ea6\u8ba1\u63d0\uff0c\u8bf7\u901a\u8fc7\u91c7\u96c6\u7a0e\u6e90\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"CcxwsImportServiceImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), chineseTaxtype));
                }
                QFilter smFilter = new QFilter("sm", "=", (Object)entity.getString("sm"));
                DynamicObjectCollection hbCollect = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid", (QFilter[])new QFilter[]{sbbidFilter, smFilter, sksssqFilter = new QFilter("startdate", "=", (Object)entity.getDate("startdate")).and(new QFilter("enddate", "=", (Object)entity.getDate("enddate")))});
                if (CollectionUtils.isEmpty((Collection)hbCollect)) continue;
                List repeatSbbid = hbCollect.stream().map(s -> Long.parseLong(s.getString("sbbid"))).distinct().collect(Collectors.toList());
                List collect = dynamicObjects.stream().filter(s -> repeatSbbid.contains(s.getLong("id"))).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) continue;
                return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s\u81f3%3$s\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\u3010%5$s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\u3002", (String)"CcxwsImportServiceImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), organname, DateUtils.format(entity.getDate("startdate")), DateUtils.format(entity.getDate("enddate")), entity.get("taxtype"), ((DynamicObject)collect.get(0)).getString("billno")));
            }
        }
        return ValidDataResultVo.success();
    }

    @Override
    public DynamicObject queryReportExistsId(ImportDataVo vo) {
        return null;
    }

    private boolean isDimprovision(long orgId, String chineseTaxtype, Date startdate, Date enddate) {
        DynamicObjectCollection dynamicObjectCollection;
        Long baseTaxId = this.getBaseTaxId(chineseTaxtype);
        if (baseTaxId != null && EmptyCheckUtils.isNotEmpty(dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{orgId}), (Long)baseTaxId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)startdate, (Date)enddate).getData())) {
            DynamicObject object = (DynamicObject)dynamicObjectCollection.get(0);
            return object.getBoolean("ruleentity.rule.isdimprovision");
        }
        return false;
    }

    public Long getBaseTaxId(String chineseTaxtype) {
        for (Map.Entry<MultiLangEnumBridge, Long> entry : dimensionTaxTypes.entrySet()) {
            if (!entry.getKey().loadKDString().equals(chineseTaxtype.trim())) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        dimensionTaxTypes.put(new MultiLangEnumBridge("\u5370\u82b1\u7a0e", "CcxwsImportServiceImpl_0", "taxc-bdtaxr-common"), BaseTaxCategory.YHS);
        dimensionTaxTypes.put(new MultiLangEnumBridge("\u623f\u4ea7\u7a0e", "CcxwsImportServiceImpl_1", "taxc-bdtaxr-common"), BaseTaxCategory.FCS);
        dimensionTaxTypes.put(new MultiLangEnumBridge("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", "CcxwsImportServiceImpl_2", "taxc-bdtaxr-common"), BaseTaxCategory.CZTDSYS);
        dimensionTaxTypes.put(new MultiLangEnumBridge("\u73af\u5883\u4fdd\u62a4\u7a0e", "CcxwsImportServiceImpl_3", "taxc-bdtaxr-common"), BaseTaxCategory.HBS);
    }
}

