/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.util.finance.DeclareCheckFacility;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.lang3.ObjectUtils;

public class FinanceImportHandlerImpl
implements ImportExcelHandler {
    private static DynamicObject template = null;
    private static List<String> declareDate = new ArrayList<String>(16);

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        template = templateContent;
        HashSet<String> reportDates = new HashSet<String>();
        if ("FR0011".equalsIgnoreCase(templateContent.getString("number"))) {
            for (String string : declareDate) {
                if (ObjectUtils.isEmpty((Object)excelDataMap.get(string))) continue;
                reportDates.add(excelDataMap.get(string));
            }
            if (reportDates.size() != 1 && !ObjectUtils.isEmpty(reportDates)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u9001\u65e5\u671f\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u62a5\u9001\u65e5\u671f\u6b63\u786e\u6027\u3002", (String)"FinanceImportHandlerImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (reportDates.size() == 1) {
                String reportDate = "";
                Iterator iterator = reportDates.iterator();
                while (iterator.hasNext()) {
                    String date;
                    reportDate = date = (String)iterator.next();
                }
                String string = "^\\d{4}-\\d{2}-\\d{2}$";
                Pattern pattern = Pattern.compile(string);
                Matcher matcher = pattern.matcher(reportDate);
                boolean matches = matcher.matches();
                if (!matches) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u62a5\u9001\u65e5\u671f\u201d\u8bf7\u6539\u4e3aYYYY-MM-DD\u7684\u683c\u5f0f\u3002", (String)"FinanceImportHandlerImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
            }
        }
        return ValidDataResultVo.success();
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        String sbrq = resultMap.get("tcvat_nsrxx#1#sbrq");
        if (!ObjectUtils.isEmpty((Object)sbrq)) {
            resultMap.put("tcvat_nsrxx#1#declaretype", "0");
            resultMap.put("tcvat_nsrxx#1#sbrq", sbrq);
            resultMap.put("tcvat_nsrxx#1#declarer", String.valueOf(RequestContext.get().getCurrUserId()));
            resultMap.put("tcvat_nsrxx#1#declarestatus", "declared");
        } else {
            resultMap.put("tcvat_nsrxx#1#declarestatus", "editing");
        }
        String orgid = importDataVo.getOrgId();
        String orgName = importDataVo.getOrgName();
        Date startDate = importDataVo.getStartDate();
        Date endDate = importDataVo.getEndDate();
        if (!ObjectUtils.isEmpty((Object)template) && !ObjectUtils.isEmpty((Object)orgid)) {
            DeclareCheckFacility.checkAccountstandard(template.getString("number"), Long.parseLong(orgid));
            if (!ObjectUtils.isEmpty((Object)startDate) && !ObjectUtils.isEmpty((Object)endDate)) {
                DeclareCheckFacility.checkOrgAndDate(template, orgid, null, startDate, endDate);
                DeclareCheckFacility.queryExistsbb(Long.parseLong(orgid), orgName, startDate, endDate, template);
            }
        }
    }

    static {
        declareDate.add(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868#3#5", (String)"FinanceImportHandlerImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        declareDate.add(ResManager.loadKDString((String)"\u5229\u6da6\u8868#3#3", (String)"FinanceImportHandlerImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        declareDate.add(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868#3#3", (String)"FinanceImportHandlerImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        declareDate.add(ResManager.loadKDString((String)"\u6240\u6709\u8005\u6743\u76ca\u53d8\u52a8\u8868#3#12", (String)"FinanceImportHandlerImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }
}

