/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class LatqsImportServiceImpl
implements ImportExcelHandler {
    private static final String PRONUMBER = "tcret_tdzzs_base_tax#1#pronumber";

    @Override
    public String getBillNo(String id, String skssqz) {
        return DeclareServiceHelper.generateSBBNo("tcret_tdzzs_qssyxx");
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        String pronumber = resultMap.get(PRONUMBER);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tdm_tdzzs_clearing_unit", (String)"id,taxauthority", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)pronumber)});
        if (object != null) {
            resultMap.put("tcvat_nsrxx#1#taxsourcetype", "tdm_tdzzs_clearing_unit");
            resultMap.put("tcvat_nsrxx#1#taxsourceid", object.getString("id"));
        }
    }

    @Override
    public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        QFilter q3;
        QFilter q2;
        String pronumber = resultMap.get(PRONUMBER);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tdm_tdzzs_clearing_unit", (String)"id,taxauthority,status,enable,taxorg.number as orgnumber", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)pronumber)});
        if (object == null) {
            return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u7801\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"LatqsImportServiceImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), pronumber));
        }
        if (!"C".equals(object.getString("status")) || !"1".equals(object.getString("enable"))) {
            return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u3010%s\u3011\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\u3002", (String)"LatqsImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), pronumber));
        }
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(importDataVo.getOrgId()));
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,datatype,sbbid", (QFilter[])new QFilter[]{q1, q2 = new QFilter("type", "=", (Object)"latqs"), q3 = new QFilter("taxsourceid.number", "=", (Object)pronumber)});
        if (nsrxx != null && nsrxx.getLong("sbbid") != 0L) {
            return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u7684\u7a0e\u6e90\u8868\u88ab\u7533\u62a5\u8868\u9501\u5b9a\uff0c\u4e0d\u53ef\u91cd\u65b0\u5f15\u5165\u3002", (String)"LatqsImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), importDataVo.getOrgName(), pronumber));
        }
        return ValidDataResultVo.success();
    }

    @Override
    public DynamicObject queryReportExistsId(ImportDataVo vo) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(vo.getOrgId()));
        QFilter q2 = new QFilter("type", "=", (Object)vo.getTemplateTypeId());
        QFilter q3 = new QFilter("taxsourceid.number", "=", (Object)vo.getResultMap().get(PRONUMBER));
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,datatype", (QFilter[])new QFilter[]{q1, q2, q3});
    }
}

