/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.refactor.declare.helper.QtsftysbbDeclareHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class QtsftysbbImportServiceImpl
implements ImportExcelHandler {
    private static final String QTSF_HNTYSBB = "QTSF_HNTYSBB";
    public static final Map<String, String> zspmAndzsxmMap = new HashMap<String, String>(){
        {
            this.put(ResManager.loadKDString((String)"\u5de5\u4f1a\u7ecf\u8d39", (String)"QtsftysbbImportServiceImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6\u6536\u5165", (String)"QtsftysbbImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put(ResManager.loadKDString((String)"\u5de5\u4f1a\u7b79\u5907\u91d1", (String)"QtsftysbbImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6\u6536\u5165", (String)"QtsftysbbImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put(ResManager.loadKDString((String)"\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"QtsftysbbImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u4e13\u9879\u6536\u5165", (String)"QtsftysbbImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put(ResManager.loadKDString((String)"\u5824\u56f4\u9632\u62a4\u8d39", (String)"QtsftysbbImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u4e13\u9879\u6536\u5165", (String)"QtsftysbbImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    };

    @Override
    public String getBillNo(String id, String month) {
        return DeclareServiceHelper.generateSBBNo("totf_tysb_declare_main");
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        ValidDataResultVo validDataResultVo = ValidDataResultVo.success();
        if ("QTSF_TYSBB".equals(templateContent.getString("number")) && !ResManager.loadKDString((String)"\u901a\u7528\u7533\u62a5\u8868\uff08\u7a0e\u53ca\u9644\u5f81\u7a0e\u8d39\uff09", (String)"QtsftysbbImportServiceImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(excelDataMap.get(QtsftysbbImportServiceImpl.getSheetName1()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4sheet\u9875\u540d\u79f0\u4e3a\u201c\u4e3b\u8868\u201d\u4e14\u8868\u5934\u4e3a\u201c\u901a\u7528\u7533\u62a5\u8868\uff08\u7a0e\u53ca\u9644\u5f81\u7a0e\u8d39\uff09\u201d", (String)"QtsftysbbImportServiceImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        return validDataResultVo;
    }

    @Override
    public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        if (StringUtils.isEmpty((CharSequence)importDataVo.getOrgId())) {
            return ValidDataResultVo.success();
        }
        QtsftysbbDeclareHelper.checkDate(importDataVo, template);
        QtsftysbbDeclareHelper.checkTemplate(importDataVo, template);
        QtsftysbbDeclareHelper.checkDynRowImportData(resultMap, Long.parseLong(importDataVo.getOrgId()), zspmAndzsxmMap);
        BaseResult<Object> result = QtsftysbbDeclareHelper.checkZeroDeclareValues(resultMap, false);
        if (!BaseResult.OK.equals(result.getCode())) {
            return ValidDataResultVo.fail(result.getMessage());
        }
        return ValidDataResultVo.success();
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        Date startDate = null;
        Date endDate = null;
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("#");
            if (key.contains("totf_sjfzsf_dtb") && key.contains("startdate")) {
                Date startDateTepm = QtsftysbbDeclareHelper.formatDateStr(entry.getValue(), ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77", (String)"QtsftysbbImportServiceImpl_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                Date date = startDate = startDate == null || startDate != null && startDateTepm != null && startDate.compareTo(startDateTepm) > 0 ? startDateTepm : startDate;
            }
            if (key.contains("totf_sjfzsf_dtb") && key.contains("enddate")) {
                Date endDateTepm = QtsftysbbDeclareHelper.formatDateStr(entry.getValue(), ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u6b62", (String)"QtsftysbbImportServiceImpl_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                Date date = endDate = endDate == null || endDate != null && endDateTepm != null && endDate.compareTo(endDateTepm) < 0 ? endDateTepm : endDate;
            }
            if (split.length != 3 || !"zszm".equals(split[2])) continue;
            String zszm = resultMap.get("totf_sjfzsf_dtb#".concat(split[1]).concat("#zszm"));
            String zspm = resultMap.get("totf_sjfzsf_dtb#".concat(split[1]).concat("#zspm"));
            if (ZspmEnum.DFSLJSJJ.getName().equals(zspm) || !StringUtil.isNotBlank((CharSequence)zszm)) continue;
            resultMap.put("totf_sjfzsf_dtb#".concat(split[1]).concat("#zszm"), "");
        }
        importDataVo.setStartDate(startDate);
        resultMap.put("tcvat_nsrxx#1#skssqq", DateUtils.format(startDate));
        importDataVo.setEndDate(endDate);
        resultMap.put("tcvat_nsrxx#1#skssqz", DateUtils.format(endDate));
    }

    private static String getSheetName1() {
        return ResManager.loadKDString((String)"\u4e3b\u8868#0#0", (String)"QtsftysbbImportServiceImpl_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    @Override
    public DynamicObject queryReportExistsId(ImportDataVo vo) {
        return null;
    }
}

