/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.collections.CollectionUtils;

public class SzysAImportServiceImpl
implements ImportExcelHandler {
    private static final String TCWAT_DECLARE_QUERY = "tcwat_declare_query";

    @Override
    public String getBillNo(String id, String skssqz) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCWAT_DECLARE_QUERY);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber(TCWAT_DECLARE_QUERY, dynamicObject, null);
        return codeRuleService.readNumber(TCWAT_DECLARE_QUERY, dynamicObject, null);
    }

    @Override
    public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        String orgId = importDataVo.getOrgId();
        if (template != null && StringUtils.isNotEmpty((CharSequence)orgId)) {
            String number;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)template.getLong("id"), (String)"bdtaxr_template_main");
            String conditionjson = dynamicObject.getString("conditionjson");
            if (StringUtils.isNotEmpty((CharSequence)conditionjson)) {
                QFilter orgQfilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgId));
                QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
                QFilter qFilter4 = FilterBuilderUtils.buildFilter(conditionjson, "tctb_tax_main_form");
                TemplateUtils.dealAddress(qFilter4);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id", (QFilter[])new QFilter[]{qFilter4, orgQfilter, taxationsys});
                if (CollectionUtils.isEmpty((Collection)query)) {
                    return ValidDataResultVo.fail(ResManager.loadKDString((String)"\u5f15\u5165\u7533\u62a5\u6570\u636e\u4e2d\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5728\u7533\u62a5\u6a21\u677f\u7684\u9002\u7528\u5730\u533a\u8303\u56f4\u5185", (String)"SzysAImportServiceImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
            }
            if ("henan_declareA".equals(number = dynamicObject.getString("number"))) {
                TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
                String sysedc = resultMap.get("tcwat_declare_a_base#1#sysedc");
                if (taxResult.isSuccess()) {
                    String longnumber = ((DynamicObject)taxResult.getData()).getString("taxoffice.longnumber");
                    List<String> hnList = Arrays.asList("1", "2", "4");
                    String name = this.getSysedcZh(sysedc);
                    if (longnumber.startsWith("14100000000") && !hnList.contains(sysedc)) {
                        return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u989d\u7b49\u6b21\u3010%s\u3011\u4e0d\u9002\u7528\u4e8e\u6cb3\u5357\u7701\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SzysAImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), name));
                    }
                    if (longnumber.startsWith("13700000000") && !"6".equals(sysedc)) {
                        return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u989d\u7b49\u6b21\u3010%s\u3011\u4e0d\u9002\u7528\u4e8e\u5c71\u4e1c\u7701\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SzysAImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), name));
                    }
                }
            }
        }
        return ValidDataResultVo.success();
    }

    private String getSysedcZh(String sysedc) {
        if (sysedc == null) {
            return "";
        }
        switch (sysedc) {
            case "1": {
                return ResManager.loadKDString((String)"\u8bbe\u533a\u7684\u5e02", (String)"SzysAImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u53bf\u7ea7\u57ce\u5e02\u53ca\u4ee5\u4e0b", (String)"SzysAImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u7701\u8f96\u5e02", (String)"SzysAImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u989d\u6807\u51c6", (String)"SzysAImportServiceImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Override
    public DynamicObject queryReportExistsId(ImportDataVo vo) {
        return TemplateUtils.queryReportExists(vo.getOrgId(), vo.getTemplateTypeId(), vo.getStartDate(), vo.getEndDate(), vo.getTaxauthority(), vo.getBusinessno());
    }
}

