/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TcvvtTrasProductProjectUnit;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.declare.impl.AbstractTrasStaffImportHandlerImpl;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class TrasStaffImportHandlerMonthImpl
extends AbstractTrasStaffImportHandlerImpl {
    public boolean noproducts = false;

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        super.initImportData(importDataVo, resultMap);
        String startDate = DateUtils.format(importDataVo.getStartDate(), "yyyy-MM-dd");
        Date sssqq = this.formatDateStr(startDate);
        int yearOfDate = DateUtils.getYearOfDate(sssqq);
        Date xxyyearOfDate = DateUtils.addMonth(sssqq, 2);
        int xxyyear = DateUtils.getYearOfDate(xxyyearOfDate);
        StringBuilder s = new StringBuilder();
        StringBuilder surveyZbycMouth = new StringBuilder();
        StringBuilder surveyZxybycMouth = new StringBuilder();
        int monthOfDateStart = DateUtils.getMonthOfDate(sssqq);
        if (monthOfDateStart < 10) {
            s.append(0).append(monthOfDateStart);
            if (monthOfDateStart + 1 < 10) {
                surveyZbycMouth.append(0).append(monthOfDateStart + 1);
            } else {
                surveyZbycMouth.append(monthOfDateStart + 1);
            }
        } else {
            s.append(monthOfDateStart);
            surveyZbycMouth.append(monthOfDateStart + 1);
        }
        if (monthOfDateStart < 10) {
            if (monthOfDateStart + 2 < 10) {
                surveyZxybycMouth.append(0).append(monthOfDateStart + 2);
            } else {
                surveyZxybycMouth.append(monthOfDateStart + 2);
            }
        } else if (monthOfDateStart + 2 > 12) {
            surveyZxybycMouth.append(0).append(monthOfDateStart + 2 - 12);
        } else {
            surveyZxybycMouth.append(monthOfDateStart + 2);
        }
        String year = String.format(ResManager.loadKDString((String)"\u5e74(01-", (String)"TrasStaffImportHandlerMonthImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        String month = String.format(ResManager.loadKDString((String)"\u6708\u7d2f\u8ba1)", (String)"TrasStaffImportHandlerMonthImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        StringBuilder sb = new StringBuilder(String.valueOf(yearOfDate)).append(year).append((CharSequence)s).append(month);
        StringBuilder sp = new StringBuilder(String.valueOf(yearOfDate - 1)).append(year).append((CharSequence)s).append(month);
        String year1 = String.format(ResManager.loadKDString((String)"\u5e74", (String)"TrasStaffImportHandlerMonthImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        String monthend = String.format(ResManager.loadKDString((String)"\u6708\u671f\u672b", (String)"TrasStaffImportHandlerMonthImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        resultMap.put("tcvvt_tras_attached#1#bnyljmc", sb.toString());
        resultMap.put("tcvvt_tras_attached#1#snyljmc", sp.toString());
        StringBuilder yearup = new StringBuilder(String.valueOf(yearOfDate)).append(year1);
        StringBuilder yeardowm = new StringBuilder(String.valueOf(yearOfDate - 1)).append(year1);
        StringBuilder monthend1 = new StringBuilder(s).append(monthend);
        resultMap.put("tcvvt_tras_attached#1#bnmc", yearup.toString());
        resultMap.put("tcvvt_tras_attached#1#snmc", yeardowm.toString());
        resultMap.put("tcvvt_tras_attached#1#yqmmc", monthend1.toString());
        String y = String.format(ResManager.loadKDString((String)"\u6708", (String)"TrasStaffImportHandlerMonthImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        String yc = String.format(ResManager.loadKDString((String)"\u9884\u6d4b", (String)"TrasStaffImportHandlerMonthImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        String sjwc = String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210", (String)"TrasStaffImportHandlerMonthImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        String qnyc = String.format(ResManager.loadKDString((String)"\u5168\u5e74\u9884\u6d4b", (String)"TrasStaffImportHandlerMonthImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        String qnsj = String.format(ResManager.loadKDString((String)"\u5168\u5e74\u5b9e\u9645", (String)"TrasStaffImportHandlerMonthImpl_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
        resultMap.put("tcvvt_tras_attached#1#tbnyycmc", String.valueOf(yearOfDate) + year1 + surveyZbycMouth + y + yc);
        resultMap.put("tcvvt_tras_attached#1#tbsnysjwcmc", String.valueOf(yearOfDate - 1) + year1 + surveyZbycMouth + y + sjwc);
        resultMap.put("tcvvt_tras_attached#1#tbnqnycmc", String.valueOf(yearOfDate) + year1 + qnyc);
        resultMap.put("tcvvt_tras_attached#1#tbsnqnsjmc", String.valueOf(yearOfDate - 1) + year1 + qnsj);
        resultMap.put("tcvvt_tras_attached#1#tbnyxyycmc", String.valueOf(xxyyear) + year1 + surveyZxybycMouth + y + yc);
        resultMap.put("tcvvt_tras_attached#1#tbsnyxysjwcmc", String.valueOf(xxyyear - 1) + year1 + surveyZxybycMouth + y + sjwc);
        resultMap.put("tcvvt_tras_attached#1#tbnxyqnycmc", String.valueOf(xxyyear) + year1 + qnyc);
        resultMap.put("tcvvt_tras_attached#1#tbsnxyqnsjmc", String.valueOf(xxyyear - 1) + year1 + qnsj);
        HashMap objectObjectHashMap = new HashMap();
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String[] split;
            String row;
            String string = entry.getKey();
            if (!string.startsWith("tcvvt_product") || "1".equalsIgnoreCase(row = (split = string.split("#"))[1])) continue;
            Set productRowKey = objectObjectHashMap.containsKey(row) ? (Set)objectObjectHashMap.get(row) : new HashSet();
            productRowKey.add(string);
            objectObjectHashMap.put(row, productRowKey);
        }
        HashMap<String, String> projectuniMap = new HashMap<String, String>(512);
        for (TcvvtTrasProductProjectUnit value : TcvvtTrasProductProjectUnit.values()) {
            projectuniMap.put(String.valueOf(value.getId()), value.getUnit().getDescription());
        }
        if (this.noproducts && ObjectUtils.isEmpty(objectObjectHashMap) && yearOfDate >= 2024) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f15\u5165\u6b63\u786e\u7684\u4ea7\u54c1\u540d\u79f0\u3002", (String)"TrasStaffImportHandlerMonthImpl_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        for (Map.Entry entry : objectObjectHashMap.entrySet()) {
            String cpmc = "tcvvt_product#" + (String)entry.getKey() + "#cpmc";
            String unit = "tcvvt_product#" + (String)entry.getKey() + "#unit";
            if (!((Set)entry.getValue()).contains(cpmc)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f15\u5165\u6b63\u786e\u7684\u4ea7\u54c1\u540d\u79f0\u3002", (String)"TrasStaffImportHandlerMonthImpl_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object)resultMap.get(cpmc))) continue;
            String cpmcId = resultMap.get(cpmc);
            resultMap.put(unit, (String)projectuniMap.get(cpmcId));
        }
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        String orgName = excelDataMap.get(TrasStaffImportHandlerMonthImpl.getSheetName1());
        if (!ObjectUtils.isEmpty((Object)orgName)) {
            excelDataMap.put("originOrgName", orgName);
            TaxResult dyo = TaxcOrgDataServiceHelper.queryTaxcOrgByTaxpayer((String)orgName);
            if (!ObjectUtils.isEmpty((Object)dyo) && !ObjectUtils.isEmpty((Object)dyo.getData())) {
                excelDataMap.put(TrasStaffImportHandlerMonthImpl.getSheetName1(), ((DynamicObject)dyo.getData()).getString("org.name"));
            }
        }
        String s = excelDataMap.get(ResManager.loadKDString((String)"B2\u4ea7\u54c1\u8868#8#0", (String)"TrasStaffImportHandlerMonthImpl_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        if (!ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TrasStaffImportHandlerMonthImpl_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equalsIgnoreCase(s)) {
            this.noproducts = true;
        }
        return super.validExcelData(excelDataMap, templateContent);
    }

    private static String getSheetName1() {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8868#13#4", (String)"TrasStaffImportHandlerMonthImpl_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }
}

