/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.old;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.CommonInfoUtil;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.JobUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxDeclareQueryListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(TaxDeclareQueryListPlugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String ITEM_KEY = "itemKey";
    private static final String BILL_LIST = "billlistap";
    private static final String DIRECT_DECLARE = "directdeclare";
    private static final String DIRECT_PAY = "fastpay";
    private static final String VIEWLOG_KEY = "viewlog";
    private static final String DEFER_PAY_KEY = "applydeferpay";
    private static final String APPLY = "apply";
    private static final String CANCELAPPLY = "cancelapply";
    private static final String PAY = "pay";
    private static final String CANCELPAY = "cancelpay";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        List<String> list = this.getTemplateTypeList();
        if (!CollectionUtils.isEmpty(list)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DIRECT_DECLARE});
            this.getView().setVisible(Boolean.FALSE, new String[]{DIRECT_PAY});
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEWLOG_KEY});
            QFilter qFilter = new QFilter("type", "in", list);
            billlist.setFilter(qFilter);
            billlist.setOrderBy("id desc,entryentity.taxtypes asc");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn typeColumn;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        List<String> templates = this.getTemplateTypeList();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(templates.size());
        for (String template : templates) {
            ComboItem item = new ComboItem();
            item.setValue(template);
            item.setCaption(new LocaleString(TemplateTypeConstant.getNsrtypemap().get(template)));
            combos.add(item);
        }
        for (FilterColumn column : filterColumnList) {
            String nolimit;
            if (!"type".equals(column.getFieldName())) continue;
            typeColumn = (CommonFilterColumn)column;
            String querytype = (String)customParams.get("querytype");
            if (!StringUtils.isEmpty((CharSequence)querytype)) {
                typeColumn.setDefaultValue(querytype);
            }
            if ("false".equals(nolimit = (String)customParams.get("nolimit"))) {
                typeColumn.setMustInput(true);
            }
            typeColumn.setComboItems(combos);
        }
        for (FilterColumn column : schemeColumnList) {
            if (!"type".equals(column.getFieldName())) continue;
            typeColumn = (SchemeFilterColumn)column;
            typeColumn.setComboItems(combos);
            break;
        }
        QFilter typeFilter = new QFilter("type", "in", templates);
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        billlist.setFilter(typeFilter);
        billlist.getQueryFilterParameter().setOrderBy("id desc");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("skssqq");
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                this.getPageCache().put("skssqq", SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        for (QFilter eQFilter : e.getQFilters()) {
            for (QFilter filter : eQFilter.recombine()) {
                if ("skssqq".equals(filter.getProperty())) {
                    if ("<".equals(filter.getCP())) {
                        resultFilter.add(new QFilter("skssqz", "<", filter.getValue()));
                        continue;
                    }
                    resultFilter.add(filter);
                    continue;
                }
                resultFilter.add(filter);
            }
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(resultFilter);
    }

    /*
     * WARNING - void declaration
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        block142: {
            String appId = this.getView().getFormShowParameter().getAppId();
            if ("new".equals(evt.getOperateKey())) {
                ControlFilter typeFilter = (ControlFilter)this.getControlFilters().getFilters().get("type");
                String type = typeFilter == null || CollectionUtils.isEmpty((Collection)typeFilter.getValue()) || StringUtil.isEmpty((CharSequence)typeFilter.getValue().get(0).toString()) ? Optional.ofNullable(this.getView().getFormShowParameter().getCustomParams()).map(s -> (String)s.get("querytype")).orElseGet(() -> {
                    List<String> templateTypeList = this.getTemplateTypeList();
                    return templateTypeList.get(0);
                }) : (String)typeFilter.getValue().get(0);
                if ("fjsf".equals(type)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u636e\u653f\u7b56\uff0c\u9644\u52a0\u7a0e\u8d39\u4e0d\u518d\u5355\u72ec\u7533\u62a5\u3002", (String)"TaxDeclareQueryListPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> custom = new HashMap<String, Object>(16);
                custom.put("type", type);
                this.showDeclarePage(type, custom, null);
            } else {
                if ("export".equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                    if (collect.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa\u3002", (String)"TaxDeclareQueryListPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    String pk = list.get(0).getPrimaryKeyValue().toString();
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"tcvat_nsrxx");
                    DynamicObject org = obj.getDynamicObject("org");
                    String string = obj.getString("type");
                    String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(string, string) + "_";
                    if (org != null) {
                        fileName = fileName + org.getString("name");
                    }
                    Date date = (Date)obj.get("skssqq");
                    String orgid = obj.getString("org.id");
                    DynamicObject template = null;
                    String templateid = obj.getString("templateid");
                    if (StringUtils.isNotEmpty((CharSequence)templateid)) {
                        template = TemplateUtilsOld.getTemplateObjectById(string, templateid);
                    }
                    if (template == null) {
                        template = TemplateUtilsOld.getTemplateObjectByConfig(string, orgid, date, date);
                    }
                    if (template == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"TaxDeclareQueryListPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    fileName = fileName + DateUtils.format(date, "yyyy-MM");
                    Map<String, String> valMap = TemplateShowUtils.queryData(string, pk, "_");
                    try (InputStream in = TemplateShowUtils.getDownResultExcelFile(template, valMap);){
                        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", in, 5000);
                        String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
                        String entityNum = ((IListView)this.getView()).getBillFormId();
                        PermissionUtils.putTempFilePermissionCache(urls, serviceAppId, entityNum, "4730fc9f000004ae");
                        this.getView().openUrl(urls);
                        break block142;
                    }
                    catch (IOException e2) {
                        throw new KDBizException((Throwable)e2, new ErrorCode("", e2.toString()), new Object[0]);
                    }
                }
                if (APPLY.equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    List successPkIds = evt.getOperationResult().getSuccessPkIds();
                    if (!evt.getOperationResult().isSuccess() && successPkIds.isEmpty()) {
                        return;
                    }
                    List pklist = successPkIds.isEmpty() ? list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList()) : successPkIds;
                    StringBuilder message = new StringBuilder();
                    StringBuilder fzybhzMessage = new StringBuilder();
                    Object[] objectArray = pklist.toArray();
                    DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)objectArray)});
                    if (declares != null && declares.length > 0) {
                        ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                        for (DynamicObject declare : declares) {
                            DynamicObject org = declare.getDynamicObject("org");
                            String type = declare.getString("type");
                            String typeName = TemplateTypeConstant.getNsrtypemap().get(type);
                            String skssqq = DateUtils.format(declare.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE);
                            String skssqz = DateUtils.format(declare.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE);
                            String billStatus = declare.getString("billstatus");
                            OrgUtils.getfzybqyMessage(type, org.getString("id"), DateUtils.format(declare.getDate("skssqq")), DateUtils.format(declare.getDate("skssqz")), fzybhzMessage);
                            if (!"C".equals(billStatus)) {
                                message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u786e\u8ba4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                            if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
                                declare.set("paystatus", (Object)"nopay");
                            }
                            declare.set("declarestatus", (Object)"declared");
                            declare.set("modifytime", (Object)new Date());
                            declare.set("modifier", (Object)RequestContext.get().getUserId());
                            declare.set("declaretype", (Object)"0");
                            declare.set("sbrq", (Object)new Date());
                            declare.set("declarer", (Object)RequestContext.get().getUserId());
                            modifyDynamicObjects.add(declare);
                        }
                        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                            String[] messages = message.toString().split(System.getProperty("line.separator"));
                            if (messages.length == 1) {
                                this.getView().showErrorNotification(message.toString());
                            } else {
                                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                                OperationResult operationResult = new OperationResult();
                                operationResult.setSuccess(false);
                                operationResult.setMessage(message.toString());
                                this.getView().showOperationResult(operationResult);
                            }
                            return;
                        }
                        if (StringUtils.isNotBlank((CharSequence)fzybhzMessage.toString())) {
                            this.getView().showConfirm(fzybhzMessage.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(APPLY, (IFormPlugin)this));
                            return;
                        }
                        if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                            List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                            SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                            billlist.refresh();
                            this.calcElement(modifyDynamicObjects, APPLY);
                        }
                    }
                } else if (CANCELAPPLY.equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    List successPkIds = evt.getOperationResult().getSuccessPkIds();
                    if (!evt.getOperationResult().isSuccess() && successPkIds.isEmpty()) {
                        return;
                    }
                    List pklist = successPkIds.isEmpty() ? list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList()) : successPkIds;
                    StringBuilder message = new StringBuilder();
                    Object[] pkIds = pklist.toArray();
                    DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)(DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING + ",entryentity.deferpayapply1"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
                    if (dynamicObjectArray != null && dynamicObjectArray.length > 0) {
                        ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(dynamicObjectArray.length);
                        for (DynamicObject declare : dynamicObjectArray) {
                            boolean deferpayapply;
                            DynamicObject org = declare.getDynamicObject("org");
                            String type = declare.getString("type");
                            String typeName = TemplateTypeConstant.getNsrtypemap().get(type);
                            String declareType = declare.getString("declaretype");
                            String skssqq = DateUtils.format(declare.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE);
                            String skssqz = DateUtils.format(declare.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE);
                            String billStatus = declare.getString("billstatus");
                            if (!"C".equals(billStatus)) {
                                message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if ("tcvat".equals(appId)) {
                                DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
                                deferpayapply = entryentity.stream().anyMatch(e -> e.getBoolean("deferpayapply1"));
                            } else {
                                deferpayapply = declare.getBoolean("deferpayapply");
                            }
                            if (!"payfailed".equals(declare.getString("paystatus")) && !"unpaid".equals(declare.getString("paystatus")) && !"nopay".equals(declare.getString("paystatus")) && !StringUtils.isBlank((CharSequence)declare.getString("paystatus")) || deferpayapply) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u3001\u7f34\u6b3e\u5931\u8d25\u3001\u65e0\u9700\u7f34\u6b3e\u6216\u672a\u7533\u8bf7\u7f13\u7f34\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName));
                                continue;
                            }
                            if (!"declared".equals(declare.getString("declarestatus"))) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u53ef\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (!"0".equals(declareType)) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u65b9\u5f0f\u4e3a\u624b\u5de5\u7533\u62a5\u53ef\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)"1");
                            QFilter sbbidfilter = new QFilter("sbbid", "=", (Object)String.valueOf(declare.getLong("id")));
                            boolean exists = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidfilter, voucherFilter});
                            if (exists) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u751f\u6210\u51ed\u8bc1\u7684\u6570\u636e\u53ef\u8fdb\u884c\u53d6\u6d88\u7533\u62a5\u64cd\u4f5c: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            declare.set("declarestatus", (Object)"editing");
                            declare.set("paystatus", (Object)"unpaid");
                            declare.set("modifytime", (Object)new Date());
                            declare.set("modifier", (Object)RequestContext.get().getUserId());
                            declare.set("declaretype", (Object)"");
                            declare.set("paytype", (Object)"");
                            declare.set("sbrq", null);
                            declare.set("paydate", null);
                            declare.set("payer", (Object)0L);
                            declare.set("declarer", (Object)0L);
                            modifyDynamicObjects.add(declare);
                        }
                        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                            String[] messages = message.toString().split(System.getProperty("line.separator"));
                            if (messages.length == 1) {
                                this.getView().showErrorNotification(message.toString());
                            } else {
                                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                                OperationResult operationResult = new OperationResult();
                                operationResult.setSuccess(false);
                                operationResult.setMessage(message.toString());
                                this.getView().showOperationResult(operationResult);
                            }
                        }
                        if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                            List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelDeclare", (Object[])new Object[]{sbbIds});
                            SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                            billlist.refresh();
                        }
                    }
                } else if (PAY.equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    List successPkIds = evt.getOperationResult().getSuccessPkIds();
                    if (!evt.getOperationResult().isSuccess() && successPkIds.isEmpty()) {
                        return;
                    }
                    List pklist = successPkIds.isEmpty() ? list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList()) : successPkIds;
                    Object[] pkIds = pklist.toArray();
                    StringBuilder message = new StringBuilder();
                    StringBuilder stringBuilder = new StringBuilder();
                    DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)(DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING + ",entryentity.deferpayapply1"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
                    if (declares != null && declares.length > 0) {
                        for (DynamicObject declare : declares) {
                            boolean deferpayapply;
                            DynamicObject org = declare.getDynamicObject("org");
                            String type = declare.getString("type");
                            String typeName = TemplateTypeConstant.getNsrtypemap().get(type);
                            String payStatus = declare.getString("paystatus");
                            String skssqq = DateUtils.format(declare.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE);
                            String skssqz = DateUtils.format(declare.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE);
                            String billStatus = declare.getString("billstatus");
                            OrgUtils.getfzybqyMessage(type, org.getString("id"), DateUtils.format(declare.getDate("skssqq")), DateUtils.format(declare.getDate("skssqz")), stringBuilder);
                            if (!"C".equals(billStatus)) {
                                message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (!"declared".equals(declare.getString("declarestatus"))) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u786e\u8ba4\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (!("payfailed".equals(payStatus) || "unpaid".equals(payStatus) || StringUtils.isBlank((CharSequence)declare.getString("paystatus")))) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u3001\u7f34\u6b3e\u5931\u8d25\u7684\u6570\u636e\u53ef\u786e\u8ba4\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if ("tcvat".equals(appId)) {
                                DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
                                deferpayapply = entryentity.stream().anyMatch(e -> e.getBoolean("deferpayapply1"));
                            } else {
                                deferpayapply = declare.getBoolean("deferpayapply");
                            }
                            if (!deferpayapply) continue;
                            message.append(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u8bb0\u5f55\u5df2\u7533\u8bf7\u7f13\u7f34\uff0c\u8bf7\u5230\u7f13\u7f34\u7533\u8bf7\u67e5\u8be2\u754c\u9762\u64cd\u4f5c: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        }
                        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                            String[] messages = message.toString().split(System.getProperty("line.separator"));
                            if (messages.length == 1) {
                                this.getView().showErrorNotification(message.toString());
                            } else {
                                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                                OperationResult operationResult = new OperationResult();
                                operationResult.setSuccess(false);
                                operationResult.setMessage(message.toString());
                                this.getView().showOperationResult(operationResult);
                            }
                            return;
                        }
                        if (StringUtils.isNotBlank((CharSequence)stringBuilder.toString())) {
                            this.getView().showConfirm(stringBuilder.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(PAY, (IFormPlugin)this));
                            return;
                        }
                        FormShowParameter param = new FormShowParameter();
                        param.setFormId("bdtaxr_paydate_confirm");
                        param.getOpenStyle().setShowType(ShowType.NonModal);
                        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
                        param.setCloseCallBack(closeCallBack);
                        this.getView().showForm(param);
                    }
                } else if (CANCELPAY.equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    List successPkIds = evt.getOperationResult().getSuccessPkIds();
                    if (!evt.getOperationResult().isSuccess() && successPkIds.isEmpty()) {
                        return;
                    }
                    List pklist = successPkIds.isEmpty() ? list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList()) : successPkIds;
                    StringBuilder message = new StringBuilder();
                    Object[] pkIds = pklist.toArray();
                    DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)(DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING + ",entryentity.deferpayapply1"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
                    if (dynamicObjectArray != null && dynamicObjectArray.length > 0) {
                        ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(dynamicObjectArray.length);
                        for (DynamicObject declare : dynamicObjectArray) {
                            boolean deferpayapply;
                            DynamicObject org = declare.getDynamicObject("org");
                            String type = declare.getString("type");
                            String typeName = TemplateTypeConstant.getNsrtypemap().get(type);
                            String payType = declare.getString("paytype");
                            String skssqq = DateUtils.format(declare.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE);
                            String skssqz = DateUtils.format(declare.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE);
                            String billStatus = declare.getString("billstatus");
                            if (!"C".equals(billStatus)) {
                                message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (!"paid".equals(declare.getString("paystatus"))) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u6210\u529f\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if ("tcvat".equals(appId)) {
                                DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
                                deferpayapply = entryentity.stream().anyMatch(e -> e.getBoolean("deferpayapply1"));
                            } else {
                                deferpayapply = declare.getBoolean("deferpayapply");
                            }
                            if (deferpayapply) {
                                message.append(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u8bb0\u5f55\u5df2\u7533\u8bf7\u7f13\u7f34\uff0c\u8bf7\u5230\u7f13\u7f34\u7533\u8bf7\u67e5\u8be2\u754c\u9762\u64cd\u4f5c: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (!"0".equals(payType)) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u65b9\u5f0f\u4e3a\u624b\u5de5\u7f34\u6b3e\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            declare.set("paystatus", (Object)"unpaid");
                            declare.set("modifytime", (Object)new Date());
                            declare.set("modifier", (Object)RequestContext.get().getUserId());
                            declare.set("paytype", (Object)"");
                            declare.set("paydate", null);
                            declare.set("payer", (Object)0L);
                            modifyDynamicObjects.add(declare);
                        }
                        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                            String[] messages = message.toString().split(System.getProperty("line.separator"));
                            if (messages.length == 1) {
                                this.getView().showErrorNotification(message.toString());
                            } else {
                                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                                OperationResult operationResult = new OperationResult();
                                operationResult.setSuccess(false);
                                operationResult.setMessage(message.toString());
                                this.getView().showOperationResult(operationResult);
                            }
                        }
                        if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                            for (DynamicObject dynamicObject : modifyDynamicObjects) {
                                if (null == TaxDeclareQueryListPlugin.getPayDate(dynamicObject)) continue;
                                this.getPageCache().put(dynamicObject.getString("id"), TaxDeclareQueryListPlugin.getPayDate(dynamicObject).toString());
                            }
                            List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelPay", (Object[])new Object[]{sbbIds});
                            SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                            billlist.refresh();
                            this.calcElement(modifyDynamicObjects, CANCELPAY);
                        }
                    }
                } else if ("import".equals(evt.getOperateKey())) {
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setFormId("bdtaxr_declare_import");
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
                    parameter.setCustomParam("source", (Object)"declare");
                    parameter.setCustomParam("templatetypelist", this.getTemplateTypeList());
                    this.getView().showForm(parameter);
                } else if ("submit".equals(evt.getOperateKey()) || "unsubmit".equals(evt.getOperateKey()) || "audit".equals(evt.getOperateKey()) || "unaudit".equals(evt.getOperateKey())) {
                    List<Object> successPkIds = evt.getOperationResult().getSuccessPkIds();
                    if (evt.getOperationResult().isSuccess() || !successPkIds.isEmpty()) {
                        BillList billlist = (BillList)this.getControl(BILL_LIST);
                        ListSelectedRowCollection list = billlist.getSelectedRows();
                        if (list == null || list.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                            return;
                        }
                        List<Object> pklist = successPkIds.isEmpty() ? list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList()) : successPkIds;
                        DeclareUtils.submit(this.getView(), pklist, evt.getOperateKey(), "tcvat_nsrxx", true);
                        billlist.refresh();
                    }
                } else if ("viewflowchart".equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                    if (collect.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u3002", (String)"TaxDeclareQueryListPlugin_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    OpenStyle openStyle = new OpenStyle();
                    openStyle.setShowType(ShowType.MainNewTabPage);
                    try {
                        WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
                    }
                    catch (Exception e3) {
                        LOGGER.error(ThrowableHelper.toString(e3));
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"TaxDeclareQueryListPlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                } else if (VIEWLOG_KEY.equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                    if (collect.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u65e5\u5fd7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxDeclareQueryListPlugin_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    Object pkId = list.get(0).getPrimaryKeyValue();
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tcvat_nsrxx");
                    if (declare != null) {
                        HashMap<String, Object> customerParams = new HashMap<String, Object>();
                        String string = declare.getDynamicObject("org").getString("id");
                        String type = declare.getString("type");
                        ArrayList<String> skssq = new ArrayList<String>();
                        skssq.add(DateUtils.format(declare.getDate("skssqq"), "yyyy-MM-dd"));
                        skssq.add(DateUtils.format(declare.getDate("skssqz"), "yyyy-MM-dd"));
                        customerParams.put("org", string);
                        customerParams.put("types", type);
                        customerParams.put("skssqq", skssq);
                        OpenStyle openStyle = new OpenStyle();
                        openStyle.setShowType(ShowType.MainNewTabPage);
                        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tsate_declare_record", (boolean)false, (int)0, (boolean)false);
                        showParameter.setOpenStyle(openStyle);
                        showParameter.setCustomParams(customerParams);
                        this.getView().showForm((FormShowParameter)showParameter);
                    }
                } else if (DIRECT_DECLARE.equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    JSONArray jsonArray = new JSONArray();
                    Object[] declarePkIds = list.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).toArray();
                    DynamicObject[] declareData = BusinessDataServiceHelper.load((Object[])declarePkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
                    StringBuilder message = new StringBuilder();
                    for (DynamicObject declare : declareData) {
                        DynamicObject org = declare.getDynamicObject("org");
                        String type = declare.getString("type");
                        String typeName = TemplateTypeConstant.getNsrtypemap().get(type);
                        String skssqq = DateUtils.format(declare.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE);
                        String skssqz = DateUtils.format(declare.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE);
                        String billStatus = declare.getString("billstatus");
                        if (!"C".equals(billStatus)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u53d1\u9001\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (!"zzsybnsr".equals(type)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        JSONObject customMap = new JSONObject();
                        customMap.put("sbbid", (Object)declare.getString("id"));
                        customMap.put("type", (Object)declare.getString("type"));
                        customMap.put("nsrsbh", (Object)declare.getString("nsrsbh"));
                        customMap.put(ORGID_KEY, (Object)org.getString("id"));
                        Date skssqqDate = declare.getDate("skssqq");
                        customMap.put("skssqq", (Object)DateUtils.format(skssqqDate, "yyyy-MM-dd"));
                        Date skssqzDate = declare.getDate("skssqz");
                        customMap.put("skssqz", (Object)DateUtils.format(skssqzDate, "yyyy-MM-dd"));
                        customMap.put("address", (Object)declare.getString("scjydz"));
                        customMap.put(ITEM_KEY, (Object)DIRECT_DECLARE);
                        jsonArray.add((Object)customMap);
                    }
                    if (!jsonArray.isEmpty()) {
                        this.directDeclareConfirmTips(jsonArray, evt.getOperateKey(), ResManager.loadKDString((String)"\u53d1\u9001\u7533\u62a5\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7533\u62a5\u5417\uff1f", (String)"TaxDeclareQueryListPlugin_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                    if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                        String[] stringArray = message.toString().split(System.getProperty("line.separator"));
                        if (stringArray.length == 1) {
                            this.getView().showErrorNotification(message.toString());
                        } else {
                            this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                            OperationResult operationResult = new OperationResult();
                            operationResult.setSuccess(false);
                            operationResult.setMessage(message.toString());
                            this.getView().showOperationResult(operationResult);
                        }
                    }
                } else if (DIRECT_PAY.equals(evt.getOperateKey())) {
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    if (list == null || list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    JSONArray jsonArray = new JSONArray();
                    Object[] declarePkIds = list.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).toArray();
                    DynamicObject[] declareData = BusinessDataServiceHelper.load((Object[])declarePkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
                    StringBuilder message = new StringBuilder();
                    for (DynamicObject declare : declareData) {
                        DynamicObject org = declare.getDynamicObject("org");
                        String type = declare.getString("type");
                        String typeName = TemplateTypeConstant.getNsrtypemap().get(type);
                        String skssqq = DateUtils.format(declare.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE);
                        String skssqz = DateUtils.format(declare.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE);
                        String billStatus = declare.getString("billstatus");
                        if (!"C".equals(billStatus)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (!"declared".equals(declare.getString("declarestatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u53ef\u53d1\u9001\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (!"unpaid".equals(declare.getString("paystatus")) && !"payfailed".equals(declare.getString("paystatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u6216\u7f34\u6b3e\u5931\u8d25\u53ef\u53d1\u9001\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (!"zzsybnsr".equals(type)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\u7533\u62a5,%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        JSONObject customMap = new JSONObject();
                        customMap.put("sbbid", (Object)declare.getString("id"));
                        customMap.put("type", (Object)declare.getString("type"));
                        customMap.put("nsrsbh", (Object)declare.getString("nsrsbh"));
                        customMap.put(ORGID_KEY, (Object)org.getString("id"));
                        Date skssqqDate = declare.getDate("skssqq");
                        customMap.put("skssqq", (Object)DateUtils.format(skssqqDate, "yyyy-MM-dd"));
                        Date skssqzDate = declare.getDate("skssqz");
                        customMap.put("skssqz", (Object)DateUtils.format(skssqzDate, "yyyy-MM-dd"));
                        customMap.put("address", (Object)declare.getString("scjydz"));
                        customMap.put(ITEM_KEY, (Object)DIRECT_PAY);
                        jsonArray.add((Object)customMap);
                    }
                    if (!jsonArray.isEmpty()) {
                        this.directDeclareConfirmTips(jsonArray, evt.getOperateKey(), ResManager.loadKDString((String)"\u53d1\u9001\u7f34\u6b3e\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7f34\u6b3e\u5417\uff1f", (String)"TaxDeclareQueryListPlugin_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                    if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                        String[] stringArray = message.toString().split(System.getProperty("line.separator"));
                        if (stringArray.length == 1) {
                            this.getView().showErrorNotification(message.toString());
                        } else {
                            this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                            OperationResult operationResult = new OperationResult();
                            operationResult.setSuccess(false);
                            operationResult.setMessage(message.toString());
                            this.getView().showOperationResult(operationResult);
                        }
                    }
                } else if (DEFER_PAY_KEY.equals(evt.getOperateKey())) {
                    OperationResult operationResult1 = evt.getOperationResult();
                    if (operationResult1 != null && (!operationResult1.isSuccess() || operationResult1.getSuccessPkIds().isEmpty())) {
                        operationResult1.setSuccessPkIds(Collections.emptyList());
                        return;
                    }
                    BillList billlist = (BillList)this.getControl(BILL_LIST);
                    ListSelectedRowCollection list = billlist.getSelectedRows();
                    FormShowParameter parameter = new FormShowParameter();
                    if (list != null && !list.isEmpty()) {
                        void var9_81;
                        List pkIds = Arrays.stream(list.getPrimaryKeyValues()).distinct().collect(Collectors.toList());
                        if ("tcvat".equals(appId)) {
                            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id as sbbid,org,org.name as orgname,skssqq,skssqz,type,declarestatus,paystatus,entryentity.id,entryentity.deferpayapply1", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                        } else {
                            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id as sbbid,org,org.name as orgname,skssqq,skssqz,type,declarestatus,paystatus,deferpayapply", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                        }
                        String uniqueKey = null;
                        JSONArray jsonArray = new JSONArray();
                        StringBuilder message = new StringBuilder();
                        StringBuilder fzybhzMessage = new StringBuilder();
                        List<Object> sbbid = new ArrayList();
                        for (void declare : var9_81) {
                            String orgId = declare.getDynamicObject("org").getString("id");
                            String skssqq = declare.getString("skssqq");
                            String skssqz = declare.getString("skssqz");
                            String payStatus = declare.getString("paystatus");
                            String type = declare.getString("type");
                            String orgname = declare.getDynamicObject("org").getString("name");
                            String typeName = TemplateTypeConstant.getNsrtypemap().get(type);
                            sbbid.addAll(declare.getDynamicObjectCollection("entryentity").stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
                            OrgUtils.getfzybqyMessage(type, orgId, DateUtils.format(declare.getDate("skssqq")), DateUtils.format(declare.getDate("skssqz")), fzybhzMessage);
                            if (!"declared".equals(declare.getString("declarestatus"))) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u7533\u8bf7\u7f13\u7f34: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_32", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname, skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (!"unpaid".equals(payStatus) && !StringUtils.isBlank((CharSequence)declare.getString("paystatus"))) {
                                message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u7684\u6570\u636e\u53ef\u7533\u8bf7\u7f13\u7f34: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_33", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname, skssqq, skssqz, typeName)).append(SEPARATOR);
                                continue;
                            }
                            if (uniqueKey == null) {
                                uniqueKey = orgId + skssqq + skssqz;
                                continue;
                            }
                            if (uniqueKey.equals(orgId + skssqq + skssqz)) continue;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3001\u6240\u5c5e\u7a0e\u671f\u76f8\u540c\u7684\u7533\u62a5\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_34", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                            return;
                        }
                        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                            String[] messages = message.toString().split(System.getProperty("line.separator"));
                            if (messages.length == 1) {
                                this.getView().showErrorNotification(message.toString());
                            } else {
                                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                                OperationResult operationResult = new OperationResult();
                                operationResult.setSuccess(false);
                                operationResult.setMessage(message.toString());
                                this.getView().showOperationResult(operationResult);
                            }
                            return;
                        }
                        if ("tcvat".equals(appId)) {
                            parameter.setCustomParam("sbbEntryIds", sbbid);
                        } else {
                            sbbid = Arrays.stream(var9_81).map(e -> e.getLong("sbbid")).collect(Collectors.toList());
                            parameter.setCustomParam("sbbIds", sbbid);
                        }
                        if (StringUtils.isNotBlank((CharSequence)fzybhzMessage.toString())) {
                            JSONObject customMap = new JSONObject();
                            customMap.put("sbbIds", sbbid);
                            jsonArray.add((Object)customMap);
                            this.directDeclareConfirmTips(jsonArray, evt.getOperateKey(), fzybhzMessage.toString());
                            return;
                        }
                    }
                    parameter.setFormId("bdtaxr_deferpay_dialog");
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DEFER_PAY_KEY);
                    parameter.setCloseCallBack(closeCallBack);
                    this.getView().showForm(parameter);
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            return;
        }
        if ("riskcontent".equals(args.getFieldName())) {
            DeclareUtils.showRiskDialog(currentSelectedRowInfo.getPrimaryKeyValue().toString(), this.getView());
        } else {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_nsrxx");
            String type = object.getString("type");
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
            customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
            Date skssqq = object.getDate("skssqq");
            Date skssqz = object.getDate("skssqz");
            customParams.put("type", type);
            customParams.put("templatetype", type);
            customParams.put("taxPayerType", type);
            customParams.put("deadLine", "month".equals(object.getString("taxlimit")) ? "aysb" : "ajsb");
            customParams.put("tcrettype", object.getString("tcrettype"));
            customParams.put("apanage", object.getString("apanage"));
            String startDate = DateUtils.format(skssqq, "yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format(skssqz, "yyyy-MM-dd"));
            customParams.put("taxlimit", DateUtils.getTaxLimit(skssqq, skssqz));
            customParams.put("taxperiod", startDate.substring(0, 7));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", object.getDate("modifytime"));
            String declarestatus = object.getString("declarestatus");
            String dataType = object.getString("datatype");
            customParams.put("datatype", dataType);
            customParams.put("sbbid", String.valueOf(currentSelectedRowInfo.getPrimaryKeyValue()));
            this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String type = data.getString("type");
        if ("taxtype".equals(columnDesc.getKey())) {
            if (type != null) {
                if (type.startsWith("zzs")) {
                    e.setFormatValue((Object)ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxDeclareQueryListPlugin_35", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                } else if (type.startsWith("qysds")) {
                    e.setFormatValue((Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"TaxDeclareQueryListPlugin_36", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                } else {
                    e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
                }
            }
        } else if ("type".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
        } else if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format(data.getDate("skssqq"), InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            String skssqz = DateUtils.format(data.getDate("skssqz"), InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        } else if ("riskcontent".equals(columnDesc.getKey()) && "normal".equals(e.getFormatValue())) {
            e.getNoLinkKey().add("riskcontent");
        }
    }

    private List<String> getTemplateTypeList() {
        String taxtype = (String)this.getView().getFormShowParameter().getCustomParam("taxtype");
        String querytype = (String)this.getView().getFormShowParameter().getCustomParam("querytype");
        if (EmptyCheckUtils.isNotEmpty(taxtype)) {
            return Arrays.stream(taxtype.split(",")).map(String::trim).collect(Collectors.toList());
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyCheckUtils.isEmpty(appId)) {
            LOGGER.info("taxDeclareQueryParams --- appid: {}", (Object)appId);
            appId = (String)this.getView().getFormShowParameter().getCustomParam("appid");
        } else if ("qysdsnb".equals(querytype)) {
            appId = "tccit_hj";
        }
        LOGGER.info("taxDeclareQueryParams --- taxtype: {}, appid: {}", (Object)taxtype, (Object)appId);
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.valueOfAppId(appId);
        if (taxTypeEnum != null) {
            return Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
        }
        return new ArrayList<String>(TemplateTypeConstant.getNsrtypemap().keySet());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("import") || DEFER_PAY_KEY.equals(actionId)) {
            Object returnData;
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            billList.refresh();
            if (DEFER_PAY_KEY.equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
                this.getView().showSuccessNotification((String)returnData);
            }
        } else if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            ListSelectedRowCollection list = billList.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)(DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING + ",entryentity.deferpayapply1"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
            this.pay(billList, declares, payDate);
        }
    }

    private void pay(BillList billlist, DynamicObject[] declares, Date payDate) {
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            String appId = this.getView().getFormShowParameter().getAppId();
            for (DynamicObject declare : declares) {
                declare.set("paystatus", (Object)"paid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"0");
                declare.set("paydate", (Object)payDate);
                declare.set("payer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[0]));
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                billlist.refresh();
                this.calcElement(modifyDynamicObjects, PAY);
            }
        }
    }

    private void directDeclareConfirmTips(JSONArray jSONArray, String key, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxDeclareQueryListPlugin_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxDeclareQueryListPlugin_38", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, JSONArray.toJSONString((Object)jSONArray));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        JSONArray customMaps;
        String customVaule;
        BillList billlist;
        ListSelectedRowCollection list;
        Object[] pkIds;
        DynamicObject[] declares;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (PAY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
        if (APPLY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes && (declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(pkIds = (list = (billlist = (BillList)this.getControl(BILL_LIST)).getSelectedRows()).getPrimaryKeyValues()))})) != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            for (DynamicObject declare : declares) {
                BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
                    declare.set("paystatus", (Object)"nopay");
                }
                declare.set("declarestatus", (Object)"declared");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("declaretype", (Object)"0");
                declare.set("sbrq", (Object)new Date());
                declare.set("declarer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                billlist.refresh();
            }
        }
        if (DEFER_PAY_KEY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            customVaule = event.getCustomVaule();
            JSONArray.parseArray((String)customVaule);
            customMaps = JSONArray.parseArray((String)customVaule);
            JSONObject customMap = (JSONObject)customMaps.get(0);
            List sbbid = (List)customMap.get((Object)"sbbIds");
            FormShowParameter parameter = new FormShowParameter();
            if ("tcvat".equals(appId)) {
                parameter.setCustomParam("sbbEntryIds", (Object)sbbid);
            } else {
                parameter.setCustomParam("sbbIds", (Object)sbbid);
            }
            parameter.setFormId("bdtaxr_deferpay_dialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DEFER_PAY_KEY);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
        if ((DIRECT_DECLARE.equals(event.getCallBackId()) || DIRECT_PAY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            customVaule = event.getCustomVaule();
            JSONArray.parseArray((String)customVaule);
            customMaps = JSONArray.parseArray((String)customVaule);
            for (Object obj : customMaps) {
                JSONObject customMap = (JSONObject)obj;
                String sbbid = customMap.getString("sbbid");
                String type = customMap.getString("type");
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
                paramMap.put("transrc", DIRECT_DECLARE);
                paramMap.put("businessId", sbbid);
                paramMap.put("type", type);
                String skssqq = customMap.getString("skssqq");
                String skssqz = customMap.getString("skssqz");
                paramMap.put("skssqq", skssqq);
                paramMap.put("skssqz", skssqz);
                paramMap.put("nsrsbh", customMap.getString("nsrsbh"));
                if (DIRECT_DECLARE.equals(event.getCallBackId())) {
                    paramMap.put("operationType", "declare");
                } else if (DIRECT_PAY.equals(event.getCallBackId())) {
                    paramMap.put("operationType", DIRECT_PAY);
                }
                String dqdm = CommonInfoUtil.getAreaInfo(paramMap.get("nsrsbh").toString(), "number");
                if (StringUtils.isNotBlank((CharSequence)dqdm)) {
                    paramMap.put("sbdq", dqdm);
                }
                try {
                    DynamicObject recordObj;
                    DynamicObject[] recordLog;
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)"tcvat_nsrxx");
                    if (DIRECT_DECLARE.equals(event.getCallBackId())) {
                        declare.set("declarestatus", (Object)"declaring");
                        recordLog = TaxDeclareQueryListPlugin.assembleDeclareRecord(customMap.getLong(ORGID_KEY), type, DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz), "1");
                        recordObj = recordLog[0];
                        paramMap.put("id", recordObj.getLong("id"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                        paramMap.put("key", event.getCallBackId());
                        JobUtils.submitJob(paramMap);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u7533\u62a5\uff01", (String)"TaxDeclareQueryListPlugin_39", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    } else if (DIRECT_PAY.equals(event.getCallBackId())) {
                        declare.set("paystatus", (Object)"paying");
                        recordLog = TaxDeclareQueryListPlugin.assembleDeclareRecord(customMap.getLong(ORGID_KEY), type, DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz), "2");
                        recordObj = recordLog[0];
                        paramMap.put("id", recordObj.getLong("id"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                        paramMap.put("key", event.getCallBackId());
                        JobUtils.submitJob(paramMap);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u7f34\u6b3e\uff01", (String)"TaxDeclareQueryListPlugin_40", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        DeclareMQSender.sendMQ(declare, TaxDeclareQueryListPlugin.getPayDate(declare), DeclareMQType.PAY.name(), DIRECT_PAY);
                    }
                    BillList billlist2 = (BillList)this.getControl(BILL_LIST);
                    billlist2.refresh();
                }
                catch (Exception e) {
                    LOGGER.error("invokeBizSerivce error:" + e);
                }
            }
        }
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(type);
        if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption(TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private static DynamicObject[] assembleDeclareRecord(Long orgId, String type, Date skssqq, Date skssqz, String executeType) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("skssqz", (Object)skssqz);
        dynamicObject.set("type", (Object)type);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", (Object)executeType);
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        String number = codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void calcElement(List<DynamicObject> modifyDynamicObjects, String act) {
        for (DynamicObject modifyob : modifyDynamicObjects) {
            if (CANCELPAY.equals(act) || PAY.equals(act)) continue;
            DeclareMQSender.sendMQ(modifyob, TaxDeclareQueryListPlugin.getPayDate(modifyob), DeclareMQType.PAY.name(), act);
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }
}

