/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.plugin;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.handler.IDeclareHandler;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.listener.IControlListener;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.datasynchronize.DataSynchronizeMQSender;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.DevprotalBizAppUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

@Deprecated
public abstract class AbstractDeclareReportPlugin
extends AbstractFormPlugin
implements IDeclareHandler {
    private static Log logger = LogFactory.getLog(AbstractDeclareReportPlugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String CONTENT_TAB = "tabcontent";
    private static final String BAR_KEY = "toolbarap";
    private static final String TOOL_BAR_DECLARE = "toolbarapdeclare";
    private static final String VIEW_DRAFT_KEY = "viewdraft";
    private static final String ONE_KEY_GENERATE = "onekeygenerate";
    private static final String LINK_TO_DRAFT_LIST = "linktodraftlist";
    private static final String CREATESBB = "createsbb";
    protected static final String ORG_SEL = "org";
    protected static final String DECLARE_NUMBER = "declarenumber";
    protected static final String DECLARE_DATE = "declaredate";
    protected static final String TAXAUTHORITY = "taxauthority";
    private static final String DECLARE_PAGE_ENTITY_NEW = "bdtaxr_declare";
    private static final String CALLBACKID_MOD = "modifyOrDelete";
    private static final String CALLBACKID_MODIFY = "callback_modify";
    protected static final String EDIT = "edit";
    protected static final String VIEW = "read";
    private List<IControlListener> controlListeners = new ArrayList<IControlListener>();

    public void setControlListeners(List<IControlListener> controlListeners) {
        this.controlListeners = controlListeners;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_reset", "bar_edit", "bar_submit", "bar_audit", "bar_save", "bar_cancel", "bar_refresh"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("sbbid") != null) {
            this.loadFromHyperLinkClick(customParams);
        } else if (customParams.get(CREATESBB) != null) {
            this.loadFromOtherPage(customParams);
        } else {
            this.loadFromMenuClick();
        }
    }

    private void loadFromMenuClick() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramOrg = (String)customParams.get(ORGID_KEY);
        long org = StringUtil.isNotBlank((CharSequence)paramOrg) ? Long.parseLong(paramOrg) : RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        Long orgid = OrgCheckUtil.setDefaultOrg(this.getView(), (Long)org, col);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyCheckUtils.isNotEmpty(orgid)) {
            TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid(appId);
            Boolean checkResult = OrgCheckUtil.check(this.getView(), String.valueOf(orgid), appId, licenseTaxEnum != null ? licenseTaxEnum.getCategoryCode() : null);
            if (checkResult.booleanValue()) {
                return;
            }
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, String.valueOf(orgid));
            boolean showSbbPage = this.initModelValue(false, String.valueOf(orgid));
            if (showSbbPage) {
                this.openDeclarePage(false);
            }
        }
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String sbbid = (String)customParams.get("sbbid");
        DynamicObject nsrxx = YbnsrService.queryYbnsr(sbbid);
        if (nsrxx == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u6570\u636e\u5df2\u5220\u9664\uff01", (String)"AbstractDeclareReportPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        String orgid = nsrxx.getString(ORG_SEL);
        String appid = this.getView().getFormShowParameter().getAppId();
        String templatetype = (String)customParams.get("templatetype");
        String categoryType = TaxAppEnum.getCategoryType(appid, templatetype);
        boolean checkResult = OrgCheckUtil.check(this.getView(), orgid, appid, categoryType);
        if (!checkResult) {
            this.getPageCache().put(ORGID_KEY, orgid);
            Date skssqq = nsrxx.getDate("skssqq");
            String skssqqstr = DateUtils.format(skssqq);
            this.getPageCache().put("skssqq", skssqqstr);
            Date skssqz = nsrxx.getDate("skssqz");
            String skssqzstr = DateUtils.format(skssqz);
            this.getPageCache().put("skssqz", skssqzstr);
            this.getPageCache().put("sbbid", sbbid);
            this.getPageCache().put("sbbbillno", nsrxx.getString("billno"));
            this.getPageCache().put("businessno", nsrxx.getString("businessno"));
            this.getPageCache().put("templatetype", nsrxx.getString("type"));
            this.getPageCache().put("templateid", nsrxx.getString("templateid"));
            this.getPageCache().put(TAXAUTHORITY, nsrxx.getString(TAXAUTHORITY));
            this.getPageCache().put(DECLARE_DATE, DateUtils.format(nsrxx.getDate(DECLARE_DATE)));
            this.setModelValue(ORG_SEL, orgid);
            this.setModelValue("skssqq", skssqq);
            this.setModelValue("skssqz", skssqz);
            this.setModelValue(DECLARE_NUMBER, nsrxx.get("billno"));
            this.setModelValue(DECLARE_DATE, nsrxx.get(DECLARE_DATE));
            this.setModelValue(TAXAUTHORITY, nsrxx.get(TAXAUTHORITY));
            this.doInLoadFromHyperLinkClick(nsrxx);
            this.openDeclarePage(false);
        }
    }

    private void setModelValue(String key, Object value) {
        Control control = this.getControl(key);
        if (control != null) {
            this.getModel().setValue(key, value);
        }
    }

    public void beforeOpenInnerPage(String orgid) {
        String appid = this.getView().getFormShowParameter().getAppId();
        Boolean checkResult = OrgCheckUtil.check(this.getView(), orgid, appid, TaxAppEnum.getEnumInstanceByAppid(appid).getCategoryCode());
        if (!checkResult.booleanValue()) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.openDeclarePage(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        this.controlListeners.forEach(iPropertyListener -> iPropertyListener.propertyChanged(args, this, this.getView(), this.getPageCache(), this.getModel()));
    }

    @Override
    public void loadData(Date skssqq, Date skssqz) {
        Boolean success = this.isValidDates(skssqq, skssqz);
        if (success.booleanValue()) {
            this.getPageCache().put("skssqq", DateUtils.format(skssqq));
            this.getPageCache().put("skssqz", DateUtils.format(skssqz));
            this.openDeclarePage(false);
        }
    }

    protected Boolean isValidDates(Date skssqq, Date skssqz) {
        String[] taxLimits;
        boolean isvalid = Boolean.FALSE;
        for (String taxLimit : taxLimits = this.getTaxLimits()) {
            boolean temp = DateUtils.validDateRange(taxLimit, skssqq, skssqz);
            isvalid |= temp;
        }
        if (!isvalid) {
            String errMsg = this.buildErrorMsg(taxLimits);
            this.getView().showTipNotification(errMsg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4e3a%s", (String)"AbstractDeclareReportPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        ArrayList<String> nameList = new ArrayList<String>(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map<String, String> dataMap = CacheUtils.getInstance().getDataResult(this.getPageCache());
        this.clientCallBackMethod(dataMap, e.getName());
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (!"bar_close".equals(key) && this.isInvalidInput()) {
            return;
        }
        switch (key) {
            case "bar_close": {
                this.close(null);
                break;
            }
            case "bar_refresh": {
                String sbbid = this.getPageCache().get("sbbid");
                boolean exists = DeclareServiceHelper.exists(sbbid);
                this.showInnerPage(!exists, this.getPageCache().get("operation"));
                break;
            }
            case "bar_reset": {
                this.reset();
                break;
            }
            case "bar_cancel": {
                this.cancel();
                break;
            }
        }
    }

    private void cancel() {
        boolean dataChanged;
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        IPageCache childPageCache = childPage.getPageCache();
        Map updateMap = TreeUtils.getCache(childPageCache, "updata_cellid", Map.class);
        boolean bl = dataChanged = updateMap != null && updateMap.size() > 0;
        if (dataChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_cancel", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractDeclareReportPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"AbstractDeclareReportPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"AbstractDeclareReportPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            DynamicObject dyo = YbnsrService.queryYbnsr(this.getPageCache().get("sbbid"));
            if (dyo == null) {
                this.closeView();
            } else {
                this.enableSubmitBtn();
                FormulaService.cancel(this.getPageCache());
                this.operationSbb(VIEW);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String code_close = this.getPageCache().get("code_close");
        if (!"true".equals(code_close)) {
            this.close(e);
        }
    }

    private void close(BeforeClosedEvent e) {
        boolean dataChanged;
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        if (childPage == null) {
            this.closeView();
            return;
        }
        IPageCache childPageCache = childPage.getPageCache();
        Map updateMap = TreeUtils.getCache(childPageCache, "updata_cellid", Map.class);
        boolean bl = dataChanged = updateMap != null && updateMap.size() > 0;
        if (dataChanged) {
            if (e != null) {
                e.setCancel(true);
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de", (String)"AbstractDeclareReportPlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa", (String)"AbstractDeclareReportPlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"AbstractDeclareReportPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.closeView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key;
            switch (key = ((Donothing)args.getSource()).getOperateKey()) {
                case "edit": 
                case "submit": 
                case "unsubmit": 
                case "audit": 
                case "unaudit": 
                case "save": {
                    args.setCancel(this.isInvalidInput());
                }
            }
        }
    }

    protected boolean isInvalidInput() {
        for (IControlListener listener : this.controlListeners) {
            boolean invalidInput = listener.checkControlValue(this.getView(), this.getPageCache(), this.getModel());
            if (invalidInput) continue;
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_audit"});
                String sbbid = this.getPageCache().get("sbbid");
                SourceOperateHelper.saveSourceTemporaryEntity(this.getTemplateType(), sbbid);
                this.operationSbb(EDIT);
                break;
            }
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclareReportPlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                this.save();
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "viewdraft": {
                this.viewDraft();
                break;
            }
            case "onekeygenerate": {
                this.onekeygenerate();
                break;
            }
            case "print": {
                this.print();
                break;
            }
        }
    }

    protected void print() {
        HashMap<String, String> params = new HashMap<String, String>();
        FormShowParameter showParameter = new FormShowParameter();
        params.put("templateId", this.getPageCache().get("templateid"));
        params.put("sbbid", this.getPageCache().get("sbbid"));
        showParameter.setFormId("bdtaxr_declare_print");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void viewDraft() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(skssqq));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate(skssqz));
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(templateType);
        QFilter templateFilter = new QFilter("templatetype", "=", (Object)templateEnum.getDraftType());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"id,type", (QFilter[])new QFilter[]{orgFilter, templateFilter, startFilter, endFilter});
        if (dynamicObject == null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(VIEW_DRAFT_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            String orgName = org != null ? org.getString("name") : "";
            String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5c1a\u672a\u7f16\u5236\u8ba1\u7a0e\u5e95\u7a3f\uff0c\u662f\u5426\u524d\u5f80\u7f16\u5236\uff1f", (String)"AbstractDeclareReportPlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put(ORGID_KEY, orgid);
            customParams.put("skssqq", skssqq);
            customParams.put("skssqz", skssqz);
            customParams.put("type", dynamicObject.getString("type"));
            customParams.put("templatetype", templateEnum.getDraftType());
            PageShowCommon.showForm(ShowType.MainNewTabPage, templateEnum.getDraftPage(), this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void operationSbb(String operationType) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        DeclareRequestModel requestModel = new DeclareRequestModel();
        String sbbid = this.getPageCache().get("sbbid");
        requestModel.setId(sbbid != null ? Long.valueOf(sbbid) : null);
        requestModel.setOrgId(Long.parseLong(this.getPageCache().get(ORGID_KEY)));
        requestModel.setTemplateType((String)customParams.get("templatetype"));
        requestModel.setOperation(operationType);
        requestModel.setSkssqq(this.getPageCache().get("skssqq"));
        requestModel.setSkssqz(this.getPageCache().get("skssqz"));
        requestModel.setRefresh(false);
        if (EmptyCheckUtils.isNotEmpty(this.getPageCache().get("templateid"))) {
            requestModel.setTemplateId(Long.parseLong(this.getPageCache().get("templateid")));
        }
        this.setRequestModel(requestModel);
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(DECLARE_PAGE_ENTITY_NEW);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        this.getPageCache().put("operation", operationType);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if (EDIT.equals(operationType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_edit", "bar_submit", "bar_audit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, "bar_save", "bar_cancel"});
            String datatype = this.getPageCache().get("datatype");
            this.getView().setVisible(Boolean.valueOf("1".equals(datatype)), new String[]{"bar_reset"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_edit", VIEW_DRAFT_KEY, "bar_submit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_audit", "bar_save", "bar_cancel", "bar_reset"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_submit"});
        }
    }

    public void save() {
        try {
            String sbbid = this.getPageCache().get("sbbid");
            DynamicObject sbbObj = YbnsrService.queryYbnsr(sbbid);
            if (sbbObj != null && !"A".equals(sbbObj.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u8005\u5df2\u5ba1\u6838", (String)"AbstractDeclareReportPlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AbstractDeclareReportPlugin_43", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
        }
        catch (Exception sbbid) {
            // empty catch block
        }
        IFormView childView = this.getView().getView(this.getPageCache().get("declarepageid"));
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            DeclareRequestModel declareRequestModel = new DeclareRequestModel();
            try (TXHandle h = TX.requiresNew();){
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                declareRequestModel.setId(Long.valueOf(this.getPageCache().get("sbbid")));
                declareRequestModel.setOrgId(Long.parseLong(this.getPageCache().get(ORGID_KEY)));
                declareRequestModel.setTemplateType(this.getTemplateType());
                declareRequestModel.setRefresh(true);
                declareRequestModel.setOperation(EDIT);
                declareRequestModel.setSkssqq(this.getPageCache().get("skssqq"));
                declareRequestModel.setSkssqz(this.getPageCache().get("skssqz"));
                BaseResult baseResult = (BaseResult)saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                if (baseResult.getCode() != 200) {
                    this.getView().showErrorNotification(baseResult.getMessage());
                    return;
                }
                try {
                    this.operationBill("save");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractDeclareReportPlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    String billno = this.getPageCache().get("sbbbillno");
                    String templatetype = this.getTemplateType();
                    if (StringUtils.trimToEmpty((String)templatetype).startsWith("qtsf")) {
                        OperatorDialogUtils.operateDialog("qtsf", TemplateEnum.getEnumByDeclareType(templatetype).getDeclarePage(), ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDeclareReportPlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f", (String)"AbstractDeclareReportPlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno));
                    }
                }
                catch (Exception e) {
                    logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AbstractDeclareReportPlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    h.markRollback();
                    return;
                }
            }
            this.operationSbb(VIEW);
            DataSynchronizeMQSender.sendMessage(new SynchronizeParam(declareRequestModel.getId(), this.getTemplateType(), declareRequestModel.getOrgId()));
        }
    }

    public void enableSubmitBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
    }

    public void submit(String key) {
        DynamicObject declare = YbnsrService.queryYbnsr(this.getPageCache().get("sbbid"));
        if (declare != null) {
            if ("unaudit".equals(key) && declare.getLong("sbbid") != 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"AbstractDeclareReportPlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            String sbbid = declare.getString("id");
            boolean flag = DeclareUtils.submit(this.getView(), Collections.singletonList(sbbid), key, "tcvat_nsrxx", false);
            this.operationBill(key);
            if (flag) {
                this.setBtnStatus(VIEW);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"AbstractDeclareReportPlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    private void reset() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_reset", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u7eb3\u7a0e\u7533\u62a5\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void onekeygenerate() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        if (LicenseCheckServiceHelper.check(orgid, this.getView(), "tcdrs")) {
            return;
        }
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(this.getTemplateType());
        String draftType = templateEnum.getDraftType();
        DynamicObject draft = StatusUtils.queryOne(draftType, orgid, skssqq, skssqz, "nssb");
        if (draft != null) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgid), (String)"bos_org");
            String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u5df2\u5b58\u5728\u5e95\u7a3f\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\u5c06\u5bfc\u81f4\u539f\u6709\u7684\u5e95\u7a3f\u548c\u7533\u62a5\u8868\u6570\u636e\u88ab\u6e05\u9664\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgObj.getString("name"), skssqq, skssqz);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ONE_KEY_GENERATE, (IFormPlugin)this);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks, null, SerializationUtils.toJsonString((Object)draft));
        } else {
            this.executeEngineHandler(orgid, skssqq, skssqz, this.getTemplateType());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        String templateType = this.getTemplateType();
        switch (callBackId) {
            case "bar_reset": {
                if (this.isInvalidInput()) {
                    return;
                }
                if (e.getResult() != MessageBoxResult.Yes) break;
                String appId = this.getView().getFormShowParameter().getAppId();
                String entityId = this.getView().getEntityId();
                Object declarenumber = this.getModel().getValue(DECLARE_NUMBER);
                String operateName = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"AbstractDeclareReportPlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7f16\u53f7%s\uff0c\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"AbstractDeclareReportPlugin_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), declarenumber);
                OperatorDialogUtils.operateDialogByAppid(DevprotalBizAppUtil.getTaxcAppByNumber(appId), entityId, operateName, operateDescription);
                String sbbid = this.getPageCache().get("sbbid");
                SourceOperateHelper.deleteSourceTpEntity(this.getTemplateType(), EmptyCheckUtils.isEmpty(sbbid) ? null : Long.valueOf(Long.parseLong(sbbid)));
                this.openDeclarePage(true);
                break;
            }
            case "viewdraft": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(templateType);
                customParams.put("templatetype", templateEnum.getDraftType());
                PageShowCommon.showForm(ShowType.MainNewTabPage, templateEnum.getDraftPage(), this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "callback_modify": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    this.showInnerPage(false, VIEW);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_selectsbb", "bar_viewsource"});
                    break;
                }
                this.getView().close();
                break;
            }
            case "modifyOrDelete": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(templateType);
                    StatusUtils.delete(templateEnum.getDraftType(), orgId, skssqq, skssqz, "nssb");
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put(ORGID_KEY, orgId);
                    customParams.put("skssqq", skssqq);
                    customParams.put("skssqz", skssqz);
                    PageShowCommon.showForm(ShowType.MainNewTabPage, templateEnum.getDeclarePage(), this.getView(), customParams, (IFormPlugin)this);
                    this.getView().close();
                    break;
                }
                if (e.getResult() == MessageBoxResult.No) {
                    this.showInnerPage(false, EDIT);
                    String sbbid = this.getView().getFormShowParameter().getCustomParams().getOrDefault("sbbid", "0");
                    SourceOperateHelper.saveSourceTemporaryEntity(this.getTemplateType(), sbbid);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_reset"});
                    break;
                }
                this.getView().close();
                break;
            }
            case "onekeygenerate": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String customVaule = e.getCustomVaule();
                JSONObject object = JSONObject.parseObject((String)customVaule);
                if (!"A".equals(object.getString("billstatus"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u662f\u5426\u9700\u8981\u524d\u5f80\u5e95\u7a3f\u67e5\u8be2\u754c\u9762\u4fee\u6539\uff1f", (String)"AbstractDeclareReportPlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), object.getString("billno"));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(LINK_TO_DRAFT_LIST, (IFormPlugin)this);
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, object.getString("billno"));
                    break;
                }
                this.executeEngineHandler(orgId, skssqq, skssqz, templateType);
                break;
            }
            case "linktodraftlist": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String draftQueryPage = TemplateEnum.getEnumByDeclareType(this.getTemplateType()).getDraftQueryPage();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put(ORGID_KEY, Long.parseLong(orgId));
                customParams.put("startdate", DateUtils.stringToDate(skssqq));
                customParams.put("enddate", DateUtils.stringToDate(skssqz));
                PageShowCommon.showBillList(ShowType.MainNewTabPage, draftQueryPage, this.getView(), customParams);
                break;
            }
            case "handle_onekey_generate_exception": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String declareType = this.getTemplateType();
                String draftPage = TemplateEnum.getEnumByDeclareType(declareType).getDraftPage();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                PageShowCommon.showForm(ShowType.MainNewTabPage, draftPage, this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "bar_close": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.closeView();
                break;
            }
            case "bar_cancel": {
                DynamicObject dyo = YbnsrService.queryYbnsr(this.getPageCache().get("sbbid"));
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (dyo == null) {
                    this.closeView();
                    break;
                }
                this.enableSubmitBtn();
                FormulaService.cancel(this.getPageCache());
                this.operationSbb(VIEW);
            }
        }
    }

    private void executeEngineHandler(String orgId, String skssqq, String skssqz, String templateType) {
        EngineHandler handler = EngineHandlerFactory.createHandler(templateType);
        EngineModel engineModel = this.buildEngineModel(orgId, skssqq, skssqz, templateType, this.getPageCache());
        try {
            handler.validate(engineModel);
            handler.execute(engineModel);
        }
        catch (KDBizException exception) {
            handler.handleException(exception, this.getView(), (IFormPlugin)this);
            return;
        }
        this.openDeclarePage(true);
    }

    private boolean isDeclared(String rootPageId, String orgId, String startdate, String enddate) {
        DynamicObject declare = this.queryNsrxx(orgId, this.getTemplateType(), startdate, enddate);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put("billstatus", "A");
        rootCache.put("datatype", "1");
        this.getPageCache().remove("templateid");
        if (declare != null) {
            if (StringUtil.isNotEmpty((CharSequence)declare.getString("templateid"))) {
                this.getPageCache().put("templateid", declare.getString("templateid"));
            }
            String status = declare.getString("declarestatus");
            String billstatus = declare.getString("billstatus");
            String datatype = declare.getString("datatype");
            String id = declare.getString("id");
            rootCache.put("billstatus", billstatus);
            rootCache.put("sbbid", id);
            rootCache.put("datatype", datatype);
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
                String orgName = null != org ? org.getString("name") : "";
                String statusName = this.getStatusLocaleName(status, billstatus);
                String taxlimitStr = DateUtils.getTaxLimitTips(DateUtils.stringToDate(startdate), DateUtils.stringToDate(enddate));
                if (!taxlimitStr.equals("")) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u6570\u636e\u5df2%3$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"AbstractDeclareReportPlugin_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, taxlimitStr, statusName);
                    rootView.showTipNotification(msg, Integer.valueOf(5000));
                    this.getView().sendFormAction(rootView);
                }
                return true;
            }
        }
        return false;
    }

    private String getStatusLocaleName(String status, String billstatus) {
        String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"AbstractDeclareReportPlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        if ("C".equals(billstatus)) {
            statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"AbstractDeclareReportPlugin_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        if ("declared".equals(status)) {
            statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"AbstractDeclareReportPlugin_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        return statusName;
    }

    protected String[] getTaxLimits() {
        return new String[]{"month"};
    }

    protected void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        switch (taxLimit = this.getTaxLimits()[0]) {
            case "year": {
                skssqq = DateUtils.getFirstDateOfYear(DateUtils.addYear(new Date(), -1));
                skssqz = DateUtils.getLastDateOfYear(skssqq);
                break;
            }
            case "halfyear": {
                skssqq = DateUtils.getFirstDateOfHalfYear(DateUtils.addMonth(new Date(), -6));
                skssqz = DateUtils.getLastDateOfHalfYear(skssqq);
                break;
            }
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason(DateUtils.addMonth(new Date(), -3));
                skssqz = DateUtils.getLastDateOfSeason(skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(new Date(), -1));
                skssqz = DateUtils.getLastDateOfMonth(skssqq);
            }
        }
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqq), (CharSequence)DateUtils.format((Date)this.getModel().getValue("skssqq")))) {
            this.getPageCache().put("code_change_skssqq", "true");
        }
        this.getModel().setValue("skssqq", (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format(skssqq));
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqz), (CharSequence)DateUtils.format((Date)this.getModel().getValue("skssqz")))) {
            this.getPageCache().put("code_change_skssqz", "true");
        }
        this.getModel().setValue("skssqz", (Object)skssqz);
        this.getPageCache().put("skssqz", DateUtils.format(skssqz));
    }

    protected void openDeclarePage(boolean refresh) {
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        Map<String, Object> map = this.chooseDeclareFormByDataType();
        if (StringUtils.equals((CharSequence)"2", (CharSequence)((String)map.get("datatype")))) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)((String)map.get("billstatus")))) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                String taxLimitTips = DateUtils.getTaxLimitTips(DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz));
                String orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"AbstractDeclareReportPlugin_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                String templateType = this.getTemplateType();
                if ("yhs".equals(templateType) || "szys_a".equals(templateType) || "kjqysds".equals(templateType) || "szys_b".equals(templateType)) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPlugin_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPlugin_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e", (String)"AbstractDeclareReportPlugin_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACKID_MODIFY, (IFormPlugin)this), btnNameMaps);
                } else {
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPlugin_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPlugin_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"AbstractDeclareReportPlugin_32", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e", (String)"AbstractDeclareReportPlugin_33", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
                }
            } else {
                this.showInnerPage(refresh, VIEW);
            }
        } else if (StringUtil.isBlank((CharSequence)((String)map.get("billstatus")))) {
            this.showInnerPage(true, EDIT);
        } else {
            this.showInnerPage(refresh, refresh ? EDIT : VIEW);
        }
    }

    private Map<String, Object> chooseDeclareFormByDataType() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String sbbid = this.getPageCache().get("sbbid");
        DynamicObject dyo = YbnsrService.queryYbnsr(sbbid);
        String declareStatus = "";
        String billstatus = "";
        String datatype = "";
        if (null != dyo) {
            declareStatus = dyo.getString("declarestatus");
            billstatus = dyo.getString("billstatus");
            datatype = dyo.getString("datatype");
        }
        map.put("declarestatus", declareStatus);
        map.put("billstatus", billstatus);
        map.put("datatype", datatype);
        return map;
    }

    protected void showInnerPage(boolean refresh, String operationStatus) {
        this.getPageCache().put("operation", operationStatus);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("rootPageId", this.getView().getPageId());
        customParams.put("templatetype", this.getTemplateType());
        if ("zzsybnsr_ybfz".equals(customParams.get("templatetype"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u6c47\u603b\u7ec4\u7ec7\u65e0\u987b\u7533\u62a5", (String)"AbstractDeclareReportPlugin_34", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), null);
            return;
        }
        if ("zzsybnsr_fzjg".equals(customParams.get("templatetype")) || "zzsybnsr_zjg".equals(customParams.get("templatetype"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6c47\u603b\u822a\u7a7a\u6682\u4e0d\u652f\u6301\u7eb3\u7a0e\u7533\u62a5", (String)"AbstractDeclareReportPlugin_35", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), null);
            return;
        }
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(this.getView().getPageId(), this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        if (isDeclare) {
            readonly = true;
        }
        customParams.put("readonly", readonly);
        FormShowParameter param = new FormShowParameter();
        DeclareRequestModel requestModel = new DeclareRequestModel();
        String sbbid = this.getPageCache().get("sbbid");
        requestModel.setId(sbbid != null ? Long.valueOf(sbbid) : null);
        requestModel.setBillNo(this.getPageCache().get("sbbbillno"));
        requestModel.setOrgId(Long.parseLong(this.getPageCache().get(ORGID_KEY)));
        requestModel.setTemplateType((String)customParams.get("templatetype"));
        requestModel.setOperation(operationStatus);
        requestModel.setSkssqq(this.getPageCache().get("skssqq"));
        requestModel.setSkssqz(this.getPageCache().get("skssqz"));
        requestModel.setRefresh(refresh);
        this.setRequestModel(requestModel);
        if (EmptyCheckUtils.isNotEmpty(this.getPageCache().get("templateid"))) {
            requestModel.setTemplateId(Long.parseLong(this.getPageCache().get("templateid")));
        }
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(DECLARE_PAGE_ENTITY_NEW);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.getView().updateView(CONTENT_TAB);
        this.setBtnStatus(operationStatus);
    }

    protected void closeView() {
        this.getPageCache().put("code_close", "true");
        this.getView().close();
    }

    private void setBtnStatus(String operationStatus) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_refresh"});
        DynamicObject dyo = YbnsrService.queryYbnsr(this.getPageCache().get("sbbid"));
        if (dyo != null && VIEW.equals(operationStatus)) {
            String billstatus = dyo.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_edit", VIEW_DRAFT_KEY, "bar_submit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_audit", "bar_save", "bar_cancel", "bar_reset"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_submit"});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_audit", VIEW_DRAFT_KEY, "bar_submit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_edit", "bar_save", "bar_cancel", "bar_reset"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_submit"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_audit"});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_audit", VIEW_DRAFT_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_edit", "bar_save", "bar_cancel", "bar_reset", "bar_submit"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_audit"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_edit", "bar_submit", "bar_audit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, "bar_reset", "bar_save", "bar_cancel"});
        }
        if (dyo != null && ("dkdj".equals(dyo.getString("type")) || "kjqysds".equals(dyo.getString("type")))) {
            this.getView().setEnable(Boolean.valueOf("1".equals(dyo.getString("datatype"))), new String[]{"bar_viewdraft"});
        }
    }

    protected EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String templateType, IPageCache pageCache) {
        return new EngineModel(orgId, skssqq, skssqz, templateType, pageCache);
    }

    protected DynamicObject queryNsrxx(String orgId, String templateType, String startdate, String enddate) {
        return YbnsrService.queryYbnsr(orgId, templateType, startdate, enddate, Collections.emptyMap());
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected void setRequestModel(DeclareRequestModel requestModel) {
    }

    protected void doInLoadFromHyperLinkClick(DynamicObject nsrxx) {
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
    }

    protected void operationBill(String operationKey) {
    }

    public abstract String getTemplateType();

    public abstract boolean initModelValue(boolean var1, String var2);
}

