/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.savecheck;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.refactor.declare.helper.QtsftysbbDeclareHelper;
import kd.taxc.bdtaxr.common.refactor.declare.impl.QtsftysbbImportServiceImpl;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckHandler;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class QtsfTysbbDeclareCheckImpl
implements TaxDeclareCheckHandler {
    private static final String REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";

    @Override
    public BaseResult beforeSaveCheck(Map<String, String> updateMap, Map<String, String> newDataMap, DeclareResponseModel responseModel) {
        Map.Entry entry;
        String operatorno;
        Optional<Map.Entry> optional;
        if (updateMap != null && (optional = updateMap.entrySet().stream().filter(e -> "tcvat_nsrxx#1#operatorno".equals(e.getKey())).findAny()).isPresent() && StringUtil.isNotEmpty((CharSequence)(operatorno = (String)(entry = optional.get()).getValue())) && !QtsfTysbbDeclareCheckImpl.isIDCard18(operatorno)) {
            return BaseResult.fail(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5408\u6cd5\uff01", (String)"QtsfTysbbDeclareCheckImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        Map<String, String> resultMap = EmptyCheckUtils.isNotEmpty(newDataMap) ? newDataMap : responseModel.getData();
        BaseResult<Object> baseResult = QtsftysbbDeclareHelper.checkZeroDeclareValues(resultMap, true);
        if (!baseResult.getCode().equals(BaseResult.OK)) {
            return baseResult;
        }
        String org = resultMap.get("tcvat_nsrxx#1#org");
        try {
            QtsftysbbDeclareHelper.checkDynRowData(resultMap, Long.parseLong(org), QtsftysbbImportServiceImpl.zspmAndzsxmMap);
        }
        catch (Exception e2) {
            return BaseResult.fail(e2.getMessage());
        }
        return BaseResult.ok();
    }

    private static boolean isIDCard18(CharSequence input) {
        Matcher matcher = Pattern.compile(REGEX_ID_CARD18).matcher(input);
        return matcher.matches();
    }
}

