/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class CacheUtils {
    public static final String TMP_ID = "tmpId";
    public static final String RULE_FORMULAS = "ruleFormulas_%s";
    public static final String FORMULATYPE = "formulaType";
    private static final String PARAM = "param";
    private static final String CACHERESULT = "cacheResult_%s";
    private static final Cache cache = CacheBuilder.newBuilder().initialCapacity(10).concurrencyLevel(5).expireAfterWrite(1800L, TimeUnit.SECONDS).build();

    private CacheUtils() {
    }

    public static Object get(String key) {
        Object result = null;
        try {
            result = cache.get((Object)key, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void put(String key, Object value) {
        cache.put((Object)key, value);
    }

    private static void setCacheValue(String key, Object value) {
        CacheUtils.put(key, value);
    }

    public static void setDataResult(Long tmpId, Map<String, String> map) {
        CacheUtils.setCacheValue(String.format(CACHERESULT, tmpId), map);
    }

    public static Map<String, String> getDataResult(Long tmpId) {
        return (Map)CacheUtils.get(String.format(CACHERESULT, tmpId));
    }

    public static void setRuleFormulas(Long tmpId, Map<String, String> map) {
        CacheUtils.setCacheValue(String.format(RULE_FORMULAS, tmpId), map);
    }

    public static Map<String, String> getRuleFormulas(Long tmpId) {
        return (Map)CacheUtils.get(String.format(RULE_FORMULAS, tmpId));
    }
}

