/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.cal;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.exception.FelException;
import kd.taxc.bdtaxr.common.refactor.formula.cal.FelService;
import kd.taxc.bdtaxr.common.refactor.formula.cal.eval.Parser;
import kd.taxc.bdtaxr.common.refactor.formula.cal.eval.tokenizer.ParseException;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.velocity.VelocityUtils;

public class CalculateService {
    private static Log logger = LogFactory.getLog(CalculateService.class);
    private static final String IF_PRE = "if";
    private static final String IF_PRE1 = "if(";
    private static final Double EPSILON = 1.0E-11;
    private static Map<String, String> swapMap = new HashMap<String, String>(){
        {
            this.put("790466954983902210", "790466954983902208");
            this.put("790468283538082820", "790468283538082816");
        }
    };

    public static String calculate(String formula) {
        return CalculateService.calculate(formula, "1");
    }

    public static String calculateOld(String formula) {
        return CalculateService.calculateOld(formula, "1");
    }

    public static String calculate(String formula, String formulatype) {
        return CalculateService.calculate(formula, formulatype, null, "", false, null);
    }

    public static String calculateOld(String formula, String formulatype) {
        try {
            return CalculateService.numberToString(formula, null);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return "0";
        }
    }

    public static String calculate(String formula, String formulatype, EntityField cellStyleModel, String key, boolean offerDefaultValue, Map<String, String> errorInfo) {
        logger.info("\u5f00\u59cb\u6267\u884cCalculateService.calculate,key={},formula={}", (Object)key, (Object)formula);
        long l = System.currentTimeMillis();
        String result = "";
        if (StringUtil.isNotBlank((CharSequence)formula)) {
            result = formula = formula.replace("\n", "").replace("\t", "").replace("\r", "").trim();
            if ("1".equals(formulatype) || "2".equals(formulatype) || "4".equals(formulatype) && formula.contains(IF_PRE1) || formula.contains("zeroToBlank")) {
                Object resultObj;
                long t1;
                block10: {
                    t1 = System.currentTimeMillis();
                    resultObj = null;
                    try {
                        resultObj = FelService.evalWithKey(formula, key);
                    }
                    catch (FelException e) {
                        if (errorInfo == null) break block10;
                        errorInfo.put(key, e.getMessage());
                    }
                }
                long t2 = System.currentTimeMillis();
                if (t2 - t1 > 5L) {
                    logger.info("fel\u516c\u5f0f\u8ba1\u7b97\u8017\u65f6---{}\uff1a{}ms", (Object)formula, (Object)(t2 - t1));
                }
                if (resultObj != null && "true".equals(resultObj.toString())) {
                    resultObj = "1";
                }
                if (resultObj != null && "false".equals(resultObj.toString())) {
                    resultObj = "0";
                }
                result = resultObj != null ? CalculateService.format(key, resultObj, cellStyleModel) : CalculateService.getDefaultValue(cellStyleModel);
            }
        } else if (offerDefaultValue) {
            result = CalculateService.getDefaultValue(cellStyleModel);
        }
        if (System.currentTimeMillis() - l > 5L) {
            logger.info("\u7ed3\u675f\u6267\u884cCalculateService.calculate,result={},,cost:{}ms", (Object)result, (Object)(System.currentTimeMillis() - l));
        }
        return result;
    }

    public static String calculateNoBusiness(String formula) {
        logger.info("\u5f00\u59cb\u6267\u884cCalculateService.cal,formula={}", (Object)formula);
        long l = System.currentTimeMillis();
        String result = "";
        if (StringUtil.isNotBlank((CharSequence)formula)) {
            result = formula = formula.replace("\n", "").replace("\t", "").replace("\r", "").trim();
            long t1 = System.currentTimeMillis();
            Object resultObj = null;
            try {
                resultObj = FelService.eval(formula);
            }
            catch (FelException e) {
                logger.error("\u5f00\u59cb\u6267\u884cCalculateService.calculate,formula={}", (Object)formula);
            }
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 5L) {
                logger.info("fel\u516c\u5f0f\u8ba1\u7b97\u8017\u65f6---{}\uff1a{}ms", (Object)formula, (Object)(t2 - t1));
            }
            if (resultObj != null) {
                result = CalculateService.format("", resultObj, null);
            }
        }
        if (System.currentTimeMillis() - l > 5L) {
            logger.info("\u7ed3\u675f\u6267\u884cCalculateService.calculate,result={},,cost:{}ms", (Object)result, (Object)(System.currentTimeMillis() - l));
        }
        return result;
    }

    public static String calculate(String formula, String formulatype, EntityField fieldType) {
        String result = null;
        if (formula.startsWith("#") || "4".equals(formulatype)) {
            try {
                result = VelocityUtils.velocityEngine(null, formula).toString();
            }
            catch (Exception e) {
                logger.error("\u5f02\u5e38\u65e5\u5fd7\u4e3a: " + e.getMessage());
            }
            if ("4".equals(formulatype)) {
                if ("0".equals(result) && "Text".equals(fieldType.getFieldType())) {
                    return "";
                }
                return StringUtil.trim((String)result);
            }
            try {
                if ("1".equals(formulatype) || "2".equals(formulatype) || "4".equals(formulatype) && formula.contains(IF_PRE)) {
                    return CalculateService.numberToString(result, fieldType);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                return "0";
            }
            return result;
        }
        try {
            if ("1".equals(formulatype) || "2".equals(formulatype) || "4".equals(formulatype) && formula.contains(IF_PRE)) {
                return CalculateService.numberToString(formula, fieldType);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return "0";
        }
        return formula;
    }

    private static String numberToString(String formula, EntityField fieldType) {
        if (StringUtil.isBlank((CharSequence)formula)) {
            return "0";
        }
        try {
            double values = Parser.parse(formula.replaceAll(" ", "")).evaluate();
            if (Math.abs(values) <= EPSILON) {
                return "0";
            }
            BigDecimal b = BigDecimal.valueOf(values);
            String s = DataFormatUtils.decimalFormat(b, fieldType);
            return null == swapMap.get(s) ? s : swapMap.get(s);
        }
        catch (ParseException e) {
            logger.error("numberToString error by formula:" + formula, (Throwable)e);
            return "0";
        }
    }

    public static boolean check(String formula, String formulaKey) {
        try {
            Object result = FelService.evalWithKey(formula, formulaKey);
            if (result != null) {
                if ("true".equals(result.toString())) {
                    return true;
                }
                if (result instanceof Integer) {
                    return (Integer)result > 0;
                }
                if (result instanceof Byte) {
                    return (Byte)result > 0;
                }
            }
        }
        catch (FelException e) {
            logger.error((Throwable)e);
        }
        return false;
    }

    public static boolean checkOld(String formula) {
        try {
            double values;
            if (formula.startsWith("#")) {
                String s = VelocityUtils.velocityEngine(null, formula).toString();
                values = Parser.parse(s.replaceAll(" ", "")).evaluate();
            } else {
                values = Parser.parse(formula.replaceAll(" ", "")).evaluate();
            }
            return values > 0.0;
        }
        catch (Exception e) {
            logger.error("check method error by formula:" + formula, (Throwable)e);
            return false;
        }
    }

    public static String format(String key, Object obj, EntityField cellStyle) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
            try {
                if (obj instanceof Double) {
                    double values = (Double)obj;
                    if (Math.abs(values) <= EPSILON) {
                        values = 0.0;
                    }
                    BigDecimal b = BigDecimal.valueOf(values);
                    result = DataFormatUtils.decimalFormat(b, cellStyle);
                } else if (obj instanceof Integer) {
                    int values = (Integer)obj;
                    if ((double)Math.abs(values) <= EPSILON) {
                        values = 0;
                    }
                    BigDecimal b = BigDecimal.valueOf(values);
                    result = DataFormatUtils.decimalFormat(b, cellStyle);
                } else if (obj instanceof Long) {
                    long values = (Long)obj;
                    if ((double)Math.abs(values) <= EPSILON) {
                        values = 0L;
                    }
                    BigDecimal b = BigDecimal.valueOf(values);
                    result = DataFormatUtils.decimalFormat(b, cellStyle);
                } else if (obj instanceof String && StringUtil.isBlank((CharSequence)((CharSequence)obj))) {
                    result = CalculateService.getDefaultValue(cellStyle);
                }
            }
            catch (Exception e) {
                logger.error("\u6267\u884cCalculateService.format\u5f02\u5e38,key={},result={}", new Object[]{key, result, e});
            }
        } else {
            result = CalculateService.getDefaultValue(cellStyle);
        }
        return result;
    }

    private static String getDefaultValue(EntityField cellStyle) {
        if (cellStyle != null && cellStyle.getFieldType() != null) {
            String fieldType = cellStyle.getFieldType();
            if (DataFormatUtils.NUMBERIC_TYPE.contains(fieldType)) {
                if (cellStyle.getDefaultValue() != null && !"".equals(cellStyle.getDefaultValue())) {
                    return (String)cellStyle.getDefaultValue();
                }
                return "0";
            }
            if (DataFormatUtils.TEXT_TYPE.contains(fieldType) || DataFormatUtils.DATE_TYPE.contains(fieldType)) {
                return "";
            }
        }
        return "";
    }

    public static String calculateWithLog(String formula) {
        String result = "";
        if (StringUtil.isBlank((CharSequence)formula)) {
            return result;
        }
        Object resultObj = FelService.eval(formula, true);
        result = String.valueOf(resultObj);
        return result;
    }
}

