/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.context;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.refactor.formula.value.GetValueService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.CellFormatModel;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;

public abstract class AbstractContext
implements Context {
    protected Map<String, Object> param;
    protected Map<String, String> data;
    protected Map<String, String> errorInfo;
    protected Map<String, FormulaVo> formulas;
    protected String formula;
    private GetValueService getValueService;
    private Map<String, String> sqlValues;
    private Map<String, String> metadataSqlValues;
    private CopyOnWriteArrayList<String> msqlKeys = new CopyOnWriteArrayList();
    private Map<String, String> constValues;
    private Map<String, String> paramValues;
    protected Map<String, Object> businessParam;
    protected Map<String, EntityField> allEntityFieldByType;
    private Map<String, String> cpValues;
    private static final List<String> noChangeTypes = Lists.newArrayList((Object[])new String[]{"A", "C", "M"});
    protected Map<String, String> variableKey;
    protected Map<String, CellFormatModel> allCellFormat;
    protected Map<String, String> ruleValues;
    protected Long tmpId;
    protected int calType;

    public AbstractContext() {
        this.errorInfo = new ConcurrentHashMap<String, String>();
        this.param = new HashMap<String, Object>();
        this.sqlValues = new HashMap<String, String>();
        this.metadataSqlValues = new ConcurrentHashMap<String, String>();
        this.constValues = new HashMap<String, String>();
        this.paramValues = new HashMap<String, String>();
        this.getValueService = new GetValueService(this);
        this.ruleValues = new HashMap<String, String>();
        this.allEntityFieldByType = new HashMap<String, EntityField>();
        this.cpValues = new ConcurrentHashMap<String, String>();
    }

    public String parse(FormulaVo formulaVo) {
        String ret = formulaVo.getFormula();
        if (StringUtils.isEmpty((String)ret)) {
            return "";
        }
        ret = this.parseFormula(formulaVo, ret);
        return ret;
    }

    private String parseFormula(FormulaVo formulaVo, String ret) {
        try {
            if (ret.contains("{calType}")) {
                ret = ret.replaceAll("\\{calType\\}", String.valueOf(this.calType));
            }
            if (formulaVo.isParsed() && !formulaVo.isNested()) {
                for (Map<String, String> parseInfo : formulaVo.getParseInfos()) {
                    String formulaStr = ParseUtils.getOrginalStr(parseInfo);
                    String value = this.getCalValue(formulaVo, parseInfo, formulaVo.isNested());
                    ret = ret.replace(formulaStr, value == null ? "" : value);
                }
            } else {
                ArrayList<Map<String, String>> parseInfos = new ArrayList<Map<String, String>>(16);
                List<String> list = ParseUtils.parseformula(ret);
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String formulaStr;
                    Map<String, String> map = ParseUtils.parseFormulaZKH(formulaStr = iterator.next());
                    String value = this.getCalValue(formulaVo, map, formulaVo.isNested());
                    ret = ret.replace(formulaStr, value == null ? "" : value);
                    parseInfos.add(map);
                }
                formulaVo.setParsed(true);
                formulaVo.setParseInfos(parseInfos);
            }
            if (ParseUtils.isFormulaFormat(ret)) {
                FormulaVo clone = formulaVo.clone();
                clone.setParsed(false);
                clone.setNested(true);
                ret = this.parseFormula(clone, ret);
            }
        }
        catch (StackOverflowError e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format("%s cased StackOverflowError", formulaVo.getFormulaKey())), new Object[0]);
        }
        return ret;
    }

    private String getCalValue(FormulaVo formulaVo, Map<String, String> parseInfo, boolean nested) {
        String value;
        if (!nested && noChangeTypes.contains(ParseUtils.getType(parseInfo)) && Objects.equals(parseInfo.get("isCalced"), "true")) {
            value = parseInfo.get("calV");
        } else {
            value = this.getValue(parseInfo, formulaVo);
            parseInfo.put("isCalced", "true");
            parseInfo.put("calV", value);
        }
        return value;
    }

    public String parseNew(FormulaVo formulaVo) {
        String ret = formulaVo.getFormula();
        if (StringUtils.isEmpty((String)ret)) {
            return this.putDefautData(ret);
        }
        ret = this.parseFormulaNew(formulaVo, ret);
        return ret;
    }

    private String parseFormulaNew(FormulaVo formulaVo, String ret) {
        try {
            if (ret.contains("{calType}")) {
                ret = ret.replaceAll("\\{calType\\}", String.valueOf(this.calType));
            }
            List<Map<String, String>> list = ParseUtils.parseformulaTypeKey(ret);
            for (Map<String, String> formulaMap : list) {
                String value = this.getValue(formulaMap, formulaVo);
                ret = ret.replace("{" + formulaMap.get("type") + "[" + formulaMap.get("value") + "]}", value == null ? "" : value);
            }
            if (ParseUtils.isFormulaFormat(ret)) {
                ret = this.parseFormula(formulaVo, ret);
            }
        }
        catch (StackOverflowError e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format("%s cased StackOverflowError", formulaVo.getFormulaKey())), new Object[0]);
        }
        return ret;
    }

    public String parseWithLog(String formula, List<String> logs) {
        String ret = formula;
        if (StringUtils.isEmpty((String)ret)) {
            return this.putDefautData(ret);
        }
        FormulaVo formulaVo = new FormulaVo("parseWithLog", "1", formula);
        return this.parseFormulaWithLogs(formulaVo, ret, logs);
    }

    private String parseFormulaWithLogs(FormulaVo formulaVo, String ret, List<String> logs) {
        try {
            List<String> list = ParseUtils.parseformula(ret);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String formulaStr;
                Map<String, String> map = ParseUtils.parseFormulaZKH(formulaStr = iterator.next());
                String value = this.getValueWithLog(map, formulaVo, logs);
                ret = ret.replace(formulaStr, value == null ? "" : value);
            }
            if (ParseUtils.isFormulaFormat(ret)) {
                ret = this.parseFormulaWithLogs(formulaVo, ret, logs);
            }
        }
        catch (StackOverflowError e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format("%s cased StackOverflowError", formulaVo.getFormulaKey())), new Object[0]);
        }
        return ret;
    }

    @Override
    public abstract String calculate(FormulaVo var1);

    public String getValue(Map<String, String> map, FormulaVo formulaVo) {
        return this.getValueService.getValue(ParseUtils.getType(map), ParseUtils.getValue(map), formulaVo);
    }

    public String getValueWithLog(Map<String, String> map, FormulaVo formulaVo, List<String> logs) {
        return this.getValueService.getValueWithLog(ParseUtils.getType(map), ParseUtils.getValue(map), formulaVo, logs);
    }

    @Override
    public Map<String, Object> getParam() {
        return this.param;
    }

    @Override
    public Map<String, Object> getBusinessParam() {
        return this.businessParam;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public Map<String, FormulaVo> getFormulas() {
        return this.formulas;
    }

    public String getFormula() {
        return this.formula;
    }

    @Override
    public Map<String, String> getSqlValues() {
        return this.sqlValues;
    }

    @Override
    public Map<String, String> getMetadataSqlValues() {
        return this.metadataSqlValues;
    }

    @Override
    public List<String> getMsqlKeys() {
        return this.msqlKeys;
    }

    @Override
    public Map<String, EntityField> getAllEntityFieldByType() {
        return this.allEntityFieldByType;
    }

    @Override
    public Map<String, String> getConstValues() {
        return this.constValues;
    }

    @Override
    public Map<String, String> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(Map<String, String> paramValues) {
        this.paramValues = paramValues;
    }

    @Override
    public Map<String, String> getVariableKey() {
        return this.variableKey;
    }

    @Override
    public Map<String, String> getRuleValues() {
        return this.ruleValues;
    }

    public Map<String, String> getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(Map<String, String> errorInfo) {
        this.errorInfo = errorInfo;
    }

    @Override
    public String putDefautData(Object formula) {
        this.data.put((String)formula, "0");
        return "0";
    }

    @Override
    public Long getTmpId() {
        return this.tmpId;
    }

    @Override
    public Map<String, CellFormatModel> getAllCellFormat() {
        if (null == this.allCellFormat) {
            return new HashMap<String, CellFormatModel>();
        }
        return this.allCellFormat;
    }

    @Override
    public Map<String, String> getCpValues() {
        return this.cpValues;
    }
}

