/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.context;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.cal.CalculateService;
import kd.taxc.bdtaxr.common.refactor.formula.context.AbstractContext;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalculateTask;
import kd.taxc.bdtaxr.common.refactor.formula.context.MexcuteTask;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.FormulaCalVo;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class CalFormulaContext
extends AbstractContext {
    private static Log logger = LogFactory.getLog(CalFormulaContext.class);

    public Map<String, String> initCal(FormulaCalVo formulaCalVo, Map<String, String> data, Map<String, FormulaVo> formulas, Map<String, String> rformulas, Map<String, String> mFormulasMap) {
        this.formulas = formulas;
        this.data = data;
        Map<String, Object> paramMap = formulaCalVo.getParamMap();
        this.param = new ConcurrentHashMap(paramMap.size());
        this.putMap(this.param, paramMap);
        this.businessParam = formulaCalVo.getBusinessParam();
        this.allCellFormat = formulaCalVo.getAllCellFormat();
        this.allEntityFieldByType = new HashMap();
        this.variableKey = new HashMap();
        this.ruleValues = rformulas;
        this.tmpId = formulaCalVo.getTemplateId();
        this.calType = 0;
        if (!CollectionUtils.isEmpty(formulaCalVo.getMetaTypeMap())) {
            this.allEntityFieldByType.putAll(formulaCalVo.getMetaTypeMap());
        }
        CacheUtils.setRuleFormulas(formulaCalVo.getTemplateId(), rformulas);
        ArrayList<FormulaVo> formulaList = new ArrayList<FormulaVo>();
        ArrayList<FormulaVo> firstList = new ArrayList<FormulaVo>();
        ArrayList<FormulaVo> secondList = new ArrayList<FormulaVo>();
        long time = System.currentTimeMillis();
        MexcuteTask task = new MexcuteTask(mFormulasMap, this);
        ThreadPoolsService.getInstance().submit(task);
        logger.info("\u8ba1\u7b97\u516c\u5f0f\u8017\u65f6:M\u516c\u5f0f\u6267\u884c\u65f6\u95f4--mFormulas--" + (System.currentTimeMillis() - time));
        for (Map.Entry<String, FormulaVo> formula : formulas.entrySet()) {
            if (!formula.getKey().contains("#")) continue;
            String[] ary = formula.getKey().split("#");
            if ("tcret_ccxws_zb_hb".equals(ary[0]) && "taxtype".equals(ary[2])) {
                firstList.add(formula.getValue());
                continue;
            }
            secondList.add(formula.getValue());
        }
        formulaList.addAll(firstList);
        formulaList.addAll(secondList);
        long time1 = System.currentTimeMillis();
        CalculateTask calculateTask = new CalculateTask(formulaList, this);
        ThreadPoolsService.getInstance().submit(calculateTask);
        logger.info("\u8ba1\u7b97\u516c\u5f0f\u8017\u65f6:\u591a\u7ebf\u7a0b\u6267\u884c\u8ba1\u7b97\u516c\u5f0f\uff1a{} ms", (Object)(System.currentTimeMillis() - time1));
        logger.info("\u8ba1\u7b97\u516c\u5f0f\u8017\u65f6:\u6240\u6709\u516c\u5f0f\u6267\u884c\u65f6\u95f4--all--" + (System.currentTimeMillis() - time));
        return data;
    }

    private void putMap(Map<String, Object> targetMap, Map<String, Object> sourceMap) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (StringUtil.isEmpty((CharSequence)key) || value == null) {
                logger.info("\u53c2\u6570\u4e3a\u7a7a\u7684\u6570\u636e\u5254\u9664\uff1akey={},value={}", (Object)key, value);
                continue;
            }
            targetMap.put(key, value);
        }
    }

    public Map<String, String> calcUnknownKeys(Map<String, String> data, Map<String, Object> param, Map<String, FormulaVo> formulas, Map<String, EntityField> typeMap) {
        this.formulas = formulas;
        this.data = data;
        this.param = param;
        this.allEntityFieldByType = typeMap;
        this.variableKey = new HashMap();
        for (Map.Entry<String, FormulaVo> formula : formulas.entrySet()) {
            if (data.get(formula.getKey()) != null) continue;
            this.calculate(formula.getValue());
        }
        return data;
    }

    public Map<String, String> cal(Map<String, String> data, FormulaCalVo formulaCalVo, Map<String, FormulaVo> formulas, Map<String, Map<String, String>> classformula, Map<String, String> rformulaMap, String ... key) {
        this.data = data;
        this.param = formulaCalVo.getParamMap();
        this.businessParam = formulaCalVo.getBusinessParam();
        this.formulas = formulas;
        this.allCellFormat = formulaCalVo.getAllCellFormat();
        this.variableKey = new LinkedHashMap();
        this.tmpId = formulaCalVo.getTemplateId();
        this.allEntityFieldByType = new HashMap();
        this.calType = 1;
        Map<String, String> ruleFormulasMap = CacheUtils.getRuleFormulas(this.tmpId);
        if (CollectionUtils.isEmpty(ruleFormulasMap)) {
            CacheUtils.setRuleFormulas(this.tmpId, rformulaMap);
        }
        if (!CollectionUtils.isEmpty(formulaCalVo.getMetaTypeMap())) {
            this.allEntityFieldByType.putAll(formulaCalVo.getMetaTypeMap());
        }
        this.ruleValues = ruleFormulasMap;
        for (String k : key) {
            this.calValues(classformula, formulas, k);
        }
        this.calVariableFormulaKey(formulas);
        return data;
    }

    public Map<String, String> linkageCal(Map<String, String> variableKeys, Map<String, String> data, FormulaCalVo formulaCalVo, Map<String, FormulaVo> formulas, Map<String, String> rformulaMap, String ... key) {
        this.data = data;
        this.param = formulaCalVo.getParamMap();
        this.businessParam = formulaCalVo.getBusinessParam();
        this.formulas = formulas;
        this.allCellFormat = formulaCalVo.getAllCellFormat();
        this.variableKey = variableKeys;
        this.tmpId = formulaCalVo.getTemplateId();
        this.allEntityFieldByType = new HashMap();
        this.calType = 1;
        Map<String, String> ruleFormulasMap = CacheUtils.getRuleFormulas(this.tmpId);
        if (CollectionUtils.isEmpty(ruleFormulasMap)) {
            CacheUtils.setRuleFormulas(this.tmpId, rformulaMap);
        }
        this.ruleValues = ruleFormulasMap;
        if (!CollectionUtils.isEmpty(formulaCalVo.getMetaTypeMap())) {
            this.allEntityFieldByType.putAll(formulaCalVo.getMetaTypeMap());
        }
        HashSet<String> set = new HashSet<String>(variableKeys.keySet());
        for (String k : set) {
            FormulaVo f = formulas.get(k);
            if (null == f) continue;
            this.calculate(f);
        }
        return data;
    }

    public String calculateNew(FormulaVo formulaVo) {
        if (StringUtils.isNotBlank((CharSequence)formulaVo.getFormulaKey())) {
            long l = System.currentTimeMillis();
            String f = this.parseNew(formulaVo);
            long l1 = System.currentTimeMillis();
            if (l1 - l > 5L) {
                logger.info("2\u6267\u884cCalFormulaContext.calculate ,formulaKey={},\u66ff\u6362\u540e\u7684formula={},cost:{}ms", new Object[]{formulaVo.getFormulaKey(), f, l1 - l});
            }
            String value = CalculateService.calculate(f, formulaVo.getFormulaType(), this.allEntityFieldByType.get(formulaVo.getFormulaKey()) instanceof EntityField ? (EntityField)this.allEntityFieldByType.get(formulaVo.getFormulaKey()) : (EntityField)JSONObject.parseObject((String)JSON.toJSONString(this.allEntityFieldByType.get(formulaVo.getFormulaKey())), EntityField.class), formulaVo.getFormulaKey(), true, this.errorInfo);
            if (System.currentTimeMillis() - l1 > 5L) {
                logger.info("3\u6267\u884cCalFormulaContext.calculate ,formulaKey={},\u6700\u7ec8\u516c\u5f0f\u7684\u503cvalue={},cost:{}ms", new Object[]{formulaVo.getFormulaKey(), value, System.currentTimeMillis() - l1});
            }
            this.data.put(formulaVo.getFormulaKey(), value);
            if (System.currentTimeMillis() - l > 5L) {
                logger.info("4\u6267\u884cCalFormulaContext.calculate ,formulaKey={},#calculate cost:{}ms", (Object)formulaVo.getFormulaKey(), (Object)(System.currentTimeMillis() - l));
            }
            return (String)this.data.get(formulaVo.getFormulaKey());
        }
        return null;
    }

    private void calValues(Map<String, Map<String, String>> classformula, Map<String, FormulaVo> formulas, String key) {
        Map<String, String> calFormula = classformula.get(key);
        if (null != calFormula && calFormula.get(key) != null) {
            return;
        }
        if (null != calFormula && calFormula.size() > 0) {
            for (String k : calFormula.keySet()) {
                FormulaVo f = formulas.get(k);
                if (null == f) continue;
                this.getVariableKey().put(f.getFormulaKey(), f.getFormulaKey());
                this.calValues(classformula, formulas, f.getFormulaKey());
            }
        }
    }

    private void calVariableFormulaKey(Map<String, FormulaVo> formulas) {
        Map<String, String> map = this.getVariableKey();
        LinkedHashSet<String> set = new LinkedHashSet<String>(map.keySet());
        for (String key : set) {
            FormulaVo f = formulas.get(key);
            if (null == f) continue;
            this.calculate(f);
        }
    }

    @Override
    public String calculate(FormulaVo formulaVo) {
        if (StringUtils.isNotBlank((CharSequence)formulaVo.getFormulaKey())) {
            long l = System.currentTimeMillis();
            String f = this.parse(formulaVo);
            long l1 = System.currentTimeMillis();
            if (l1 - l > 5L) {
                logger.info("2\u6267\u884cCalFormulaContext.calculate ,formulaKey={},\u66ff\u6362\u540e\u7684formula={},cost:{}ms", new Object[]{formulaVo.getFormulaKey(), f, l1 - l});
            }
            String value = CalculateService.calculate(f, formulaVo.getFormulaType(), this.allEntityFieldByType.get(formulaVo.getFormulaKey()) instanceof EntityField ? (EntityField)this.allEntityFieldByType.get(formulaVo.getFormulaKey()) : (EntityField)JSONObject.parseObject((String)JSON.toJSONString(this.allEntityFieldByType.get(formulaVo.getFormulaKey())), EntityField.class), formulaVo.getFormulaKey(), true, this.errorInfo);
            if (System.currentTimeMillis() - l1 > 5L) {
                logger.info("3\u6267\u884cCalFormulaContext.calculate ,formulaKey={},\u6700\u7ec8\u516c\u5f0f\u7684\u503cvalue={},cost:{}ms", new Object[]{formulaVo.getFormulaKey(), value, System.currentTimeMillis() - l1});
            }
            this.data.put(formulaVo.getFormulaKey(), value);
            if (System.currentTimeMillis() - l > 5L) {
                logger.info("4\u6267\u884cCalFormulaContext.calculate ,formulaKey={},#calculate cost:{}ms", (Object)formulaVo.getFormulaKey(), (Object)(System.currentTimeMillis() - l));
            }
            return (String)this.data.get(formulaVo.getFormulaKey());
        }
        return null;
    }

    public Map<String, Object> previewFormula(String formula) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        Boolean success = Boolean.FALSE;
        ArrayList<String> logs = new ArrayList<String>(32);
        try {
            logs.add(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884cCalFormulaContext.previewFormula\uff0c\u539fformula=%s", (String)"CalFormulaContext_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), formula));
            String f = this.parseWithLog(formula, logs);
            logs.add(String.format(ResManager.loadKDString((String)"\u6267\u884cCalFormulaContext.previewFormula\uff0c\u66ff\u6362\u540e\u7684formula=%s", (String)"CalFormulaContext_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), f));
            if (!f.startsWith("{") || !f.endsWith("}")) {
                String value = CalculateService.calculateWithLog(f);
                resultMap.put("data", value);
            } else {
                resultMap.put("data", f);
            }
            success = Boolean.TRUE;
        }
        catch (Exception e) {
            logs.add(ResManager.loadKDString((String)"\u516c\u5f0f\u9884\u89c8\u5f02\u5e38\uff01", (String)"CalFormulaContext_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            logs.add(StringUtil.getStackTraceMessage(e));
        }
        resultMap.put("success", success);
        resultMap.put("logs", logs);
        return resultMap;
    }

    public static void main(String[] args) {
        String str = "tcvat_ybnsr_jsxm_10_swsxdmm";
        String str2 = str.replaceAll("[0-9]", "0");
        System.out.println(str2);
        System.out.println(str2.replaceAll("(0)\\1+", "0"));
        System.out.println(String.format("%s_%s_%s", 1, 2, 3));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("C", "{Q[A]}+{Q[B]}");
        map.put("D", "{Q[A]}+{Q[B]}");
        HashMap result = new HashMap();
        HashMap listMap = new HashMap();
        ArrayList<String> listA = new ArrayList<String>();
        listA.add("A1");
        listA.add("A2");
        listA.add("A3");
        listMap.put("A", listA);
        ArrayList<String> listB = new ArrayList<String>();
        listB.add("B1");
        listB.add("B2");
        listB.add("B3");
        listMap.put("B", listB);
        ArrayList<String> listC = new ArrayList<String>();
        listC.add("C1");
        listC.add("C2");
        listC.add("C3");
        listMap.put("C", listC);
        map.keySet().stream().forEach(v -> {
            List list = (List)listMap.get(v);
            if (list != null && list.size() > 0) {
                String formula = (String)map.get(v);
                for (int i = 0; i < list.size(); ++i) {
                    String formulaTemp = formula;
                    String regx = "\\[(.*?)]";
                    Pattern pattern = Pattern.compile(regx);
                    Matcher matcher = pattern.matcher(formula);
                    while (matcher.find()) {
                        String matchKey = matcher.group(1);
                        List list2 = (List)listMap.get(matchKey);
                        if (list2 == null || list2.size() <= 0) continue;
                        formulaTemp = formulaTemp.replaceAll(matchKey, (String)list2.get(i));
                    }
                    result.put(list.get(i), formulaTemp);
                }
            }
        });
    }
}

