/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.context;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.threadpools.Task;

public class CalculateTask
extends Task<List<FormulaVo>> {
    private static Log logger = LogFactory.getLog(CalculateTask.class);
    private List<FormulaVo> formulas;
    private Context context;
    private static final int FORMULA_SIZE = 5;

    public CalculateTask(List<FormulaVo> formulas, Context context) {
        this.formulas = formulas;
        this.context = context;
    }

    @Override
    public List<List<FormulaVo>> getValue() {
        long t1 = System.currentTimeMillis();
        ArrayList<List<FormulaVo>> list = new ArrayList<List<FormulaVo>>();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int i = availableProcessors > 0 ? availableProcessors : 4;
        logger.info("\u8ba1\u7b97\u516c\u5f0f\u591a\u7ebf\u7a0b\u6267\u884c:\u516c\u5f0f\u91cf={}\uff0cCPU\u6838\u5fc3\u6570={}", (Object)this.formulas.size(), (Object)i);
        int batchSize = this.formulas.size() / (i * 2);
        list.addAll(Lists.partition(this.formulas, (int)(batchSize > 0 ? batchSize : 16)));
        long t2 = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u516c\u5f0f\u591a\u7ebf\u7a0b\u6267\u884c\u5f52\u7c7b\u8017\u65f6\uff1a{} ms,\u6279\u6570\uff1a", (Object)(t2 - t1), (Object)list.size());
        return list;
    }

    @Override
    public List<FormulaVo> executor(List<FormulaVo> list) {
        long t1 = System.currentTimeMillis();
        for (FormulaVo vo : list) {
            this.context.calculate(vo);
        }
        long t2 = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u516c\u5f0f\u591a\u7ebf\u7a0b\u6267\u884c\u8017\u65f6\uff1a{} ms,\u516c\u5f0f\uff1a{}\u6761", (Object)(t2 - t1), (Object)list.size());
        return null;
    }
}

