/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.context;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.formula.sql.ParseSqlUtils;
import kd.taxc.bdtaxr.common.formula.sql.SqlVo;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.MetadataGetValue;
import kd.taxc.bdtaxr.common.threadpools.Task;

public class MexcuteTask
extends Task<List<String>> {
    private static Log logger = LogFactory.getLog(MexcuteTask.class);
    private Map<String, String> mformulas;
    private Context context;
    private static final String[] EXCLUDE_KEYWORDS = new String[]{" distinct ", " DISTINCT "};
    private static final int SQL_SIZE = 2;

    public MexcuteTask(Map<String, String> mformulas, Context context) {
        this.mformulas = mformulas;
        this.context = context;
    }

    @Override
    public List<List<String>> getValue() {
        ParseSqlUtils utils = new ParseSqlUtils();
        for (Map.Entry<String, String> entry : this.mformulas.entrySet()) {
            if (Arrays.stream(EXCLUDE_KEYWORDS).anyMatch(v -> ((String)entry.getKey()).contains((CharSequence)v))) continue;
            utils.parseSql(entry.getValue(), entry.getKey());
        }
        Map<String, SqlVo> data = utils.getData();
        List sqlVoList = data.values().stream().collect(Collectors.toList());
        Map<String, List<SqlVo>> listMap = sqlVoList.stream().collect(Collectors.groupingBy(SqlVo::getFromWhere));
        ArrayList<String> list = new ArrayList<String>(listMap.size());
        for (Map.Entry<String, List<SqlVo>> entry : listMap.entrySet()) {
            StringBuilder sql = new StringBuilder("select ");
            for (SqlVo v2 : entry.getValue()) {
                String s = v2.getField().toLowerCase();
                if (s.indexOf(" as ") > 0) {
                    s = s.substring(0, s.indexOf(" as "));
                }
                sql.append(s.trim()).append(" as ").append(v2.getMd5()).append(',');
            }
            sql.deleteCharAt(sql.length() - 1).append(" from ").append(entry.getValue().get(0).getTable()).append(" where ").append(entry.getValue().get(0).getWhere());
            list.add(sql.toString());
        }
        return Lists.partition(list, (int)2);
    }

    @Override
    public List<String> executor(List<String> list) {
        MetadataGetValue m = new MetadataGetValue(this.context);
        ArrayList<String> valueList = new ArrayList<String>(1);
        for (String str : list) {
            valueList.add(m.getValue(str, null));
        }
        return valueList;
    }

    private List<String> reBuildList(List<Object> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object obj : list) {
            List sqlVoList = (List)obj;
            Map<String, List<SqlVo>> listMap = sqlVoList.stream().collect(Collectors.groupingBy(SqlVo::getWhere));
            for (SqlVo sqlVo : sqlVoList) {
            }
        }
        return result;
    }

    private void listSplit(List<SqlVo> list, List<Object> result) {
        int rows = list.size();
        int pageSum = rows % 2 == 0 ? rows / 2 : rows / 2 + 1;
        for (int i = 0; i < pageSum; ++i) {
            if (i == 0) {
                result.add(list.subList(0, 2));
                continue;
            }
            if (i == pageSum - 1) {
                result.add(list.subList(2 * i, rows));
                continue;
            }
            result.add(list.subList(2 * i, 2 * i + 2));
        }
    }
}

