/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class QueryFormulaService {
    private static Log logger = LogFactory.getLog(QueryFormulaService.class);
    public static final String fields = "templatenum,formulakey,table,row,column,formula,title,content,celltype,formulatype,formulaname,name,describe";
    public static final String entry = "bdtaxr_formula_edit";
    private static final String TEMPLATE_MAIN_ENTITY_NAME = "bdtaxr_template_main";

    public static List<FormulaVo> queryDBFormulaByTmpId(Long tmpId) {
        DynamicObject[] objs = QueryFormulaService.getFormulaList(tmpId);
        if (objs == null || objs.length == 0) {
            return new ArrayList<FormulaVo>(1);
        }
        ArrayList<FormulaVo> list = new ArrayList<FormulaVo>(objs.length);
        for (DynamicObject dynObj : objs) {
            FormulaVo formulaVo = QueryFormulaService.buildFormulaVo(dynObj);
            list.add(formulaVo);
        }
        return list;
    }

    public static Map<String, FormulaVo> queryDBFormulaById(Long tmpId) {
        long time = System.currentTimeMillis();
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>(16);
        for (DynamicObject dynObj : QueryFormulaService.getFormulaList(tmpId)) {
            FormulaVo formulaVo = QueryFormulaService.buildFormulaVo(dynObj);
            result.put(formulaVo.getFormulaKey(), formulaVo);
        }
        logger.info("logflag \u67e5\u8be2\u516c\u5f0f\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return result;
    }

    public static Map<String, FormulaVo> queryDBFormulaById(Long tmpId, String formulaType) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>(16);
        for (DynamicObject dynObj : QueryFormulaService.getCellFormulaList(tmpId, formulaType)) {
            FormulaVo formulaVo = QueryFormulaService.buildFormulaVo(dynObj);
            result.put(formulaVo.getFormulaKey(), formulaVo);
        }
        return result;
    }

    private static FormulaVo buildFormulaVo(DynamicObject dynObj) {
        FormulaVo formulaVo = new FormulaVo();
        String key = dynObj.getString("formulakey");
        String formula = dynObj.getString("formula");
        formulaVo.setFormula(formula);
        formulaVo.setFormulaKey(key);
        formulaVo.setFormulaType(dynObj.getString("formulatype"));
        formulaVo.setCellType(dynObj.getString("celltype"));
        String formulaname = dynObj.getString("formulaname");
        formulaVo.setFormulaName(StringUtil.isNotEmpty((CharSequence)formulaname) ? formulaname.replace("\t", "") : formulaname);
        formulaVo.setContent(dynObj.getString("content"));
        String title = dynObj.getString("title");
        formulaVo.setTitle(title);
        formulaVo.setName(dynObj.getString("name"));
        formulaVo.setTable(dynObj.getString("table"));
        formulaVo.setRow(dynObj.getString("row"));
        formulaVo.setColumn(dynObj.getString("column"));
        formulaVo.setDescribe(dynObj.getString("describe"));
        return formulaVo;
    }

    public static DynamicObject[] getFormulaList(Long tmpId) {
        QFilter filter1 = new QFilter("templateid", "=", (Object)String.valueOf(tmpId));
        QFilter filter2 = new QFilter("formulatype", "!=", (Object)"3");
        QFilter filter3 = new QFilter("formulatype", "!=", (Object)"2");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entry, (String)fields, (QFilter[])new QFilter[]{filter1, filter2, filter3});
        return dynamicObjects;
    }

    private static DynamicObject[] getCellFormulaList(Long tmpId, String formulaType) {
        QFilter filter1 = new QFilter("templateid", "=", (Object)String.valueOf(tmpId));
        QFilter filter2 = new QFilter("formulatype", "=", (Object)formulaType);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entry, (String)fields, (QFilter[])new QFilter[]{filter1, filter2});
        return dynamicObjects;
    }

    public static List<FormulaVo> queryDBCellConfig(String type, String startData, String endData, String templateid) {
        return QueryFormulaService.queryDBFormulaListByType(type, "3", startData, endData, templateid);
    }

    public static List<FormulaVo> queryDBFormulaType(String type, String startData, String endData, String templateid) {
        return QueryFormulaService.queryDBFormulaListByType(type, "2", startData, endData, templateid);
    }

    @Deprecated
    private static List<FormulaVo> queryDBFormulaListByType(String type, String formualType, String startData, String endData, String templateid) {
        ArrayList<FormulaVo> list = new ArrayList<FormulaVo>();
        QFilter q = new QFilter("taxtype", "=", (Object)type);
        QFilter q1 = new QFilter("formulatype", "=", (Object)formualType);
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        listFilters.add(q);
        listFilters.add(q1);
        if (StringUtil.isNotEmpty((CharSequence)templateid)) {
            QFilter q2 = new QFilter("templateid", "=", (Object)templateid);
            listFilters.add(q2);
        } else {
            QFilter qFilter3;
            DynamicObject dynamicObject = null;
            QFilter qFilter1 = new QFilter("type", "=", (Object)type);
            QFilter qFilter2 = new QFilter("startdate", "<=", (Object)DateUtils.stringToDate(startData, "yyyy-MM-dd"));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)TEMPLATE_MAIN_ENTITY_NAME, (String)"id,number,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3 = QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate(startData, "yyyy-MM-dd")))});
            if (collection != null && !collection.isEmpty()) {
                dynamicObject = (DynamicObject)collection.get(0);
            }
            if (null != dynamicObject) {
                QFilter q2 = new QFilter("templateid", "=", (Object)dynamicObject.getString("id"));
                listFilters.add(q2);
            }
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])listFilters.toArray(new QFilter[listFilters.size()]));
        doc.stream().forEach(d -> {
            FormulaVo f = QueryFormulaService.buildFormulaVo(d);
            list.add(f);
        });
        return list;
    }

    public static List<FormulaVo> queryDBFormulaListByType(String type, String formualType, String templateid) {
        ArrayList<FormulaVo> list = new ArrayList<FormulaVo>();
        QFilter q = new QFilter("taxtype", "=", (Object)type);
        QFilter q1 = new QFilter("formulatype", "=", (Object)formualType);
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        QFilter q2 = new QFilter("templateid", "=", (Object)templateid);
        listFilters.add(q2);
        listFilters.add(q);
        listFilters.add(q1);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])listFilters.toArray(new QFilter[listFilters.size()]));
        doc.stream().forEach(d -> {
            FormulaVo f = QueryFormulaService.buildFormulaVo(d);
            list.add(f);
        });
        return list;
    }

    public static Map<String, List<FormulaVo>> queryDBFormulaListByTemplate(String formulaType, List<String> templates) {
        QFilter q1 = new QFilter("formulatype", "=", (Object)formulaType);
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        listFilters.add(q1);
        listFilters.add(new QFilter("templatenum", "in", templates));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])listFilters.toArray(new QFilter[listFilters.size()]));
        HashMap<String, List<FormulaVo>> result = new HashMap<String, List<FormulaVo>>();
        Map formulaMap = doc.stream().collect(Collectors.groupingBy(d -> d.getString("templatenum"), Collectors.toList()));
        formulaMap.forEach((k, v) -> result.put((String)k, v.stream().map(QueryFormulaService::buildFormulaVo).collect(Collectors.toList())));
        return result;
    }

    public static Map<String, FormulaVo> getFormulaVoMap(List<QFilter> listFilters) {
        HashMap<String, FormulaVo> map = new HashMap<String, FormulaVo>();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])listFilters.toArray(new QFilter[listFilters.size()]));
        doc.stream().forEach(d -> {
            FormulaVo f = QueryFormulaService.buildFormulaVo(d);
            map.put(f.getFormulaKey(), f);
        });
        return map;
    }

    public static boolean deleteFormulaByKeyAndType(String formulaType, String formulaKey, Long templateId) {
        QFilter qFilter = new QFilter("formulakey", "=", (Object)formulaKey);
        QFilter qFilte2 = new QFilter("formulatype", "=", (Object)formulaType);
        QFilter qFilte3 = new QFilter("templateid", "=", (Object)templateId);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilte2, qFilte3};
        DeleteServiceHelper.delete((String)entry, (QFilter[])qFilters);
        return true;
    }

    public static List<FormulaVo> queryDBFormulaByFormulaKey(String formulaType, String formulaKey, String templateId) {
        ArrayList<FormulaVo> list = new ArrayList<FormulaVo>();
        QFilter q = new QFilter("formulakey", "=", (Object)formulaKey);
        QFilter q1 = new QFilter("formulatype", "=", (Object)formulaType);
        QFilter t = new QFilter("formulatype", "=", (Object)"4");
        QFilter q2 = new QFilter("templateid", "=", (Object)templateId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])new QFilter[]{q, q1.or(t), q2});
        doc.stream().forEach(d -> {
            FormulaVo f = QueryFormulaService.buildFormulaVo(d);
            list.add(f);
        });
        return list;
    }
}

