/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function;

import com.greenpineyu.fel.function.Dollar;
import com.greenpineyu.fel.function.Function;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Add;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.And;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.CollectionGet;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Cond;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Div;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Dot;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Equal;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.GreaterThan;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.GreaterThenEqual;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.LessThen;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.LessThenEqual;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Mod;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Mul;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.NotEqual;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.NotOper;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Or;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.Sub;

public class FunMgr {
    private final Map<String, Function> userFunMap;
    private Map<String, Function> funcMap = new HashMap<String, Function>();

    public FunMgr() {
        this.addFun(new Dot());
        this.addFun((Function)new CollectionGet());
        this.addFun((Function)new Cond());
        this.addFun((Function)new Dollar());
        this.addFun((Function)new NotOper());
        this.addFun((Function)new Add());
        this.addFun((Function)new Sub());
        this.addFun((Function)new Equal());
        this.addFun((Function)new NotEqual());
        this.addFun((Function)new Mul());
        this.addFun((Function)new Div());
        this.addFun((Function)new Mod());
        this.addFun(new LessThen());
        this.addFun(new LessThenEqual());
        this.addFun(new GreaterThan());
        this.addFun(new GreaterThenEqual());
        this.addFun((Function)new And());
        this.addFun((Function)new Or());
        this.userFunMap = new HashMap<String, Function>();
    }

    public void autoLoad() {
        try {
            Enumeration<URL> res = this.getClass().getClassLoader().getResources("com/greenpineyu/fel/function/");
            while (res.hasMoreElements()) {
                URL nex = res.nextElement();
                System.out.println(nex.getFile());
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void addFun(Function fun) {
        this.funcMap.put(fun.getName(), fun);
    }

    public Function getFun(String funName) {
        if (funName != null) {
            String newFunName = this.getLowerCaseName(funName);
            Function userFun = this.userFunMap.get(newFunName);
            if (userFun != null) {
                return userFun;
            }
            return this.funcMap.get(newFunName);
        }
        return null;
    }

    private String getLowerCaseName(String funName) {
        return funName.toLowerCase();
    }

    public void add(Function fun) {
        if (fun == null) {
            return;
        }
        String name = fun.getName();
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u51fd\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"FunMgr_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        this.userFunMap.put(this.getLowerCaseName(name), fun);
    }

    public void remove(String name) {
        if (name != null) {
            this.userFunMap.remove(this.getLowerCaseName(name));
        }
    }
}

