/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.common.ArrayUtils;
import com.greenpineyu.fel.common.Null;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.CommonFunction;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.security.SecurityMgr;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.fel.common.ReflectUtil;

public class Dot
implements Function {
    private SecurityMgr securityMgr;
    public static final String DOT = ".";

    public SecurityMgr getSecurityMgr() {
        return this.securityMgr;
    }

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    public String getName() {
        return DOT;
    }

    public Object call(FelNode node, FelContext context) {
        String methodName;
        FelNode right;
        List children = node.getChildren();
        Object left = children.get(0);
        if (left instanceof Expression) {
            Expression exp = (Expression)left;
            left = exp.eval(context);
        }
        FelNode exp = right = (FelNode)children.get(1);
        Class[] argsType = new Class[]{};
        Object[] args = CommonFunction.evalArgs((FelNode)right, (FelContext)context);
        if (!ArrayUtils.isEmpty((Object[])args)) {
            argsType = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsType[i] = args[i] == null ? Null.class : args[i].getClass();
            }
        }
        Method method = null;
        Class<?> cls = left instanceof Class ? (Class<?>)left : left.getClass();
        method = this.findMethod(cls, methodName = right.getText(), argsType);
        if (method == null) {
            String getMethod = "get";
            method = this.findMethod(cls, getMethod, new Class[]{String.class});
            args = new Object[]{exp.getText()};
        }
        if (method != null) {
            return Dot.invoke(left, method, args);
        }
        return null;
    }

    private Method findMethod(Class<?> cls, String methodName, Class<?>[] argsType) {
        Method method = ReflectUtil.findMethod(cls, methodName, argsType);
        return this.getCallableMethod(method);
    }

    private Method getMethod(Class<?> cls, String methodName, Class<?>[] argsType) {
        Method method = ReflectUtil.getMethod(cls, methodName, argsType);
        return this.getCallableMethod(method);
    }

    private Method getCallableMethod(Method m) {
        if (m == null || this.securityMgr.isCallable(m)) {
            return m;
        }
        throw new SecurityException(String.format(ResManager.loadKDString((String)"\u5b89\u5168\u7ba1\u7406\u5668[%1$s]\u7981\u6b62\u8c03\u7528\u65b9\u6cd5[%2$s]", (String)"Dot_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), this.securityMgr.getClass().getSimpleName(), m));
    }

    public static Object invoke(Object obj, Method method, Object[] args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public FelMethod toMethod(FelNode node, FelContext context) {
        StringBuilder sb = new StringBuilder();
        List children = node.getChildren();
        FelNode l = (FelNode)children.get(0);
        SourceBuilder leftMethod = l.toMethod(context);
        Class cls = leftMethod.returnType(context, l);
        String leftSrc = leftMethod.source(context, l);
        if (cls.isPrimitive()) {
            Class<?> wrapperClass = ReflectUtil.toWrapperClass(cls);
            sb.append("((").append(wrapperClass.getSimpleName()).append(')').append(leftSrc).append(')');
        } else {
            sb.append(leftSrc);
        }
        sb.append('.');
        Method method = null;
        FelNode rightNode = (FelNode)children.get(1);
        List params = rightNode.getChildren();
        Class[] paramValueTypes = null;
        boolean hasParam = params != null && !params.isEmpty();
        String rightMethod = rightNode.getText();
        String rightMethodParam = "";
        StringBuilder sbs = new StringBuilder();
        if (hasParam) {
            paramValueTypes = new Class[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                FelNode p = (FelNode)params.get(i);
                SourceBuilder paramMethod = p.toMethod(context);
                paramValueTypes[i] = paramMethod.returnType(context, p);
            }
            method = this.findMethod(cls, rightNode.getText(), paramValueTypes);
            if (method != null) {
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int i = 0; i < paramTypes.length; ++i) {
                    Class<?> paramType = paramTypes[i];
                    FelNode p = (FelNode)params.get(i);
                    String paramCode = Dot.getParamCode(paramType, p, context);
                    sbs.append(paramCode);
                    sbs.append(',');
                }
                rightMethodParam = sbs.toString();
                rightMethod = method.getName();
            }
        } else {
            method = this.findMethod(cls, rightNode.getText(), new Class[0]);
            if (method == null) {
                method = this.getMethod(cls, "get", new Class[]{String.class});
                if (method != null) {
                    rightMethod = "get";
                    rightMethodParam = "\"" + rightNode.getText() + "\"";
                }
            } else {
                rightMethod = method.getName();
            }
        }
        if (method != null) {
            // empty if block
        }
        if (rightMethodParam.endsWith(",")) {
            rightMethodParam = rightMethodParam.substring(0, rightMethodParam.length() - 1);
        }
        rightMethod = rightMethod + "(" + rightMethodParam + ")";
        sb.append(rightMethod);
        FelMethod returnMe = new FelMethod(method == null ? null : method.getReturnType(), sb.toString());
        return returnMe;
    }

    public static String getParamCode(Class<?> paramType, FelNode node, FelContext ctx) {
        String paramCode = "";
        SourceBuilder paramMethod = node.toMethod(ctx);
        Class paramValueType = paramMethod.returnType(ctx, node);
        if (ReflectUtil.isTypeMatch(paramType, paramValueType)) {
            paramCode = paramMethod.source(ctx, node);
        } else {
            String className = null;
            Class<?> wrapperClass = ReflectUtil.toWrapperClass(paramType);
            className = wrapperClass != null ? wrapperClass.getName() : paramType.getName();
            paramCode = "(" + className + ")" + paramMethod.source(ctx, node);
        }
        return paramCode;
    }
}

