/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.operator.NotEqual;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.VarAstNode;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.fel.common.ReflectUtil;

public class Equal
extends StableFunction {
    public String getName() {
        return "==";
    }

    public Object call(FelNode node, FelContext context) {
        List children = node.getChildren();
        if (children != null && children.size() == 2) {
            Object left = Equal.evalParam(context, children.get(0));
            Object right = Equal.evalParam(context, children.get(1));
            return this.compare(left, right);
        }
        throw new NullPointerException(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u8005\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e!", (String)"Equal_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    private static Object evalParam(FelContext context, Object obj) {
        if (obj instanceof VarAstNode) {
            return ((VarAstNode)obj).getText();
        }
        if (obj instanceof Expression) {
            return ((Expression)obj).eval(context);
        }
        return obj;
    }

    boolean compare(Object left, Object right) {
        return this.equals(left, right);
    }

    public boolean equals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getClass().equals(right.getClass())) {
            return left.equals(right);
        }
        if (left instanceof Number && right instanceof Number) {
            return this.compareNumber(left, right);
        }
        if (left instanceof Boolean && right instanceof Integer) {
            return Boolean.TRUE.equals(left) ? "1".equals(right.toString()) : "0".equals(right.toString());
        }
        if (left instanceof Boolean && right instanceof Byte) {
            return Boolean.TRUE.equals(left) ? "1".equals(right.toString()) : "0".equals(right.toString());
        }
        return left.equals(right);
    }

    protected boolean compareNumber(Object left, Object right) {
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return NumberUtil.toBigDecimal((Object)left).compareTo(NumberUtil.toBigDecimal((Object)right)) == 0;
        }
        if (NumberUtil.isFloatingPointNumber((Object)left) || NumberUtil.isFloatingPointNumber((Object)right)) {
            return Equal.isEqual(NumberUtil.toDouble((Object)left), NumberUtil.toDouble((Object)right));
        }
        return Equal.isEqual(NumberUtil.toDouble((Object)left), NumberUtil.toDouble((Object)right));
    }

    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        String operator = this.getName();
        return this.toMethod(node, ctx, operator);
    }

    private FelMethod toMethod(FelNode node, FelContext ctx, String operator) {
        StringBuilder sb = Equal.buildRelationExpr(node, ctx, operator);
        if (sb.length() == 0) {
            String left = Equal.getChildCode(node, ctx, 0);
            String right = Equal.getChildCode(node, ctx, 1);
            String toMethod = this.toMethod(left, right);
            sb.append(toMethod);
        }
        return new FelMethod(Boolean.class, sb.toString());
    }

    String toMethod(String left, String right) {
        return "ObjectUtils.equals(" + left + "," + right + ")";
    }

    public static String getChildCode(FelNode node, FelContext ctx, int index) {
        List children = node.getChildren();
        FelNode child = (FelNode)children.get(index);
        SourceBuilder leftM = child.toMethod(ctx);
        String code = "(" + leftM.source(ctx, child) + ")";
        return code;
    }

    private static StringBuilder buildRelationExpr(FelNode node, FelContext ctx, String operator) {
        List child = node.getChildren();
        FelNode leftNode = (FelNode)child.get(0);
        FelNode rightNode = (FelNode)child.get(1);
        SourceBuilder leftM = leftNode.toMethod(ctx);
        SourceBuilder rightM = rightNode.toMethod(ctx);
        Class leftType = leftM.returnType(ctx, leftNode);
        Class rightType = rightM.returnType(ctx, rightNode);
        String left = "(" + leftM.source(ctx, leftNode) + ")";
        String right = "(" + rightM.source(ctx, rightNode) + ")";
        StringBuilder sb = new StringBuilder();
        boolean isNotEqual = new NotEqual().getName().equals(operator);
        if (ReflectUtil.isPrimitiveOrWrapNumber(leftType) && ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
            if (isNotEqual) {
                sb.append('!');
            }
            sb.append("NumberUtil.equals(").append(left).append(',').append(right).append(')');
            return sb;
        }
        if (isNotEqual) {
            sb.append('!');
        }
        sb.append("ObjectUtils.equals(").append(left).append(',').append(right).append(')');
        return sb;
    }

    public static boolean isEqual(float a, float b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return (double)Math.abs(a - b) < eps;
    }

    public static boolean isEqual(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return Math.abs(a - b) < eps;
    }
}

