/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.big;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.big.BigAdd;

public class BigSub
extends StableFunction {
    public Object call(FelNode node, FelContext context) {
        List children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        Object left = TolerantFunction.eval((FelContext)context, children.get(0));
        Object right = null;
        if (children.size() == 1) {
            right = left;
            left = 0;
        } else {
            right = TolerantFunction.eval((FelContext)context, children.get(1));
        }
        try {
            if (BigAdd.isFloat(left) || BigAdd.isFloat(right)) {
                BigDecimal l = NumberUtil.toBigDecimal((Object)left);
                BigDecimal r = NumberUtil.toBigDecimal((Object)right);
                return l.subtract(r);
            }
            if (BigAdd.isInt(left) && BigAdd.isInt(right)) {
                BigInteger l = NumberUtil.toBigInteger((Object)left);
                BigInteger r = NumberUtil.toBigInteger((Object)right);
                return l.subtract(r);
            }
        }
        catch (NumberFormatException e) {
            throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u5931\u8d25[%1$s-%2$s]", (String)"BigSub_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), left, right), (Throwable)e);
        }
        throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u5931\u8d25[%1$s-%2$s]", (String)"BigSub_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), left, right));
    }

    public String getName() {
        return "-";
    }

    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        return InterpreterSourceBuilder.getInstance();
    }

    public static void main(String[] args) {
    }
}

