/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ParseUtils {
    private static final String formulaExp = "\\{\\w{0,2}\\[[\\w\\s_\n\r\\.\\(\\),\\:\\%\\+\\-\\*\\/#!=`><\uff08-\uff09\\\\'\u4e00-\u9fa5]*\\]\\}";
    private static final String formulaZKHExp = "(\\w{0,2})\\[([\\w\\s_\n\r\\.\\(\\),\\:\\%\\+\\-\\*\\/#!=`><\uff08-\uff09\\\\'\u4e00-\u9fa5]*)\\]";
    private static final String contentExp = "\\{F\\[[\\{\\w{0,2}\\[[\\{\\}\\w\\s_\n\r\\.\\(\\),\\%#=><\\-\\\\']*\\]\\}\\+\\-\\*\\/]*\\]\\}";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String ORGINAL_STR = "orginal_str";

    public static void main(String[] args) {
        String s = ResManager.loadKDString((String)"{Q[\u884c\u5217\u7ef4#1036898781553336320]}\u5f55\u5165\u91d1\u989d{F[{Q[tccit_dg_b105016#1#gjzqtglfdggfhywxcf]}]}\uff1e\uff08\u7b26\u5408\u6761\u4ef6\u6263\u9664\u9650\u989d{F[{Q[tccit_dg_b105016#1#fhtjkce]}]}\u4e0e\u7a0e\u6536\u6263\u9664\u9650\u989d{F[{Q[tccit_dg_b105016#1#sskcxe]}]}\uff09\u7684\u5b70\u5c0f\u503c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165", (String)"ParseUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        Map<String, String> result2 = ParseUtils.parseFormulaZKH(ResManager.loadKDString((String)"{Q[\u884c\u5217\u7ef4#1036898781553336320]}", (String)"ParseUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        System.out.println("=================" + result2);
        List<String> list = ParseUtils.parseformulaContent(s);
        for (String formula : list) {
            List<String> l = ParseUtils.parseformula(formula);
            for (String ll : l) {
                Map<String, String> result = ParseUtils.parseFormulaZKH(ll);
                System.out.println("=================" + result);
            }
        }
    }

    public static boolean isFormulaFormat(String formula) {
        if (StringUtil.isNotEmpty((CharSequence)formula)) {
            Pattern r = Pattern.compile(formulaExp);
            Matcher m = r.matcher(formula);
            return m.find();
        }
        return false;
    }

    public static List<String> parseformulaContent(String formula) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern r = Pattern.compile(ParseUtils.getContentexp());
        Matcher m = r.matcher(formula);
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public static List<String> parseformula(String formula) {
        long l = System.currentTimeMillis();
        ArrayList<String> list = new ArrayList<String>();
        String temp = formula;
        if (temp.startsWith("if")) {
            temp = temp.substring(3, temp.length() - 1);
        }
        Pattern r = Pattern.compile(formulaExp);
        Matcher m = r.matcher(temp);
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public static Map<String, String> parseFormulaZKH(String formula) {
        long l = System.currentTimeMillis();
        Pattern r = Pattern.compile(formulaZKHExp);
        Matcher m = r.matcher(formula);
        HashMap<String, String> map = new HashMap<String, String>();
        if (m.find()) {
            map.put(ORGINAL_STR, formula);
            map.put(TYPE, m.group(1));
            map.put(VALUE, m.group(2));
        }
        return map;
    }

    public static List<Map<String, String>> parseformulaTypeKey(String formula) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        char[] formulaChars = formula.toCharArray();
        boolean typeSwitch = false;
        boolean keySwitch = false;
        StringBuilder type = new StringBuilder();
        StringBuilder keyStr = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>(2);
        for (int i = 0; i < formulaChars.length; ++i) {
            char str = formulaChars[i];
            if (str == '{') {
                typeSwitch = true;
                if (StringUtil.isNotBlank((CharSequence)type)) {
                    type = new StringBuilder();
                }
                if (!StringUtil.isNotBlank((CharSequence)keyStr)) continue;
                keyStr = new StringBuilder();
                continue;
            }
            if (str == '[') {
                typeSwitch = false;
                keySwitch = true;
                continue;
            }
            if (typeSwitch) {
                type.append(str);
                continue;
            }
            if (str == ']' && StringUtil.isNotBlank((CharSequence)keyStr)) {
                String t = type.toString();
                String v = keyStr.toString();
                if (StringUtil.isNotBlank((CharSequence)t) && StringUtil.isNotBlank((CharSequence)v)) {
                    map.put(TYPE, t);
                    map.put(VALUE, v);
                }
                list.add(map);
                keySwitch = false;
                type = new StringBuilder();
                keyStr = new StringBuilder();
                map.clear();
                continue;
            }
            if (!keySwitch) continue;
            keyStr.append(str);
        }
        return list;
    }

    public static List<String> parseformulaNew(String formula) {
        ArrayList<String> list = new ArrayList<String>();
        char[] formulaChars = formula.toCharArray();
        boolean typeSwitch = false;
        boolean keySwitch = false;
        StringBuilder type = new StringBuilder();
        StringBuilder keyStr = new StringBuilder();
        for (int i = 0; i < formulaChars.length; ++i) {
            char str = formulaChars[i];
            if (str == '{') {
                typeSwitch = true;
                if (StringUtil.isNotBlank((CharSequence)type)) {
                    type = new StringBuilder();
                }
                if (!StringUtil.isNotBlank((CharSequence)keyStr)) continue;
                keyStr = new StringBuilder();
                continue;
            }
            if (str == '[') {
                typeSwitch = false;
                keySwitch = true;
                continue;
            }
            if (typeSwitch) {
                type.append(str);
                continue;
            }
            if (str == ']' && StringUtil.isNotBlank((CharSequence)keyStr)) {
                list.add(keyStr.toString());
                keySwitch = false;
                type = new StringBuilder();
                keyStr = new StringBuilder();
                continue;
            }
            if (!keySwitch) continue;
            keyStr.append(str);
        }
        return list;
    }

    public static Map<String, String> parseFormulaZKHnew(String formula) {
        char[] formulaChars = formula.toCharArray();
        StringBuilder type = new StringBuilder();
        StringBuilder keyStr = new StringBuilder();
        boolean typeSwitch = false;
        boolean keySwitch = false;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < formulaChars.length; ++i) {
            char str = formulaChars[i];
            if (keySwitch && str == '{' || str == '[') {
                return null;
            }
            if (str == '{') {
                typeSwitch = true;
                continue;
            }
            if (str == '[') {
                typeSwitch = false;
                keySwitch = true;
                continue;
            }
            if (typeSwitch) {
                type.append(str);
                continue;
            }
            if (str == ']') {
                String t = type.toString();
                String v = keyStr.toString();
                if (StringUtil.isNotBlank((CharSequence)t) && StringUtil.isNotBlank((CharSequence)v)) {
                    map.put(TYPE, t);
                    map.put(VALUE, v);
                }
            }
            keyStr.append(str);
        }
        return map;
    }

    public static String getType(Map<String, String> map) {
        return map.get(TYPE);
    }

    public static String getOrginalStr(Map<String, String> map) {
        return map.get(ORGINAL_STR);
    }

    public static String getValue(Map<String, String> map) {
        return map.get(VALUE);
    }

    public static String getContentexp() {
        return contentExp;
    }
}

