/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import org.apache.commons.collections.CollectionUtils;

public class CacheFormulaService {
    private static final String INITCACHEFORMULAS = "initcacheFormulas_%s";
    private static final String QCACHEFORMULAS = "qcacheFormulas_%s";
    private static final String SCACHEFORMULAS = "scacheFormulas_%s";
    private static final String RCACHEFORMULAS = "rcacheFormulas_%s";
    private static final String MCACHEFORMULAS = "mcacheFormulas_%s";
    private static final String CPCACHEFORMULAS = "cpcacheFormulas_%s";
    private static final String CHECKFORMULA = "checkFormula_%s";

    public static Map<String, FormulaVo> getCellFormulas(Long tmpId) {
        Map<String, FormulaVo> formulas = QueryFormulaService.queryDBFormulaById(tmpId, "3");
        return formulas;
    }

    public static Map<String, Object> getAllFormulas(Long tmpId, List<DynamicRowModel> dynList, Map<String, FormulaVo> dbCalFormulas) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ParseFormulaService p = CacheFormulaService.paserFormula(tmpId, dynList, dbCalFormulas);
        result.put("all", p.getFormulas());
        result.put("Q", p.getQformulas());
        result.put("R", p.getRformulas());
        result.put("M", p.getMformulas());
        result.put("CP", p.getCpformulas());
        result.put("C", p.getCformulas());
        return result;
    }

    public static Map<String, Object> getAllFormulas(Long tmpId, List<DynamicRowModel> dynList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ParseFormulaService p = CacheFormulaService.paserFormula(tmpId, dynList);
        result.put("all", p.getFormulas());
        result.put("Q", p.getQformulas());
        result.put("R", p.getRformulas());
        result.put("M", p.getMformulas());
        result.put("CP", p.getCpformulas());
        result.put("C", p.getCformulas());
        return result;
    }

    public static FormulaCollectionVo getAllFormulasVo(Long tmpId, List<DynamicRowModel> dynList) {
        FormulaCollectionVo result = new FormulaCollectionVo();
        ParseFormulaService p = CacheFormulaService.paserFormula(tmpId, dynList);
        result.setFormulas(p.getFormulas());
        result.setQformulas(p.getQformulas());
        result.setRformulas(p.getRformulas());
        result.setMformulas(p.getMformulas());
        result.setCpformulas(p.getCpformulas());
        result.setCformulas(p.getCformulas());
        return result;
    }

    public static Map<String, FormulaVo> getFormulas(Long tmpId, List<DynamicRowModel> dynList) {
        Map<String, FormulaVo> formulas = null;
        if (formulas == null) {
            return CacheFormulaService.paserFormula(tmpId, dynList).getFormulas();
        }
        return formulas;
    }

    public static Map<String, Map<String, String>> getQformulas(Long tmpId, List<DynamicRowModel> dynList) {
        Map qformulas = (Map)CacheUtils.get(String.format(QCACHEFORMULAS, tmpId));
        if (null == qformulas) {
            return CacheFormulaService.paserFormula(tmpId, dynList).getQformulas();
        }
        return qformulas;
    }

    public static Map<String, String> getRformulas(Long tmpId, List<DynamicRowModel> dynList) {
        return CacheFormulaService.paserFormula(tmpId, dynList).getRformulas();
    }

    private static ParseFormulaService paserFormula(Long tmpId, List<DynamicRowModel> dynList, Map<String, FormulaVo> dbCalFormulas) {
        ParseFormulaService p = new ParseFormulaService(tmpId, dynList);
        p.parse(dbCalFormulas);
        if (null != p.getFormulas()) {
            CacheUtils.put(String.format(INITCACHEFORMULAS, tmpId), p.getFormulas());
        }
        if (null != p.getQformulas()) {
            CacheUtils.put(String.format(QCACHEFORMULAS, tmpId), p.getQformulas());
        }
        if (null != p.getRformulas()) {
            CacheUtils.put(String.format(RCACHEFORMULAS, tmpId), p.getRformulas());
        }
        if (null != p.getMformulas()) {
            CacheUtils.put(String.format(MCACHEFORMULAS, tmpId), p.getMformulas());
        }
        if (null != p.getCpformulas()) {
            CacheUtils.put(String.format(CPCACHEFORMULAS, tmpId), p.getCpformulas());
        }
        return p;
    }

    private static ParseFormulaService paserFormula(Long tmpId, List<DynamicRowModel> dynList) {
        ParseFormulaService p = new ParseFormulaService(tmpId, dynList);
        p.parse();
        if (null != p.getFormulas()) {
            CacheUtils.put(String.format(INITCACHEFORMULAS, tmpId), p.getFormulas());
        }
        if (null != p.getQformulas()) {
            CacheUtils.put(String.format(QCACHEFORMULAS, tmpId), p.getQformulas());
        }
        if (null != p.getRformulas()) {
            CacheUtils.put(String.format(RCACHEFORMULAS, tmpId), p.getRformulas());
        }
        if (null != p.getMformulas()) {
            CacheUtils.put(String.format(MCACHEFORMULAS, tmpId), p.getMformulas());
        }
        if (null != p.getCpformulas()) {
            CacheUtils.put(String.format(CPCACHEFORMULAS, tmpId), p.getCpformulas());
        }
        return p;
    }

    @Deprecated
    public static List<FormulaVo> queryCheckFormulas(DeclareRequestModel requestModel) {
        List<FormulaVo> formulas = null;
        String checkformula = requestModel.getCheckFormula();
        if (StringUtils.isNotEmpty((String)checkformula)) {
            formulas = JsonUtils.strToList(checkformula);
        }
        if (CollectionUtils.isEmpty(formulas)) {
            String templateId = requestModel.getTemplateId() == null ? StringUtils.getEmpty() : requestModel.getTemplateId().toString();
            formulas = QueryFormulaService.queryDBFormulaType(requestModel.getTemplateType(), requestModel.getSkssqq(), requestModel.getSkssqz(), templateId);
            requestModel.setCheckFormula(JsonUtils.mapToStr(formulas));
        }
        return formulas;
    }

    public static List<FormulaVo> queryCheckFormulas(DeclareRequestModel requestModel, List<DynamicRowModel> dynamicRowList) {
        List<FormulaVo> formulas;
        List<FormulaVo> list = formulas = requestModel.getFormulas() != null ? requestModel.getFormulas().getDbCheckFormulasCopy() : null;
        if (CollectionUtils.isEmpty(formulas)) {
            String templateId = requestModel.getTemplateId() == null ? StringUtils.getEmpty() : requestModel.getTemplateId().toString();
            formulas = QueryFormulaService.queryDBFormulaType(requestModel.getTemplateType(), requestModel.getSkssqq(), requestModel.getSkssqz(), templateId);
        }
        if (formulas != null && !CollectionUtils.isEmpty(formulas) && !CollectionUtils.isEmpty(dynamicRowList)) {
            ParseFormulaService p = new ParseFormulaService();
            Map<String, FormulaVo> newFormulas = formulas.stream().collect(Collectors.toMap(FormulaVo::getFormulaKey, Function.identity(), (key1, kye2) -> key1));
            ArrayList<FormulaVo> deleteFormulas = new ArrayList<FormulaVo>();
            if (newFormulas != null) {
                newFormulas = p.generateDynFormula(newFormulas, dynamicRowList);
                for (FormulaVo entry : formulas) {
                    if (newFormulas.get(entry.getFormulaKey()) != null && entry.getFormula().equals(newFormulas.get(entry.getFormulaKey()).getFormula())) {
                        newFormulas.remove(entry.getFormulaKey());
                    }
                    if (!entry.getFormula().startsWith("{[DynRowCustomFormula]")) continue;
                    deleteFormulas.add(entry);
                }
                if (!newFormulas.isEmpty()) {
                    formulas.addAll(new ArrayList<FormulaVo>(newFormulas.values()));
                }
            }
            for (FormulaVo entry : formulas) {
                if (!DynamicRowService.isDelKey(dynamicRowList, entry.getFormulaKey())) continue;
                deleteFormulas.add(entry);
            }
            formulas.removeAll(deleteFormulas);
        }
        return formulas;
    }

    public static List<FormulaVo> queryCheckFormulas(Long tmpId) {
        ArrayList formulas = (ArrayList)CacheUtils.get(String.format(CHECKFORMULA, tmpId));
        if (null == formulas && null != (formulas = QueryFormulaService.queryDBFormulaByTmpId(tmpId))) {
            CacheUtils.put(String.format(CHECKFORMULA, tmpId), formulas);
        }
        return formulas == null ? new ArrayList() : formulas;
    }

    public static Map<String, String> getFormulaMate(Long tmpId) {
        Map<String, FormulaVo> formulas = null;
        HashMap<String, String> result = new HashMap<String, String>();
        formulas = QueryFormulaService.queryDBFormulaById(tmpId);
        if (formulas != null) {
            for (String key : formulas.keySet()) {
                if (!key.contains("#")) continue;
                key = key.split("#")[0];
                result.put(key, key);
            }
        }
        return result;
    }

    public static Map<String, FormulaVo> getCellTypeFormulas(Long templateid, List<DynamicRowModel> dynamicRowList) {
        Map<String, FormulaVo> formulas = QueryFormulaService.queryDBFormulaById(templateid, "3");
        HashMap<String, FormulaVo> cellTypeMap = new HashMap<String, FormulaVo>();
        for (FormulaVo formulaVo : formulas.values()) {
            String celltype = formulaVo.getCellType();
            if (!"2".equals(celltype) && !"3".equals(celltype) && !"4".equals(celltype) && !"5".equals(celltype) && !"7".equals(celltype)) continue;
            if (kd.bos.orm.util.CollectionUtils.isEmpty(dynamicRowList)) {
                cellTypeMap.put(formulaVo.getFormulaKey(), formulaVo);
                continue;
            }
            String[] formulakeySplit = formulaVo.getFormulaKey().split("#");
            String dynamicRowNo = formulakeySplit[0] + "#" + formulakeySplit[1];
            DynamicRowModel dynamicRowModel = dynamicRowList.stream().filter(e -> null != e.getDynRowNo() && e.getDynRowNo().equals(dynamicRowNo)).findFirst().orElse(null);
            if (null != dynamicRowModel && dynamicRowModel.getRowList() != null) {
                int startRow = dynamicRowModel.getStartRow().intValue();
                int dynamicRowSize = dynamicRowModel.getRowList().size();
                for (int i = Integer.parseInt(formulakeySplit[1]); i < dynamicRowSize + startRow; ++i) {
                    String formulakey = formulakeySplit[0] + "#" + i + "#" + formulakeySplit[2];
                    cellTypeMap.put(formulakey, formulaVo);
                }
                continue;
            }
            cellTypeMap.put(formulaVo.getFormulaKey(), formulaVo);
        }
        return cellTypeMap;
    }
}

