/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.optimize.MsqlOptimizer;
import kd.taxc.bdtaxr.common.refactor.formula.parse.MetaDataSqlParser;
import kd.taxc.bdtaxr.common.refactor.formula.service.SqlDataSet;
import kd.taxc.bdtaxr.common.refactor.formula.utils.MsqlQueryUtil;
import kd.taxc.bdtaxr.common.refactor.formula.verify.MsqlChecker;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MsqlQueryService {
    private static Log logger = LogFactory.getLog(MsqlQueryService.class);

    public Map<String, Object> queryWithLog(String sql) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        Boolean success = Boolean.FALSE;
        ArrayList<String> logs = new ArrayList<String>(32);
        try {
            MsqlChecker.check(sql);
            List<Object> objects = this.queryLowerSql(sql, logs, false);
            resultMap.put("datas", objects);
            success = Boolean.TRUE;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            logs.add(StringUtil.getStackTraceMessage(e));
        }
        resultMap.put("success", success);
        resultMap.put("logs", logs);
        return resultMap;
    }

    public List<Object> query(String sql) {
        MsqlChecker.check(sql);
        return this.queryLowerSql(sql, new ArrayList<String>(32), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> queryLowerSql(String sql, List<String> logs, boolean isOnlyOne) {
        String lowerSql;
        long t1 = System.currentTimeMillis();
        String reusltSql = lowerSql = MsqlQueryUtil.toLowerSql(sql);
        try {
            reusltSql = new MsqlOptimizer(lowerSql).doOptimize().getReusltSql();
            logs.add(String.format(ResManager.loadKDString((String)"\u4f18\u5316\u524dsql\uff1a\n%s", (String)"MsqlQueryService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), lowerSql));
            logs.add(String.format(ResManager.loadKDString((String)"\u4f18\u5316\u540esql\uff1a\n%s", (String)"MsqlQueryService_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), reusltSql));
            if (logger.isDebugEnabled()) {
                logger.debug("MetadataGetValue.sql.MsqlOptimizer=\u4f18\u5316sql\u539fsql\uff1a{} \n\u4f18\u5316\u540e:{}", (Object)lowerSql, (Object)reusltSql);
            }
        }
        catch (Exception e) {
            logger.error("MetadataGetValue.sql.MsqlOptimizer=\u4f18\u5316\u5f02\u5e38,sql:" + lowerSql, (Throwable)e);
            logs.add(ResManager.loadKDString((String)"\u4f18\u5316\u5f02\u5e38\u8be6\u60c5\u5982\u4e0b\n", (String)"MsqlQueryService_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            logs.add(StringUtil.getStackTraceMessage(e));
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 100L) {
            logger.info("MetadataGetValue.sql.MsqlOptimizer=\u4f18\u5316msql\u8017\u65f6:{}ms,\u539fsql\uff1a{} \n\u4f18\u5316\u540e:{}", new Object[]{t2 - t1, lowerSql, reusltSql});
        }
        long t3 = System.currentTimeMillis();
        MetaDataSqlParser metaDataSqlParser = new MetaDataSqlParser(reusltSql, 0);
        metaDataSqlParser.parse(true);
        SqlDataSet sqlDataSet = new SqlDataSet();
        sqlDataSet.setLevel(0);
        sqlDataSet.setSql(metaDataSqlParser.getSql());
        sqlDataSet.setName(metaDataSqlParser.getSql());
        sqlDataSet.setWhere(metaDataSqlParser.getWhere());
        sqlDataSet.setFrom(metaDataSqlParser.getFrom());
        sqlDataSet.setSelectItems(metaDataSqlParser.getSelectList());
        sqlDataSet.setDataSetAliasHashMap(metaDataSqlParser.getDataSetAliasHashMap());
        long t4 = System.currentTimeMillis();
        long t = t4 - t3;
        if (t > 100L) {
            logger.info("MetadataGetValue.sql.MetaDataSqlParser=\u89e3\u6790msql\u8017\u65f6\uff1a{}ms", (Object)t);
        }
        logs.addAll(metaDataSqlParser.getLogs());
        try {
            List<Object> query;
            if (metaDataSqlParser.getDataSetAliasHashMap().size() > 0) {
                sqlDataSet.createDataSet(logs);
            }
            logs.add(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6700\u5916\u5c42\u6570\u636e\u96c6:\n%s", (String)"MsqlQueryService_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), metaDataSqlParser.getSql()));
            List<Object> list = query = MsqlQueryUtil.querySqlDataSet(sqlDataSet, isOnlyOne);
            return list;
        }
        finally {
            MsqlQueryUtil.recursionCloseDataSet(sqlDataSet);
            long t5 = System.currentTimeMillis();
            if (t5 - t1 > 1000L) {
                logger.info("MetadataGetValue.sql.MsqlQueryService=\u67e5\u8be2\u603bmsql\u8017\u65f6\uff1a{}ms,msql:{}", (Object)(t5 - t1), (Object)lowerSql);
            }
        }
    }

    public static void main(String[] args) {
        String sql2 = "select sum(invoice_amount) from rim_inv_special where tax_org = '100000' and tax_period >= '2021-06-01' and tax_period <= '2021-06-30 23:59:59' and invoice_status = '0' and authenticate_flag in ('2','3') and deduction_purpose='1'";
        String sql3 = "select sum(a.calctaxamount * a.verifyrate) from tcret_yhs_tax_account a left join tcret_ysh_tax_source_de b on a.serialno=b.serialno where a.org='100000' and a.skssqq >= '2021-01-01 00:00:00' and a.skssqz <= '2021-12-31 00:00:00'";
        String sql4 = "select sum(a.calctaxamount * a.verifyrate) from tcret_yhs_tax_account a left join tcret_ysh_tax_source_de b on a.serialno=b.serialno where a.org in (select id from bos_org where number='00') and a.skssqq >= '2021-01-01 00:00:00' and a.skssqz <= '2021-12-31 00:00:00'";
        String sql5 = "select count(id) from tdm_invoice_input where org='100000' and taxperiod = '2021-05' and invoicestatus = '0' and selectstatus= '1' and certstatus IN ('1','2' ) and specialinvoiceitems.spe_goodscode like '5%'";
        String sql51 = "select count(a.id) from tdm_invoice_input a where a.org='100000' and a.taxperiod = '2021-05' and a.invoicestatus = '0' and a.selectstatus= '1' and a.certstatus IN ('1','2' ) and a.specialinvoiceitems.spe_goodscode like '5%'";
        String sql6 = "select count(a.id) from tdm_invoice_input a where a.org in (select id from bos_org where number='00') and a.taxperiod = '2021-05' and a.invoicestatus = '0' and a.selectstatus= '1' and a.certstatus in ('1','2' ) and a.specialinvoiceitems.spe_goodscode like '5%'";
        String sql7 = "select count(a.id) from tdm_invoice_input a where a.org in (select v.orgid from tctb_tax_main v left join bos_org b on v.orgid = b.id where b.number='00') and a.taxperiod = '2021-05' and a.invoicestatus = '0' and a.selectstatus= '1' and a.certstatus in ('1','2' ) and a.specialinvoiceitems.spe_goodscode like '5%'";
        String sql8 = "select count(a.baseinvoicetype.number) from tdm_invoice_input a where a.org.name in (select name from bos_org where number='00') and a.taxperiod = '2021-05' and a.invoicestatus = '0' and a.selectstatus= '1' and a.certstatus in ('1','2' ) and a.specialinvoiceitems.spe_goodscode like '5%'";
        String sql9 = "select sum(c.calctaxamount) from (select d.calctaxamount,d.org from (select a.calctaxamount,a.org,a.gathernumber from tcret_yhs_tax_account a inner join  tcret_yhs_tax_account_fb  b on a.org=b.org) d  where d.org='1' and d.gathernumber='9d0821612ad44f648ca5b1819a403274') c\ninner join (select * from tcret_yhs_tax_account_fb where org='1' and taxsourceno='9d0821612ad44f648ca5b1819a403274') b on c.org=b.org";
        long l = System.currentTimeMillis();
        System.out.println(new MsqlQueryService().query(sql7));
        System.out.println(String.format("use time:%d", System.currentTimeMillis() - l));
        MetaDataSqlParser metaDataSqlParser = new MetaDataSqlParser(sql3, 0);
        metaDataSqlParser.parse(true);
    }
}

