/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.value;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.value.GetValue;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.AssistedGetValue;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.CodePluginGetValue;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.ConstGetValue;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.MetadataGetValue;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.ParamsGetValue;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.RuleGetValue;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.TableGetValue;

public class GetValueService {
    private Map<String, GetValue> values = new HashMap<String, GetValue>();

    public GetValueService(Context context) {
        this.values.put("Q", new TableGetValue(context));
        this.values.put("A", new AssistedGetValue(context));
        this.values.put("C", new ConstGetValue(context));
        this.values.put("P", new ParamsGetValue(context));
        this.values.put("R", new RuleGetValue(context));
        this.values.put("M", new MetadataGetValue(context));
        this.values.put("CP", new CodePluginGetValue(context));
    }

    public String getValue(String type, String value, FormulaVo formulaVo) {
        if (this.values.get(type) == null) {
            return "";
        }
        return this.values.get(type).getValue(value, formulaVo);
    }

    public String getValueWithLog(String type, String value, FormulaVo formulaVo, List<String> logs) {
        return this.values.get(type).getValueWithLog(value, formulaVo, logs);
    }
}

