/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.value.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.service.MsqlQueryService;
import kd.taxc.bdtaxr.common.refactor.formula.utils.MsqlQueryUtil;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.AbstractGetValue;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MetadataGetValue
extends AbstractGetValue {
    private static Log logger = LogFactory.getLog(MetadataGetValue.class);

    public MetadataGetValue(Context context) {
        super(context);
    }

    @Override
    public String getValue(Object formula, FormulaVo srcFormulaVo) {
        long l = System.currentTimeMillis();
        String md5 = StringUtil.hashFormulaStr((String)formula);
        long l1 = System.currentTimeMillis();
        if (l1 - l > 10L) {
            logger.info("MetadataGetValue.sql.hash=\u5b57\u7b26\u4e32\u8f6c\u63621\u8017\u65f6cost:{}ms", (Object)(l1 - l));
        }
        String sql = this.replaceFormula((String)formula);
        long l2 = System.currentTimeMillis();
        if (l2 - l1 > 10L) {
            logger.info("MetadataGetValue.sql.replace=\u5b57\u7b26\u4e32\u8f6c\u63622\u8017\u65f6cost:{}ms", (Object)(l2 - l1));
        }
        if (this.getFormulaContext().getMetadataSqlValues() == null) {
            throw new KDBizException("Msql context must contains [MetadataSqlValues] feild");
        }
        String values = this.getFormulaContext().getMetadataSqlValues().get(md5);
        if (!this.getFormulaContext().getMsqlKeys().contains(md5)) {
            long l3 = System.currentTimeMillis();
            Object obj = MetadataGetValue.queryMetadataObj(sql, srcFormulaVo);
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    String key = entry.getKey().toString().startsWith("key") ? entry.getKey().toString() : md5;
                    this.getFormulaContext().getMetadataSqlValues().put(key, MsqlQueryUtil.objectToString(entry.getValue()));
                    values = MsqlQueryUtil.objectToString(entry.getValue());
                }
            } else {
                values = MsqlQueryUtil.objectToString(obj);
                if (values != null) {
                    this.getFormulaContext().getMetadataSqlValues().put(md5, values);
                }
            }
            this.getFormulaContext().getMsqlKeys().add(md5);
            long l4 = System.currentTimeMillis();
            if (l4 - l3 > 200L) {
                logger.info("MetadataGetValue.sql.queryMetadataValue={},\u8017\u65f6cost:{}ms", (Object)sql, (Object)(l4 - l3));
            }
        }
        if (System.currentTimeMillis() - l > 500L) {
            logger.info("MetadataGetValue.sql.total={},values={},cost:{}ms", new Object[]{sql, values, System.currentTimeMillis() - l});
        }
        return values;
    }

    @Override
    public String replaceFormula(String formula) {
        String f = formula;
        for (Map.Entry<String, Object> entry : this.getFormulaContext().getParam().entrySet()) {
            Object obj;
            if (!StringUtil.isNotEmpty((CharSequence)entry.getKey()) || null == (obj = this.getFormulaContext().getParam().get(entry.getKey()))) continue;
            f = f.replaceAll('#' + entry.getKey(), this.getFormulaContext().getParam().get(entry.getKey()).toString());
        }
        return f;
    }

    @Override
    public String getValueWithLog(Object formula, FormulaVo formulaVo, List<String> logList) {
        logList.add(ResManager.loadKDString((String)"M\u516c\u5f0f\uff0c\u5f00\u59cb\u8fd0\u884c\uff01", (String)"MetadataGetValue_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        logList.add(formula + "\n");
        String sql = this.replaceFormula((String)formula);
        Map<String, Object> resultMap = new MsqlQueryService().queryWithLog(sql);
        String value = null;
        Boolean success = (Boolean)resultMap.get("success");
        if (Boolean.FALSE.equals(success)) {
            logList.add(ResManager.loadKDString((String)"M\u516c\u5f0f\uff0c\u8fd0\u884c\u5931\u8d25\uff01", (String)"MetadataGetValue_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        } else {
            List objects = (List)resultMap.get("datas");
            logList.add(String.format(ResManager.loadKDString((String)"M\u516c\u5f0f\uff0c\u8fd0\u884c\u6210\u529f\uff01\u67e5\u5230\u8bb0\u5f55%d\u6761\uff0c\u660e\u7ec6\u5982\u4e0b\uff1a", (String)"MetadataGetValue_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), objects.size()));
            String collect = objects.stream().map(a -> MsqlQueryUtil.objectToString(a)).collect(Collectors.joining(","));
            logList.add(collect);
            value = EmptyCheckUtils.isEmpty(objects) || objects.get(0) == null ? null : MsqlQueryUtil.objectToString(objects.get(0));
        }
        List logs = (List)resultMap.get("logs");
        logList.addAll(logs);
        logList.add(ResManager.loadKDString((String)"M\u516c\u5f0f\uff0c\u8fd0\u884c\u7ed3\u675f\uff01", (String)"MetadataGetValue_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        return value;
    }

    public static Object queryMetadataObj(String sql, FormulaVo srcFormulaVo) {
        List<Object> query = null;
        try {
            query = new MsqlQueryService().query(sql);
        }
        catch (Exception e) {
            logger.error("MetadataGetValue.sql----query Msql error----------:" + sql + "----------" + e.getMessage());
        }
        return query != null && query.size() > 0 ? query.get(0) : null;
    }
}

