/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.log.taxlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.taxc.vo.TaxLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.BillTaxStepEnum;
import kd.taxc.bdtaxr.common.constant.TaxLogRuleEnum;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogMaterialLineDto;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogMultiLangConstant;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogAddresstermsService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogFourAbstractService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogPartyService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogProcessService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogProductService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogSpecificService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxRuleAlgoService;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.TaxLogUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FieldsAndDataTypeVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FourPVo;
import kd.taxc.bdtaxr.common.threadpools.Task;

public class TaxLogService
extends Task {
    private static Log logger = LogFactory.getLog(TaxLogService.class);
    private static final Map<String, TaxLogFourAbstractService> map = new LinkedHashMap<String, TaxLogFourAbstractService>();
    private static final Map<String, String> fourNameMap = new LinkedHashMap<String, String>();
    private BillTaxVo billTaxVo;
    private List<TaxLogMaterialLineDto> materialLineDtos = new ArrayList<TaxLogMaterialLineDto>(0);
    private Map callBillMap;
    private Map<String, String> taxCodeLineLog;
    private String taxResults;
    private boolean isCloseWriteLog;

    public TaxLogService(boolean isCloseWriteLog) {
        this.isCloseWriteLog = isCloseWriteLog;
    }

    public void service() {
        logger.info("taxc-TaxLogService saveTaxLog");
        if (this.isCloseWriteLog) {
            return;
        }
        logger.info("taxc-TaxLogService begin write");
        LinkedHashMap<String, LinkedHashMap<String, String>> log = new LinkedHashMap<String, LinkedHashMap<String, String>>(this.materialLineDtos.size());
        for (int i = 0; i < this.materialLineDtos.size(); ++i) {
            TaxLogMaterialLineDto materialLineDto = this.materialLineDtos.get(i);
            log.put(String.valueOf(i + 1), TaxLogUtils.initStepMap());
            LinkedHashMap stepLogMap = (LinkedHashMap)log.get(String.valueOf(i + 1));
            this.dealStepOne(materialLineDto, stepLogMap);
            this.dealStepTwo(materialLineDto, stepLogMap);
            this.dealStepThreeAndFour(materialLineDto, stepLogMap);
            this.dealStepFive(materialLineDto, stepLogMap);
            this.dealStepSix(materialLineDto, stepLogMap);
            this.dealStepSeven(materialLineDto, stepLogMap);
        }
        this.saveStepLog(log, this.taxResults, this.taxCodeLineLog);
    }

    private void dealStepSeven(TaxLogMaterialLineDto materialLineDto, LinkedHashMap<String, String> stepLogMap) {
        List<TaxLineVo> taxLineVos = materialLineDto.getTaxLineVos();
        if (null == taxLineVos) {
            return;
        }
        ArrayList<String> stepStepSevenLog = new ArrayList<String>();
        taxLineVos.stream().forEach(vo -> {
            StringBuilder message = new StringBuilder();
            Long codeId = vo.getTaxCode();
            Long rateId = vo.getTaxRate();
            logger.info("getTaxCode:" + codeId + ",getTaxRate" + rateId);
            DynamicObject taxCode = ObjectQueryUtils.queryDynamicObject("bastax_taxcode", "name,number", codeId);
            message.append(TaxLogMultiLangConstant.getTAXCODE()).append(null == taxCode ? "" : taxCode.getString("name")).append(" ");
            DynamicObject taxRate = ObjectQueryUtils.queryDynamicObject("bd_taxrate", "name,number", rateId);
            message.append(TaxLogMultiLangConstant.getTAXRATE()).append(null == taxRate ? "" : taxRate.getString("name"));
            stepStepSevenLog.add(message.toString());
        });
        stepStepSevenLog.add(" ");
        TaxLogUtils.setLogV(BillTaxStepEnum.STEP_SEVEN.getStepName(), stepLogMap, stepStepSevenLog);
    }

    private void dealStepSix(TaxLogMaterialLineDto materialLineDto, LinkedHashMap<String, String> stepLogMap) {
        DynamicObject dynamicObject = materialLineDto.getLastTaxRule();
        ArrayList<String> stepStepSixLog = new ArrayList<String>();
        if (null != dynamicObject) {
            stepStepSixLog.add(dynamicObject.getString("number") + " " + dynamicObject.getString("name") + "\n");
        }
        TaxLogUtils.setLogV(BillTaxStepEnum.STEP_SIX.getStepName(), stepLogMap, stepStepSixLog);
    }

    private void dealStepFive(TaxLogMaterialLineDto materialLineDto, LinkedHashMap<String, String> stepLogMap) {
        ArrayList<String> stepStepFiveLog = new ArrayList<String>();
        DynamicObject[] taxRules = materialLineDto.getTaxRules();
        if (null == taxRules) {
            return;
        }
        LinkedHashMap<String, String> ruleMap = TaxLogRuleEnum.initRuleLogMap();
        HashMap allRuleMap = new HashMap();
        StringBuilder one = new StringBuilder();
        Arrays.stream(taxRules).forEach(dynamicObject -> {
            one.append(dynamicObject.getString("number"));
            one.append(" ");
            one.append(dynamicObject.getString("name"));
            one.append("\n");
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            StringBuilder meg = new StringBuilder();
            collection.stream().forEach(o -> {
                meg.append(fourNameMap.get(o.getString("entryclass"))).append(" ");
                meg.append(StringUtils.isBlank((CharSequence)o.getString("entrytype.name")) ? "" : o.getString("entrytype.name")).append(" ");
                meg.append(o.getString("condition")).append(" ");
                meg.append(o.getString("valuename")).append(" ");
                meg.append(o.getString("link")).append(" ");
            });
            String tempMeg = meg.toString().endsWith("AND ") && meg.toString().length() > 4 ? meg.toString().substring(0, meg.toString().length() - 4) : meg.toString();
            allRuleMap.put(dynamicObject.getString("number"), this.getTaxRuleLineInfo((DynamicObject)dynamicObject, tempMeg));
        });
        ruleMap.put(TaxLogRuleEnum.ONE.getName(), one.toString());
        ArrayList<String> noMeetList = new ArrayList<String>();
        List<FourPVo> fourP = materialLineDto.getFourP();
        DataSet dataSet = TaxRuleAlgoService.handlerFourPVo(fourP);
        block0: for (DynamicObject dd : taxRules) {
            DynamicObjectCollection entry = dd.getDynamicObjectCollection("entryentity");
            for (DynamicObject v : entry) {
                String filter = this.createFilter(v);
                if (!dataSet.copy().filter(filter).isEmpty()) continue;
                noMeetList.add(dd.getString("number"));
                continue block0;
            }
        }
        StringBuilder noMeet = new StringBuilder();
        noMeetList.stream().forEach(o -> {
            noMeet.append((String)allRuleMap.get(o));
            noMeet.append("\n");
        });
        ruleMap.put(TaxLogRuleEnum.TWO.getName(), noMeet.toString());
        ArrayList yesMeet = new ArrayList();
        allRuleMap.keySet().stream().filter(o -> !noMeetList.contains(o)).forEach(key -> yesMeet.add(allRuleMap.get(key)));
        ruleMap.put(TaxLogRuleEnum.THREE.getName(), String.join((CharSequence)"\n", yesMeet));
        stepStepFiveLog.addAll(TaxLogUtils.generateSmallStepLogInfo(ruleMap));
        TaxLogUtils.setLogV(BillTaxStepEnum.STEP_FIVE.getStepName(), stepLogMap, stepStepFiveLog);
    }

    private void dealStepThreeAndFour(TaxLogMaterialLineDto materialLineDto, LinkedHashMap<String, String> stepLogMap) {
        DynamicObject businessScenario = materialLineDto.getLastBillTaxConfig();
        ArrayList<String> stepThreeLog = new ArrayList<String>();
        ArrayList<String> stepFourLog = new ArrayList<String>();
        LinkedHashMap<String, List> stepFourLogMap = new LinkedHashMap<String, List>();
        if (null != businessScenario) {
            map.forEach((k, v) -> {
                ArrayList<String> log = new ArrayList<String>();
                stepThreeLog.addAll(v.service(this.billTaxVo, materialLineDto, log));
                if (!ObjectUtils.isEmpty(log)) {
                    stepFourLogMap.put((String)k, log);
                }
            });
        }
        stepFourLogMap.forEach((key, value) -> {
            String info = String.join((CharSequence)"\n", value);
            if (StringUtils.isNotBlank((CharSequence)info)) {
                if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bastax_taxproduct")) {
                    stepFourLog.add(TaxLogMultiLangConstant.getFOURP_Product() + "\n" + info);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bastax_addresstype")) {
                    stepFourLog.add(TaxLogMultiLangConstant.getFOURP_Addressterms() + "\n" + info);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bastax_party_type")) {
                    stepFourLog.add(TaxLogMultiLangConstant.getFOURP_Party() + "\n" + info);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bastax_process_type")) {
                    stepFourLog.add(TaxLogMultiLangConstant.getFOURP_Process() + "\n" + info);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bastax_specific_product")) {
                    stepFourLog.add(TaxLogMultiLangConstant.getFOURP_Specific() + "\n" + info);
                }
            }
        });
        stepFourLog.add(" ");
        TaxLogUtils.setLogV(BillTaxStepEnum.STEP_THREE.getStepName(), stepLogMap, stepThreeLog);
        TaxLogUtils.setLogV(BillTaxStepEnum.STEP_FOUR.getStepName(), stepLogMap, stepFourLog);
    }

    private void dealStepTwo(TaxLogMaterialLineDto materialLineDto, LinkedHashMap<String, String> stepLogMap) {
        DynamicObject businessScenario = materialLineDto.getLastBillTaxConfig();
        ArrayList<String> stepTwoLog = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (null != businessScenario) {
            sb.append(businessScenario.getString("number")).append(" ").append(businessScenario.getString("name"));
        } else {
            sb.append("NULL");
        }
        stepTwoLog.add(sb.append("\n").toString());
        TaxLogUtils.setLogV(BillTaxStepEnum.STEP_TWO.getStepName(), stepLogMap, stepTwoLog);
    }

    private void dealStepOne(TaxLogMaterialLineDto materialLineDto, LinkedHashMap<String, String> stepLogMap) {
        ArrayList<String> stepOneLog = new ArrayList<String>();
        stepOneLog.add(TaxLogMultiLangConstant.getONE_ONE());
        DynamicObject[] taxConfigs = materialLineDto.getBillTaxConfigs();
        if (null != taxConfigs && taxConfigs.length > 0) {
            StringBuilder sb = new StringBuilder();
            Arrays.stream(taxConfigs).forEach(row -> {
                sb.append(row.getString("number")).append(" ").append(row.getString("name"));
                sb.append(",");
                sb.append(TaxLogMultiLangConstant.getCALL_CONDITIONS()).append(row.getString("callcondition"));
                sb.append("\n");
            });
            stepOneLog.add(sb.toString());
        } else {
            stepOneLog.add(TaxLogMultiLangConstant.getONE_ONE_NO());
        }
        stepOneLog.add(TaxLogMultiLangConstant.getONE_TWO());
        List<FieldsAndDataTypeVo> list = materialLineDto.getBillConfigsFieldList();
        String entityName = this.billTaxVo.getCurrentBillKey();
        if (ObjectUtils.isEmpty(list)) {
            stepOneLog.add("NULL");
        } else {
            List fields = list.stream().map(vo -> vo.getFields()).collect(Collectors.toList());
            Map<String, Object> fieldValueMap = list.stream().collect(Collectors.toMap(o -> o.getFields(), b -> null == b.getValue() ? "" : b.getValue()));
            QFilter billnumberQ = new QFilter("billnumber", "=", (Object)entityName);
            QFilter numberQ = new QFilter("number", "in", (Object)fields.toArray());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_where_fields", (String)"name,number", (QFilter[])new QFilter[]{billnumberQ, numberQ});
            StringBuilder sb = new StringBuilder();
            collection.stream().forEach(o -> {
                sb.append("[").append(o.get("name")).append("]").append(":");
                sb.append(TaxLogUtils.getEntityFieldValue(fieldValueMap.get(o.getString("number")), entityName, o.getString("number")));
                sb.append("\n");
            });
            stepOneLog.add(sb.toString());
        }
        TaxLogUtils.setLogV(BillTaxStepEnum.STEP_ONE.getStepName(), stepLogMap, stepOneLog);
    }

    private String createFilter(DynamicObject dd) {
        StringBuilder sb = new StringBuilder();
        String entryClass = dd.getString("entryclass");
        sb.append(" entryClass = \"").append(entryClass).append('\"');
        DynamicObject d = dd.getDynamicObject("entrytype");
        long entryType = 0L;
        if (null != d) {
            entryType = dd.getDynamicObject("entrytype").getLong("id");
        }
        sb.append(" and entryType = ").append(entryType);
        String value = dd.getString("valueid");
        String conditions = dd.getString("condition");
        if (conditions.contains("in")) {
            sb.append(" and valueId ").append(conditions).append('(').append(value).append(')');
        } else {
            sb.append(" and valueId ").append(conditions).append(value);
        }
        return sb.toString();
    }

    private String getTaxRuleLineInfo(DynamicObject dynamicObject, String ruleInfo) {
        StringBuilder info = new StringBuilder();
        info.append(dynamicObject.getString("number"));
        info.append(" ");
        info.append(dynamicObject.getString("name"));
        info.append("\n");
        info.append(TaxLogMultiLangConstant.getTAXRULE_CONDITION());
        info.append(ruleInfo);
        return info.toString();
    }

    public void saveStepLog(Map<String, LinkedHashMap<String, String>> logs, String taxResults, Map<String, String> taxcodeLineLogs) {
        DynamicObject billtaxlog = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_billtaxlog");
        billtaxlog.set("billid", this.callBillMap.get("billid"));
        billtaxlog.set("number", this.callBillMap.get("billno"));
        billtaxlog.set("billlname", this.callBillMap.get("billlname"));
        billtaxlog.set("createtime", (Object)new Date());
        billtaxlog.set("creator", (Object)RequestContext.get().getUserId());
        billtaxlog.set("enable", (Object)1);
        billtaxlog.set("status", (Object)"C");
        billtaxlog.set("lognumber", (Object)TaxLogUtils.getLogNumber("JS", String.valueOf(this.callBillMap.get("billlname"))));
        billtaxlog.set("taxResults", (Object)taxResults);
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObject[] saveDb = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billtaxlog});
                Long id = saveDb[0].getLong("id");
                ArrayList list = new ArrayList();
                logs.forEach((key, value) -> {
                    DynamicObject content = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_logcontent");
                    content.set("number", key);
                    content.set("taxcodelinelog", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"TaxLogService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    if (null != taxcodeLineLogs) {
                        content.set("taxcodelinelog_tag", taxcodeLineLogs.get(key));
                    }
                    content.set("billtaxlog", (Object)id);
                    content.set("enable", (Object)1);
                    content.set("status", (Object)"C");
                    TaxLogMaterialLineDto dto = this.materialLineDtos.get(Integer.parseInt(key) - 1);
                    content.set("lineresults", (Object)(ObjectUtils.isEmpty(dto.getTaxLineVos()) ? "fail" : "succ"));
                    StringBuilder business = new StringBuilder();
                    value.forEach((k, v) -> {
                        business.append("\n");
                        business.append(BillTaxStepEnum.getStepNo(k)).append((String)k);
                        business.append("\n");
                        business.append((String)v);
                    });
                    content.set("businesslog", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"TaxLogService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    content.set("businesslog_tag", (Object)business.toString());
                    list.add(content);
                });
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
            }
            catch (Exception e) {
                logger.error("taxc-TaxLogService saveStepLog fail:", (Object)e.getMessage());
                h.markRollback();
            }
        }
    }

    public List<TaxLogMaterialLineDto> getMaterialLineDtos() {
        return this.materialLineDtos;
    }

    public void collectBillTaxVo(BillTaxVo billTaxVo) {
        if (this.isCloseWriteLog) {
            return;
        }
        this.billTaxVo = billTaxVo;
    }

    public void collectCallBillMap(Map callBillMap) {
        if (this.isCloseWriteLog) {
            return;
        }
        this.callBillMap = callBillMap;
    }

    public void collectTaxCodeLineLog(Map<String, String> taxCodeLineLog) {
        if (this.isCloseWriteLog) {
            return;
        }
        this.taxCodeLineLog = taxCodeLineLog;
    }

    public void collectTaxResults(String taxResults) {
        if (this.isCloseWriteLog) {
            return;
        }
        this.taxResults = taxResults;
    }

    public List getValue() {
        return Collections.singletonList("");
    }

    public Object executor(Object ex) {
        this.service();
        return null;
    }

    static {
        map.put("bastax_taxproduct", new TaxLogProductService());
        map.put("bastax_addresstype", new TaxLogAddresstermsService());
        map.put("bastax_party_type", new TaxLogPartyService());
        map.put("bastax_process_type", new TaxLogProcessService());
        map.put("bastax_specific_product", new TaxLogSpecificService());
        fourNameMap.put("bastax_taxproduct", TaxLogMultiLangConstant.getFOURP_Product());
        fourNameMap.put("bastax_addresstype", TaxLogMultiLangConstant.getFOURP_Addressterms());
        fourNameMap.put("bastax_party_type", TaxLogMultiLangConstant.getFOURP_Party());
        fourNameMap.put("bastax_process_type", TaxLogMultiLangConstant.getFOURP_Process());
    }
}

