/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.TaxLogFourEnum;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogMaterialLineDto;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogMultiLangConstant;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogAddresstermsService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogPartyService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogProcessService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogProductService;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.service.TaxLogSpecificService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.AddresstermsServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.PartyServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.ProcessServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.SpecificServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxProductServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.TaxLogUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;

public abstract class TaxLogFourAbstractService {
    private static Log logger = LogFactory.getLog(TaxLogFourAbstractService.class);
    protected String entryKey;
    protected String sourceKey;
    protected String fieldKey;
    protected String conditionjson;
    protected String condition;

    public abstract List<String> service(BillTaxVo var1, TaxLogMaterialLineDto var2, List<String> var3);

    public Map<DynamicObject, Map<String, Object>> beforeService(TaxLogMaterialLineDto materialLineDto) {
        AtomicReference map = new AtomicReference();
        List<Map<String, Map<DynamicObject, Map<String, Object>>>> list = materialLineDto.getFourPList();
        list.stream().forEach(fourPMap -> fourPMap.forEach((k, v) -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)k, (CharSequence)TaxProductServiceImpl.class.getSimpleName()) && this instanceof TaxLogProductService) {
                map.set(v);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)k, (CharSequence)AddresstermsServiceImpl.class.getSimpleName()) && this instanceof TaxLogAddresstermsService) {
                map.set(v);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)k, (CharSequence)PartyServiceImpl.class.getSimpleName()) && this instanceof TaxLogPartyService) {
                map.set(v);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)k, (CharSequence)ProcessServiceImpl.class.getSimpleName()) && this instanceof TaxLogProcessService) {
                map.set(v);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)k, (CharSequence)SpecificServiceImpl.class.getSimpleName()) && this instanceof TaxLogSpecificService) {
                map.set(v);
            }
        }));
        return (Map)map.get();
    }

    public List<String> getInfo(LinkedHashMap<String, String> fourMap) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        fourMap.forEach((k, v) -> sb.append((String)k).append("\n").append((String)v).append("\n"));
        list.add(sb.toString());
        return list;
    }

    protected String getBillHead(DynamicObject key, String source, String field) {
        StringBuilder billHead = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)field)) {
            billHead.append(key.getString(source));
            billHead.append("[");
            billHead.append(key.getString(field));
            billHead.append("]");
        } else {
            billHead.append(key.getString(source));
        }
        return billHead.toString();
    }

    protected void readBusinessElement(LinkedHashMap<String, String> fourMap, BillTaxVo billTaxVo, String sourceKey, String fieldKey, DynamicObject key, Map<String, Object> map, String source, String field) {
        if (StringUtils.isNotBlank((CharSequence)fieldKey)) {
            fourMap.put(TaxLogFourEnum.TWO.getName(), this.getBillHead(key, source, field) + ":" + String.valueOf(TaxLogUtils.getEntityFieldValue(billTaxVo, key.getString(sourceKey), key.getString(fieldKey))) + "," + (null == map ? TaxLogMultiLangConstant.getMEET_NO() : TaxLogMultiLangConstant.getMEET_YES()));
        } else {
            fourMap.put(TaxLogFourEnum.TWO.getName(), this.getBillHead(key, source, field) + "," + (null == map ? TaxLogMultiLangConstant.getMEET_NO() : TaxLogMultiLangConstant.getMEET_YES()));
        }
    }

    protected void conversionTaxElement(DynamicObject key, String entryNubmer, String conditiontype, List<String> tempList, Map<String, Object> map, LinkedHashMap<String, String> fourMap, List<String> stepFourLog) {
        ArrayList<Long> idList = new ArrayList<Long>();
        if (null != map && map.get("valueid") instanceof Long) {
            idList.add((Long)map.get("valueid"));
        } else if (null != map && map.get("valueid") instanceof String) {
            String[] ids;
            for (String id : ids = ((String)map.get("valueid")).split(",")) {
                idList.add(Long.parseLong(id));
            }
        }
        DynamicObject[] objects = ObjectQueryUtils.queryDynamicObject(entryNubmer, "number,name", idList);
        if (null != objects && objects.length > 0) {
            List list = Arrays.stream(objects).map(o -> o.getString("number") + " " + o.getString("name")).collect(Collectors.toList());
            fourMap.put(TaxLogFourEnum.THREE.getName(), ObjectUtils.isEmpty(list) ? "NULL" : String.join((CharSequence)"\n", list));
            if (StringUtils.isNotBlank((CharSequence)conditiontype) && !ObjectUtils.isEmpty(list)) {
                stepFourLog.add(key.get(conditiontype) + ":" + String.join((CharSequence)"\n", list));
            } else {
                stepFourLog.addAll(list);
            }
        }
        tempList.addAll(TaxLogUtils.generateSmallStepLogInfo(fourMap));
    }

    protected List<String> returnResult(List<String> fourLog) {
        if (!ObjectUtils.isEmpty(fourLog) && fourLog.size() == 1) {
            return new ArrayList<String>();
        }
        return fourLog;
    }
}

