/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxConfigService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxConfigAbstractService;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FieldsAndDataTypeVo;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class AddresstermsServiceImpl
extends TaxConfigAbstractService
implements TaxConfigService {
    private static Log logger = LogFactory.getLog(AddresstermsServiceImpl.class);
    private String conditiontype = "conditiontype";
    private String entryentity = "entryentity.administrativelevel,entryentity.condition,entryentity.valueid";
    private String administrativelevel_Key = "administrativelevel";
    private String conditionKey = "condition";
    private String valueKey = "valueid";

    public AddresstermsServiceImpl() {
        this.entryKey = "address_entity";
        this.sourceKey = "addresssourcekey";
        this.fieldKey = "addressfieldkey";
        this.conditionjson = "";
        this.condition = "";
    }

    @Override
    public Map<String, Object> cal(BillTaxVo billTaxVo, DynamicObject d) {
        FieldsAndDataTypeVo value = this.getValue(billTaxVo, d);
        logger.info("tax-AddresstermsServiceImpl" + JsonUtil.toJson(value.toString()));
        if (value.getBaseEntityId().equals("bd_admindivision") || value.getBaseEntityId().equals("bd_address") || null != value.getDynamicProperty() && value.getDynamicProperty() instanceof AdminDivisionProp) {
            DynamicObject dob = ObjectQueryUtils.queryBdAdmindivisionId(value.getValue());
            long countryid = null != dob ? dob.getLong("country.id") : 0L;
            logger.info("tax-ids" + JsonUtil.toJson(countryid));
            long[] ids = this.queryOtherAddress(null != dob ? dob.getLong("id") : 0L, null != dob ? dob.getInt("basedatafield.level") : 0);
            logger.info("tax-ids" + JsonUtil.toJson(ids));
            return this.handler(countryid, ids, billTaxVo, d);
        }
        if (value.getBaseEntityId().equals("bd_country")) {
            return this.handler(null != value.getValue() ? (Long)value.getValue() : 0L, new long[]{0L, 0L, 0L}, billTaxVo, d);
        }
        return null;
    }

    private long getId(long[] ids, int index) {
        if (ids.length > index) {
            return ids[index];
        }
        return 0L;
    }

    private Map<String, Object> handler(long countryid, long[] ids, BillTaxVo billTaxVo, DynamicObject d) {
        DynamicObject[] doc;
        HashMap<String, Object> map = null;
        List<Long> groupIds = ObjectQueryUtils.queryTaxAreaIdAndDate(countryid, billTaxVo.getDate());
        for (DynamicObject dd : doc = ObjectQueryUtils.queryBastaxAddressterms(billTaxVo.getCountry(), billTaxVo.getOrgId(), d.getDynamicObject(this.conditiontype).getLong("id"), "id," + this.entryentity)) {
            DynamicObjectCollection vs = dd.getDynamicObjectCollection("entryentity");
            boolean flag = false;
            for (DynamicObject v : vs) {
                String administrativelevelKey = v.getString(this.administrativelevel_Key);
                String conditionkey = v.getString(this.conditionKey);
                long valueidKey = v.getLong(this.valueKey);
                flag = "taxarea".equals(administrativelevelKey) ? this.isConditionTaxarea(conditionkey, groupIds, valueidKey) : ("country".equals(administrativelevelKey) ? this.isCondition(conditionkey, countryid, valueidKey) : ("province".equals(administrativelevelKey) ? this.isCondition(conditionkey, this.getId(ids, 0), valueidKey) : ("city".equals(administrativelevelKey) ? this.isCondition(conditionkey, this.getId(ids, 1), valueidKey) : ("county".equals(administrativelevelKey) ? this.isCondition(conditionkey, this.getId(ids, 2), valueidKey) : false))));
                if (flag) continue;
                break;
            }
            if (!flag) continue;
            if (map == null) {
                map = new HashMap<String, Object>(2);
                map.put("entrytype", d.getDynamicObject(this.conditiontype).getLong("id"));
                map.put("valueid", dd.getString("id"));
                continue;
            }
            String id = (String)map.get("valueid");
            map.put("valueid", id + "," + dd.getString("id"));
        }
        return map;
    }

    private boolean isCondition(String condition, long value1, long value2) {
        if (value1 == value2 && "=".equals(condition)) {
            return true;
        }
        return value1 != value2 && "<>".equals(condition);
    }

    private boolean isConditionTaxarea(String condition, List<Long> groupIds, long value2) {
        if (groupIds.contains(value2) && "=".equals(condition)) {
            return true;
        }
        return !groupIds.contains(value2) && "<>".equals(condition);
    }

    public long[] queryOtherAddress(long id, int level) {
        long[] ids = new long[]{0L, 0L, 0L};
        for (int i = 1; i <= level; ++i) {
            logger.info("tax-ids" + id + ";level:" + level);
            if (level - i <= 2) {
                ids[level - i] = id;
            }
            if (level - i <= 0) continue;
            DynamicObject temp = ObjectQueryUtils.queryBdAdmindivisionId(id);
            id = null != temp ? temp.getLong("parent.id") : 0L;
        }
        return ids;
    }
}

