/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.tax.service.BillRegisterService;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillRegisterVo;

public class BillRegisterServiceImpl
implements BillRegisterService {
    private static final String BASTAX_BILL_INTERFACE = "bastax_bill_interface";
    private static final String FIELDS = "servicename,method,orgkey,countrykey,datekey,vat,taxbillentrykeykey,internationaltaxkeykey,taxtypekeykey,taxcodekeykey";

    @Override
    public BillRegisterVo getBillParams(String currentBillKey, String servicename, String method, DynamicObject dos) {
        QFilter billQ = new QFilter("bill", "=", (Object)currentBillKey);
        QFilter serviceNameQ = new QFilter("servicename", "=", (Object)servicename);
        QFilter methodQ = new QFilter("method", "=", (Object)method);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_BILL_INTERFACE, (String)FIELDS, (QFilter[])new QFilter[]{enable, billQ, serviceNameQ, methodQ});
        BillRegisterVo billRegisterVo = null;
        if (null != collection && collection.size() > 0) {
            billRegisterVo = new BillRegisterVo();
            DynamicObject dynamicObject = (DynamicObject)collection.get(0);
            String orgKey = dynamicObject.getString("orgkey");
            String countryKey = dynamicObject.getString("countrykey");
            String dateKey = dynamicObject.getString("datekey");
            String vat = dynamicObject.getString("vat");
            String taxbillentrykey = dynamicObject.getString("taxbillentrykeykey");
            String internationaltaxkey = dynamicObject.getString("internationaltaxkeykey");
            String taxtypekey = dynamicObject.getString("taxtypekeykey");
            String taxcodekey = dynamicObject.getString("taxcodekeykey");
            DynamicObject org = StringUtils.isEmpty((CharSequence)orgKey) ? null : dos.getDynamicObject(orgKey);
            DynamicObject country = StringUtils.isEmpty((CharSequence)countryKey) ? null : dos.getDynamicObject(countryKey);
            billRegisterVo.setCallBill(currentBillKey);
            billRegisterVo.setServicename(servicename);
            billRegisterVo.setMethod(method);
            billRegisterVo.setOrgId(0L);
            billRegisterVo.setCountry(0L);
            if (null != org) {
                billRegisterVo.setOrgId(org.getLong("id"));
            }
            if (null != country) {
                billRegisterVo.setCountry(country.getLong("id"));
            }
            billRegisterVo.setDate(StringUtils.isEmpty((CharSequence)dateKey) ? null : dos.getDate(dateKey));
            billRegisterVo.setTaxbillentrykey(taxbillentrykey);
            billRegisterVo.setInternationaltaxkey(internationaltaxkey);
            billRegisterVo.setTaxtypekey(taxtypekey);
            billRegisterVo.setTaxcodekey(taxcodekey);
            billRegisterVo.setVat(vat);
        }
        return billRegisterVo;
    }
}

