/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.taxc.vo.TaxLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxRuleService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxRuleAlgoService;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FourPVo;

public class TaxRuleServiceImpl
implements TaxRuleService {
    private static Log logger = LogFactory.getLog(TaxRuleServiceImpl.class);
    private String entryclass = "entryclass";
    private String entrytype = "entrytype";
    private String condition = "condition";
    private String valueid = "valueid";
    private String link = "link";
    private String itemclass = "itemclass";
    private String itemresult = "itemresult";
    private String number = "number";
    private String select = "id," + this.number + "," + this.itemclass + "," + this.itemresult + ",entryentity." + this.entryclass + ",entryentity." + this.entrytype + ",entryentity." + this.condition + ",entryentity." + this.valueid + ",entryentity." + this.link + ",entryentity.valuename";

    @Override
    public List<TaxLineVo> service(BillTaxVo billTaxVo, List<FourPVo> fourP) {
        ArrayList<TaxLineVo> taxLineVos = new ArrayList<TaxLineVo>(16);
        DataSet dataSet = TaxRuleAlgoService.handlerFourPVo(fourP);
        DynamicObject[] dos = ObjectQueryUtils.queryBdtaxrTaxRules(this.select, billTaxVo.getOrgId(), billTaxVo.getCountry(), billTaxVo.getDate());
        billTaxVo.getLogger().addTaxRule(dos);
        billTaxVo.getTaxLogMaterialLineDto().collectTaxRules(dos);
        long size = 0L;
        DynamicObject ret = null;
        for (DynamicObject dd : dos) {
            boolean flag = true;
            DynamicObjectCollection entry = dd.getDynamicObjectCollection("entryentity");
            for (DynamicObject v : entry) {
                String filter = this.createFilter(v);
                if (!dataSet.copy().filter(filter).isEmpty()) continue;
                billTaxVo.getLogger().addTaxRule(dd.getString("number"), filter);
                flag = false;
                break;
            }
            if (!flag || size >= (long)entry.size()) continue;
            size = entry.size();
            ret = dd;
        }
        if (null != ret) {
            billTaxVo.getLogger().addTaxRule(ret);
            billTaxVo.getTaxLogMaterialLineDto().collectLastTaxRule(ret);
            ArrayList<Long> taxCodeList = new ArrayList<Long>(16);
            long id = ret.getDynamicObject("itemresult").getLong("id");
            String itemclassName = ret.getDynamicObject("itemresult").getDynamicObjectType().getName();
            if (StringUtils.equalsIgnoreCase((CharSequence)itemclassName, (CharSequence)"bastax_taxcode")) {
                taxCodeList.add(id);
                this.singleTaxCode(taxLineVos, taxCodeList, billTaxVo, 1);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)itemclassName, (CharSequence)"bastax_taxgroup")) {
                List<DynamicObject> taxCodes = ObjectQueryUtils.queryBastaxTaxgroup(id, billTaxVo.getOrgId(), billTaxVo.getCountry(), billTaxVo.getDate());
                taxCodes.stream().forEach(code -> this.singleTaxCode(taxLineVos, Collections.singletonList(code.getLong("entryentity.taxcode.id")), billTaxVo, code.getInt("entryentity.order")));
                taxCodeList.addAll(taxCodes.stream().map(o -> o.getLong("entryentity.taxcode.id")).collect(Collectors.toList()));
            }
            if (!ObjectUtils.isEmpty(taxLineVos)) {
                billTaxVo.getAtomicInteger().getAndIncrement();
            }
        }
        billTaxVo.getLogger().addTaxCodeAndTaxRate(taxLineVos);
        billTaxVo.getTaxLogMaterialLineDto().collectTaxLineVos(taxLineVos);
        return taxLineVos;
    }

    private String createFilter(DynamicObject dd) {
        StringBuilder sb = new StringBuilder();
        String entryClass = dd.getString(this.entryclass);
        sb.append(" entryClass = \"").append(entryClass).append('\"');
        DynamicObject d = dd.getDynamicObject(this.entrytype);
        long entryType = 0L;
        if (null != d) {
            entryType = dd.getDynamicObject(this.entrytype).getLong("id");
        }
        sb.append(" and entryType = ").append(entryType);
        String value = dd.getString(this.valueid);
        String conditions = dd.getString(this.condition);
        if (conditions.contains("in")) {
            sb.append(" and valueId ").append(conditions).append('(').append(value).append(')');
        } else {
            sb.append(" and valueId ").append(conditions).append(value);
        }
        return sb.toString();
    }

    private void singleTaxCode(List<TaxLineVo> taxLineVos, List<Long> ids, BillTaxVo billTaxVo, int order) {
        long orgId = billTaxVo.getOrgId();
        long countryId = billTaxVo.getCountry();
        Date date = billTaxVo.getDate();
        String vat = billTaxVo.getTaxcodeProperty();
        DynamicObject[] taxCodes = ObjectQueryUtils.queryTaxCode(ids, orgId, countryId, date);
        logger.info("============singleTaxCode\uff1a" + ids);
        for (DynamicObject taxCode : taxCodes) {
            TaxLineVo taxLineVo = new TaxLineVo();
            String taxcodeproperty = taxCode.getString("taxcodeproperty");
            taxLineVo.setTaxType(Long.valueOf(taxCode.getLong("taxtype.id")));
            taxLineVo.setTaxCode(Long.valueOf(taxCode.getLong("id")));
            taxLineVo.setTaxRate(null);
            taxLineVo.setOffsetLogo(taxCode.getString("offsetlogo"));
            taxLineVo.setOrder(Integer.valueOf(order));
            taxLineVo.setDefaultTaxCode(StringUtils.equalsIgnoreCase((CharSequence)vat, (CharSequence)taxcodeproperty) ? Integer.valueOf(1) : Integer.valueOf(0));
            DynamicObject taxrate = ObjectQueryUtils.queryBastaxTaxcode(taxCode.getLong("id"), countryId, date);
            if (null != taxrate) {
                logger.info("============singleTaxCode taxrate:id=" + taxrate.getLong("id") + ",taxrate=" + taxrate.getBigDecimal("taxrate"));
                taxLineVo.setTaxRate(Long.valueOf(taxrate.getLong("id")));
                taxLineVo.setTaxRatePercent(taxrate.getBigDecimal("taxrate"));
            }
            logger.info(taxLineVo.toString());
            taxLineVos.add(taxLineVo);
        }
    }
}

