/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class BotpUtils {
    private static Log logger = LogFactory.getLog(BotpUtils.class);

    public static void findSourceBills(Map<String, HashSet<Long>> sourceBills, String entityNumber, long billIds) {
        try {
            Map map = BFTrackerServiceHelper.findSourceBills((String)entityNumber, (Long[])new Long[]{billIds});
            map.forEach((k, v) -> sourceBills.put((String)k, (HashSet<Long>)v));
            Map targetBil = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])new Long[]{billIds});
            targetBil.forEach((k, v) -> sourceBills.put((String)k, (HashSet<Long>)v));
        }
        catch (Exception e) {
            logger.error("findSourceBills:", (Throwable)e);
        }
    }

    public static long findSourceEntryBills(String sourceNumber, String soureEntryNumber, String targetNumber, String targetEntityNumber, long id) {
        logger.error("tax-findSourceEntryBills:\u5f00\u59cb\u8c03\u7528");
        Set<Long> set = null;
        if (StringUtils.isNotEmpty((String)sourceNumber) && (null == (set = BotpUtils.findSourceEntryDownBills(sourceNumber, soureEntryNumber, targetNumber, targetEntityNumber, id)) || ObjectUtils.isEmpty(set))) {
            set = BotpUtils.findSourceEntryUpBills(sourceNumber, soureEntryNumber, targetNumber, targetEntityNumber, id);
        }
        logger.error("tax-set:" + JsonUtil.toJson(set));
        if (null == set) {
            return 0L;
        }
        if (set.size() > 0) {
            return set.toArray(new Long[0])[0];
        }
        return 0L;
    }

    private static Set<Long> findSourceEntryUpBills(String sourceNumber, String soureEntryNumber, String targetNumber, String targetEntityNumber, long id) {
        TableDefine srcMainTable = EntityMetadataCache.loadTableDefine((String)targetNumber, (String)targetNumber);
        TableDefine srcEntryTable = EntityMetadataCache.loadTableDefine((String)targetNumber, (String)targetEntityNumber);
        TableDefine targetEntryTable = EntityMetadataCache.loadTableDefine((String)sourceNumber, (String)soureEntryNumber);
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)sourceNumber, (String)soureEntryNumber, (Long[])new Long[]{id});
        logger.info("tax-linkUpNodes" + JsonUtil.toJson(linkUpNodes));
        HashMap rowId_SrcRowIds = new HashMap();
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            if (Long.compare(targetEntryTable.getTableId(), linkUpNode.getRowId().getTableId()) != 0) continue;
            Long targetRowId = linkUpNode.getRowId().getEntryId();
            if (!rowId_SrcRowIds.containsKey(targetRowId)) {
                rowId_SrcRowIds.put(targetRowId, new HashSet());
            }
            List srcRowNodes = linkUpNode.findSourceNodes(srcMainTable.getTableId());
            for (BFRowLinkUpNode srcRowNode : srcRowNodes) {
                if (Long.compare(srcEntryTable.getTableId(), srcRowNode.getRowId().getTableId()) != 0) continue;
                Long srcRowId = srcRowNode.getRowId().getEntryId();
                ((Set)rowId_SrcRowIds.get(targetRowId)).add(srcRowId);
            }
        }
        if (!rowId_SrcRowIds.isEmpty()) {
            return (Set)rowId_SrcRowIds.get(id);
        }
        return null;
    }

    private static Set<Long> findSourceEntryDownBills(String sourceNumber, String soureEntryNumber, String targetNumber, String targetEntityNumber, long id) {
        TableDefine sourceEntryTable = EntityMetadataCache.loadTableDefine((String)sourceNumber, (String)soureEntryNumber);
        TableDefine targetMainTable = EntityMetadataCache.loadTableDefine((String)targetNumber, (String)targetNumber);
        TableDefine targetEntryTable = EntityMetadataCache.loadTableDefine((String)targetNumber, (String)targetEntityNumber);
        List linkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)sourceNumber, (String)soureEntryNumber, (Long[])new Long[]{id});
        logger.info("tax-linkDownNodes" + JsonUtil.toJson(linkDownNodes));
        HashMap rowId_targetRowIds = new HashMap();
        for (BFRowLinkDownNode linkDownNode : linkDownNodes) {
            Long sourceRowId;
            if (Long.compare(sourceEntryTable.getTableId(), linkDownNode.getRowId().getTableId()) != 0 || rowId_targetRowIds.containsKey(sourceRowId = linkDownNode.getRowId().getEntryId())) continue;
            rowId_targetRowIds.put(sourceRowId, new HashSet());
        }
        if (!rowId_targetRowIds.isEmpty()) {
            return (Set)rowId_targetRowIds.get(id);
        }
        return null;
    }
}

