/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.BotpUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FilterGetValueUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FieldsAndDataTypeVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FiledsPropertyVo;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class FetchValueUtils {
    private static Log logger = LogFactory.getLog(FetchValueUtils.class);

    public static FieldsAndDataTypeVo fetchValue(BillTaxVo billTaxVo, String entityNumber, String filed) {
        ArrayList<FieldsAndDataTypeVo> list = new ArrayList<FieldsAndDataTypeVo>();
        String[] filedsArr = new String[3];
        List<LinkedList<FiledsPropertyVo>> filedsPropertyVos = MetadataUtil.queryProperty(entityNumber, filed, filedsArr, false);
        LinkedList<FiledsPropertyVo> filedsPropertyVo = filedsPropertyVos.get(0);
        if (billTaxVo.getEntityNumber().equalsIgnoreCase(entityNumber)) {
            FilterGetValueUtils.filterFetchValue(filedsPropertyVo, billTaxVo.getDos(), billTaxVo.getTaxBillEntry(), entityNumber, filedsArr[0], list, billTaxVo, "");
            FieldsAndDataTypeVo v = (FieldsAndDataTypeVo)list.get(0);
            v.setBaseEntityId(filedsPropertyVo.get(filedsPropertyVo.size() - 1).getBaseEntityId());
            v.setDynamicProperty(filedsPropertyVo.get(filedsPropertyVo.size() - 1).getDynamicProperty());
            return v;
        }
        DynamicObject[] array = FetchValueUtils.calEntryValue(billTaxVo, entityNumber, filedsPropertyVo);
        DynamicObject main = null;
        DynamicObject sub = null;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (0 == i) {
                    main = array[i];
                    continue;
                }
                if (1 != i) continue;
                sub = array[i];
            }
        }
        FilterGetValueUtils.filterFetchValue(filedsPropertyVo, main, sub, entityNumber, filedsArr[0], list, billTaxVo, "");
        FieldsAndDataTypeVo v = (FieldsAndDataTypeVo)list.get(0);
        v.setBaseEntityId(filedsPropertyVo.get(filedsPropertyVo.size() - 1).getBaseEntityId());
        v.setDynamicProperty(filedsPropertyVo.get(filedsPropertyVo.size() - 1).getDynamicProperty());
        return v;
    }

    public static DynamicObject[] calEntryValue(BillTaxVo billTaxVo, String entityNumber, LinkedList<FiledsPropertyVo> filedsPropertyVo) {
        DynamicObject[] array = new DynamicObject[2];
        DynamicObjectCollection source = billTaxVo.getSourceData().get(entityNumber);
        if (null != source && source.size() > 0) {
            array[0] = ObjectQueryUtils.queryDynamicObject(entityNumber, filedsPropertyVo.get(0).getFiled(), ((DynamicObject)source.get(0)).get("id"));
            if (filedsPropertyVo.get(0).getDynamicProperty() instanceof EntryProp) {
                DynamicObject[] maintemp;
                long id = 0L;
                if (StringUtils.isEmpty((String)billTaxVo.getEntrySourceKey())) {
                    if ("ap_finapbill".equals(billTaxVo.getEntityNumber())) {
                        id = billTaxVo.getTaxBillEntry().getLong("e_sourcebillentryid");
                    } else if ("ar_finarbill".equals(billTaxVo.getEntityNumber())) {
                        id = billTaxVo.getTaxBillEntry().getLong("e_srcentryid");
                    }
                } else {
                    id = billTaxVo.getTaxBillEntry().getLong(billTaxVo.getEntrySourceKey());
                }
                logger.info("tax-id:" + id);
                long targetid = BotpUtils.findSourceEntryBills(billTaxVo.getBillKey(), billTaxVo.getBillEntryKey(), entityNumber, filedsPropertyVo.get(0).getFiled(), id);
                logger.info("tax-targetid:" + targetid);
                ArrayList<Long> ids = new ArrayList<Long>(source.size());
                source.forEach(v -> ids.add(v.getLong("id")));
                for (DynamicObject temp : maintemp = ObjectQueryUtils.queryDynamicObject(entityNumber, filedsPropertyVo.get(0).getFiled() + "." + filedsPropertyVo.get(1).getFiled(), ids)) {
                    DynamicObjectCollection entry = temp.getDynamicObjectCollection(filedsPropertyVo.get(0).getFiled());
                    for (DynamicObject d : entry) {
                        if (d.getLong("id") != targetid) continue;
                        array[1] = d;
                        array[0] = temp;
                    }
                }
            }
            return array;
        }
        return array;
    }
}

