/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class ObjectQueryUtils {
    public static DynamicObject queryBillConfig(String entityNumber) {
        QFilter filters = new QFilter("number", "=", (Object)entityNumber);
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter ENABLE = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bdtaxr_bill_configs", (String)"billfieldnumber", (QFilter[])new QFilter[]{filters, STATUS, ENABLE});
        return doc.size() > 0 ? (DynamicObject)doc.get(0) : null;
    }

    public static DynamicObject queryBdAdmindivisionId(Object value) {
        QFilter id = new QFilter("id", "=", value);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,parent.id,country.id,basedatafield.level", (QFilter[])new QFilter[]{id});
        return doc.size() > 0 ? (DynamicObject)doc.get(0) : null;
    }

    public static long queryBastaxTaxAreaId(long country) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bastax_taxarea", (String)"group", (QFilter[])new QFilter[]{new QFilter("country", "=", (Object)country)});
        long group = doc.size() > 0 ? ((DynamicObject)doc.get(0)).getLong("group") : 0L;
        return group;
    }

    public static List<Long> queryTaxAreaIdAndDate(long country, Date date) {
        List<Long> taxAreaIds = new ArrayList<Long>();
        QFilter countryQ = new QFilter("country", "=", (Object)country);
        QFilter startDateQ = new QFilter("startdate", "<=", (Object)date);
        QFilter endDateQ = new QFilter("enddate", ">=", (Object)date);
        endDateQ.or(QFilter.isNull((String)"enddate"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bastax_taxarea", (String)"group", (QFilter[])new QFilter[]{countryQ, startDateQ, endDateQ});
        if (null != doc && doc.size() > 0) {
            taxAreaIds = doc.stream().map(o -> o.getLong("group")).collect(Collectors.toList());
        }
        return taxAreaIds;
    }

    public static DynamicObject[] queryBastaxAddressterms(long country, long useorg, long conditiontype, String select) {
        QFilter countryFilter = new QFilter("country", "=", (Object)country);
        QFilter orgid = BaseDataServiceHelper.getBaseDataFilter((String)"bastax_addressterms", (Long)useorg);
        if (null == orgid) {
            orgid = new QFilter("useorg", "=", (Object)useorg);
            QFilter ctrlstrategy = new QFilter("ctrlstrategy", "=", (Object)5);
            orgid.or(ctrlstrategy);
        }
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter addtype = new QFilter("addtype", "=", (Object)conditiontype);
        QFilter[] q = new QFilter[]{countryFilter, orgid, enable, addtype, STATUS};
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)"bastax_addressterms", (String)select, (QFilter[])q);
        return doc;
    }

    public static DynamicObject[] queryBdtaxrBilltaxConfigs(String entityNumber, long orgId, long country) {
        QFilter idsfilters = new QFilter("callbillkey", "=", (Object)entityNumber);
        QFilter ENABLE = new QFilter("enable", "=", (Object)"1");
        QFilter orgid = BaseDataServiceHelper.getBaseDataFilter((String)"bdtaxr_billtax_configs", (Long)orgId);
        if (null == orgid) {
            orgid = new QFilter("useorg", "=", (Object)orgId);
            QFilter ctrlstrategy = new QFilter("ctrlstrategy", "=", (Object)5);
            orgid.or(ctrlstrategy);
        }
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter countryQfilter = new QFilter("country", "=", (Object)country);
        DynamicObject[] businessScenario = BusinessDataServiceHelper.load((String)"bdtaxr_billtax_configs", (String)"id,number,name,callconditionjson,callbill,callcondition,product_entity.productconditionjson,product_entity.productcondition,product_entity.productsourcekey,product_entity.productfieldkey,product_entity.product,product_entity.converttype,product_entity.valuerules,product_entity.productsource,product_entity.productfield,address_entity.addresssourcekey,address_entity.addressfieldkey,address_entity.conditiontype,address_entity.addresssource,address_entity.addressfield,party_entity.partyconditionjson,party_entity.partycondition,party_entity.partysourcekey,party_entity.party,party_entity.partytype,party_entity.partysource,element_entity.elementconditionjson,element_entity.elementcondition,element_entity.elementsourcekey,element_entity.processtype,element_entity.process,element_entity.elementsource,specific_entity.specificconditionjson,specific_entity.specificcondition,specific_entity.specificsourcekey,specific_entity.specificfieldkey,specific_entity.specificsource,specific_entity.specificfield,specific_entity.euproduct,specific_entity.specificproduct", (QFilter[])new QFilter[]{orgid, idsfilters, ENABLE, STATUS, countryQfilter});
        return businessScenario;
    }

    public static DynamicObject[] queryBdtaxrTaxRules(String select, long orgId, long countryId, Date date) {
        QFilter orgid = BaseDataServiceHelper.getBaseDataFilter((String)"bdtaxr_tax_rules", (Long)orgId);
        if (null == orgid) {
            orgid = new QFilter("useorg", "=", (Object)orgId);
            QFilter ctrlstrategy = new QFilter("ctrlstrategy", "=", (Object)5);
            orgid.or(ctrlstrategy);
        }
        QFilter country = new QFilter("type.country", "=", (Object)countryId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter startdate = new QFilter("startdate", "<=", (Object)date);
        QFilter endDate = new QFilter("enddate", ">=", (Object)date);
        endDate.or(QFilter.isNull((String)"enddate"));
        QFilter[] q = new QFilter[]{orgid, country, enable, STATUS, startdate, endDate};
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bdtaxr_tax_rules", (String)select, (QFilter[])q);
        return dos;
    }

    public static DynamicObject queryBastaxTaxcode(long id, long countryId, Date date) {
        QFilter idS = new QFilter("id", "=", (Object)id);
        QFilter[] q = new QFilter[]{idS, new QFilter("entryentity1.valuesource", "=", (Object)"bd_taxrate")};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bastax_taxcode", (String)"id,entryentity1.valuesource ,entryentity1.valueid as taxrateid", (QFilter[])q);
        if (ObjectUtils.isNotEmpty((Object)doc)) {
            List taxrateList = doc.stream().filter(row -> StringUtil.isNotBlank((CharSequence)row.getString("taxrateid"))).map(row -> row.getLong("taxrateid")).collect(Collectors.toList());
            QFilter taxrateIdQ = new QFilter("id", "in", taxrateList);
            QFilter country = new QFilter("country", "=", (Object)countryId);
            QFilter startdate = new QFilter("activedate", "<=", (Object)date);
            QFilter endDate = new QFilter("expdate", ">=", (Object)date);
            endDate.or(QFilter.isNull((String)"expdate"));
            QFilter[] qFilters = new QFilter[]{taxrateIdQ, startdate, endDate, country};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_taxrate", (String)"id,taxrate", (QFilter[])qFilters);
            if (null != collection && ObjectUtils.isNotEmpty((Object)collection)) {
                return (DynamicObject)collection.get(0);
            }
        }
        return null;
    }

    public static DynamicObject queryBastaxTaxcode(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bastax_taxcode");
    }

    public static DynamicObject queryBdRate(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_taxrate");
    }

    public static DynamicObject queryDynamicObject(String entry, String select, Object id) {
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)entry, (String)select, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        if (doc.length > 0) {
            return doc[0];
        }
        return null;
    }

    public static DynamicObject[] queryDynamicObject(String entry, String select, List<Long> id) {
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)entry, (String)select, (QFilter[])new QFilter[]{new QFilter("id", "in", id)});
        return doc;
    }

    public static DynamicObject queryDynamicObject(String entry, String select, Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        QFilter[] qfilter = new QFilter[map.size()];
        String[] set = map.keySet().toArray(new String[0]);
        Stream.iterate(0, i -> i + 1).limit(set.length).forEach(i -> {
            qfilter[i.intValue()] = new QFilter(set[i], "=", map.get(set[i]));
        });
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)entry, (String)select, (QFilter[])qfilter);
        if (doc.length > 0) {
            return doc[0];
        }
        return null;
    }

    public static DynamicObject[] queryBdtaxrBilltaxConfigsByField(String entityNumber, long orgId, long country, String field) {
        QFilter idsfilters = new QFilter("callbillkey", "=", (Object)entityNumber);
        QFilter ENABLE = new QFilter("enable", "=", (Object)"1");
        QFilter orgid = BaseDataServiceHelper.getBaseDataFilter((String)"bdtaxr_billtax_configs", (Long)orgId);
        if (null == orgid) {
            orgid = new QFilter("useorg", "=", (Object)orgId);
            QFilter ctrlstrategy = new QFilter("ctrlstrategy", "=", (Object)5);
            orgid.or(ctrlstrategy);
        }
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter countryQfilter = new QFilter("country", "=", (Object)country);
        QFilter condition = new QFilter("callconditionjson", "ftlike", (Object)field);
        DynamicObject[] businessScenario = BusinessDataServiceHelper.load((String)"bdtaxr_billtax_configs", (String)"id,number,name,callconditionjson,callbill,callcondition,product_entity.productconditionjson,product_entity.productcondition,product_entity.productsourcekey,product_entity.productfieldkey,product_entity.product,product_entity.converttype,product_entity.valuerules,product_entity.productsource,product_entity.productfield,address_entity.addresssourcekey,address_entity.addressfieldkey,address_entity.conditiontype,address_entity.addresssource,address_entity.addressfield,party_entity.partyconditionjson,party_entity.partycondition,party_entity.partysourcekey,party_entity.party,party_entity.partytype,party_entity.partysource,element_entity.elementconditionjson,element_entity.elementcondition,element_entity.elementsourcekey,element_entity.processtype,element_entity.process,element_entity.elementsource,specific_entity.specificconditionjson,specific_entity.specificcondition,specific_entity.specificsourcekey,specific_entity.specificfieldkey,specific_entity.specificsource,specific_entity.specificfield,specific_entity.euproduct,specific_entity.specificproduct", (QFilter[])new QFilter[]{orgid, idsfilters, ENABLE, STATUS, countryQfilter, condition});
        return businessScenario;
    }

    public static List<DynamicObject> queryBastaxTaxgroup(long id, long orgId, long countryId, Date date) {
        ArrayList<DynamicObject> taxcodes = new ArrayList(16);
        QFilter orgid = BaseDataServiceHelper.getBaseDataFilter((String)"bastax_taxgroup", (Long)orgId);
        if (null == orgid) {
            orgid = new QFilter("useorg", "=", (Object)orgId);
            QFilter ctrlstrategy = new QFilter("ctrlstrategy", "=", (Object)5);
            orgid.or(ctrlstrategy);
        }
        QFilter groupId = new QFilter("id", "=", (Object)id);
        QFilter country = new QFilter("country", "=", (Object)countryId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter startdate = new QFilter("startdate", "<=", (Object)date);
        QFilter endDate = new QFilter("enddate", ">=", (Object)date);
        endDate.or(QFilter.isNull((String)"enddate"));
        QFilter[] q = new QFilter[]{orgid, country, enable, STATUS, startdate, endDate, groupId};
        DynamicObjectCollection dos = QueryServiceHelper.query((String)"bastax_taxgroup", (String)"entryentity.taxcode.id,entryentity.order", (QFilter[])q, (String)"entryentity.order asc");
        taxcodes = dos.stream().collect(Collectors.toList());
        return taxcodes;
    }

    public static DynamicObject[] queryTaxCode(List<Long> ids, long orgId, long countryId, Date date) {
        QFilter orgid = BaseDataServiceHelper.getBaseDataFilter((String)"bastax_taxcode", (Long)orgId);
        if (null == orgid) {
            orgid = new QFilter("useorg", "=", (Object)orgId);
            QFilter ctrlstrategy = new QFilter("ctrlstrategy", "=", (Object)5);
            orgid.or(ctrlstrategy);
        }
        QFilter codeIds = new QFilter("id", "in", (Object)ids.toArray());
        QFilter country = new QFilter("country", "=", (Object)countryId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter startdate = new QFilter("startdate", "<=", (Object)date);
        QFilter endDate = new QFilter("enddate", ">=", (Object)date);
        endDate.or(QFilter.isNull((String)"enddate"));
        QFilter[] q = new QFilter[]{orgid, country, enable, STATUS, startdate, endDate, codeIds};
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bastax_taxcode", (String)"id,name,number,taxtype,offsetlogo,taxcodeproperty", (QFilter[])q);
        return dos;
    }
}

