/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.taxLinecalculate.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.cal.FelService;
import kd.taxc.bdtaxr.common.refactor.taxLinecalculate.TaxLineCalculateService;

public class TaxLineCalculateServiceImpl
implements TaxLineCalculateService {
    private static Log logger = LogFactory.getLog(TaxLineCalculateServiceImpl.class);
    private static final String FORMULA_ENTITY = "bdtaxr_tax_cal_formula";
    private static final String FORMULA = "saveformula";
    private static final String ID = "id";

    @Override
    public List<String> getFieldsByFormulaId(long formulaId) {
        String express = this.getExpressById(formulaId);
        if (StringUtils.isEmpty((CharSequence)express)) {
            return new ArrayList<String>();
        }
        String[] fields = FormulaEngine.extractVariables((String)express);
        return Arrays.asList(fields);
    }

    @Override
    public Object getTaxLineCalResult(long formulaId, Map<String, Object> params) {
        String express = this.getExpressById(formulaId);
        if (null != express && express.length() > 0) {
            ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(params.entrySet());
            entries.sort((e1, e2) -> ((String)e2.getKey()).length() - ((String)e1.getKey()).length());
            for (Map.Entry entry : entries) {
                express = express.replaceAll((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
            return FelService.eval(express);
        }
        return new ArrayList();
    }

    private String getExpressById(long formulaId) {
        DynamicObject formulaObj = QueryServiceHelper.queryOne((String)FORMULA_ENTITY, (String)FORMULA, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)formulaId)});
        if (null == formulaObj) {
            logger.warn("formulaId: " + formulaId + "is not exist.");
            return null;
        }
        CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formulaObj.getString(FORMULA), CRFormula.class);
        if (null == crFormula || StringUtils.isEmpty((CharSequence)crFormula.getExpression())) {
            logger.warn("formulaId: " + formulaId + "have not set formula.");
            return null;
        }
        return crFormula.getExpression();
    }
}

